package com.publiccms.entities.cms;
// Generated 2020-7-1 18:53:08 by Hibernate Tools 6.0.0-SNAPSHOT

import java.util.Date;

import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.validator.constraints.Length;
import org.springframework.format.annotation.DateTimeFormat;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.publiccms.common.generator.annotation.GeneratorColumn;

import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.Table;
import jakarta.persistence.Temporal;
import jakarta.persistence.TemporalType;
import jakarta.validation.constraints.NotBlank;

/**
 * CmsSurvey generated by hbm2java
 */
@Entity
@Table(name = "cms_survey")
@DynamicUpdate
public class CmsSurvey implements java.io.Serializable {

    /**
    *
    */
    private static final long serialVersionUID = 1L;

    /**
     * id
     */
    @GeneratorColumn(title = "ID")
    private Long id;
    @GeneratorColumn(title = "站点", condition = true)
    @JsonIgnore
    private short siteId;
    /**
     * user id

     * 发布用户id
     */
    @GeneratorColumn(title = "发布用户", condition = true)
    private long userId;
    /**
     * survey type(survey,exam)

     * 问卷类型(survey:问卷,exam:考试)
     */
    @GeneratorColumn(title = "问卷类型", condition = true)
    private String surveyType;
    /**
     * title

     * 标题
     */
    @GeneratorColumn(title = "标题", condition = true, like = true)
    @NotBlank
    @Length(max = 100)
    private String title;
    /**
     * description

     * 描述
     */
    @GeneratorColumn(title = "描述")
    @Length(max = 300)
    private String description;
    /**
     * votes

     * 投票次数
     */
    @GeneratorColumn(title = "投票次数", order = true)
    private int votes;
    /**
     * start date

     * 开始日期
     */
    @GeneratorColumn(title = "开始日期", condition = true, order = true)
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date startDate;
    /**
     * end date

     * 结束日期
     */
    @GeneratorColumn(title = "结束日期", condition = true, order = true)
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date endDate;
    /**
     * allow anonymous

     * 允许匿名
     */
    @GeneratorColumn(title = "允许匿名", condition = true)
    private boolean allowAnonymous;
    /**
     * create date

     * 创建日期
     */
    @GeneratorColumn(title = "创建日期", order = true)
    private Date createDate;
    @GeneratorColumn(title = "已禁用", condition = true)
    @JsonIgnore
    private boolean disabled;

    public CmsSurvey() {
    }

    public CmsSurvey(short siteId, long userId, String surveyType, String title, int votes, Date startDate, Date endDate,
            boolean allowAnonymous, Date createDate, boolean disabled) {
        this.siteId = siteId;
        this.userId = userId;
        this.surveyType = surveyType;
        this.title = title;
        this.votes = votes;
        this.startDate = startDate;
        this.endDate = endDate;
        this.allowAnonymous = allowAnonymous;
        this.createDate = createDate;
        this.disabled = disabled;
    }

    public CmsSurvey(short siteId, long userId, String surveyType, String title, String description, int votes, Date startDate,
            Date endDate, boolean allowAnonymous, Date createDate, boolean disabled) {
        this.siteId = siteId;
        this.userId = userId;
        this.surveyType = surveyType;
        this.title = title;
        this.description = description;
        this.votes = votes;
        this.startDate = startDate;
        this.endDate = endDate;
        this.allowAnonymous = allowAnonymous;
        this.createDate = createDate;
        this.disabled = disabled;
    }

    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    @Column(name = "id", unique = true, nullable = false)
    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    @Column(name = "site_id", nullable = false)
    public short getSiteId() {
        return this.siteId;
    }

    public void setSiteId(short siteId) {
        this.siteId = siteId;
    }

    @Column(name = "user_id", nullable = false)
    public long getUserId() {
        return this.userId;
    }

    public void setUserId(long userId) {
        this.userId = userId;
    }

    @Column(name = "survey_type", nullable = false, length = 20)
    public String getSurveyType() {
        return this.surveyType;
    }

    public void setSurveyType(String surveyType) {
        this.surveyType = surveyType;
    }

    @Column(name = "title", nullable = false, length = 100)
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    @Column(name = "description", nullable = false, length = 300)
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Column(name = "votes", nullable = false)
    public int getVotes() {
        return this.votes;
    }

    public void setVotes(int votes) {
        this.votes = votes;
    }

    @Temporal(TemporalType.TIMESTAMP)
    @Column(name = "start_date", nullable = false, length = 19)
    public Date getStartDate() {
        return this.startDate;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    @Temporal(TemporalType.TIMESTAMP)
    @Column(name = "end_date", length = 19)
    public Date getEndDate() {
        return this.endDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    @Column(name = "allow_anonymous", nullable = false)
    public boolean isAllowAnonymous() {
        return this.allowAnonymous;
    }

    public void setAllowAnonymous(boolean allowAnonymous) {
        this.allowAnonymous = allowAnonymous;
    }

    @Temporal(TemporalType.TIMESTAMP)
    @Column(name = "create_date", nullable = false, length = 19)
    public Date getCreateDate() {
        return this.createDate;
    }

    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }

    @Column(name = "disabled", nullable = false)
    public boolean isDisabled() {
        return this.disabled;
    }

    public void setDisabled(boolean disabled) {
        this.disabled = disabled;
    }
}
