package com.publiccms.entities.log;

import java.util.Date;

import org.hibernate.annotations.DynamicUpdate;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.publiccms.common.generator.annotation.GeneratorColumn;

import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.Table;
import jakarta.persistence.Temporal;
import jakarta.persistence.TemporalType;

/**
 * LogTask generated by hbm2java
 */
@Entity
@Table(name = "log_task")
@DynamicUpdate
public class LogTask implements java.io.Serializable {

    /**
     * 
     */
    private static final long serialVersionUID = 1L;
    /**
     * id
     */
    @GeneratorColumn(title = "ID")
    private Long id;
    @GeneratorColumn(title = "站点", condition = true)
    @JsonIgnore
    private short siteId;
    /**
     * task id<p>
     * 任务id
     */
    @GeneratorColumn(title = "任务", condition = true)
    private int taskId;
    /**
     * begin time<p>
     * 开始日期
     */
    @GeneratorColumn(title = "开始日期", condition = true, order = true)
    private Date begintime;
    /**
     * end timeb<p>
     * 结束日期
     */
    @GeneratorColumn(title = "结束时间")
    private Date endtime;
    /**
     * success<p>
     * 执行成功
     */
    @GeneratorColumn(title = "结果", condition = true)
    private boolean success;
    /**
     * result<p>
     * 执行结果
     */
    @GeneratorColumn(title = "日志")
    private String result;

    public LogTask() {
    }

    public LogTask(short siteId, int taskId, Date begintime, boolean success) {
        this.siteId = siteId;
        this.taskId = taskId;
        this.begintime = begintime;
        this.success = success;
    }

    public LogTask(Long id, short siteId, int taskId, Date begintime, Date endtime, boolean success) {
        this.id = id;
        this.siteId = siteId;
        this.taskId = taskId;
        this.begintime = begintime;
        this.endtime = endtime;
        this.success = success;
    }

    public LogTask(short siteId, int taskId, Date begintime, Date endtime, boolean success, String result) {
        this.siteId = siteId;
        this.taskId = taskId;
        this.begintime = begintime;
        this.endtime = endtime;
        this.success = success;
        this.result = result;
    }

    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    @Column(name = "id", unique = true, nullable = false)
    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    @Column(name = "site_id", nullable = false)
    public short getSiteId() {
        return this.siteId;
    }

    public void setSiteId(short siteId) {
        this.siteId = siteId;
    }

    @Column(name = "task_id", nullable = false)
    public int getTaskId() {
        return this.taskId;
    }

    public void setTaskId(int taskId) {
        this.taskId = taskId;
    }

    @Temporal(TemporalType.TIMESTAMP)
    @Column(name = "begintime", nullable = false, length = 19)
    public Date getBegintime() {
        return this.begintime;
    }

    public void setBegintime(Date begintime) {
        this.begintime = begintime;
    }

    @Temporal(TemporalType.TIMESTAMP)
    @Column(name = "endtime", length = 19)
    public Date getEndtime() {
        return this.endtime;
    }

    public void setEndtime(Date endtime) {
        this.endtime = endtime;
    }

    @Column(name = "success", nullable = false)
    public boolean isSuccess() {
        return this.success;
    }

    public void setSuccess(boolean success) {
        this.success = success;
    }

    @Column(name = "result")
    public String getResult() {
        return this.result;
    }

    public void setResult(String result) {
        this.result = result;
    }

}
