package com.publiccms.entities.sys;

import org.hibernate.annotations.DynamicUpdate;

import com.publiccms.common.generator.annotation.GeneratorColumn;

import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.Table;

/**
 * SysExtend generated by hbm2java
 */
@Entity
@Table(name = "sys_extend")
@DynamicUpdate
public class SysExtend implements java.io.Serializable {

    /**
     * 
     */
    private static final long serialVersionUID = 1L;
    /**
     * id
     */
    @GeneratorColumn(title = "ID")
    private Integer id;
    /**
     * item type<p>
     * 项目类型
     */
    @GeneratorColumn(title = "扩展类型")
    private String itemType;
    /**
     * item id<p>
     * 项目id
     */
    @GeneratorColumn(title = "扩展项目")
    private int itemId;

    public SysExtend() {
    }

    public SysExtend(String itemType, int itemId) {
        this.itemType = itemType;
        this.itemId = itemId;
    }

    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    @Column(name = "id", unique = true, nullable = false)
    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    @Column(name = "item_type", nullable = false, length = 20)
    public String getItemType() {
        return this.itemType;
    }

    public void setItemType(String itemType) {
        this.itemType = itemType;
    }

    @Column(name = "item_id", nullable = false)
    public int getItemId() {
        return this.itemId;
    }

    public void setItemId(int itemId) {
        this.itemId = itemId;
    }

}
