package com.publiccms.entities.sys;

import java.util.Date;

import org.hibernate.annotations.DynamicUpdate;

import com.publiccms.common.generator.annotation.GeneratorColumn;

import jakarta.persistence.AttributeOverride;
import jakarta.persistence.AttributeOverrides;
import jakarta.persistence.Column;
import jakarta.persistence.EmbeddedId;
import jakarta.persistence.Entity;
import jakarta.persistence.Table;
import jakarta.persistence.Temporal;
import jakarta.persistence.TemporalType;

/**
 * SysRecord generated by hbm2java
 */
@Entity
@Table(name = "sys_record")
@DynamicUpdate
public class SysRecord implements java.io.Serializable {

    /**
     * 
     */
    private static final long serialVersionUID = 1L;
    /**
     * id
     */
    @GeneratorColumn(title = "ID")
    private SysRecordId id;
    /**
     * record data

     * 记录数据
     */
    @GeneratorColumn(title = "值")
    private String data;
    /**
     * create date

     * 创建日期
     */
    @GeneratorColumn(title = "创建日期", condition = true, order = true)
    private Date createDate;
    /**
     * update date

     * 更新日期
     */
    @GeneratorColumn(title = "更新日期", order = true)
    private Date updateDate;

    public SysRecord() {
    }

    public SysRecord(SysRecordId id, String data, Date createDate) {
        this.id = id;
        this.data = data;
        this.createDate = createDate;
    }

    public SysRecord(SysRecordId id, String data, Date createDate, Date updateDate) {
        this.id = id;
        this.data = data;
        this.createDate = createDate;
        this.updateDate = updateDate;
    }

    @EmbeddedId

    @AttributeOverrides({ @AttributeOverride(name = "siteId", column = @Column(name = "site_id", nullable = false)),
            @AttributeOverride(name = "code", column = @Column(name = "code", nullable = false, length = 50)) })
    public SysRecordId getId() {
        return this.id;
    }

    public void setId(SysRecordId id) {
        this.id = id;
    }

    @Column(name = "data", nullable = false)
    public String getData() {
        return this.data;
    }

    public void setData(String data) {
        this.data = data;
    }

    @Temporal(TemporalType.TIMESTAMP)
    @Column(name = "create_date", nullable = false, length = 19)
    public Date getCreateDate() {
        return this.createDate;
    }

    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }

    @Temporal(TemporalType.TIMESTAMP)
    @Column(name = "update_date", length = 19)
    public Date getUpdateDate() {
        return this.updateDate;
    }

    public void setUpdateDate(Date updateDate) {
        this.updateDate = updateDate;
    }
}
