package com.publiccms.entities.sys;

import org.hibernate.annotations.DynamicUpdate;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.publiccms.common.generator.annotation.GeneratorColumn;

import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.Id;
import jakarta.persistence.Table;

/**
 * SysUserAttribute generated by hbm2java
 */
@Entity
@Table(name = "sys_user_attribute")
@DynamicUpdate
public class SysUserAttribute implements java.io.Serializable {

    /**
     * 
     */
    private static final long serialVersionUID = 1L;
    @GeneratorColumn(title = "用户")
    private long userId;
    @GeneratorColumn(title = "全文索引文本")
    @JsonIgnore
    private String searchText;
    @GeneratorColumn(title = "数据字典值")
    @JsonIgnore
    private String dictionaryValues;
    @GeneratorColumn(title = "扩展文本字段")
    private String extendsFields;
    @GeneratorColumn(title = "扩展数据")
    private String data;

    public SysUserAttribute() {
    }

    public SysUserAttribute(long userId) {
        this.userId = userId;
    }

    public SysUserAttribute(long userId, String data) {
        this.userId = userId;
        this.data = data;
    }

    @Id
    @Column(name = "user_id", unique = true, nullable = false)
    public long getUserId() {
        return this.userId;
    }

    public void setUserId(long userId) {
        this.userId = userId;
    }

    @Column(name = "search_text")
    public String getSearchText() {
        return this.searchText;
    }

    public void setSearchText(String searchText) {
        this.searchText = searchText;
    }

    @Column(name = "dictionary_values", length = 65535)
    public String getDictionaryValues() {
        return this.dictionaryValues;
    }

    public void setDictionaryValues(String dictionaryValues) {
        this.dictionaryValues = dictionaryValues;
    }

    @Column(name = "extends_fields", length = 65535)
    public String getExtendsFields() {
        return this.extendsFields;
    }

    public void setExtendsFields(String extendsFields) {
        this.extendsFields = extendsFields;
    }

    @Column(name = "data")
    public String getData() {
        return this.data;
    }

    public void setData(String data) {
        this.data = data;
    }

}
