/*
 * Copyright 2012-2022 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.springframework.boot.autoconfigure.graphql;

import com.querydsl.core.types.Path;
import com.querydsl.core.types.PathMetadata;
import com.querydsl.core.types.PathMetadataFactory;
import com.querydsl.core.types.dsl.EntityPathBase;
import com.querydsl.core.types.dsl.NumberPath;
import com.querydsl.core.types.dsl.StringPath;

/**
 * QBook is a Querydsl query type for Book. This class is usually generated by the
 * Querydsl annotation processor.
 */
public class QBook extends EntityPathBase<Book> {

	private static final long serialVersionUID = -1932588188L;

	public static final QBook book = new QBook("book");

	public final StringPath author = createString("author");

	public final StringPath id = createString("id");

	public final StringPath name = createString("name");

	public final NumberPath<Integer> pageCount = createNumber("pageCount", Integer.class);

	public QBook(String variable) {
		super(Book.class, PathMetadataFactory.forVariable(variable));
	}

	public QBook(Path<? extends Book> path) {
		super(path.getType(), path.getMetadata());
	}

	public QBook(PathMetadata metadata) {
		super(Book.class, metadata);
	}

}
