/*
 * Copyright 2012-2024 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.springframework.boot.logging.logback;

import java.io.IOException;
import java.nio.charset.StandardCharsets;

import org.junit.jupiter.api.Test;

import org.springframework.util.StreamUtils;

import static org.assertj.core.api.Assertions.assertThat;

/**
 * Tests for {@link DefaultLogbackConfiguration}
 *
 * @author Phillip Webb
 */
class DefaultLogbackConfigurationTests {

	@Test
	void defaultLogbackXmlContainsConsoleLogPattern() throws Exception {
		assertThatDefaultXmlContains("CONSOLE_LOG_PATTERN", DefaultLogbackConfiguration.CONSOLE_LOG_PATTERN);
	}

	@Test
	void defaultLogbackXmlContainsFileLogPattern() throws Exception {
		assertThatDefaultXmlContains("FILE_LOG_PATTERN", DefaultLogbackConfiguration.FILE_LOG_PATTERN);
	}

	private void assertThatDefaultXmlContains(String name, String value) throws Exception {
		String expected = "<property name=\"%s\" value=\"%s\"/>".formatted(name, value);
		assertThat(defaultXmlContent()).contains(expected);
	}

	private String defaultXmlContent() throws IOException {
		return StreamUtils.copyToString(getClass().getResourceAsStream("defaults.xml"), StandardCharsets.UTF_8);
	}

}
