// Copyright (C) 2020 The Android Open Source Project
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

package com.google.gerrit.acceptance.testsuite.change;

import java.util.function.IntFunction;

/**
 * Builder to simplify a position specification. Used by {@link TestCommentCreation} and {@link
 * TestRobotCommentCreation}.
 */
public class PositionBuilder<T> {
  private final IntFunction<T> nextStepProvider;

  public PositionBuilder(IntFunction<T> nextStepProvider) {
    this.nextStepProvider = nextStepProvider;
  }

  /** Character offset within the line. A value of 0 indicates the beginning of the line. */
  public T charOffset(int characterOffset) {
    return nextStepProvider.apply(characterOffset);
  }
}
