// Copyright (C) 2009 The Android Open Source Project
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

package com.google.gerrit.server.git;

import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

/**
 * Wrapper class so a Runnable can schedule itself onto the Gerrit Workqueue. Subclasses must
 * implement the {@code run} method.
 */
public abstract class DefaultQueueOp implements Runnable {
  private final WorkQueue workQueue;

  protected DefaultQueueOp(WorkQueue wq) {
    workQueue = wq;
  }

  public ScheduledFuture<?> start(long delay, TimeUnit unit) {
    return workQueue.getDefaultQueue().schedule(this, delay, unit);
  }

  public ScheduledFuture<?> startWithFixedDelay(long initialDelay, long delay, TimeUnit unit) {
    return workQueue.getDefaultQueue().scheduleWithFixedDelay(this, initialDelay, delay, unit);
  }
}
