/**
 * @license
 * Copyright 2020 Google LLC
 * SPDX-License-Identifier: Apache-2.0
 */

// Ugly import path due to the following bugs:
// https://github.com/bazelbuild/rules_nodejs/issues/1522
// https://github.com/bazelbuild/rules_nodejs/issues/1380
import {
  PackageInfo,
  LicenseType,
  LicenseInfo,
} from '../../../tools/node_tools/node_modules_licenses/package-license-info';
import * as path from 'path';

class LicenseTypes {
  public static Mit: LicenseType = {
    name: 'MIT',
    allowed: true,
  };
  public static Apache2_0: LicenseType = {
    name: 'Apache 2.0',
    allowed: true,
  };

  public static Bsd3: LicenseType = {
    name: 'BSD-3-Clause',
    allowed: true,
  };

  public static BsdZeroClause: LicenseType = {
    name: 'BSD-Zero-Clause',
    allowed: true,
  };
}

/** List of licenses texts. Add the licenses here if there is no text file with license
 * in package. For details - see comments for {@link LicenseInfo} and {@link PackageInfo} */
class SharedLicenses {
  public static Lit: LicenseInfo = {
    name: 'Lit',
    type: LicenseTypes.Bsd3,
    sharedLicenseFile: 'lit.txt',
  };

  public static Polymer2014: LicenseInfo = {
    name: 'Polymer-2014',
    type: LicenseTypes.Bsd3,
    sharedLicenseFile: 'polymer-2014.txt',
  };

  public static Polymer2015: LicenseInfo = {
    name: 'Polymer-2015',
    type: LicenseTypes.Bsd3,
    sharedLicenseFile: 'polymer-2015.txt',
  };

  public static Polymer2016: LicenseInfo = {
    name: 'Polymer-2016',
    type: LicenseTypes.Bsd3,
    sharedLicenseFile: 'polymer-2016.txt',
  };

  public static Polymer2017: LicenseInfo = {
    name: 'Polymer-2017',
    type: LicenseTypes.Bsd3,
    sharedLicenseFile: 'polymer-2017.txt',
  };

  public static Polymer2018: LicenseInfo = {
    name: 'Polymer-2018',
    type: LicenseTypes.Bsd3,
    sharedLicenseFile: 'polymer-2018.txt',
  };

  public static IsArray: LicenseInfo = {
    name: 'isarray',
    type: LicenseTypes.Mit,
    sharedLicenseFile: 'isarray.txt',
  };

  public static Page: LicenseInfo = {
    name: 'page',
    type: LicenseTypes.Mit,
    sharedLicenseFile: 'page.txt',
  };
}

const fontsRobotoFilter = (fileName: string) =>
  fileName.startsWith('fonts/roboto/') &&
  path.basename(fileName) !== 'DESCRIPTION.en_us.html';

const fontsRobotomonoFilter = (fileName: string) =>
  fileName.startsWith('fonts/robotomono/') &&
  path.basename(fileName) !== 'DESCRIPTION.en_us.html';

const packages: PackageInfo[] = [
  {
    name: '@lit/reactive-element',
    license: SharedLicenses.Lit,
  },
  {
    name: '@polymer/decorators',
    license: SharedLicenses.Polymer2017,
  },
  {
    name: '@polymer/font-roboto',
    license: SharedLicenses.Polymer2015,
  },
  {
    name: '@polymer/font-roboto-local',
    license: SharedLicenses.Polymer2015,
    filesFilter: fileName =>
      !fontsRobotoFilter(fileName) && !fontsRobotomonoFilter(fileName),
  },
  {
    name: '@polymer/font-roboto-local',
    license: {
      name: 'font-roboto-local-fonts-roboto',
      type: LicenseTypes.Apache2_0,
      packageLicenseFile: 'fonts/roboto/LICENSE.txt',
    },
    filesFilter: fontsRobotoFilter,
  },
  {
    name: '@polymer/font-roboto-local',
    license: {
      name: 'font-roboto-local-fonts-robotomono',
      type: LicenseTypes.Apache2_0,
      packageLicenseFile: 'fonts/robotomono/LICENSE.txt',
    },
    filesFilter: fontsRobotomonoFilter,
  },
  {
    name: '@polymer/iron-a11y-announcer',
    license: SharedLicenses.Polymer2015,
  },
  {
    name: '@polymer/iron-a11y-keys-behavior',
    license: SharedLicenses.Polymer2015,
  },
  {
    name: '@polymer/iron-autogrow-textarea',
    license: SharedLicenses.Polymer2015,
  },
  {
    name: '@polymer/iron-behaviors',
    license: SharedLicenses.Polymer2015,
  },
  {
    name: '@polymer/iron-checked-element-behavior',
    license: SharedLicenses.Polymer2015,
  },
  {
    name: '@polymer/iron-dropdown',
    license: SharedLicenses.Polymer2015,
  },
  {
    name: '@polymer/iron-fit-behavior',
    license: SharedLicenses.Polymer2015,
  },
  {
    name: '@polymer/iron-flex-layout',
    license: SharedLicenses.Polymer2015,
  },
  {
    name: '@polymer/iron-form-element-behavior',
    license: SharedLicenses.Polymer2015,
  },
  {
    name: '@polymer/iron-icon',
    license: SharedLicenses.Polymer2015,
  },
  {
    name: '@polymer/iron-iconset-svg',
    license: SharedLicenses.Polymer2015,
  },
  {
    name: '@polymer/iron-image',
    license: SharedLicenses.Polymer2016,
  },
  {
    name: '@polymer/iron-input',
    license: SharedLicenses.Polymer2015,
  },
  {
    name: '@polymer/iron-menu-behavior',
    license: SharedLicenses.Polymer2015,
  },
  {
    name: '@polymer/iron-meta',
    license: SharedLicenses.Polymer2015,
  },
  {
    name: '@polymer/iron-overlay-behavior',
    license: SharedLicenses.Polymer2015,
  },
  {
    name: '@polymer/iron-resizable-behavior',
    license: SharedLicenses.Polymer2015,
  },
  {
    name: '@polymer/iron-selector',
    license: SharedLicenses.Polymer2015,
  },
  {
    name: '@polymer/iron-validatable-behavior',
    license: SharedLicenses.Polymer2015,
  },
  {
    name: '@polymer/marked-element',
    license: SharedLicenses.Polymer2015,
  },
  {
    name: '@polymer/neon-animation',
    license: SharedLicenses.Polymer2015,
  },
  {
    name: '@polymer/paper-behaviors',
    license: SharedLicenses.Polymer2015,
  },
  {
    name: '@polymer/paper-button',
    license: SharedLicenses.Polymer2015,
  },
  {
    name: '@polymer/paper-card',
    license: SharedLicenses.Polymer2015,
  },
  {
    name: '@polymer/paper-checkbox',
    license: SharedLicenses.Polymer2016,
  },
  {
    name: '@polymer/paper-dialog',
    license: SharedLicenses.Polymer2015,
  },
  {
    name: '@polymer/paper-dialog-behavior',
    license: SharedLicenses.Polymer2015,
  },
  {
    name: '@polymer/paper-dialog-scrollable',
    license: SharedLicenses.Polymer2015,
  },
  {
    name: '@polymer/paper-dropdown-menu',
    license: SharedLicenses.Polymer2015,
  },
  {
    name: '@polymer/paper-fab',
    license: SharedLicenses.Polymer2015,
  },
  {
    name: '@polymer/paper-icon-button',
    license: SharedLicenses.Polymer2015,
  },
  {
    name: '@polymer/paper-input',
    license: SharedLicenses.Polymer2015,
  },
  {
    name: '@polymer/paper-item',
    license: SharedLicenses.Polymer2015,
  },
  {
    name: '@polymer/paper-listbox',
    license: SharedLicenses.Polymer2015,
  },
  {
    name: '@polymer/paper-menu-button',
    license: SharedLicenses.Polymer2015,
  },
  {
    name: '@polymer/paper-ripple',
    license: SharedLicenses.Polymer2014,
  },
  {
    name: '@polymer/paper-styles',
    license: SharedLicenses.Polymer2014,
  },
  {
    name: '@polymer/paper-tabs',
    license: SharedLicenses.Polymer2015,
  },
  {
    name: '@polymer/paper-toggle-button',
    license: SharedLicenses.Polymer2015,
  },
  {
    name: '@polymer/paper-tooltip',
    license: SharedLicenses.Polymer2015,
  },
  {
    name: '@polymer/polymer',
    license: SharedLicenses.Polymer2017,
  },
  {
    name: '@types/resemblejs',
    license: {
      name: 'DefinitelyTyped',
      type: LicenseTypes.Mit,
      packageLicenseFile: 'LICENSE',
    },
  },
  {
    name: '@types/resize-observer-browser',
    license: {
      name: 'DefinitelyTyped',
      type: LicenseTypes.Mit,
      packageLicenseFile: 'LICENSE',
    },
  },
  {
    name: '@types/trusted-types',
    license: {
      name: 'DefinitelyTyped',
      type: LicenseTypes.Mit,
      packageLicenseFile: 'LICENSE',
    },
  },
  {
    name: '@webcomponents/shadycss',
    license: SharedLicenses.Polymer2017,
  },
  {
    name: '@webcomponents/webcomponentsjs',
    license: SharedLicenses.Polymer2018,
  },
  {
    name: 'ba-linkify',
    license: {
      name: 'ba-linkify',
      type: LicenseTypes.Mit,
      packageLicenseFile: 'LICENSE-MIT',
    },
  },
  {
    name: 'codemirror-minified',
    license: {
      name: 'codemirror-minified',
      type: LicenseTypes.Mit,
      packageLicenseFile: 'LICENSE',
    },
  },
  {
    name: 'isarray',
    license: SharedLicenses.IsArray,
  },
  {
    name: 'page',
    license: SharedLicenses.Page,
  },
  {
    name: 'shadow-selection-polyfill',
    license: {
      name: 'shadow-selection-polyfill',
      type: LicenseTypes.Apache2_0,
      packageLicenseFile: 'LICENSE',
    },
  },
  {
    name: 'path-to-regexp',
    license: {
      name: 'path-to-regexp',
      type: LicenseTypes.Mit,
      packageLicenseFile: 'LICENSE',
    },
  },
  {
    name: 'polymer-resin',
    license: SharedLicenses.Polymer2018,
  },
  {
    name: 'polymer-bridges',
    license: SharedLicenses.Polymer2018,
  },
  {
    name: 'web-vitals',
    license: {
      name: 'web-vitals',
      type: LicenseTypes.Apache2_0,
      packageLicenseFile: 'LICENSE',
    },
  },
  {
    name: 'rxjs',
    license: {
      name: 'rxjs',
      type: LicenseTypes.Apache2_0,
      packageLicenseFile: 'LICENSE.txt',
    },
    // The following directories are not real packages, but contains package.json
    nonPackages: [
      'ajax',
      'fetch',
      'internal-compatibility',
      'operators',
      'testing',
      'webSocket',
      'src/ajax',
      'src/fetch',
      'src/internal-compatibility',
      'src/operators',
      'src/testing',
      'src/webSocket',
    ],
  },
  {
    name: 'lit',
    license: SharedLicenses.Lit,
  },
  {
    name: 'lit-element',
    license: SharedLicenses.Lit,
  },
  {
    name: 'lit-html',
    license: SharedLicenses.Lit,
  },
  {
    name: 'tslib',
    license: {
      name: 'tslib',
      type: LicenseTypes.BsdZeroClause,
      packageLicenseFile: 'LICENSE.txt',
    },
    nonPackages: ['modules', 'test/validateModuleExportsMatchCommonJS'],
  },
  {
    name: 'resemblejs',
    license: {
      name: 'resemblejs',
      type: LicenseTypes.Mit,
      packageLicenseFile: 'LICENSE',
    },
  },
  {
    name: 'immer',
    license: {
      name: 'immer',
      type: LicenseTypes.Mit,
      packageLicenseFile: 'LICENSE',
    },
  },
  {
    name: 'highlight.js',
    license: {
      name: 'highlight.js',
      type: LicenseTypes.Bsd3,
      packageLicenseFile: 'LICENSE',
    },
    nonPackages: ['es'],
  },
  {
    name: 'highlightjs-closure-templates',
    license: {
      name: 'highlightjs-closure-templates',
      type: LicenseTypes.Bsd3,
      packageLicenseFile: 'LICENSE',
    },
  },
  {
    name: 'highlightjs-structured-text',
    license: {
      name: 'highlightjs-structured-text',
      type: LicenseTypes.Bsd3,
      packageLicenseFile: 'LICENSE',
    },
  },
  {
    name: 'marked',
    license: {
      name: 'marked',
      type: LicenseTypes.Mit,
      packageLicenseFile: 'LICENSE.md',
    },
  },
  {
    name: 'safevalues',
    license: {
      name: 'safevalues',
      type: LicenseTypes.Apache2_0,
      packageLicenseFile: 'LICENSE',
    },
  },
];

export default packages;
