/*
 * The MIT License
 *
 * Copyright (c) 2015, CloudBees, Inc.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

package jenkins.security;

import static org.junit.Assert.assertTrue;

import java.nio.charset.StandardCharsets;
import java.security.Signature;
import java.util.Base64;
import org.junit.Rule;
import org.junit.Test;

public class RSADigitalSignatureConfidentialKeyTest {

    @Rule
    public ConfidentialStoreRule store = new ConfidentialStoreRule();

    private final RSADigitalSignatureConfidentialKey key = new RSADigitalSignatureConfidentialKey("test");

    @Test
    public void dsigSignAndVerify() throws Exception {
        String plainText = "Hello world";
        String msg = key.sign(plainText);
        System.out.println(msg);

        Signature sig = Signature.getInstance("SHA256withRSA");
        sig.initVerify(key.getPublicKey());
        sig.update(plainText.getBytes(StandardCharsets.UTF_8));

        assertTrue(sig.verify(Base64.getDecoder().decode(msg)));
    }

}
