/*
 * The MIT License
 *
 * Copyright 2023 CloudBees, Inc.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

package hudson;

import static org.hamcrest.MatcherAssert.assertThat;
import static org.hamcrest.Matchers.is;

import hudson.model.InvisibleAction;
import hudson.model.UnprotectedRootAction;
import java.net.URI;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.jvnet.hudson.test.JenkinsRule;
import org.jvnet.hudson.test.TestExtension;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.HttpResponses;

public final class ProxyConfigurationTest {

    @Rule
    public JenkinsRule r = new JenkinsRule();

    @Ignore("prone to timing out on CI")
    @Test
    public void httpClientExecutor() throws Exception {
        for (int i = 0; i < 50_000; i++) {
            if (i % 1_000 == 0) {
                System.err.println("#" + i);
            }
            assertThat(ProxyConfiguration.newHttpClient().send(ProxyConfiguration.newHttpRequestBuilder(URI.create(r.getURL() + "ping/")).build(),
                    java.net.http.HttpResponse.BodyHandlers.discarding()).statusCode(),
                is(200));
        }
    }

    @TestExtension("httpClientExecutor")
    public static final class Ping extends InvisibleAction implements UnprotectedRootAction {
        @Override
        public String getUrlName() {
            return "ping";
        }

        public HttpResponse doIndex() {
            return HttpResponses.ok();
        }
    }

}
