/*!
Copyright (c) REBUILD <https://getrebuild.com/> and/or its owners. All rights reserved.

rebuild is dual-licensed under commercial and open source licenses (GPLv3).
See LICENSE and COMMERCIAL in the project root for license information.
*/

package com.rebuild.core.configuration.general;

import cn.devezhao.persist4j.engine.ID;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.rebuild.core.configuration.ConfigBean;
import com.rebuild.core.metadata.EntityHelper;
import com.rebuild.core.service.query.ParseHelper;
import com.rebuild.core.service.query.QueryHelper;
import com.rebuild.utils.JSONUtils;
import lombok.extern.slf4j.Slf4j;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;


@Slf4j
public class FormsManager extends BaseLayoutManager {

    public static final FormsManager instance = new FormsManager();

    protected FormsManager() {}

    
    public static int APPLY_NEW = 1;
    public static int APPLY_EDIT = 2;
    public static int APPLY_VIEW = 4;

    
    public ConfigBean getNewFormLayout(String entity) {
        return getFormLayout(entity, null, APPLY_NEW);
    }

    
    public ConfigBean getFormLayout(String entity, ID recordOrLayoutId, int applyType) {
        final Object[][] alls = getAllConfig(entity, TYPE_FORM);

        

        ConfigBean use = null;

        
        if (recordOrLayoutId != null && recordOrLayoutId.getEntityCode() == EntityHelper.LayoutConfig) {
            use = findConfigBean(alls, recordOrLayoutId);
            if (use == null) {
                log.warn("Spec layout not longer exists : {}", recordOrLayoutId);
                recordOrLayoutId = null;
            }
        }

        
        if (use == null) {
            
            for (Object[] o : alls) {
                ConfigBean cb = findConfigBean(alls, (ID) o[0]);
                ShareToAttr attr = new ShareToAttr(cb);
                if (recordOrLayoutId == null) {
                    if (attr.isFallback() || attr.isForNew()) {
                        use = cb;
                        break;
                    }
                } else {
                    if (attr.isMatchUseFilter(recordOrLayoutId)) {
                        use = cb;
                        break;
                    }
                }
            }

            
            if (recordOrLayoutId == null) {
                use = findDefault(alls);
            }
        }

        
        if (use == null && recordOrLayoutId != null) {
            for (Object[] o : alls) {
                ConfigBean cb = findConfigBean(alls, (ID) o[0]);
                ShareToAttr attr = new ShareToAttr(cb);
                if (attr.isFallback()) {
                    use = cb;
                    break;
                }
            }
        }

        if (use != null) {
            use.set("entity", entity)
                    .remove("shareTo").remove("name");
            return use;
        }
        return useBlank(entity);
    }

    
    private ConfigBean useBlank(String entity) {
        return new ConfigBean()
                .set("entity", entity)
                .set("elements", JSONUtils.EMPTY_ARRAY);
    }

    
    private ConfigBean findDefault(Object[][] alls) {
        for (Object[] o : alls) {
            ConfigBean cb = findConfigBean(alls, (ID) o[0]);
            ShareToAttr attr = new ShareToAttr(cb);
            if (attr.isFallback() && attr.isForNew()) return cb;
        }
        return null;
    }

    

    
    public ConfigBean getFormLayout(ID formConfigId, String entity) {
        final Object[][] alls = getAllConfig(entity, TYPE_FORM);

        
        if (formConfigId == null) {
            ConfigBean best = findDefault(alls);
            if (best != null) return best;
        }

        
        for (Object[] o : alls) {
            if (formConfigId == null) {
                return findConfigBean(alls, (ID) o[0]);
            }

            if (formConfigId.equals(o[0])) {
                return findConfigBean(alls, formConfigId);
            }
        }

        return useBlank(entity);
    }

    
    public List<ConfigBean> getAllFormsAttr(String entity) {
        return getAllFormsAttr(entity, false);
    }

    
    public List<ConfigBean> getAllFormsAttr(String entity, boolean forNew) {
        final Object[][] alls = getAllConfig(entity, TYPE_FORM);

        List<ConfigBean> flist = new ArrayList<>();
        for (Object[] o : alls) {
            ConfigBean cb = findConfigBean(alls, (ID) o[0]).remove("config");
            cb.remove("elements");
            if (forNew) {
                if (new ShareToAttr(cb).isForNew()) flist.add(cb.remove("shareTo"));
            } else {
                flist.add(cb);
            }
        }

        
        flist.sort((o1, o2) -> {
            String name1 = Objects.toString(o1.getString("name"), "0");
            String name2 = Objects.toString(o2.getString("name"), "0");
            return name1.compareTo(name2);
        });

        return flist;
    }

    @Override
    protected ConfigBean findConfigBean(Object[][] uses, ID cfgid) {
        ConfigBean cb = super.findConfigBean(uses, cfgid);
        if (cb == null) return null;

        
        for (Object[] c : uses) {
            if (c[0].equals(cfgid)) {
                cb.set("name", c[4]);
                break;
            }
        }

        cb.set("elements", cb.getJSON("config"))
                .remove("config");

        
        String shareTo = cb.getString("shareTo");
        if (JSONUtils.wellFormat(shareTo)) {
            cb.set("shareTo", JSON.parse(shareTo));
        }
        return cb;
    }

    
    static class ShareToAttr {

        private final JSONObject attrs;
        private final boolean sysDefault;
        protected ShareToAttr(ConfigBean cb) {
            Object s = cb.getObject("shareTo");
            if (s instanceof JSON) {
                this.attrs = (JSONObject) s;
            } else {
                
                this.attrs = JSONUtils.toJSONObject("fallback", true);
            }
            this.sysDefault = cb.getString("name") == null;  
        }

        
        boolean isFallback() {
            return this.sysDefault || this.attrs.getBooleanValue("fallback");
        }

        
        boolean isForNew() {
            return this.sysDefault || this.attrs.getBooleanValue("fornew");
        }

        
        boolean isMatchUseFilter(ID recordId) {
            JSONObject filter = this.attrs.getJSONObject("filter");
            if (ParseHelper.validAdvFilter(filter)) {
                return QueryHelper.isMatchAdvFilter(recordId, filter);
            }
            return false;
        }
    }
}
