/*!
Copyright (c) REBUILD <https://getrebuild.com/> and/or its owners. All rights reserved.

rebuild is dual-licensed under commercial and open source licenses (GPLv3).
See LICENSE and COMMERCIAL in the project root for license information.
*/

package com.rebuild.core.metadata;

import cn.devezhao.persist4j.Entity;
import cn.devezhao.persist4j.Field;
import cn.devezhao.persist4j.engine.ID;
import cn.devezhao.persist4j.metadata.BaseMeta;
import com.rebuild.core.Application;
import com.rebuild.core.metadata.easymeta.DisplayType;
import com.rebuild.core.metadata.easymeta.EasyEntity;
import com.rebuild.core.metadata.easymeta.EasyMetaFactory;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.util.Assert;

import java.text.Collator;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;


@SuppressWarnings("SuspiciousToArrayCall")
public class MetadataSorter {

    
    public static Entity[] sortEntities() {
        return sortEntities(null, true, true);
    }

    
    public static Entity[] sortEntities(ID user, boolean includesBizz, boolean includesDetail) {
        List<BaseMeta> entities = new ArrayList<>();
        for (Entity e : MetadataHelper.getEntities()) {
            if (!e.isQueryable()) continue;
            if (!includesDetail && e.getMainEntity() != null) continue;

            EasyEntity easyEntity = EasyMetaFactory.valueOf(e);
            if (easyEntity.isBuiltin() && !easyEntity.isPlainEntity()) continue;

            Entity checkEntity = e;
            if (includesDetail && e.getMainEntity() != null) checkEntity = e.getMainEntity();

            if (user == null || !MetadataHelper.hasPrivilegesField(checkEntity)) {
                entities.add(e);
            } else if (Application.getPrivilegesManager().allowRead(user, checkEntity.getEntityCode())) {
                entities.add(e);
            }
        }

        sortByLabel(entities);

        
        if (includesDetail) {
            List<BaseMeta> entities2 = new ArrayList<>();
            for (BaseMeta o : entities) {
                Entity me = (Entity) o;
                if (me.getDetailEntity() == null && me.getMainEntity() == null) {
                    entities2.add(me);
                } else if (me.getDetailEntity() != null) {
                    entities2.add(me);

                    for (BaseMeta de : entities) {
                        if (me.equals(((Entity) de).getMainEntity())) entities2.add(de);
                    }
                }
            }

            entities = entities2;
        }

        if (includesBizz) {
            entities.add(MetadataHelper.getEntity(EntityHelper.User));
            entities.add(MetadataHelper.getEntity(EntityHelper.Department));
            entities.add(MetadataHelper.getEntity(EntityHelper.Role));
            entities.add(MetadataHelper.getEntity(EntityHelper.Team));
        }

        return entities.toArray(new Entity[0]);
    }

    
    public static Entity[] sortDetailEntities(Entity mainEntity) {
        Assert.notNull(mainEntity.getDetailEntity(), "None main entity : " + mainEntity);

        List<BaseMeta> entities = new ArrayList<>();
        CollectionUtils.addAll(entities, mainEntity.getDetialEntities());
        
        if (entities.size() > 1) sortByLabel(entities);
        return entities.toArray(new Entity[0]);
    }

    
    public static Field[] sortFields(Entity entity, DisplayType... usesTypes) {
        return sortFields(entity.getFields(), usesTypes);
    }

    
    public static Field[] sortFields(Field[] fields, DisplayType... usesTypes) {
        List<BaseMeta> fieldsList = new ArrayList<>();
        for (Field field : fields) {
            if (MetadataHelper.isSystemField(field)) continue;

            if (usesTypes.length == 0) {
                fieldsList.add(field);
            } else {
                DisplayType dt = EasyMetaFactory.getDisplayType(field);
                for (DisplayType use : usesTypes) {
                    if (dt == use) fieldsList.add(field);
                }
            }
        }

        return sortByLevel(fieldsList);
    }

    
    static Field[] sortByLevel(List<BaseMeta> fields) {
        List<BaseMeta> bizFields = new ArrayList<>();
        Map<String, BaseMeta> comFieldsMap = new HashMap<>();

        for (BaseMeta field : fields) {
            if (MetadataHelper.isApprovalField(field.getName())
                    || MetadataHelper.isCommonsField((Field) field)) {
                comFieldsMap.put(field.getName(), field);
            } else {
                bizFields.add(field);
            }
        }

        sortByLabel(bizFields);
        List<BaseMeta> allFields = new ArrayList<>(bizFields);

        
        final String[] specSortsApproval = new String[] {
                EntityHelper.ApprovalId, EntityHelper.ApprovalState,
                EntityHelper.ApprovalStepNodeName, EntityHelper.ApprovalStepUsers,
                EntityHelper.ApprovalLastUser, EntityHelper.ApprovalLastTime, EntityHelper.ApprovalLastRemark
        };
        List<BaseMeta> approvalFields = new ArrayList<>();
        for (String s : specSortsApproval) {
            BaseMeta b = comFieldsMap.get(s);
            if (b != null) approvalFields.add(b);
        }
        allFields.addAll(approvalFields);

        
        final String[] specSortsCommon = new String[] {
                EntityHelper.CreatedBy, EntityHelper.CreatedOn, EntityHelper.ModifiedBy, EntityHelper.ModifiedOn,
                EntityHelper.OwningUser, EntityHelper.OwningDept
        };
        List<BaseMeta> commonsFields = new ArrayList<>();
        for (String s : specSortsCommon) {
            BaseMeta b = comFieldsMap.get(s);
            if (b != null) commonsFields.add(b);
        }
        allFields.addAll(commonsFields);

        return allFields.toArray(new Field[0]);
    }

    
    public static void sortByLabel(List<BaseMeta> metas) {
        if (metas.size() <= 1) return;

        Comparator<Object> comparator = Collator.getInstance(Locale.CHINESE);
        metas.sort((foo, bar) -> {
            String fooLetter = EasyMetaFactory.getLabel(foo);
            String barLetter = EasyMetaFactory.getLabel(bar);
            return comparator.compare(fooLetter, barLetter);
        });
    }
}
