/*!
Copyright (c) REBUILD <https://getrebuild.com/> and/or its owners. All rights reserved.

rebuild is dual-licensed under commercial and open source licenses (GPLv3).
See LICENSE and COMMERCIAL in the project root for license information.
*/

package com.rebuild.core.service.dashboard.charts;

import lombok.ToString;
import org.apache.commons.lang3.ArrayUtils;

import java.util.Arrays;


@ToString
public class AxisEntry {

    final private int index;
    final private Object[] key;
    final private Object value;

    public AxisEntry(Object[] rowValue, int index) {
        this.key = ArrayUtils.subarray(rowValue, 0, rowValue.length - 1);
        this.value = rowValue[rowValue.length - 1];
        this.index = index;
    }

    
    public int getIndex() {
        return index;
    }

    
    public Object[] getKeyRaw() {
        return key;
    }

    
    public String getKey() {
        return Arrays.toString(getKeyRaw());
    }

    
    public Object getValue() {
        return value;
    }
}
