/*!
Copyright (c) REBUILD <https://getrebuild.com/> and/or its owners. All rights reserved.

rebuild is dual-licensed under commercial and open source licenses (GPLv3).
See LICENSE and COMMERCIAL in the project root for license information.
*/

package com.rebuild.core.service.dashboard.charts.builtin;

import cn.devezhao.commons.CalendarUtils;
import cn.devezhao.persist4j.engine.ID;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.rebuild.core.Application;
import com.rebuild.core.metadata.MetadataHelper;
import com.rebuild.core.metadata.easymeta.EasyField;
import com.rebuild.core.metadata.easymeta.EasyMetaFactory;
import com.rebuild.core.service.dashboard.charts.ChartData;
import com.rebuild.core.service.notification.MessageBuilder;
import com.rebuild.core.support.general.FieldValueHelper;
import com.rebuild.core.support.i18n.I18nUtils;
import com.rebuild.core.support.i18n.Language;
import com.rebuild.utils.JSONUtils;

import java.util.Date;


public class FeedsSchedule extends ChartData implements BuiltinChart {

    
    public static final ID MYID = ID.valueOf("017-9000000000000002");

    public FeedsSchedule() {
        super(null);
        this.config = getChartConfig();
    }

    @Override
    public ID getChartId() {
        return MYID;
    }

    @Override
    public String getChartTitle() {
        return Language.L("我的日程");
    }

    @Override
    public JSON build() {
        Object[][] array = Application.createQueryNoFilter(
                "select feedsId,scheduleTime,content,contentMore,relatedRecord from Feeds" +
                        " where createdBy = ? and type = 4 and scheduleTime > ? order by scheduleTime")
                .setParameter(1, getUser())
                .setParameter(2, CalendarUtils.addDay(-30))  
                .setLimit(200)
                .array();

        final EasyField relatedRecordMeta = EasyMetaFactory.valueOf(
                MetadataHelper.getField("Feeds", "relatedRecord"));

        JSONArray list = new JSONArray();
        for (Object[] o : array) {
            
            JSONObject state = JSON.parseObject((String) o[3]);
            if (state.getString("finishTime") != null) continue;

            String scheduleTime = I18nUtils.formatDate((Date) o[1]);
            String content = (String) o[2];
            content = MessageBuilder.formatMessage(content);

            Object relatedRecord = o[4] == null
                    ? null : FieldValueHelper.wrapFieldValue(o[4], relatedRecordMeta);

            JSONObject item = JSONUtils.toJSONObject(
                    new String[]{"id", "scheduleTime", "content", "relatedRecord"},
                    new Object[]{o[0], scheduleTime, content, relatedRecord});
            list.add(item);
        }

        return list;
    }
}
