/*!
Copyright (c) REBUILD <https://getrebuild.com/> and/or its owners. All rights reserved.

rebuild is dual-licensed under commercial and open source licenses (GPLv3).
See LICENSE and COMMERCIAL in the project root for license information.
*/

package com.rebuild.core.service.feeds;

import cn.devezhao.persist4j.PersistManagerFactory;
import cn.devezhao.persist4j.Record;
import cn.devezhao.persist4j.engine.ID;
import com.rebuild.core.Application;
import com.rebuild.core.metadata.EntityHelper;
import com.rebuild.core.privileges.OperationDeniedException;
import com.rebuild.core.privileges.UserHelper;
import com.rebuild.core.service.general.recyclebin.RecycleStore;
import com.rebuild.core.support.i18n.Language;
import org.springframework.stereotype.Service;

import java.util.Set;


@Service
public class FeedsService extends BaseFeedsService {

    protected FeedsService(PersistManagerFactory aPMFactory) {
        super(aPMFactory);
    }

    @Override
    public int getEntityCode() {
        return EntityHelper.Feeds;
    }

    @Override
    public Record createOrUpdate(Record record) {
        Integer type = record.getInt("type");
        if (type != null && type == FeedsType.ANNOUNCEMENT.getMask()
                && !UserHelper.isAdmin(getCurrentUser())) {
            throw new OperationDeniedException(Language.L("仅管理员可发布公告"));
        }

        return super.createOrUpdate(record);
    }

    @Override
    public int delete(ID recordId) {
        
        Object[][] comments = Application.createQueryNoFilter(
                "select commentId from FeedsComment where feedsId = ?")
                .setParameter(1, recordId)
                .array();
        FeedsCommentService fcs = Application.getBean(FeedsCommentService.class);
        for (Object[] c : comments) {
            fcs.delete((ID) c[0]);
        }

        
        final RecycleStore recycleBin = useRecycleStore(recordId);

        int d = super.delete(recordId);

        if (recycleBin != null) recycleBin.store();
        return d;
    }

    
    @Override
    public Set<ID> awareMentionCreate(Record record) {
        return super.awareMentionCreate(record);
    }
}
