/*!
Copyright (c) REBUILD <https://getrebuild.com/> and/or its owners. All rights reserved.

rebuild is dual-licensed under commercial and open source licenses (GPLv3).
See LICENSE and COMMERCIAL in the project root for license information.
*/

package com.rebuild.core.service.general.series;

import cn.devezhao.persist4j.Field;
import cn.devezhao.persist4j.Record;
import com.alibaba.fastjson.JSONObject;
import com.rebuild.core.metadata.easymeta.EasyMetaFactory;


public class SeriesGeneratorFactory {

    
    public static SeriesGenerator create(Field field) {
        return new SeriesGenerator(EasyMetaFactory.valueOf(field));
    }

    
    public static String generate(Field field) {
        return generate(field, null);
    }

    
    public static String generate(Field field, Record record) {
        return create(field).generate(record);
    }

    
    public static String preview(JSONObject config) {
        return new SeriesGenerator(null, config).generate();
    }

    
    public static void zero(Field field) {
        zero(field, 0);
    }

    
    public static void zero(Field field, long reset) {
        new IncreasingVar(field).clean(reset);
    }

    
    public static long getCurrentIncreasingVarValue(Field field) {
        return new IncreasingVar(field).getCurrentValue();
    }
}
