/*!
Copyright (c) REBUILD <https://getrebuild.com/> and/or its owners. All rights reserved.

rebuild is dual-licensed under commercial and open source licenses (GPLv3).
See LICENSE and COMMERCIAL in the project root for license information.
*/

package com.rebuild.core.service.general.transform;

import cn.devezhao.persist4j.Entity;
import cn.devezhao.persist4j.Field;
import cn.devezhao.persist4j.Record;
import cn.devezhao.persist4j.engine.ID;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.rebuild.core.Application;
import com.rebuild.core.configuration.ConfigurationException;
import com.rebuild.core.metadata.EntityHelper;
import com.rebuild.core.metadata.MetadataHelper;
import com.rebuild.core.service.query.AdvFilterParser;
import com.rebuild.core.service.query.ParseHelper;
import lombok.extern.slf4j.Slf4j;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;


@Slf4j
public class RecordTransfomer37 extends RecordTransfomer {

    public RecordTransfomer37(ID transid) {
        super(transid);
    }

    public RecordTransfomer37(Entity targetEntity, JSONObject transConfig, boolean skipGuard) {
        super(targetEntity, transConfig, skipGuard);
    }

    @Override
    public ID transform(ID sourceRecordId, ID specMainId) {
        
        JSONObject fieldsMapping = transConfig.getJSONObject("fieldsMapping");
        if (fieldsMapping == null || fieldsMapping.isEmpty()) {
            throw new ConfigurationException("INVALID CONFIG OF TRANSFORM");
        }
        
        if (fieldsMapping.get("_") == null) return super.transform(sourceRecordId, specMainId);

        
        JSONArray fieldsMappingDetails = transConfig.getJSONArray("fieldsMappingDetails");
        
        if (fieldsMappingDetails == null) return super.transform(sourceRecordId, specMainId);

        
        
        
        final boolean checkNullable = transConfig.getBooleanValue("checkNullable35");

        List<Record> detailsList = new ArrayList<>();
        for (Object o : fieldsMappingDetails) {
            JSONObject fmd = (JSONObject) o;
            Entity[] fmdEntity = checkEntity(fmd);
            if (fmdEntity == null) continue;

            Entity dTargetEntity = fmdEntity[0];
            Entity dSourceEntity = fmdEntity[1];

            String querySourceSql = buildDetailsSourceSql(dSourceEntity, sourceRecordId);
            String filter = appendFilter(fmd);
            if (filter != null) querySourceSql = querySourceSql.replace("(1=1)", filter);

            Object[][] dArray = Application.createQueryNoFilter(querySourceSql).array();
            for (Object[] d : dArray) {
                detailsList.add(transformRecord(
                        dSourceEntity, dTargetEntity, fmd, (ID) d[0], null, false, false, checkNullable));
            }
        }

        Map<String, Object> dvMap4Detail = null;
        if (specMainId != null) {
            Field dtf = MetadataHelper.getDetailToMainField(targetEntity);
            dvMap4Detail = Collections.singletonMap(dtf.getName(), specMainId);
        }

        Entity sourceEntity = MetadataHelper.getEntity(sourceRecordId.getEntityCode());
        Record targetRecord = transformRecord(
                sourceEntity, targetEntity, fieldsMapping, sourceRecordId, dvMap4Detail, false, false, checkNullable);

        
        
        boolean fillbackFix = fillback(sourceRecordId, EntityHelper.newUnsavedId(targetRecord.getEntity().getEntityCode()));

        
        ID theNewId = saveRecord(targetRecord, detailsList.isEmpty() ? null : detailsList);

        
        if (fillbackFix) fillback(sourceRecordId, theNewId);

        return theNewId;
    }

    
    protected static Entity[] checkEntity(JSONObject fmd) {
        JSONObject fmdMeta = fmd.getJSONObject("_");

        String dTargetEntity = fmdMeta.getString("target");
        if (!MetadataHelper.containsEntity(dTargetEntity)) {
            log.warn("Tatget entity not longer exists : {}", dTargetEntity);
            return null;
        }

        String dSourceEntity = fmdMeta.getString("source");
        if (!MetadataHelper.containsEntity(dSourceEntity)) {
            log.warn("Source entity not longer exists : {}", dSourceEntity);
            return null;
        }

        return new Entity[] { MetadataHelper.getEntity(dTargetEntity), MetadataHelper.getEntity(dSourceEntity) };
    }

    
    protected static String appendFilter(JSONObject fmd) {
        JSONObject fmdMeta = fmd.getJSONObject("_");
        JSONObject hasFilter = fmdMeta.getJSONObject("filter");

        if (ParseHelper.validAdvFilter(hasFilter)) {
            return new AdvFilterParser(hasFilter).toSqlWhere();
        }
        return null;
    }

    
    protected static String buildDetailsSourceSql(Entity sourceEntity, ID sourceId) {
        String querySourceSql = null;
        if (sourceEntity.getMainEntity() != null) {
            querySourceSql = String.format(
                    "select %s from %s where %s = '%s' and (1=1) order by autoId asc",
                    sourceEntity.getPrimaryField().getName(), sourceEntity.getName(),
                    MetadataHelper.getDetailToMainField(sourceEntity).getName(), sourceId);
        }

        
        if (querySourceSql == null || sourceEntity.getEntityCode().equals(sourceId.getEntityCode())) {
            querySourceSql = String.format(
                    "select %s from %s where %s = '%s' and (1=1) order by autoId asc",
                    sourceEntity.getPrimaryField().getName(), sourceEntity.getName(),
                    sourceEntity.getPrimaryField().getName(), sourceId);
        }

        return querySourceSql;
    }
}
