/*!
Copyright (c) REBUILD <https://getrebuild.com/> and/or its owners. All rights reserved.

rebuild is dual-licensed under commercial and open source licenses (GPLv3).
See LICENSE and COMMERCIAL in the project root for license information.
*/

package com.rebuild.core.support;

import cn.devezhao.commons.CalendarUtils;
import cn.devezhao.persist4j.Record;
import cn.devezhao.persist4j.engine.ID;
import com.rebuild.core.Application;
import com.rebuild.core.metadata.EntityHelper;
import com.rebuild.core.support.task.TaskExecutors;
import com.rebuild.utils.CommonsUtils;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.ObjectUtils;


@Slf4j
public class CommonsLog {

    public static final int STATUS_OK = 1;  
    public static final int STATUS_ERROR = 2;

    public static final String TYPE_TRIGGER = "TRIGGER";
    public static final String TYPE_EXPORT = "EXPORT";
    public static final String TYPE_ACCESS = "ACCESS";
    public static final String TYPE_EXTFORM = "EXTFORM";

    
    public static void createLog(String type, ID user, ID source, String content) {
        createLog(type, user, source, content, STATUS_OK);
    }

    
    public static void createLog(String type, ID user, ID source, Throwable error) {
        createLog(type, user, source, error.getLocalizedMessage(), STATUS_ERROR);
    }

    
    public static void createLog(String type, ID user, ID source, String content, int status) {
        Record clog = EntityHelper.forNew(EntityHelper.CommonsLog, user);
        clog.setString("type", type);
        clog.setID("user", user);
        clog.setID("source", ObjectUtils.defaultIfNull(source, user));
        clog.setInt("status", status);
        clog.setDate("logTime", CalendarUtils.now());
        if (content != null) clog.setString("logContent", CommonsUtils.maxstr(content, 32767));

        TaskExecutors.queue(() -> Application.getCommonsService().create(clog, false));
    }
}
