/*!
Copyright (c) REBUILD <https://getrebuild.com/> and/or its owners. All rights reserved.

rebuild is dual-licensed under commercial and open source licenses (GPLv3).
See LICENSE and COMMERCIAL in the project root for license information.
*/

package com.rebuild.core.support.setup;

import cn.devezhao.commons.CalendarUtils;
import com.rebuild.core.support.RebuildConfiguration;
import com.rebuild.utils.CompressUtils;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.io.FileUtils;

import java.io.File;
import java.io.IOException;


@Slf4j
public class DatafileBackup extends DatabaseBackup {

    
    @Override
    public File backup(File backups) throws IOException {
        File rbdata = RebuildConfiguration.getFileOfData("");

        String destName = "backup_datafile." + CalendarUtils.getPlainDateTimeFormat().format(CalendarUtils.now()) + ".zip";
        File destZip = new File(backups, destName);

        CompressUtils.forceZip(destZip, rbdata, pathname -> {
            String name = pathname.getName();
            return !("_backups".equals(name) || "_log".equals(name) || "temp".equals(name) || "rebuild.pid".equals(name));
        });

        log.info("Backup succeeded : {} ({})", destZip, FileUtils.byteCountToDisplaySize(destZip.length()));

        return destZip;
    }
}
