/*!
Copyright (c) REBUILD <https://getrebuild.com/> and/or its owners. All rights reserved.

rebuild is dual-licensed under commercial and open source licenses (GPLv3).
See LICENSE and COMMERCIAL in the project root for license information.
*/

package com.rebuild.core.support.setup;


public class DbInfo {

    final private String desc;

    protected DbInfo(String desc) {
        this.desc = desc;
    }

    public boolean isOceanBase() {
        return desc.contains("OceanBase");
    }

    public boolean isH2() {
        return desc.contains("H2");
    }

    public boolean isMySQL56() {
        if (isOceanBase()) return false;
        return desc.contains("5.6.");
    }

    public boolean isMySQL80() {
        if (isOceanBase()) return false;
        return desc.contains("8.0.") || desc.contains("8.1.");
    }

    
    protected boolean isIgnoredSqlLine(String L) {
        if (isH2()) {
            
            return L.startsWith("fulltext ") || L.startsWith("unique ") || L.startsWith("index ");
        }

        if (isOceanBase()) {
            return L.startsWith("fulltext ");
        }

        if (isMySQL56()) {
            
            return L.startsWith("index IX0_attachment_folder");
        }

        return false;
    }
}
