/*!
Copyright (c) REBUILD <https://getrebuild.com/> and/or its owners. All rights reserved.

rebuild is dual-licensed under commercial and open source licenses (GPLv3).
See LICENSE and COMMERCIAL in the project root for license information.
*/

package com.rebuild.utils;

import cn.devezhao.commons.CalendarUtils;
import org.apache.commons.io.FileUtils;

import java.io.File;
import java.io.FileFilter;


public class FileFilterByLastModified implements FileFilter {

    private final long lessThisTime;

    
    public FileFilterByLastModified(int exceedDays) {
        this.lessThisTime = CalendarUtils.addDay(-exceedDays).getTime();
    }

    @Override
    public boolean accept(File file) {
        if (file.isHidden() || file.isDirectory() || file.lastModified() == 0) {
            return false;
        }
        return file.lastModified() < this.lessThisTime;
    }

    

    
    public static void deletes(File dir, int keepDays) {
        File[] ds = dir.listFiles(new FileFilterByLastModified(keepDays));
        if (ds == null) return;
        
        for (File d : ds) {
            if (d.isFile()) FileUtils.deleteQuietly(d);
        }
    }
}
