/*!
Copyright (c) REBUILD <https://getrebuild.com/> and/or its owners. All rights reserved.

rebuild is dual-licensed under commercial and open source licenses (GPLv3).
See LICENSE and COMMERCIAL in the project root for license information.
*/

package com.rebuild.web.admin;

import cn.devezhao.persist4j.engine.ID;
import com.rebuild.core.Application;
import com.rebuild.core.privileges.UserService;
import com.rebuild.core.support.CommandArgs;
import com.rebuild.core.support.License;
import com.rebuild.utils.AppUtils;
import org.apache.commons.lang3.StringUtils;

import javax.servlet.http.HttpServletRequest;
import java.util.ArrayList;
import java.util.List;


public class ProtectedAdmin {

    private static PaEntry[] PA;

    
    public static boolean allow(String uriOrKey, HttpServletRequest request) {
        if (Application.devMode()) PaEntry.valueOf(uriOrKey);  
        return allow(uriOrKey, AppUtils.getRequestUser(request));
    }

    
    public static boolean allow(String uriOrKey, ID adminUser) {
        if (!License.isRbvAttached()) return true;
        if (UserService.ADMIN_USER.equals(adminUser)) return true;

        if (PA == null) {
            String vv = CommandArgs.getString(CommandArgs._ProtectedAdmin);
            if (StringUtils.isBlank(vv)) PA = new PaEntry[0];
            else {
                List<PaEntry> pp = new ArrayList<>();
                for (String v : vv.split("[,;]")) {
                    pp.add(PaEntry.valueOf(v));
                }
                PA = pp.toArray(new PaEntry[0]);
            }
        }
        if (PA.length == 0) return true;

        for (PaEntry p : PA) {
            if (p.matches(uriOrKey)) return true;
        }
        return false;
    }

    
    enum PaEntry {
        
        SYS("/systems"),
        
        SSI("/integration/"),
        
        API("/apis-manager"),
        
        ENT("/entities;/entity/;/metadata/"),
        
        APR("/robot/approval"),
        
        TRA("/robot/transform"),
        
        TRI("/robot/trigger"),
        
        SOP("/robot/sop"),
        
        REP("/data/report-template"),
        
        IMP("/data/data-imports"),
        
        EXF("/extform"),
        
        PRO("/project"),
        
        FJS("/frontjs-code"),
        
        USR("/bizuser/users;bizuser/departments"),
        
        ROL("/bizuser/role-privileges"),
        
        TEM("/bizuser/teams"),
        
        LLG("/audit/login-logs"),
        
        REV("/audit/revision-history"),
        
        RCY("/audit/recycle-bin"),

        ;

        final private String[] paths;
        PaEntry(String paths) {
            this.paths = paths.split(";");
        }

        
        public boolean matches(String uriOrKey) {
            if (name().equals(uriOrKey)) return true;
            if (!uriOrKey.contains("/admin/")) return false;

            
            uriOrKey = "/" + uriOrKey.split("/admin/")[1];
            for (String p : paths) {
                if (uriOrKey.startsWith(p)) return true;
            }
            return false;
        }
    }
}
