/*!
Copyright (c) REBUILD <https://getrebuild.com/> and/or its owners. All rights reserved.

rebuild is dual-licensed under commercial and open source licenses (GPLv3).
See LICENSE and COMMERCIAL in the project root for license information.
*/

package com.rebuild.web.commons;

import cn.devezhao.commons.CalendarUtils;
import cn.devezhao.commons.CodecUtils;
import cn.devezhao.persist4j.engine.ID;
import com.alibaba.fastjson.JSON;
import com.rebuild.api.RespBody;
import com.rebuild.core.Application;
import com.rebuild.core.privileges.UserHelper;
import com.rebuild.core.support.ConfigurationItem;
import com.rebuild.core.support.RebuildConfiguration;
import com.rebuild.core.support.ShortUrls;
import com.rebuild.core.support.i18n.Language;
import com.rebuild.core.support.integration.QiniuCloud;
import com.rebuild.utils.JSONUtils;
import com.rebuild.web.BaseController;
import com.rebuild.web.IdParam;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.ModelAndView;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Collections;


@RestController
public class FileShareController extends BaseController {

    
    @GetMapping("/filex/make-url")
    public JSON makeUrl(HttpServletRequest request) {
        String fileUrl = getParameterNotNull(request, "url");
        return JSONUtils.toJSONObject("publicUrl", makePublicUrl(fileUrl));
    }

    
    @GetMapping("/filex/make-share")
    public JSON makeSharedFile(HttpServletRequest request) {
        Assert.isTrue(
                RebuildConfiguration.getBool(ConfigurationItem.FileSharable),
                Language.L("不允许分享文件"));

        String shareUrl4del = getParameter(request, "shareUrl");
        if (shareUrl4del != null && shareUrl4del.contains("/s/")) ShortUrls.invalid(shareUrl4del.split("/s/")[1]);

        String fileUrl = getParameterNotNull(request, "url");
        int time = getIntParameter(request, "time", 5);
        String shareKey = ShortUrls.make(fileUrl, time * 60, getRequestUser(request));

        String shareUrl = RebuildConfiguration.getHomeUrl("s/" + shareKey);
        return JSONUtils.toJSONObject("shareUrl", shareUrl);
    }

    @GetMapping("/s/{shareKey}")
    public ModelAndView viewSharedFile(@PathVariable String shareKey,
                                       HttpServletResponse response) throws IOException {
        if (!RebuildConfiguration.getBool(ConfigurationItem.FileSharable)) {
            response.sendError(403, Language.L("不允许分享文件"));
            return null;
        }

        String fileUrl = ShortUrls.retrieveUrl(shareKey);
        if (fileUrl == null) {
            response.sendError(403, Language.L("分享的文件已过期"));
            return null;
        }

        String publicUrl = makePublicUrl(fileUrl);
        return createModelAndView("/common/shared-file", Collections.singletonMap("publicUrl", publicUrl));
    }

    @GetMapping("/filex/all-make-share")
    public RespBody allShareFiles(HttpServletRequest request) {
        String sql = "select shortKey,longUrl,expireTime,createdOn,createdBy,shortId" +
                " from ShortUrl where (expireTime > ? or expireTime is null) and (1=1) order by createdOn desc";

        
        final ID user = getRequestUser(request);
        if (!UserHelper.isAdmin(user)) {
            sql = sql.replace("(1=1)", "createdBy = '" + user + "'");
        }

        Object[][] array = Application.createQueryNoFilter(sql)
                .setParameter(1, CalendarUtils.now())
                .setLimit(1000)
                .array();
        for (Object[] o : array) {
            o[0] = RebuildConfiguration.getHomeUrl("s/" + o[0]);
            o[4] = UserHelper.getName((ID) o[4]);
        }

        return RespBody.ok(array);
    }

    @PostMapping("/filex/del-make-share")
    public RespBody delShareFile(@IdParam ID shortId) {
        Application.getCommonsService().delete(shortId, false);
        return RespBody.ok();
    }

    @PostMapping("/filex/is-make-share")
    public RespBody isShareFile(HttpServletRequest request) {
        final String longUrl = getParameterNotNull(request, "longUrl");

        Object[] has = Application.createQueryNoFilter(
                "select shortKey from from ShortUrl where longUrl = ? and expireTime > ?")
                .setParameter(1, longUrl)
                .setParameter(2, CalendarUtils.now())
                .unique();
        return RespBody.ok(has == null ? null : has[0]);
    }

    
    private String makePublicUrl(String fileUrl) {
        String publicUrl;
        if (QiniuCloud.instance().available()) {
            publicUrl = QiniuCloud.instance().makeUrl(fileUrl, 15 * 60);
        } else {
            String e = CodecUtils.randomCode(40);
            Application.getCommonsCache().put(e, "rb", 5 * 60);

            publicUrl = "filex/access/" + fileUrl + "?e=" + e;
            publicUrl = RebuildConfiguration.getHomeUrl(publicUrl);
        }
        return publicUrl;
    }
}
