-- !!! MYSQL VERSION NOTICE !!!
-- IN 5.7 OR ABOVE :
-- YOU SHOULD REMOVE `ONLY_FULL_GROUP_BY` SQL_MODES IN my.cnf/my.ini
-- IN 8.0 OR ABOVE :
-- ONLY SUPPORT mysql_native_password AUTHENTICATION MODE. Add `default_authentication_plugin=mysql_native_password` TO my.cnf/my.ini

-- #1 database/user
-- 首次使用请移除以下注释以创建数据库和用户
/*
CREATE DATABASE rebuild30 COLLATE utf8mb4_general_ci;
CREATE USER 'rebuild'@'127.0.0.1' IDENTIFIED BY 'rebuild';
GRANT ALL PRIVILEGES ON rebuild30.* TO 'rebuild'@'127.0.0.1';
GRANT RELOAD ON *.* TO 'rebuild'@'127.0.0.1';
FLUSH PRIVILEGES;
USE rebuild30;
*/

-- #2 schemas
-- Generated by SchemaGenerator.java

-- ************ Entity [User] DDL ************
create table if not exists `user` (
  `USER_ID`            char(20) not null,
  `LOGIN_NAME`         varchar(100) not null comment '用户名',
  `PASSWORD`           varchar(100) not null comment '登录密码',
  `EMAIL`              varchar(100) comment '邮箱',
  `FULL_NAME`          varchar(100) comment '姓名',
  `AVATAR_URL`         varchar(200) comment '头像',
  `JOB_TITLE`          varchar(100) comment '职务',
  `WORKPHONE`          varchar(100) comment '工作电话',
  `DEPT_ID`            char(20) comment '部门',
  `ROLE_ID`            char(20) comment '角色',
  `IS_DISABLED`        char(1) default 'F' comment '是否禁用',
  `QUICK_CODE`         varchar(50),
  `EXTERNAL_ID`        varchar(100) comment '外部用户ID',
  `MODIFIED_ON`        timestamp not null default current_timestamp comment '修改时间',
  `MODIFIED_BY`        char(20) not null comment '修改人',
  `CREATED_BY`         char(20) not null comment '创建人',
  `CREATED_ON`         timestamp not null default current_timestamp comment '创建时间',
  primary key  (`USER_ID`),
  unique index UIX0_user (`LOGIN_NAME`),
  unique index UIX1_user (`EMAIL`),
  unique index UIX2_user (`EXTERNAL_ID`),
  index IX3_user (`QUICK_CODE`, `FULL_NAME`, `EMAIL`)
)Engine=InnoDB;

-- ************ Entity [Department] DDL ************
create table if not exists `department` (
  `DEPT_ID`            char(20) not null,
  `NAME`               varchar(100) not null comment '部门名称',
  `PARENT_DEPT`        char(20) comment '父级部门',
  `PRINCIPAL_ID`       char(20) comment '负责人',
  `IS_DISABLED`        char(1) default 'F' comment '是否禁用',
  `QUICK_CODE`         varchar(50),
  `EXTERNAL_ID`        varchar(100) comment '外部部门ID',
  `MODIFIED_ON`        timestamp not null default current_timestamp comment '修改时间',
  `MODIFIED_BY`        char(20) not null comment '修改人',
  `CREATED_BY`         char(20) not null comment '创建人',
  `CREATED_ON`         timestamp not null default current_timestamp comment '创建时间',
  primary key  (`DEPT_ID`),
  unique index UIX0_department (`EXTERNAL_ID`)
)Engine=InnoDB;

-- ************ Entity [Role] DDL ************
create table if not exists `role` (
  `ROLE_ID`            char(20) not null,
  `NAME`               varchar(100) not null comment '角色名称',
  `IS_DISABLED`        char(1) default 'F' comment '是否禁用',
  `QUICK_CODE`         varchar(50),
  `CREATED_BY`         char(20) not null comment '创建人',
  `CREATED_ON`         timestamp not null default current_timestamp comment '创建时间',
  `MODIFIED_ON`        timestamp not null default current_timestamp comment '修改时间',
  `MODIFIED_BY`        char(20) not null comment '修改人',
  primary key  (`ROLE_ID`)
)Engine=InnoDB;

-- ************ Entity [RolePrivileges] DDL ************
create table if not exists `role_privileges` (
  `PRIVILEGES_ID`      char(20) not null,
  `ROLE_ID`            char(20) not null,
  `ENTITY`             int(11) not null default '0' comment '哪个实体',
  `ZERO_KEY`           varchar(50) comment '扩展权限',
  `DEFINITION`         varchar(2000) comment '实体权限',
  primary key  (`PRIVILEGES_ID`),
  unique index UIX0_role_privileges (`ROLE_ID`, `ENTITY`, `ZERO_KEY`)
)Engine=InnoDB;

-- ************ Entity [RoleMember] DDL ************
create table if not exists `role_member` (
  `MEMBER_ID`          char(20) not null,
  `ROLE_ID`            char(20) not null,
  `USER_ID`            char(20) not null,
  primary key  (`MEMBER_ID`),
  unique index UIX0_role_member (`ROLE_ID`, `USER_ID`)
)Engine=InnoDB;

-- ************ Entity [Team] DDL ************
create table if not exists `team` (
  `TEAM_ID`            char(20) not null,
  `NAME`               varchar(100) not null comment '团队名称',
  `PRINCIPAL_ID`       char(20) comment '负责人',
  `IS_DISABLED`        char(1) default 'F' comment '是否禁用',
  `QUICK_CODE`         varchar(50),
  `CREATED_BY`         char(20) not null comment '创建人',
  `CREATED_ON`         timestamp not null default current_timestamp comment '创建时间',
  `MODIFIED_ON`        timestamp not null default current_timestamp comment '修改时间',
  `MODIFIED_BY`        char(20) not null comment '修改人',
  primary key  (`TEAM_ID`)
)Engine=InnoDB;

-- ************ Entity [TeamMember] DDL ************
create table if not exists `team_member` (
  `MEMBER_ID`          char(20) not null,
  `TEAM_ID`            char(20) not null,
  `USER_ID`            char(20) not null,
  primary key  (`MEMBER_ID`),
  unique index UIX0_team_member (`TEAM_ID`, `USER_ID`)
)Engine=InnoDB;

-- ************ Entity [ExternalUser] DDL ************
create table if not exists `external_user` (
  `USER_ID`            char(20) not null,
  `APP_USER`           varchar(100) not null,
  `APP_ID`             varchar(100) not null,
  `BIND_USER`          char(20) not null,
  primary key  (`USER_ID`),
  unique index UIX0_external_user (`APP_USER`, `APP_ID`)
)Engine=InnoDB;

-- ************ Entity [MetaEntity] DDL ************
create table if not exists `meta_entity` (
  `ENTITY_ID`          char(20) not null,
  `TYPE_CODE`          smallint(6) not null,
  `ENTITY_NAME`        varchar(100) not null,
  `PHYSICAL_NAME`      varchar(100) not null,
  `ENTITY_LABEL`       varchar(100) not null comment '(for description)',
  `COMMENTS`           varchar(300),
  `ICON`               varchar(60),
  `NAME_FIELD`         varchar(100),
  `MASTER_ENTITY`      varchar(100) comment '所属主实体 (明细实体)',
  `EXT_CONFIG`         varchar(700) comment '扩展配置 (JSON Map)',
  `CREATED_BY`         char(20) not null comment '创建人',
  `CREATED_ON`         timestamp not null default current_timestamp comment '创建时间',
  `MODIFIED_ON`        timestamp not null default current_timestamp comment '修改时间',
  `MODIFIED_BY`        char(20) not null comment '修改人',
  primary key  (`ENTITY_ID`),
  unique index UIX0_meta_entity (`TYPE_CODE`),
  unique index UIX1_meta_entity (`ENTITY_NAME`),
  unique index UIX2_meta_entity (`PHYSICAL_NAME`)
)Engine=InnoDB;

-- ************ Entity [MetaField] DDL ************
create table if not exists `meta_field` (
  `FIELD_ID`           char(20) not null,
  `BELONG_ENTITY`      varchar(100) not null,
  `FIELD_NAME`         varchar(100) not null,
  `PHYSICAL_NAME`      varchar(100) not null,
  `FIELD_LABEL`        varchar(100) not null comment '(for description)',
  `DISPLAY_TYPE`       varchar(100) comment '显示类型 (详见 DisplayType)',
  `NULLABLE`           char(1) default 'T',
  `CREATABLE`          char(1) default 'T',
  `UPDATABLE`          char(1) default 'T',
  `REPEATABLE`         char(1) default 'T',
  `QUERYABLE`          char(1) default 'T',
  `DEFAULT_VALUE`      varchar(300) comment '(此值不影响数据库默认值)',
  `MAX_LENGTH`         smallint(6) default '300',
  `REF_ENTITY`         varchar(100),
  `CASCADE`            varchar(20),
  `COMMENTS`           varchar(300),
  `EXT_CONFIG`         varchar(700) comment '扩展配置 (JSON Map)',
  `MODIFIED_ON`        timestamp not null default current_timestamp comment '修改时间',
  `CREATED_BY`         char(20) not null comment '创建人',
  `CREATED_ON`         timestamp not null default current_timestamp comment '创建时间',
  `MODIFIED_BY`        char(20) not null comment '修改人',
  primary key  (`FIELD_ID`),
  unique index UIX0_meta_field (`BELONG_ENTITY`, `FIELD_NAME`),
  unique index UIX1_meta_field (`BELONG_ENTITY`, `PHYSICAL_NAME`)
)Engine=InnoDB;

-- ************ Entity [PickList] DDL ************
create table if not exists `pick_list` (
  `ITEM_ID`            char(20) not null,
  `BELONG_ENTITY`      varchar(100) not null,
  `BELONG_FIELD`       varchar(100) not null,
  `TEXT`               varchar(100) not null,
  `SEQ`                int(11) default '0' comment '排序 (小到大)',
  `IS_DEFAULT`         char(1) default 'F',
  `IS_HIDE`            char(1) default 'F',
  `MASK_VALUE`         bigint(20) default '0' comment '(MultiSelect专用)',
  `COLOR`              varchar(10),
  `CREATED_ON`         timestamp not null default current_timestamp comment '创建时间',
  `CREATED_BY`         char(20) not null comment '创建人',
  `MODIFIED_ON`        timestamp not null default current_timestamp comment '修改时间',
  `MODIFIED_BY`        char(20) not null comment '修改人',
  primary key  (`ITEM_ID`),
  index IX0_pick_list (`BELONG_ENTITY`, `BELONG_FIELD`, `SEQ`)
)Engine=InnoDB;

-- ************ Entity [LayoutConfig] DDL ************
create table if not exists `layout_config` (
  `CONFIG_ID`          char(20) not null,
  `BELONG_ENTITY`      varchar(100) not null,
  `CONFIG`             text(65535) not null,
  `SHARE_TO`           varchar(420) default 'SELF' comment '共享给谁 (ALL/SELF/$MemberID)',
  `APPLY_TYPE`         varchar(20) not null comment '(FORM,DATALIST,NAV,TBA,ADD)',
  `CONFIG_NAME`        varchar(100) comment '名称',
  `MODIFIED_BY`        char(20) not null comment '修改人',
  `MODIFIED_ON`        timestamp not null default current_timestamp comment '修改时间',
  `CREATED_BY`         char(20) not null comment '创建人',
  `CREATED_ON`         timestamp not null default current_timestamp comment '创建时间',
  primary key  (`CONFIG_ID`)
)Engine=InnoDB;

-- ************ Entity [FilterConfig] DDL ************
create table if not exists `filter_config` (
  `CONFIG_ID`          char(20) not null,
  `BELONG_ENTITY`      varchar(100) not null,
  `CONFIG`             text(65535) not null,
  `SHARE_TO`           varchar(420) default 'SELF' comment '共享给谁 (可选值: ALL/SELF/$MemberID)',
  `FILTER_NAME`        varchar(100) not null comment '名称',
  `MODIFIED_BY`        char(20) not null comment '修改人',
  `MODIFIED_ON`        timestamp not null default current_timestamp comment '修改时间',
  `CREATED_BY`         char(20) not null comment '创建人',
  `CREATED_ON`         timestamp not null default current_timestamp comment '创建时间',
  primary key  (`CONFIG_ID`)
)Engine=InnoDB;

-- ************ Entity [DashboardConfig] DDL ************
create table if not exists `dashboard_config` (
  `CONFIG_ID`          char(20) not null,
  `CONFIG`             text(65535) not null,
  `SHARE_TO`           varchar(420) default 'SELF' comment '共享给谁 (可选值: ALL/SELF/$MemberID)',
  `TITLE`              varchar(100) not null comment '名称',
  `MODIFIED_ON`        timestamp not null default current_timestamp comment '修改时间',
  `MODIFIED_BY`        char(20) not null comment '修改人',
  `CREATED_ON`         timestamp not null default current_timestamp comment '创建时间',
  `CREATED_BY`         char(20) not null comment '创建人',
  primary key  (`CONFIG_ID`)
)Engine=InnoDB;

-- ************ Entity [ChartConfig] DDL ************
create table if not exists `chart_config` (
  `CHART_ID`           char(20) not null,
  `BELONG_ENTITY`      varchar(100) not null,
  `CONFIG`             text(65535) not null,
  `CHART_TYPE`         varchar(100) not null,
  `TITLE`              varchar(100) not null comment '名称',
  `MODIFIED_ON`        timestamp not null default current_timestamp comment '修改时间',
  `MODIFIED_BY`        char(20) not null comment '修改人',
  `CREATED_BY`         char(20) not null comment '创建人',
  `CREATED_ON`         timestamp not null default current_timestamp comment '创建时间',
  primary key  (`CHART_ID`)
)Engine=InnoDB;

-- ************ Entity [Classification] DDL ************
create table if not exists `classification` (
  `DATA_ID`            char(20) not null,
  `NAME`               varchar(100) not null comment '名称',
  `DESCRIPTION`        varchar(600),
  `IS_DISABLED`        char(1) default 'F',
  `OPEN_LEVEL`         smallint(6) default '0',
  `CREATED_BY`         char(20) not null comment '创建人',
  `CREATED_ON`         timestamp not null default current_timestamp comment '创建时间',
  `MODIFIED_BY`        char(20) not null comment '修改人',
  `MODIFIED_ON`        timestamp not null default current_timestamp comment '修改时间',
  primary key  (`DATA_ID`)
)Engine=InnoDB;

-- ************ Entity [ClassificationData] DDL ************
create table if not exists `classification_data` (
  `ITEM_ID`            char(20) not null,
  `DATA_ID`            char(20) not null,
  `NAME`               varchar(100) not null,
  `FULL_NAME`          varchar(191) not null comment '(包括父级名称, 用点号分割)',
  `PARENT`             char(20),
  `CODE`               varchar(50) default '0',
  `LEVEL`              smallint(6) default '0',
  `IS_HIDE`            char(1) default 'F',
  `QUICK_CODE`         varchar(50),
  `COLOR`              varchar(10),
  `MODIFIED_ON`        timestamp not null default current_timestamp comment '修改时间',
  `MODIFIED_BY`        char(20) not null comment '修改人',
  `CREATED_BY`         char(20) not null comment '创建人',
  `CREATED_ON`         timestamp not null default current_timestamp comment '创建时间',
  primary key  (`ITEM_ID`),
  index IX0_classification_data (`DATA_ID`, `PARENT`, `CODE`),
  index IX1_classification_data (`DATA_ID`, `FULL_NAME`, `QUICK_CODE`, `CODE`)
)Engine=InnoDB;

-- ************ Entity [ShareAccess] DDL ************
create table if not exists `share_access` (
  `ACCESS_ID`          char(20) not null,
  `BELONG_ENTITY`      varchar(100) not null comment '哪个实体',
  `RECORD_ID`          char(20) not null comment '记录 ID',
  `SHARE_TO`           char(20) not null comment '共享给谁',
  `RIGHTS`             int(11) not null default '0' comment '共享权限 (R=2,U=4,D=8,0=Auto)',
  `MODIFIED_ON`        timestamp not null default current_timestamp comment '修改时间',
  `MODIFIED_BY`        char(20) not null comment '修改人',
  `CREATED_BY`         char(20) not null comment '创建人',
  `CREATED_ON`         timestamp not null default current_timestamp comment '创建时间',
  primary key  (`ACCESS_ID`),
  index IX0_share_access (`BELONG_ENTITY`, `RECORD_ID`, `SHARE_TO`)
)Engine=InnoDB;

-- ************ Entity [SystemConfig] DDL ************
create table if not exists `system_config` (
  `CONFIG_ID`          char(20) not null,
  `ITEM`               varchar(100) not null,
  `VALUE`              varchar(600) not null,
  primary key  (`CONFIG_ID`),
  unique index UIX0_system_config (`ITEM`)
)Engine=InnoDB;

-- ************ Entity [Notification] DDL ************
create table if not exists `notification` (
  `MESSAGE_ID`         char(20) not null,
  `FROM_USER`          char(20) not null comment '发送人',
  `TO_USER`            char(20) not null comment '接收人',
  `MESSAGE`            varchar(3000) comment '内容',
  `UNREAD`             char(1) default 'T' comment '是否未读',
  `TYPE`               smallint(6) default '0' comment '消息分类',
  `RELATED_RECORD`     char(20) comment '相关记录',
  `CREATED_BY`         char(20) not null comment '创建人',
  `CREATED_ON`         timestamp not null default current_timestamp comment '创建时间',
  `MODIFIED_ON`        timestamp not null default current_timestamp comment '修改时间',
  `MODIFIED_BY`        char(20) not null comment '修改人',
  primary key  (`MESSAGE_ID`),
  index IX0_notification (`TO_USER`, `UNREAD`, `CREATED_ON`),
  index IX1_notification (`TO_USER`, `TYPE`, `CREATED_ON`)
)Engine=InnoDB;

-- ************ Entity [Attachment] DDL ************
create table if not exists `attachment` (
  `ATTACHMENT_ID`      char(20) not null,
  `BELONG_ENTITY`      smallint(6) default '0' comment '所属实体',
  `BELONG_FIELD`       varchar(100) comment '所属字段',
  `RELATED_RECORD`     char(20) comment '相关记录',
  `FILE_PATH`          varchar(300) not null comment '文件路径',
  `FILE_TYPE`          varchar(20) comment '文件类型',
  `FILE_SIZE`          bigint(20) default '0' comment '执行顺序',
  `FILE_NAME`          varchar(100) comment '文件名称',
  `IN_FOLDER`          char(20) comment '所在目录',
  `IS_DELETED`         char(1) default 'F' comment '是否删除',
  `MODIFIED_ON`        timestamp not null default current_timestamp comment '修改时间',
  `MODIFIED_BY`        char(20) not null comment '修改人',
  `CREATED_BY`         char(20) not null comment '创建人',
  `CREATED_ON`         timestamp not null default current_timestamp comment '创建时间',
  primary key  (`ATTACHMENT_ID`),
  index IX0_attachment (`BELONG_ENTITY`, `BELONG_FIELD`, `FILE_NAME`, `IS_DELETED`),
  index IX1_attachment (`IN_FOLDER`, `CREATED_ON`, `FILE_NAME`),
  index IX2_attachment (`RELATED_RECORD`)
)Engine=InnoDB;

-- ************ Entity [AttachmentFolder] DDL ************
create table if not exists `attachment_folder` (
  `FOLDER_ID`          char(20) not null,
  `NAME`               varchar(100) not null comment '目录名称',
  `PARENT`             char(20) comment '父级',
  `SCOPE`              varchar(420) default 'ALL' comment '哪些人可见 (可选值: ALL/SELF/$MemberID)',
  `CREATED_BY`         char(20) not null comment '创建人',
  `CREATED_ON`         timestamp not null default current_timestamp comment '创建时间',
  `MODIFIED_ON`        timestamp not null default current_timestamp comment '修改时间',
  `MODIFIED_BY`        char(20) not null comment '修改人',
  primary key  (`FOLDER_ID`),
  index IX0_attachment_folder (`SCOPE`, `CREATED_BY`)
)Engine=InnoDB;

-- ************ Entity [LoginLog] DDL ************
create table if not exists `login_log` (
  `LOG_ID`             char(20) not null,
  `USER`               char(20) not null comment '登陆用户',
  `IP_ADDR`            varchar(100) comment 'IP 地址',
  `USER_AGENT`         varchar(200) comment '客户端',
  `LOGIN_TIME`         timestamp not null default current_timestamp comment '登陆时间',
  `LOGOUT_TIME`        timestamp null default null comment '退出时间',
  primary key  (`LOG_ID`),
  index IX0_login_log (`USER`, `LOGIN_TIME`)
)Engine=InnoDB;

-- ************ Entity [AutoFillinConfig] DDL ************
create table if not exists `auto_fillin_config` (
  `CONFIG_ID`          char(20) not null,
  `BELONG_ENTITY`      varchar(100) not null,
  `BELONG_FIELD`       varchar(100) not null,
  `SOURCE_FIELD`       varchar(100) not null comment '引用实体的字段',
  `TARGET_FIELD`       varchar(100) not null comment '当前实体的字段',
  `EXT_CONFIG`         varchar(700) comment '扩展配置 (JSON Map)',
  `MODIFIED_ON`        timestamp not null default current_timestamp comment '修改时间',
  `MODIFIED_BY`        char(20) not null comment '修改人',
  `CREATED_BY`         char(20) not null comment '创建人',
  `CREATED_ON`         timestamp not null default current_timestamp comment '创建时间',
  primary key  (`CONFIG_ID`)
)Engine=InnoDB;

-- ************ Entity [RobotTriggerConfig] DDL ************
create table if not exists `robot_trigger_config` (
  `CONFIG_ID`          char(20) not null,
  `BELONG_ENTITY`      varchar(100) not null,
  `WHEN`               int(11) default '0' comment '动作 (累加值)',
  `WHEN_TIMER`         varchar(100) comment '定期执行',
  `WHEN_FILTER`        text(65535) comment '附加过滤器',
  `ACTION_TYPE`        varchar(50) not null comment '预定义的触发操作类型',
  `ACTION_CONTENT`     text(65535) comment '预定义的触发操作类型 (JSON Map)',
  `PRIORITY`           int(11) default '1' comment '执行优先级 (越大越高越先执行)',
  `NAME`               varchar(100) comment '触发器名称',
  `IS_DISABLED`        char(1) default 'F' comment '是否禁用',
  `CREATED_BY`         char(20) not null comment '创建人',
  `CREATED_ON`         timestamp not null default current_timestamp comment '创建时间',
  `MODIFIED_ON`        timestamp not null default current_timestamp comment '修改时间',
  `MODIFIED_BY`        char(20) not null comment '修改人',
  primary key  (`CONFIG_ID`)
)Engine=InnoDB;

-- ************ Entity [RobotApprovalConfig] DDL ************
create table if not exists `robot_approval_config` (
  `CONFIG_ID`          char(20) not null,
  `BELONG_ENTITY`      varchar(100) not null comment '应用实体',
  `NAME`               varchar(100) not null comment '流程名称',
  `FLOW_DEFINITION`    text(65535) comment '流程定义',
  `IS_DISABLED`        char(1) default 'F' comment '是否禁用',
  `MODIFIED_ON`        timestamp not null default current_timestamp comment '修改时间',
  `MODIFIED_BY`        char(20) not null comment '修改人',
  `CREATED_BY`         char(20) not null comment '创建人',
  `CREATED_ON`         timestamp not null default current_timestamp comment '创建时间',
  primary key  (`CONFIG_ID`)
)Engine=InnoDB;

-- ************ Entity [RobotApprovalStep] DDL ************
create table if not exists `robot_approval_step` (
  `STEP_ID`            char(20) not null,
  `RECORD_ID`          char(20) not null comment '审批记录',
  `APPROVAL_ID`        char(20) not null comment '审批流程',
  `NODE`               varchar(100) not null comment '审批节点',
  `APPROVER`           char(20) not null comment '审批人',
  `STATE`              smallint(6) default '1' comment '审批结果',
  `REMARK`             varchar(600) comment '批注',
  `APPROVED_TIME`      timestamp null default null comment '审批时间',
  `PREV_NODE`          varchar(100) not null comment '上一审批节点',
  `IS_CANCELED`        char(1) default 'F' comment '是否取消',
  `IS_WAITING`         char(1) default 'F' comment '是否生效',
  `IS_BACKED`          char(1) default 'F' comment '是否退回',
  `NODE_BATCH`         varchar(100) comment '审批节点批次',
  `CC_USERS`           varchar(420) comment '抄送人',
  `CC_ACCOUNTS`        varchar(500) comment '抄送外部人员',
  `ATTR_MORE`          varchar(700) comment '扩展属性 (JSON Map)',
  `MODIFIED_ON`        timestamp not null default current_timestamp comment '修改时间',
  `MODIFIED_BY`        char(20) not null comment '修改人',
  `CREATED_BY`         char(20) not null comment '创建人',
  `CREATED_ON`         timestamp not null default current_timestamp comment '创建时间',
  primary key  (`STEP_ID`),
  index IX0_robot_approval_step (`RECORD_ID`, `APPROVAL_ID`, `NODE`, `IS_CANCELED`, `IS_WAITING`, `IS_BACKED`, `NODE_BATCH`)
)Engine=InnoDB;

-- ************ Entity [RebuildApi] DDL ************
create table if not exists `rebuild_api` (
  `UNIQUE_ID`          char(20) not null,
  `APP_ID`             varchar(20) not null comment 'APPID',
  `APP_SECRET`         varchar(60) not null comment 'APPSECRET',
  `BIND_USER`          char(20) comment '绑定用户 (权限)',
  `BIND_IPS`           varchar(300) comment 'IP 白名单',
  `MODIFIED_ON`        timestamp not null default current_timestamp comment '修改时间',
  `MODIFIED_BY`        char(20) not null comment '修改人',
  `CREATED_BY`         char(20) not null comment '创建人',
  `CREATED_ON`         timestamp not null default current_timestamp comment '创建时间',
  primary key  (`UNIQUE_ID`),
  unique index UIX0_rebuild_api (`APP_ID`)
)Engine=InnoDB;

-- ************ Entity [RebuildApiRequest] DDL ************
create table if not exists `rebuild_api_request` (
  `REQUEST_ID`         char(20) not null,
  `APP_ID`             varchar(20) not null comment 'APPID',
  `REMOTE_IP`          varchar(100) not null comment '来源 IP',
  `REQUEST_URL`        varchar(300) not null comment '请求 URL',
  `REQUEST_BODY`       text(65535) comment '请求数据',
  `RESPONSE_BODY`      text(65535) not null comment '响应数据',
  `REQUEST_TIME`       timestamp not null default current_timestamp comment '请求时间',
  `RESPONSE_TIME`      timestamp not null default current_timestamp comment '响应时间',
  primary key  (`REQUEST_ID`),
  index IX0_rebuild_api_request (`APP_ID`, `REMOTE_IP`, `REQUEST_TIME`),
  fulltext index FIX1_rebuild_api_request (`REQUEST_BODY`),
  fulltext index FIX2_rebuild_api_request (`RESPONSE_BODY`)
)Engine=InnoDB;

-- ************ Entity [DataReportConfig] DDL ************
create table if not exists `data_report_config` (
  `CONFIG_ID`          char(20) not null,
  `BELONG_ENTITY`      varchar(100) not null comment '应用实体',
  `NAME`               varchar(100) not null comment '报表名称',
  `TEMPLATE_FILE`      varchar(200) comment '模板文件',
  `TEMPLATE_CONTENT`   text(65535) comment '模板内容',
  `TEMPLATE_TYPE`      smallint(6) default '1' comment '模板类型 (1=记录, 2=列表)',
  `EXTRA_DEFINITION`   text(65535) comment '扩展配置 (JSON Map)',
  `IS_DISABLED`        char(1) default 'F' comment '是否禁用',
  `MODIFIED_ON`        timestamp not null default current_timestamp comment '修改时间',
  `MODIFIED_BY`        char(20) not null comment '修改人',
  `CREATED_BY`         char(20) not null comment '创建人',
  `CREATED_ON`         timestamp not null default current_timestamp comment '创建时间',
  primary key  (`CONFIG_ID`)
)Engine=InnoDB;

-- ************ Entity [RecycleBin] DDL ************
create table if not exists `recycle_bin` (
  `RECYCLE_ID`         char(20) not null,
  `BELONG_ENTITY`      varchar(100) not null comment '所属实体',
  `RECORD_ID`          char(20) not null comment 'ID 字段值',
  `RECORD_NAME`        varchar(191) not null comment '名称字段值',
  `RECORD_CONTENT`     longtext not null comment '数据',
  `DELETED_BY`         char(20) not null comment '删除人',
  `DELETED_ON`         timestamp not null default current_timestamp comment '删除时间',
  `CHANNEL_WITH`       char(20) comment '删除渠道 (空为直接删除, 否则为关联删除)',
  primary key  (`RECYCLE_ID`),
  index IX0_recycle_bin (`BELONG_ENTITY`, `RECORD_NAME`, `DELETED_BY`, `DELETED_ON`),
  index IX1_recycle_bin (`RECORD_ID`, `CHANNEL_WITH`)
)Engine=InnoDB;

-- ************ Entity [RevisionHistory] DDL ************
create table if not exists `revision_history` (
  `REVISION_ID`        char(20) not null,
  `BELONG_ENTITY`      varchar(100) not null comment '所属实体',
  `RECORD_ID`          char(20) not null comment '记录 ID',
  `REVISION_TYPE`      smallint(6) default '1' comment '变更类型',
  `REVISION_CONTENT`   longtext not null comment '变更数据',
  `REVISION_BY`        char(20) not null comment '操作人',
  `REVISION_ON`        timestamp not null default current_timestamp comment '操作时间',
  `CHANNEL_WITH`       char(20) comment '变更渠道 (空为直接, 否则为关联)',
  `IP_ADDR`            varchar(100) comment 'IP 地址',
  `AUTO_ID`            bigint(20) not null auto_increment comment '执行顺序',
  primary key  (`REVISION_ID`),
  unique index AIX0_revision_history (`AUTO_ID`),
  index IX1_revision_history (`BELONG_ENTITY`, `REVISION_TYPE`, `REVISION_BY`, `REVISION_ON`),
  index IX2_revision_history (`RECORD_ID`, `CHANNEL_WITH`)
)Engine=InnoDB;

-- ************ Entity [SmsendLog] DDL ************
create table if not exists `smsend_log` (
  `SEND_ID`            char(20) not null,
  `TO`                 varchar(100) not null comment '接收人',
  `CONTENT`            text(65535) not null comment '发送内容',
  `TYPE`               smallint(6) default '0' comment '(1=短信; 2=邮件)',
  `SEND_TIME`          timestamp not null default current_timestamp comment '发送时间',
  `SEND_RESULT`        varchar(191) comment '发送结果 (xxx|ERR:xxx)',
  primary key  (`SEND_ID`),
  index IX0_smsend_log (`TYPE`, `SEND_TIME`, `SEND_RESULT`)
)Engine=InnoDB;

-- ************ Entity [Language] DDL ************
create table if not exists `language` (
  `LANG_ID`            char(20) not null,
  `LOCALE`             varchar(10) not null comment 'Locale',
  `NAME`               varchar(500) not null comment '语言名',
  `VALUE`              varchar(500) not null comment '语言值',
  primary key  (`LANG_ID`),
  index IX0_language (`LOCALE`)
)Engine=InnoDB;

-- ************ Entity [TransformConfig] DDL ************
create table if not exists `transform_config` (
  `CONFIG_ID`          char(20) not null,
  `BELONG_ENTITY`      varchar(100) not null comment '源实体',
  `TARGET_ENTITY`      varchar(100) not null comment '目标实体',
  `NAME`               varchar(100) comment '名称',
  `CONFIG`             text(65535) comment '映射配置',
  `IS_DISABLED`        char(1) default 'F' comment '是否禁用',
  `MODIFIED_ON`        timestamp not null default current_timestamp comment '修改时间',
  `MODIFIED_BY`        char(20) not null comment '修改人',
  `CREATED_BY`         char(20) not null comment '创建人',
  `CREATED_ON`         timestamp not null default current_timestamp comment '创建时间',
  primary key  (`CONFIG_ID`)
)Engine=InnoDB;

-- ************ Entity [FrontjsCode] DDL ************
create table if not exists `frontjs_code` (
  `CODE_ID`            char(20) not null,
  `NAME`               varchar(100) not null comment '名称',
  `APPLY_PATH`         varchar(200) comment '匹配路径',
  `CODE`               text(65535) comment '代码',
  `ES5_CODE`           text(65535) comment 'ES5 代码',
  `MODIFIED_ON`        timestamp not null default current_timestamp comment '修改时间',
  `MODIFIED_BY`        char(20) not null comment '修改人',
  `CREATED_BY`         char(20) not null comment '创建人',
  `CREATED_ON`         timestamp not null default current_timestamp comment '创建时间',
  primary key  (`CODE_ID`)
)Engine=InnoDB;

-- ************ Entity [NreferenceItem] DDL ************
create table if not exists `nreference_item` (
  `ITEM_ID`            char(20) not null,
  `BELONG_ENTITY`      varchar(100) not null comment '哪个实体',
  `BELONG_FIELD`       varchar(100) not null comment '哪个字段',
  `RECORD_ID`          char(20) not null comment '记录 ID',
  `REFERENCE_ID`       char(20) not null comment '引用 ID',
  `SEQ`                bigint(20) not null auto_increment comment '前后顺序',
  primary key  (`ITEM_ID`),
  unique index AIX0_nreference_item (`SEQ`),
  index IX1_nreference_item (`BELONG_ENTITY`),
  unique index UIX2_nreference_item (`BELONG_FIELD`, `RECORD_ID`, `REFERENCE_ID`)
)Engine=InnoDB;

-- ************ Entity [Feeds] DDL ************
create table if not exists `feeds` (
  `FEEDS_ID`           char(20) not null,
  `TYPE`               smallint(6) not null default '1' comment '类型',
  `CONTENT`            text(65535) not null comment '内容',
  `CONTENT_MORE`       text(65535) comment '附加内容',
  `IMAGES`             varchar(700) comment '图片',
  `ATTACHMENTS`        varchar(700) comment '附件',
  `RELATED_RECORD`     char(20) comment '相关记录',
  `SCHEDULE_TIME`      timestamp null default null comment '日程时间',
  `SCOPE`              varchar(20) default 'ALL' comment '可见范围 (ALL/SELF/$TeamID)',
  `AUTO_LOCATION`      varchar(100) comment '发布位置',
  `CREATED_BY`         char(20) not null comment '创建人',
  `CREATED_ON`         timestamp not null default current_timestamp comment '创建时间',
  `MODIFIED_ON`        timestamp not null default current_timestamp comment '修改时间',
  `MODIFIED_BY`        char(20) not null comment '修改人',
  primary key  (`FEEDS_ID`),
  index IX0_feeds (`CREATED_ON`, `SCOPE`, `TYPE`, `CREATED_BY`),
  index IX1_feeds (`RELATED_RECORD`),
  index IX2_feeds (`TYPE`, `SCHEDULE_TIME`, `CREATED_BY`),
  fulltext index FIX3_feeds (`CONTENT`)
)Engine=InnoDB;

-- ************ Entity [FeedsComment] DDL ************
create table if not exists `feeds_comment` (
  `COMMENT_ID`         char(20) not null,
  `FEEDS_ID`           char(20) not null comment '相关动态',
  `CONTENT`            text(65535) not null comment '内容',
  `IMAGES`             varchar(700) comment '图片',
  `ATTACHMENTS`        varchar(700) comment '附件',
  `MODIFIED_ON`        timestamp not null default current_timestamp comment '修改时间',
  `MODIFIED_BY`        char(20) not null comment '修改人',
  `CREATED_BY`         char(20) not null comment '创建人',
  `CREATED_ON`         timestamp not null default current_timestamp comment '创建时间',
  primary key  (`COMMENT_ID`),
  index IX0_feeds_comment (`FEEDS_ID`)
)Engine=InnoDB;

-- ************ Entity [FeedsLike] DDL ************
create table if not exists `feeds_like` (
  `LIKE_ID`            char(20) not null,
  `SOURCE`             char(20) not null comment '哪个动态/评论',
  `CREATED_BY`         char(20) not null comment '创建人',
  `CREATED_ON`         timestamp not null default current_timestamp comment '创建时间',
  primary key  (`LIKE_ID`),
  index IX0_feeds_like (`SOURCE`, `CREATED_BY`)
)Engine=InnoDB;

-- ************ Entity [FeedsMention] DDL ************
create table if not exists `feeds_mention` (
  `MENTION_ID`         char(20) not null,
  `FEEDS_ID`           char(20) not null comment '哪个动态',
  `COMMENT_ID`         char(20) comment '哪个评论',
  `USER`               char(20) not null comment '哪个用户',
  primary key  (`MENTION_ID`),
  index IX0_feeds_mention (`USER`, `FEEDS_ID`, `COMMENT_ID`)
)Engine=InnoDB;

-- ************ Entity [FeedsStatus] DDL ************
create table if not exists `feeds_status` (
  `STATUS_ID`          char(20) not null,
  `FEEDS_ID`           char(20) not null comment '哪个动态',
  `CONTENT`            text(65535) comment '扩展内容',
  `CREATED_BY`         char(20) not null comment '创建人',
  `CREATED_ON`         timestamp not null default current_timestamp comment '创建时间',
  primary key  (`STATUS_ID`),
  index IX0_feeds_status (`FEEDS_ID`, `CREATED_BY`, `CREATED_ON`)
)Engine=InnoDB;

-- ************ Entity [ProjectConfig] DDL ************
create table if not exists `project_config` (
  `CONFIG_ID`          char(20) not null,
  `PROJECT_NAME`       varchar(100) not null comment '项目名称',
  `PROJECT_CODE`       varchar(10) not null comment '项目 ID',
  `ICON_NAME`          varchar(30) comment '图标',
  `COMMENTS`           varchar(300) comment '备注',
  `PRINCIPAL`          char(20) comment '负责人',
  `MEMBERS`            varchar(420) comment '项目成员 ($MemberID)',
  `SCOPE`              smallint(6) default '1' comment '可见范围 (1=公开 2=成员)',
  `EXTRA_DEFINITION`   text(65535) comment '扩展配置 (JSON Map)',
  `STATUS`             smallint(6) default '1' comment '状态 (1=正常 2=归档)',
  `CREATED_BY`         char(20) not null comment '创建人',
  `CREATED_ON`         timestamp not null default current_timestamp comment '创建时间',
  `MODIFIED_BY`        char(20) not null comment '修改人',
  `MODIFIED_ON`        timestamp not null default current_timestamp comment '修改时间',
  primary key  (`CONFIG_ID`),
  unique index UIX0_project_config (`PROJECT_CODE`)
)Engine=InnoDB;

-- ************ Entity [ProjectPlanConfig] DDL ************
create table if not exists `project_plan_config` (
  `CONFIG_ID`          char(20) not null,
  `PROJECT_ID`         char(20) not null comment '相关项目',
  `PLAN_NAME`          varchar(100) not null comment '面板名称',
  `COMMENTS`           varchar(300) comment '备注',
  `SEQ`                int(11) default '0' comment '排序 (小到大)',
  `FLOW_STATUS`        smallint(6) default '1' comment '工作流状态',
  `FLOW_NEXTS`         varchar(420) comment '可流转到哪个面板',
  primary key  (`CONFIG_ID`),
  index IX0_project_plan_config (`PROJECT_ID`, `SEQ`)
)Engine=InnoDB;

-- ************ Entity [ProjectTask] DDL ************
create table if not exists `project_task` (
  `TASK_ID`            char(20) not null,
  `PROJECT_ID`         char(20) not null comment '项目',
  `PROJECT_PLAN_ID`    char(20) not null comment '任务面板',
  `TASK_NUMBER`        bigint(20) not null comment '任务编号',
  `TASK_NAME`          varchar(191) not null comment '任务标题',
  `EXECUTOR`           char(20) comment '执行人',
  `PARTNERS`           varchar(420) default 'ALL' comment '参与者 (可选值: $UserID)',
  `PRIORITY`           smallint(6) default '1' comment '优先级 (0=较低 1=普通 2=紧急 3=非常紧急)',
  `STATUS`             smallint(6) default '0' comment '状态 (0=未完成/未开始)',
  `DEADLINE`           timestamp null default null comment '截至时间',
  `START_TIME`         timestamp null default null comment '开始时间',
  `END_TIME`           timestamp null default null comment '完成时间',
  `DESCRIPTION`        text(65535) comment '备注',
  `ATTACHMENTS`        varchar(700) comment '附件',
  `PARENT_TASK_ID`     char(20) comment '父级任务',
  `RELATED_RECORD`     char(20) comment '相关记录',
  `SEQ`                int(11) default '0' comment '排序 (小到大)',
  `MODIFIED_ON`        timestamp not null default current_timestamp comment '修改时间',
  `MODIFIED_BY`        char(20) not null comment '修改人',
  `CREATED_BY`         char(20) not null comment '创建人',
  `CREATED_ON`         timestamp not null default current_timestamp comment '创建时间',
  primary key  (`TASK_ID`),
  index IX0_project_task (`PROJECT_ID`, `PROJECT_PLAN_ID`, `SEQ`),
  index IX1_project_task (`PROJECT_ID`, `TASK_NUMBER`, `TASK_NAME`, `STATUS`),
  index IX2_project_task (`RELATED_RECORD`, `PROJECT_ID`)
)Engine=InnoDB;

-- ************ Entity [ProjectTaskRelation] DDL ************
create table if not exists `project_task_relation` (
  `RELATION_ID`        char(20) not null,
  `TASK_ID`            char(20) not null,
  `RELATION_TASK_ID`   char(20) not null,
  `RELATION_TYPE`      smallint(6) default '0' comment '关系类型 (0=相关 1=前置 2=后置)',
  primary key  (`RELATION_ID`),
  index IX0_project_task_relation (`TASK_ID`, `RELATION_TASK_ID`)
)Engine=InnoDB;

-- ************ Entity [ProjectTaskComment] DDL ************
create table if not exists `project_task_comment` (
  `COMMENT_ID`         char(20) not null,
  `TASK_ID`            char(20) not null comment '相关任务',
  `CONTENT`            text(65535) not null comment '评论内容',
  `ATTACHMENTS`        varchar(700) comment '附件',
  `MODIFIED_ON`        timestamp not null default current_timestamp comment '修改时间',
  `MODIFIED_BY`        char(20) not null comment '修改人',
  `CREATED_BY`         char(20) not null comment '创建人',
  `CREATED_ON`         timestamp not null default current_timestamp comment '创建时间',
  primary key  (`COMMENT_ID`),
  index IX0_project_task_comment (`TASK_ID`)
)Engine=InnoDB;

-- ************ Entity [ProjectTaskTag] DDL ************
create table if not exists `project_task_tag` (
  `TAG_ID`             char(20) not null,
  `PROJECT_ID`         char(20) not null comment '所属项目',
  `TAG_NAME`           varchar(100) not null comment '标签',
  `COLOR`              varchar(20) comment '颜色',
  `CREATED_BY`         char(20) not null comment '创建人',
  `CREATED_ON`         timestamp not null default current_timestamp comment '创建时间',
  primary key  (`TAG_ID`),
  index IX0_project_task_tag (`TAG_NAME`, `PROJECT_ID`)
)Engine=InnoDB;

-- ************ Entity [ProjectTaskTagRelation] DDL ************
create table if not exists `project_task_tag_relation` (
  `RELATION_ID`        char(20) not null,
  `TASK_ID`            char(20) not null,
  `TAG_ID`             char(20) not null,
  `CREATED_BY`         char(20) not null comment '创建人',
  `CREATED_ON`         timestamp not null default current_timestamp comment '创建时间',
  primary key  (`RELATION_ID`),
  unique index UIX0_project_task_tag_relation (`TASK_ID`, `TAG_ID`),
  index IX1_project_task_tag_relation (`CREATED_ON`)
)Engine=InnoDB;

-- ************ Entity [ExtformConfig] DDL ************
create table if not exists `extform_config` (
  `CONFIG_ID`          char(20) not null,
  `BELONG_ENTITY`      varchar(100) not null comment '所属实体',
  `NAME`               varchar(100) not null comment '名称',
  `PORTAL_CONFIG`      text(65535) comment '表单配置 (JSON Map)',
  `START_TIME`         timestamp null default null comment '开始时间',
  `END_TIME`           timestamp null default null comment '结束时间',
  `BIND_USER`          char(20) comment '数据绑定用户',
  `HOOK_URL`           varchar(300) comment '回调地址',
  `HOOK_SECRET`        varchar(300) comment '回调安全码',
  `CREATED_BY`         char(20) not null comment '创建人',
  `CREATED_ON`         timestamp not null default current_timestamp comment '创建时间',
  `MODIFIED_ON`        timestamp not null default current_timestamp comment '修改时间',
  `MODIFIED_BY`        char(20) not null comment '修改人',
  primary key  (`CONFIG_ID`)
)Engine=InnoDB;

-- ************ Entity [RobotSopConfig] DDL ************
create table if not exists `robot_sop_config` (
  `CONFIG_ID`          char(20) not null,
  `BELONG_ENTITY`      varchar(100) not null comment '应用实体',
  `NAME`               varchar(100) not null comment '进度名称',
  `SOP_DEFINITION`     text(65535) comment '进度定义',
  `IS_DISABLED`        char(1) default 'F' comment '是否禁用',
  `MODIFIED_BY`        char(20) not null comment '修改人',
  `MODIFIED_ON`        timestamp not null default current_timestamp comment '修改时间',
  `CREATED_BY`         char(20) not null comment '创建人',
  `CREATED_ON`         timestamp not null default current_timestamp comment '创建时间',
  primary key  (`CONFIG_ID`)
)Engine=InnoDB;

-- ************ Entity [RobotSopStep] DDL ************
create table if not exists `robot_sop_step` (
  `STEP_ID`            char(20) not null,
  `RECORD_ID`          char(20) not null comment '业务记录',
  `SOP_ID`             char(20) not null comment '业务进度',
  `NODE`               varchar(100) not null comment '进度节点',
  `OPERATOR`           char(20) not null comment '操作人',
  `ACHIEVED_TIME`      timestamp not null default current_timestamp comment '达成时间',
  `ACHIEVED_CONTENT`   text(65535) comment '达成内容',
  `PREV_STEP`          char(20),
  `MODIFIED_ON`        timestamp not null default current_timestamp comment '修改时间',
  `MODIFIED_BY`        char(20) not null comment '修改人',
  `CREATED_BY`         char(20) not null comment '创建人',
  `CREATED_ON`         timestamp not null default current_timestamp comment '创建时间',
  primary key  (`STEP_ID`),
  index IX0_robot_sop_step (`RECORD_ID`, `SOP_ID`, `NODE`, `PREV_STEP`)
)Engine=InnoDB;

-- ************ Entity [TagItem] DDL ************
create table if not exists `tag_item` (
  `ITEM_ID`            char(20) not null,
  `BELONG_ENTITY`      varchar(100) not null comment '哪个实体',
  `BELONG_FIELD`       varchar(100) not null comment '哪个字段',
  `RECORD_ID`          char(20) not null comment '记录 ID',
  `TAG_NAME`           varchar(100) not null comment '标签名称',
  `SEQ`                bigint(20) not null auto_increment comment '前后顺序',
  primary key  (`ITEM_ID`),
  unique index AIX0_tag_item (`SEQ`),
  index IX1_tag_item (`BELONG_ENTITY`),
  unique index UIX2_tag_item (`BELONG_FIELD`, `RECORD_ID`, `TAG_NAME`)
)Engine=InnoDB;

-- ************ Entity [ShortUrl] DDL ************
create table if not exists `short_url` (
  `SHORT_ID`           char(20) not null,
  `SHORT_KEY`          varchar(40) not null comment '短链ID',
  `LONG_URL`           varchar(600) not null comment '对应长链/文件',
  `EXPIRE_TIME`        timestamp null default null comment '到期时间',
  `CHECK_PASSWD`       timestamp null default null comment '密码',
  `CREATED_BY`         char(20) not null comment '创建人',
  `CREATED_ON`         timestamp not null default current_timestamp comment '创建时间',
  primary key  (`SHORT_ID`),
  index IX0_short_url (`CREATED_BY`, `CREATED_ON`, `EXPIRE_TIME`),
  index IX1_short_url (`SHORT_KEY`)
)Engine=InnoDB;

-- ************ Entity [CommonsLock] DDL ************
create table if not exists `commons_lock` (
  `LOCK_ID`            char(20) not null,
  `SOURCE`             char(20) not null comment '锁定记录',
  `LOCK_USER`          char(20) not null comment '锁定人',
  `LOCK_TIME`          timestamp not null default current_timestamp comment '锁定时间',
  primary key  (`LOCK_ID`),
  index IX0_commons_lock (`LOCK_USER`, `LOCK_TIME`),
  unique index UIX1_commons_lock (`SOURCE`)
)Engine=InnoDB;

-- ************ Entity [CommonsLog] DDL ************
create table if not exists `commons_log` (
  `LOG_ID`             char(20) not null,
  `TYPE`               varchar(20) not null,
  `USER`               char(20) not null,
  `SOURCE`             char(20) not null,
  `LOG_CONTENT`        text(65535),
  `LOG_TIME`           timestamp not null default current_timestamp,
  `STATUS`             smallint(6) default '1',
  primary key  (`LOG_ID`),
  index IX0_commons_log (`TYPE`, `LOG_TIME`, `SOURCE`)
)Engine=InnoDB;

-- #3 datas

-- User
insert into `user` (`USER_ID`, `LOGIN_NAME`, `PASSWORD`, `FULL_NAME`, `DEPT_ID`, `ROLE_ID`, `IS_DISABLED`, `CREATED_ON`, `CREATED_BY`, `MODIFIED_ON`, `MODIFIED_BY`, `QUICK_CODE`)
  values
  ('001-0000000000000000', 'system', 'system', '系统用户', '002-0000000000000001', '003-0000000000000001', 'T', CURRENT_TIMESTAMP, '001-0000000000000000', CURRENT_TIMESTAMP, '001-0000000000000000', 'XTYH'),
  ('001-0000000000000001', 'admin', '8c6976e5b5410415bde908bd4dee15dfb167a9c873fc4bb8a81f6f2ab448a918', '超级管理员', '002-0000000000000001', '003-0000000000000001', 'F', CURRENT_TIMESTAMP, '001-0000000000000000', CURRENT_TIMESTAMP, '001-0000000000000000', 'CJGLY'),
  ('001-9000000000000001', 'rebuild', 'cf44886e54f424ce136dc38e4d9ef5b4b556d06060705262d6fcce02b4322539', 'RB示例用户', '002-9000000000000001', '003-9000000000000001', 'F', CURRENT_TIMESTAMP, '001-0000000000000000', CURRENT_TIMESTAMP, '001-0000000000000000', 'RBSLYH');
-- Department
insert into `department` (`DEPT_ID`, `NAME`, `CREATED_ON`, `CREATED_BY`, `MODIFIED_ON`, `MODIFIED_BY`, `QUICK_CODE`)
  values
  ('002-0000000000000001', '总部', CURRENT_TIMESTAMP, '001-0000000000000000', CURRENT_TIMESTAMP, '001-0000000000000000', 'ZB'),
  ('002-9000000000000001', 'RB示例部门', CURRENT_TIMESTAMP, '001-0000000000000000', CURRENT_TIMESTAMP, '001-0000000000000000', 'RBSLBM');
-- Role
insert into `role` (`ROLE_ID`, `NAME`, `CREATED_ON`, `CREATED_BY`, `MODIFIED_ON`, `MODIFIED_BY`, `QUICK_CODE`)
  values
  ('003-0000000000000001', '管理员', CURRENT_TIMESTAMP, '001-0000000000000000', CURRENT_TIMESTAMP, '001-0000000000000000', 'GLY'),
  ('003-9000000000000001', 'RB示例角色', CURRENT_TIMESTAMP, '001-0000000000000000', CURRENT_TIMESTAMP, '001-0000000000000000', 'RBSLJS');
-- Team
insert into `team` (`TEAM_ID`, `NAME`, `CREATED_ON`, `CREATED_BY`, `MODIFIED_ON`, `MODIFIED_BY`, `QUICK_CODE`)
  values
  ('006-9000000000000001', 'RB示例团队', CURRENT_TIMESTAMP, '001-0000000000000000', CURRENT_TIMESTAMP, '001-0000000000000000', 'RBSLTD');
insert into `team_member` (`MEMBER_ID`, `TEAM_ID`, `USER_ID`)
  values
  ('007-9000000000000001', '006-9000000000000001', '001-9000000000000001');

-- Layouts
insert into `layout_config` (`CONFIG_ID`, `BELONG_ENTITY`, `CONFIG`, `APPLY_TYPE`, `SHARE_TO`, `CREATED_ON`, `CREATED_BY`, `MODIFIED_ON`, `MODIFIED_BY`)
  values
  ('013-9000000000000001', 'Department', '[{"field":"name"},{"field":"principalId"},{"field":"parentDept"},{"field":"isDisabled"}]', 'FORM', 'ALL', CURRENT_TIMESTAMP, '001-0000000000000001', CURRENT_TIMESTAMP, '001-0000000000000001'),
  ('013-9000000000000002', 'User', '[{"field":"fullName"},{"field":"jobTitle"},{"field":"workphone"},{"field":"email"},{"field":"loginName"},{"field":"password"},{"field":"$DIVIDER$"},{"field":"deptId"},{"field":"roleId"},{"field":"isDisabled"}]', 'FORM', 'ALL', CURRENT_TIMESTAMP, '001-0000000000000001', CURRENT_TIMESTAMP, '001-0000000000000001'),
  ('013-9000000000000003', 'Role', '[{"field":"name"},{"field":"isDisabled"}]', 'FORM', 'ALL', CURRENT_TIMESTAMP, '001-0000000000000001', CURRENT_TIMESTAMP, '001-0000000000000001'),
  ('013-9000000000000004', 'Team', '[{"field":"name"},{"field":"principalId"},{"field":"isDisabled"}]', 'FORM', 'ALL', CURRENT_TIMESTAMP, '001-0000000000000001', CURRENT_TIMESTAMP, '001-0000000000000001'),
  ('013-9000000000000005', 'User', '[{"field":"fullName"},{"field":"jobTitle"},{"field":"deptId"},{"field":"workphone"},{"field":"email"},{"field":"loginName"},{"field":"roleId"},{"field":"isDisabled"},{"field":"createdOn"}]', 'DATALIST', 'ALL', CURRENT_TIMESTAMP, '001-0000000000000001', CURRENT_TIMESTAMP, '001-0000000000000001'),
  ('013-9000000000000006', 'Department', '[{"field":"name"},{"field":"principalId"},{"field":"parentDept"},{"field":"isDisabled"},{"field":"createdOn"}]', 'DATALIST', 'ALL', CURRENT_TIMESTAMP, '001-0000000000000001', CURRENT_TIMESTAMP, '001-0000000000000001'),
  ('013-9000000000000007', 'Team', '[{"field":"name"},{"field":"principalId"},{"field":"isDisabled"},{"field":"createdOn"}]', 'DATALIST', 'ALL', CURRENT_TIMESTAMP, '001-0000000000000001', CURRENT_TIMESTAMP, '001-0000000000000001');

-- Classifications (No data)
insert into `classification` (`DATA_ID`, `NAME`, `DESCRIPTION`, `OPEN_LEVEL`, `IS_DISABLED`, `CREATED_ON`, `CREATED_BY`, `MODIFIED_ON`, `MODIFIED_BY`)
  values
  ('018-0000000000000001', '地区', NULL, 2, 'F', CURRENT_TIMESTAMP, '001-0000000000000001', CURRENT_TIMESTAMP, '001-0000000000000001'),
  ('018-0000000000000002', '行业', NULL, 1, 'F', CURRENT_TIMESTAMP, '001-0000000000000001', CURRENT_TIMESTAMP, '001-0000000000000001');

-- Projects
insert into `project_config` (`CONFIG_ID`, `PROJECT_NAME`, `PROJECT_CODE`, `PRINCIPAL`, `MEMBERS`, `SCOPE`, `CREATED_BY`, `CREATED_ON`, `MODIFIED_BY`, `MODIFIED_ON`)
  values
  ('050-0000000000000001', 'RB示例项目', 'RB', '001-0000000000000001', '001-9000000000000001', 1, '001-0000000000000000', CURRENT_TIMESTAMP, '001-0000000000000000', CURRENT_TIMESTAMP);
insert into `project_plan_config` (`CONFIG_ID`, `PROJECT_ID`, `PLAN_NAME`, `SEQ`, `FLOW_STATUS`, `FLOW_NEXTS`)
  values
  ('051-0000000000000001', '050-0000000000000001', '待处理', 1000, 1, '051-0000000000000002,051-0000000000000003'),
  ('051-0000000000000002', '050-0000000000000001', '进行中', 2000, 2, '051-0000000000000001,051-0000000000000003'),
  ('051-0000000000000003', '050-0000000000000001', '已完成', 3000, 3, '051-0000000000000001,051-0000000000000002');

-- DB Version (see `db-upgrade.sql`)
insert into `system_config` (`CONFIG_ID`, `ITEM`, `VALUE`)
  values ('021-9000000000000001', 'DBVer', 58);
