/*!
Copyright (c) REBUILD <https://getrebuild.com/> and/or its owners. All rights reserved.

rebuild is dual-licensed under commercial and open source licenses (GPLv3).
See LICENSE and COMMERCIAL in the project root for license information.
*/




const TYPE_DIVIDER = '$DIVIDER$'
const TYPE_REFFORM = '$REFFORM$'
const MODAL_MAXWIDTH = 1064


class RbFormModal extends React.Component {
  constructor(props) {
    super(props)
    this.state = { ...props, inLoad: true, _maximize: false }

    this.__maximizeKey = 'FormMaximize-ANY'
    this.state._maximize = $isTrue($storage.get(this.__maximizeKey))

    if (!props.id) this.state.id = null
  }

  render() {
    const style2 = { maxWidth: this.props.width || MODAL_MAXWIDTH }
    if (this.state._maximize) {
      style2.maxWidth = $(window).width() - 60
      if (style2.maxWidth < MODAL_MAXWIDTH) style2.maxWidth = MODAL_MAXWIDTH
    }

    return (
      <div className="modal-wrapper">
        <div className="modal rbmodal colored-header colored-header-primary" ref={(c) => (this._rbmodal = c)}>
          <div className="modal-dialog" style={style2}>
            <div className="modal-content" style={style2}>
              <div
                className="modal-header modal-header-colored"
                onDoubleClick={(e) => {
                  $stopEvent(e, true)
                  this._handleMaximize()
                }}>
                {this.state.icon && <span className={`icon zmdi zmdi-${this.state.icon}`} />}
                <h3 className="modal-title">{this.state.title || $L('新建')}</h3>
                {rb.isAdminUser && (
                  <a className="close s" href={`${rb.baseUrl}/admin/entity/${this.state.entity}/form-design`} title={$L('表单设计')} target="_blank">
                    <span className="zmdi zmdi-settings up-1" />
                  </a>
                )}
                <button className="close md-close J_maximize" type="button" title={this.state._maximize ? $L('向下还原') : $L('最大化')} onClick={() => this._handleMaximize()}>
                  <span className={`mdi ${this.state._maximize ? 'mdi mdi-window-restore' : 'mdi mdi-window-maximize'}`} />
                </button>
                <button className="close md-close" type="button" title={$L('关闭')} onClick={() => this.hide()}>
                  <span className="zmdi zmdi-close" />
                </button>
              </div>
              <div className={`modal-body rb-loading ${this.state.inLoad ? 'rb-loading-active' : ''}`}>
                {this.state.alertMessage && (
                  <div className="alert alert-warning rbform-alert">
                    <i className="zmdi zmdi-alert-triangle mr-1" />
                    {this.state.alertMessage}
                  </div>
                )}
                {this.state.fjsAlertMessage}

                {this.state.formComponent}
                {this.state.inLoad && <RbSpinner />}
              </div>
            </div>
          </div>
        </div>
      </div>
    )
  }

  _handleMaximize() {
    this.setState({ _maximize: !this.state._maximize }, () => {
      $storage.set(this.__maximizeKey, this.state._maximize)
    })
  }

  componentDidMount() {
    const $root = $(this._rbmodal)
      .modal({
        show: false,
        backdrop: 'static',
        keyboard: false,
      })
      .on('hidden.bs.modal', () => {
        $keepModalOpen()
        if (this.props.disposeOnHide === true) {
          $root.modal('dispose')
          $unmount($root.parent().parent())
        }
      })
    this._showAfter({}, true)
  }

  
  getFormModel() {
    const entity = this.state.entity
    const id = this.state.id || ''
    const initialValue = this.state.initialValue || {} 

    let url = `/app/${entity}/form-model?id=${id}`
    if (this.state.previewid) url += `&previewid=${this.state.previewid}`
    else if (this.state.specLayout) url += `&layout=${this.state.specLayout}`

    const that = this
    function _FN2(formModel) {
      const FORM = (
        <RbForm entity={entity} id={id} rawModel={formModel} $$$parent={that} readonly={!!formModel.readonlyMessage} ref={(c) => (that._formComponentRef = c)}>
          {formModel.elements.map((item) => {
            return detectElement(item, entity)
          })}
        </RbForm>
      )

      that.setState({ formComponent: FORM, alertMessage: formModel.readonlyMessage || null }, () => {
        that.setState({ inLoad: false })
        if (window.FrontJS) {
          window.FrontJS.Form._trigger('open', [formModel])
        }
      })

      that.__lastModified = formModel.lastModified || 0

      if (formModel.alertMessage) {
        setTimeout(() => RbHighbar.create(formModel.alertMessage), 1000)
      }
    }

    
    if (this.props.initialFormModel) {
      _FN2(this.props.initialFormModel)
      return
    }

    $.post(url, JSON.stringify(initialValue), (res) => {
      
      if (res.error_code > 0 || !!res.data.error) {
        const error = (res.data || {}).error || res.error_msg
        this.renderFromError(error)
      } else {
        _FN2(res.data)
      }
    })
  }

  renderFromError(message) {
    const error = (
      <div className="alert alert-danger alert-icon mt-5 w-75 mlr-auto">
        <div className="icon">
          <i className="zmdi zmdi-alert-triangle" />
        </div>
        <div className="message" dangerouslySetInnerHTML={{ __html: `<strong>${$L('抱歉!')}</strong> ${message}` }} />
      </div>
    )
    this.setState({ formComponent: error }, () => this.setState({ inLoad: false }))
  }

  show(state) {
    state = state || {}
    if (!state.id) state.id = null

    let reset = this.state.reset === true
    if (!reset) {
      
      const stateNew = [state.id, state.entity, state.initialValue, state.previewid]
      const stateOld = [this.state.id, this.state.entity, this.state.initialValue, this.state.previewid]
      reset = !$same(stateNew, stateOld)
    }

    if (reset) {
      state = { formComponent: null, initialValue: null, previewid: null, alertMessage: null, inLoad: true, ...state }
      this.setState(state, () => this._showAfter({ reset: false }, true))
    } else {
      this._showAfter({ ...state, reset: false })
      this._checkDrityData()
    }
  }

  _showAfter(state, modelChanged) {
    this.setState(state, () => {
      $(this._rbmodal).modal('show')
      if (modelChanged === true) this.getFormModel()
    })
  }

  
  _checkDrityData() {
    if (!this.__lastModified || !this.state.id) return

    $.get(`/app/entity/extras/record-last-modified?id=${this.state.id}`, (res) => {
      if (res.error_code === 0) {
        if (res.data.lastModified !== this.__lastModified) {
          
          this._refresh()
        }
      } else if (res.error_msg === 'NO_EXISTS') {
        this.setState({ alertMessage: $L('记录已经不存在，可能已被其他用户删除') })
      }
    })
  }

  _refresh() {
    const hs = { id: this.state.id, entity: this.state.entity }
    this.setState({ id: null, alertMessage: null }, () => this.show(hs))
  }

  hide(reset) {
    
    if (location.href.includes('/app/entity/form')) {
      window.close()
      return
    }

    $(this._rbmodal).modal('hide')

    const state = { reset: reset === true }
    if (state.reset) {
      state.id = null
      state.previewid = null
    }
    this.setState(state)
  }

  
  getFormComp() {
    return this._formComponentRef
  }

  
  
  static create(props, forceNew) {
    
    const that = this
    if (forceNew === true) {
      renderRbcomp(<RbFormModal {...props} disposeOnHide />, function () {
        that.__CURRENT35 = this
      })
      return
    }

    if (this.__HOLDER) {
      this.__HOLDER.show(props)
    } else {
      renderRbcomp(<RbFormModal {...props} />, function () {
        that.__HOLDER = this
        that.__CURRENT35 = this
      })
    }
  }
}


class RbForm extends React.Component {
  constructor(props) {
    super(props)
    this.state = { ...props }

    this.__FormData = {}
    const iv = props.rawModel.initialValue
    if (iv) {
      for (let k in iv) {
        let val = iv[k]
        
        val = val && typeof val === 'object' ? val.id || val : val
        this.__FormData[k] = { value: val, error: null }
      }
    }

    this.isNew = !props.id

    const $$$props = props.$$$parent && props.$$$parent.props ? props.$$$parent.props : {}
    this._postBefore = props.postBefore || $$$props.postBefore
    this._postAfter = props.postAfter || $$$props.postAfter
    this._onProTableLineUpdated = props.onProTableLineUpdated || $$$props.onProTableLineUpdated
    this._dividerRefs = []
  }

  render() {
    return (
      <div className={`rbform form-layout ${window.__LAB_VERTICALLAYOUT && 'vertical38'}`}>
        <div className="form row" ref={(c) => (this._$form = c)}>
          {this.props.children.map((fieldComp) => {
            const ref = fieldComp.props.field === TYPE_DIVIDER ? $random('divider-') : `fieldcomp-${fieldComp.props.field}`
            if (fieldComp.props.field === TYPE_DIVIDER && fieldComp.props.collapsed) {
              this._dividerRefs.push(ref)
            }
            return React.cloneElement(fieldComp, { $$$parent: this, ref: ref })
          })}

          {this.renderCustomizedFormArea()}
        </div>

        {this.renderDetailForms()}
        {this.renderFormAction()}
      </div>
    )
  }

  renderCustomizedFormArea() {
    let _FormArea
    if (window._CustomizedForms) {
      _FormArea = window._CustomizedForms.useFormArea(this.props.entity, this)
      if (_FormArea) _FormArea = React.cloneElement(_FormArea, { $$$parent: this })
    }
    return _FormArea || null
  }

  renderDetailForms() {
    if (!window.ProTable || !this.props.rawModel.detailMeta) return null

    
    const previewid = this.props.$$$parent ? this.props.$$$parent.state.previewid : null

    
    const detailImports = this.props.rawModel.detailImports

    this._ProTables = {}

    return (
      <RF>
        {this.props.rawModel.detailMetas.map((item, idx) => {
          return <RF key={idx}>{this.renderDetailsForm(item, detailImports, previewid)}</RF>
        })}
      </RF>
    )
  }

  renderDetailsForm(detailMeta, detailImports, previewid) {
    let _ProTable
    if (window._CustomizedForms) {
      _ProTable = window._CustomizedForms.useProTable(detailMeta.entity, this)
      if (_ProTable === false) return null 
    }

    function _addNew(n = 1) {
      for (let i = 0; i < n; i++) {
        setTimeout(() => _ProTable.addNew(), i * 20)
      }
    }

    function _setLines(details, force) {
      
      if (force) _ProTable.clear()

      if (_ProTable.isEmpty()) {
        _ProTable.setLines(details)
      } else {
        RbAlert.create($L('是否保留已有明细记录？'), {
          confirmText: $L('保留'),
          cancelText: $L('不保留'),
          onConfirm: function () {
            this.hide()
            _ProTable.setLines(details)
          },
          onCancel: function () {
            this.hide()
            _ProTable.clear()
            setTimeout(() => _ProTable.setLines(details), 200)
          },
        })
      }
    }

    
    let _detailImports = []
    if (detailImports) {
      let ifAutoReady = false
      detailImports.forEach((item) => {
        if (item.detailName !== detailMeta.entity) return

        const diConf = {
          icon: item.icon,
          label: item.transName || item.entityLabel,
          fetch: (form, cb, autoFields) => {
            const formdata = form.getFormData()
            if (autoFields) {
              
              let lackValue = false
              autoFields.forEach((item) => {
                if (lackValue) return
                lackValue = !formdata[item]
              })
              if (lackValue) return
            }

            const mainid = form.props.id || null
            $.post(`/app/entity/extras/detail-imports?transid=${item.transid}&mainid=${mainid}`, JSON.stringify(formdata), (res) => {
              if (res.error_code === 0) {
                if (autoFields) {
                  typeof cb === 'function' && cb(res.data)
                } else {
                  if ((res.data || []).length === 0) RbHighbar.create($L('没有可导入的明细记录'))
                  else typeof cb === 'function' && cb(res.data)
                }
              } else {
                RbHighbar.error(res.error_msg)
              }
            })
          },
        }

        _detailImports.push(diConf)

        
        
        if (item.auto === 3 || (this.isNew && item.auto === 1) || (!this.isNew && item.auto === 2)) {
          if (!ifAutoReady) {
            ifAutoReady = true
            let ifAutoReady_timer
            this.onFieldValueChange((fv) => {
              if (item.autoFields.includes(fv.name)) {
                if (ifAutoReady_timer) {
                  clearTimeout(ifAutoReady_timer)
                  ifAutoReady_timer = null
                }

                if (fv.value) {
                  ifAutoReady_timer = setTimeout(() => {
                    diConf.fetch(this, (details) => _setLines(details, true), item.autoFields)
                  }, 400)
                }
              }
            })
          }
        }
      })
    }

    if (!_ProTable) {
      _ProTable = (
        <ProTable
          entity={detailMeta}
          mainid={this.state.id}
          previewid={previewid}
          ref={(c) => {
            _ProTable = c 
            this._ProTables[detailMeta.entity] = c
            this._ProTable = c 
          }}
          $$$main={this}
        />
      )
    } else {
      this._ProTable = _ProTable 
    }

    return (
      <div className="detail-form-table">
        <div className="row">
          <div className="col">
            <h5 className="mt-2 mb-0 text-bold fs-14">
              <i className={`icon zmdi zmdi-${detailMeta.icon} fs-15 mr-2`} />
              {detailMeta.entityLabel}
            </h5>
          </div>

          <div className="col text-right">
            {_detailImports.length > 0 && (
              <div className="btn-group mr-2">
                <button className="btn btn-secondary dropdown-toggle" type="button" data-toggle="dropdown">
                  <i className="icon mdi mdi-transfer-down"></i> {$L('导入明细')}
                </button>
                <div className="dropdown-menu dropdown-menu-right">
                  {_detailImports.map((def, idx) => {
                    return (
                      <a
                        key={`imports-${idx}`}
                        className="dropdown-item"
                        onClick={() => {
                          def.fetch(this, (details) => _setLines(details))
                        }}>
                        {def.icon && <i className={`icon zmdi zmdi-${def.icon}`} />}
                        {def.label}
                      </a>
                    )
                  })}
                </div>
              </div>
            )}

            <div className="btn-group">
              <button className="btn btn-secondary" type="button" onClick={() => _addNew()} disabled={this.props.readonly}>
                <i className="icon x14 mdi mdi-playlist-plus mr-1" />
                {$L('添加明细')}
              </button>
              <button className="btn btn-secondary dropdown-toggle w-auto" type="button" data-toggle="dropdown" disabled={this.props.readonly}>
                <i className="icon zmdi zmdi-chevron-down" />
              </button>
              <div className="dropdown-menu dropdown-menu-right">
                {[5, 10, 20].map((n) => {
                  return (
                    <a className="dropdown-item" onClick={() => _addNew(n)} key={`n-${n}`}>
                      {$L('添加 %d 条', n)}
                    </a>
                  )
                })}
                <a
                  className="dropdown-item"
                  onClick={() => {
                    if (rb.commercial < 10) {
                      return RbHighbar.error(WrapHtml($L('免费版不支持此功能 [(查看详情)](https://getrebuild.com/docs/rbv-features)')))
                    }

                    const fields = []
                    _ProTable.state.formFields.forEach((item) => {
                      if (item.readonly === false && !['IMAGE', 'FILE', 'AVATAR', 'SIGN'].includes(item.type)) {
                        fields.push({ field: item.field, label: item.label })
                      }
                    })

                    const mainid = this.state.id || '000-0000000000000000'
                    renderRbcomp(
                      
                      <ExcelClipboardDataModal entity={detailMeta.entity} fields={fields} mainid={mainid} onConfirm={(data) => _setLines(data)} />
                    )
                  }}>
                  {$L('从 Excel 添加')} <sup className="rbv" />
                </a>
                <div className="dropdown-divider" />
                <a className="dropdown-item" onClick={() => _ProTable.clear()}>
                  {$L('清空')}
                </a>
              </div>
            </div>
          </div>
        </div>

        <div className="mt-2">{_ProTable}</div>
      </div>
    )
  }

  renderFormAction() {
    const props = this.props
    let moreActions = []
    
    if (props.rawModel.mainMeta) {
      
      if (props.$$$parent && props.$$$parent.props._nextAddDetail) {
        moreActions.push(
          <a key="Action101" className="dropdown-item" onClick={() => this.post(RbForm.NEXT_NEWDETAIL)}>
            {$L('保存并继续添加')}
          </a>
        )
      }
    }
    
    else if (window.RbViewModal && window.__PageConfig.type === 'RecordList') {
      if (window.__LAB_FORMACTION_105) {
        moreActions.push(
          <a key="Action105" className="dropdown-item" onClick={() => this.post(RbForm.NEXT_ADD36)}>
            {$L('保存并继续新建')}
          </a>
        )
      }
      if (window.__LAB_FORMACTION_103 && props.rawModel.hadApproval && window.ApprovalSubmitForm) {
        moreActions.push(
          <a key="Action103" className="dropdown-item" onClick={() => this.post(RbForm.NEXT_SUBMIT37)}>
            {$L('保存并提交')}
          </a>
        )
      }

      moreActions.push(
        <a key="Action104" className="dropdown-item" onClick={() => this.post(RbForm.NEXT_VIEW)}>
          {$L('保存并打开')}
        </a>
      )
    }

    
    if (typeof this._postAfter === 'function') moreActions = []

    
    const $$$props = props.$$$parent && props.$$$parent.props ? props.$$$parent.props : {}
    const confirmText = props.confirmText || $$$props.confirmText
    const cancelText = props.cancelText || $$$props.cancelText

    return (
      <div className="dialog-footer" ref={(c) => (this._$formAction = c)}>
        <button className="btn btn-secondary btn-space" type="button" onClick={() => props.$$$parent.hide()}>
          {cancelText || $L('取消')}
        </button>
        {!props.readonly && (
          <div className="btn-group dropup btn-space ml-1">
            <button className="btn btn-primary" type="button" onClick={() => this.post()}>
              {confirmText || $L('保存')}
            </button>
            {moreActions.length > 0 && (
              <RF>
                <button className="btn btn-primary dropdown-toggle w-auto" type="button" data-toggle="dropdown">
                  <i className="icon zmdi zmdi-chevron-up" />
                </button>
                <div className="dropdown-menu dropdown-menu-primary dropdown-menu-right">{moreActions}</div>
              </RF>
            )}
          </div>
        )}
      </div>
    )
  }

  componentDidMount() {
    
    if (this.isNew) {
      this.props.children.map((child) => {
        let iv = child.props.value
        if (!$empty(iv) && (!this.props.readonly || (this.props.readonly && this.props.readonlyw === 3))) {
          if (typeof iv === 'object') {
            if (child.props.type === 'TAG') {
              
              iv = iv.join('$$$$')
            } else if (child.props.type === 'LOCATION') {
              
            } else if (Array.isArray(iv)) {
              
            } else {
              
              iv = iv.id
            }
          }

          this.setFieldValue(child.props.field, iv)
        }
      })
    }

    
    this._dividerRefs.forEach((d) => {
      
      this.refs[d]._toggle()
    })

    setTimeout(() => RbForm.renderAfter(this), 0)
  }

  
  setAutoFillin(data) {
    if (!data || data.length === 0) return

    this._inAutoFillin = true
    data.forEach((item) => {
      const fieldComp = this.getFieldComp(item.target)
      if (fieldComp) {
        
        if (!item.fillinForce && fieldComp.getValue()) return
        if ((this.isNew && item.whenCreate) || (!this.isNew && item.whenUpdate)) fieldComp.setValue(item.value)
      }
    })
    this._inAutoFillin = false
  }

  
  setFieldValue(field, value, error) {
    this.__FormData[field] = { value: value, error: error }
    this._onFieldValueChangeCall(field, value)

    
    if (rb.env === 'dev') console.log('FV1 ... ' + JSON.stringify(this.__FormData))
  }

  
  setFieldUnchanged(field, originValue) {
    delete this.__FormData[field]
    this._onFieldValueChangeCall(field, originValue)

    
    if (rb.env === 'dev') console.log('FV2 ... ' + JSON.stringify(this.__FormData))
  }

  
  onFieldValueChange(cb) {
    const c = this._onFieldValueChange_calls || []
    c.push(cb)
    this._onFieldValueChange_calls = c
  }
  
  _onFieldValueChangeCall(field, value) {
    if (this._onFieldValueChange_calls) {
      this._onFieldValueChange_calls.forEach((c) => c({ name: field, value: value }))
    }

    if (window.FrontJS) {
      const fieldKey = `${this.props.entity}.${field}`
      const ret = window.FrontJS.Form._trigger('fieldValueChange', [fieldKey, value, this.props.id || null])
      if (ret === false) return false
    }
  }

  
  getFieldComp(field) {
    
    return this.refs[`fieldcomp-${field}`] || null
  }

  
  getFormData() {
    const data = {}
    
    const _refs = this.refs
    for (let key in _refs) {
      if (!key.startsWith('fieldcomp-')) continue

      const fieldComp = _refs[key]
      let v = fieldComp.getValue()
      if (v && typeof v === 'object') v = v.id
      if (v) data[fieldComp.props.field] = v
    }
    return data
  }

  
  getProTables() {
    return this._ProTables ? Object.values(this._ProTables) : null
  }
  getProTable() {
    return (this.getProTables() || [])[0] || null
  }

  
  static NEXT_NEWDETAIL = 102
  
  static NEXT_VIEW = 104
  
  static NEXT_ADD36 = 105
  
  static NEXT_SUBMIT37 = 103
  
  post(next) {
    
    if (this.__post === 1) return
    this.__post = 1
    setTimeout(() => (this.__post = 0), 800)
    setTimeout(() => this._post(next), 40)
  }

  _post(next, weakMode) {
    let data = {}
    for (let k in this.__FormData) {
      const err = this.__FormData[k].error
      if (err) return RbHighbar.create(err)
      else data[k] = this.__FormData[k].value
    }

    if (this._ProTables) {
      const detailsNotEmpty = this.props.rawModel.detailsNotEmpty
      let detailsMix = []

      const keys = Object.keys(this._ProTables)
      for (let i = 0; i < keys.length; i++) {
        const _ProTable = this._ProTables[keys[i]]
        
        if (!_ProTable._initModel) continue

        const details = _ProTable.buildFormData()
        if (!details) return

        const detailsNotEmpty34 = _ProTable._initModel.detailsNotEmpty || detailsNotEmpty
        if (detailsNotEmpty34 && _ProTable.isEmpty()) {
          RbHighbar.create($L('请添加明细'))
          return 
        }

        detailsMix = [...detailsMix, ...details]
      }
      data['$DETAILS$'] = detailsMix
    }

    data.metadata = {
      entity: this.state.entity,
      id: this.state.id,
    }

    
    if (this._postBeforeExec(data) === false) return

    const $$$parent = this.props.$$$parent
    const previewid = $$$parent.state.previewid

    const $btn = $(this._$formAction).find('.btn').button('loading')
    let url = '/app/entity/record-save'
    if (previewid) url += `?previewid=${previewid}`
    if (weakMode) {
      url += url.includes('?') ? '&' : '?'
      url += 'weakMode=' + weakMode
    }

    $.post(url, JSON.stringify(data), (res) => {
      $btn.button('reset')
      if (res.error_code === 0) {
        RbHighbar.success($L('保存成功'))

        
        if (location.href.includes('/app/entity/form')) {
          localStorage.setItem('referenceSearch__reload', $random())
        }

        setTimeout(() => {
          $$$parent.hide(true)

          const recordId = res.data.id

          
          if (typeof this._postAfter === 'function') {
            this._postAfter(recordId, next, this)
            return
          }

          if (next === RbForm.NEXT_NEWDETAIL) {
            const iv = $$$parent.props.initialValue
            const dm = this.props.rawModel.entityMeta
            RbFormModal.create({ title: $L('添加%s', dm.entityLabel), entity: dm.entity, icon: dm.icon, initialValue: iv })
            
          } else if (next === RbForm.NEXT_VIEW && window.RbViewModal) {
            window.RbViewModal.create({ id: recordId, entity: this.state.entity })
            if (window.RbListPage) location.hash = `!/View/${this.state.entity}/${recordId}`
            
          } else if (next === RbForm.NEXT_ADD36) {
            let titleNew = $$$parent.state.title
            if ($$$parent.props.id) titleNew = titleNew.replace($L('编辑%s', ''), $L('新建%s', ''))
            const copyProps = { entity: $$$parent.state.entity, icon: $$$parent.state.icon, title: titleNew }
            RbFormModal.create(copyProps, false)
            
          } else if (next === RbForm.NEXT_SUBMIT37) {
            renderRbcomp(<ApprovalSubmitForm id={recordId} />)
            
          } else if (previewid && window.RbViewPage) {
            window.RbViewPage.clickView(`#!/View/${this.state.entity}/${recordId}`)
            
          }

          this._postAfterExec({ ...res.data, isNew: !this.state.id }, next)

          
        }, 200)
      } else if (res.error_code === 499) {
        
        renderRbcomp(<RepeatedViewer entity={this.state.entity} data={res.data} />)
      } else if (res.error_code === 497) {
        
        const that = this
        const msg_id = res.error_msg.split('$$$$')
        RbAlert.create(msg_id[0], {
          onConfirm: function () {
            this.hide()
            that._post(next, msg_id[1])
          },
        })
      } else {
        RbHighbar.error(res.error_msg)
      }
    })
    return true
  }

  
  _postBeforeExec(data) {
    if (typeof this._postBefore === 'function') {
      let ret = this._postBefore(data, this)
      if (ret === false) return false
    }

    if (window.FrontJS) {
      let ret = window.FrontJS.Form._trigger('saveBefore', [data, this])
      if (ret === false) return false
    }

    let ret = RbForm.postBefore(data, this)
    if (ret === false) return false
  }

  
  _postAfterExec(data, next) {
    if (window.FrontJS) {
      window.FrontJS.Form._trigger('saveAfter', [data, next, this])
    }

    
    const rlp = window.RbListPage || parent.RbListPage
    if (rlp) rlp.reload(data.id)
    
    if (window.RbViewPage && next !== RbForm.NEXT_NEWDETAIL) window.RbViewPage.reload()
  }

  

  
  
  static postBefore(data, formObject) {}
  
  
  static postAfter(data, next, formObject) {}
  
  
  static renderAfter(formObject) {}
}


class RbFormElement extends React.Component {
  constructor(props) {
    super(props)
    this.state = { ...props }

    
    this._isNew = props.$$$parent.isNew
    if (props.readonly) {
      if (this._isNew) {
        this._placeholderw = props.readonlyw >= 2 ? $L('自动值') : null
      } else if (!this.state.value) {
        this._placeholderw = $L('无')
      }
    }
  }

  render() {
    const props = this.props
    const state = this.state

    let colspan = 6 
    if (props.colspan === 4 || props.isFull === true) colspan = 12
    else if (props.colspan === 1) colspan = 3
    else if (props.colspan === 3) colspan = 9
    else if (props.colspan === 9) colspan = 4
    else if (props.colspan === 8) colspan = 8

    const editable = props.$$$parent.onViewEditable && props.onView && !props.readonly

    return (
      <div className={`col-12 col-sm-${colspan} form-group type-${props.type} ${editable ? 'editable' : ''} ${state.hidden ? 'hide' : ''}`} data-field={props.field}>
        <label className={`col-form-label ${!props.onView && !state.nullable ? 'required' : ''}`}>{props.label}</label>
        <div ref={(c) => (this._fieldText = c)} className="col-form-control">
          {!props.onView || (editable && state.editMode) ? this.renderElement() : this.renderViewElement()}
          {!props.onView && state.tip && <p className="form-text">{state.tip}</p>}

          {editable && !state.editMode && <a className="edit" onClick={() => this.toggleEditMode(true)} title={$L('编辑')} />}
          {editable && state.editMode && (
            <div className="edit-oper">
              <div className="btn-group shadow-sm">
                <button type="button" className="btn btn-secondary" onClick={() => this.handleEditConfirm()} title={$L('确定')}>
                  <i className="icon zmdi zmdi-check" />
                </button>
                <button
                  type="button"
                  className="btn btn-secondary"
                  onClick={() => {
                    this.toggleEditMode(false)
                    
                    props.$$$parent && props.$$$parent.setFieldUnchanged && props.$$$parent.setFieldUnchanged(props.field)
                  }}
                  title={$L('取消')}>
                  <i className="icon zmdi zmdi-close" />
                </button>
              </div>
            </div>
          )}
        </div>
      </div>
    )
  }

  componentDidMount() {
    const props = this.props
    if (!props.onView) {
      
      if (!this.state.nullable && $empty(props.value) && props.readonlyw !== 2) {
        props.$$$parent.setFieldValue(props.field, null, $L('%s不能为空', props.label))
      }

      this.onEditModeChanged()
    }
  }

  componentWillUnmount() {
    this.onEditModeChanged(true)
  }

  
  renderElement() {
    const _readonly37 = this.state.readonly
    const value = arguments.length > 0 ? arguments[0] : this.state.value

    return (
      <input
        ref={(c) => (this._fieldValue = c)}
        className={`form-control form-control-sm ${this.state.hasError ? 'is-invalid' : ''}`}
        title={this.state.hasError}
        type="text"
        value={value || ''}
        onChange={(e) => this.handleChange(e, !_readonly37)}
        readOnly={_readonly37}
        placeholder={this._placeholderw}
        maxLength={this.props.maxLength || 200}
      />
    )
  }

  
  renderViewElement() {
    let value = arguments.length > 0 ? arguments[0] : this.state.value
    if (value && $empty(value)) value = null

    return <div className="form-control-plaintext">{value || <span className="text-muted">{$L('无')}</span>}</div>
  }

  
  handleChange(e, checkValue) {
    const val = e.target.value
    this.setState({ value: val }, () => {
      
      if (this.__handleChangeTimer) {
        clearTimeout(this.__handleChangeTimer)
        this.__handleChangeTimer = null
      }

      this.__handleChangeTimer = setTimeout(() => {
        checkValue === true && this.checkValue()
        typeof this.props.onValueChange === 'function' && this.props.onValueChange(this)
      }, 222)
    })
  }

  
  handleClear() {
    this.setState({ value: '' }, () => {
      this.checkValue()
      typeof this.props.onValueChange === 'function' && typeof this.props.onValueChange(this)
    })
  }

  
  checkValue() {
    const err = this.isValueError()
    this.setState({ hasError: err || null })
    const errMsg = err ? this.props.label + ' ' + err : null

    if (this.isValueUnchanged() && !this._isNew) {
      if (err) this.props.$$$parent.setFieldValue(this.props.field, this.state.value, errMsg)
      else this.props.$$$parent.setFieldUnchanged(this.props.field, this.state.value)
    } else {
      this.props.$$$parent.setFieldValue(this.props.field, this.state.value, errMsg)
    }
  }

  
  isValueError() {
    if (this.state.nullable === false) {
      return $empty(this.state.value) ? $L('不能为空') : null
    }
  }

  
  isValueUnchanged() {
    const oldv = this.state.newValue === undefined ? this.props.value : this.state.newValue
    return $same(oldv, this.state.value)
  }

  
  onEditModeChanged(destroy) {
    if (destroy) {
      if (this.__select2) {
        if (Array.isArray(this.__select2)) {
          $(this.__select2).each(function () {
            this.select2('destroy')
          })
        } else {
          this.__select2.select2('destroy')
        }
        this.__select2 = null
      }
    }
  }

  
  toggleEditMode(editMode) {
    this.setState({ editMode: editMode }, () => {
      if (this.state.editMode) {
        this.onEditModeChanged()
        this._fieldValue && this._fieldValue.focus()
      } else {
        const newValue = arguments.length > 1 ? arguments[1] : this.state.newValue === undefined ? this.props.value : this.state.newValue
        this.setState({ value: newValue, newValue: newValue || null }, () => this.onEditModeChanged(true))
      }
    })
  }

  
  handleEditConfirm() {
    const $$$parent = this.props.$$$parent
    $$$parent && $$$parent.saveSingleFieldValue && $$$parent.saveSingleFieldValue(this)
  }

  
  setValue(val) {
    this.handleChange({ target: { value: val } }, true)
  }
  
  getValue() {
    return this.state.value
  }

  
  setHidden(hidden) {
    this.setState({ hidden: hidden === true })
  }
  
  setNullable(nullable) {
    this.setState({ nullable: nullable === true }, () => {
      
      this.setValue(this.state.value || null)
    })
  }
  
  
  setReadonly(readonly) {
    this.setState({ readonly: readonly === true })
  }
  
  setTip(tip) {
    this.setState({ tip: tip || null })
  }
}

class RbFormText extends RbFormElement {
  constructor(props) {
    super(props)
    this._textCommonMenuId = props.readonly || !props.textCommon ? null : $random('tcddm-')
  }

  renderElement() {
    const comp = super.renderElement()
    return this._textCommonMenuId ? React.cloneElement(comp, { 'data-toggle': 'dropdown', 'data-target': `#${this._textCommonMenuId}` }) : comp
  }

  componentDidMount() {
    super.componentDidMount()

    if (this._textCommonMenuId) {
      const that = this
      console.log('[dev] init dropdown-menu with text-common', this._textCommonMenuId)
      renderRbcomp(
        <div id={this._textCommonMenuId}>
          <div className="dropdown-menu common-texts">
            <h5>{$L('常用')}</h5>
            {this.props.textCommon.split(',').map((item) => {
              return (
                <a
                  key={item}
                  title={item}
                  className="badge text-ellipsis"
                  onClick={() => {
                    that.handleChange({ target: { value: item } }, true)
                  }}>
                  {item}
                </a>
              )
            })}
          </div>
        </div>
      )
    }
  }

  componentWillUnmount() {
    super.componentWillUnmount()

    if (this._textCommonMenuId) {
      console.log('[dev] unmount dropdown-menu with text-common:', this._textCommonMenuId)
      $unmount($(`#${this._textCommonMenuId}`).parent())
    }
  }
}

class RbFormUrl extends RbFormText {
  renderViewElement() {
    if (!this.state.value) return super.renderViewElement()

    const clickUrl = `${rb.baseUrl}/commons/url-safe?url=${encodeURIComponent(this.state.value)}`
    return (
      <div className="form-control-plaintext">
        <a href={clickUrl} className="link" target="_blank" rel="noopener noreferrer">
          {this.state.value}
        </a>
      </div>
    )
  }

  isValueError() {
    const err = super.isValueError()
    if (err) return err
    return !!this.state.value && $regex.isUrl(this.state.value) === false ? $L('格式不正确') : null
  }
}

class RbFormEMail extends RbFormText {
  renderViewElement() {
    if (!this.state.value) return super.renderViewElement()

    return (
      <div className="form-control-plaintext">
        <a title={$L('发送邮件')} href={`mailto:${this.state.value}`} className="link">
          {this.state.value}
        </a>
      </div>
    )
  }

  isValueError() {
    const err = super.isValueError()
    if (err) return err
    return !!this.state.value && $regex.isMail(this.state.value) === false ? $L('格式不正确') : null
  }
}

class RbFormPhone extends RbFormText {
  renderViewElement() {
    if (!this.state.value) return super.renderViewElement()

    return (
      <div className="form-control-plaintext">
        <a title={$L('拨打电话')} href={`tel:${this.state.value}`} className="link">
          {this.state.value}
        </a>
      </div>
    )
  }

  isValueError() {
    const err = super.isValueError()
    if (err) return err
    return !!this.state.value && $regex.isTel(this.state.value) === false ? $L('格式不正确') : null
  }
}

class RbFormNumber extends RbFormText {
  isValueError() {
    const err = super.isValueError()
    if (err) return err

    const value = this.state.value
    if (!!value && $regex.isDecimal(value) === false) return $L('格式不正确')
    if (!!value && $isTrue(this.props.notNegative) && parseFloat(value) < 0) return $L('不能为负数')
    return null
  }
  _isValueError() {
    return super.isValueError()
  }

  renderElement() {
    const _readonly37 = this.state.readonly
    let value = arguments.length > 0 ? arguments[0] : this.state.value
    
    if (value === undefined || value === null) value = ''

    return (
      <RF>
        <input
          ref={(c) => (this._fieldValue = c)}
          className={`form-control form-control-sm ${this.state.hasError ? 'is-invalid' : ''}`}
          title={this.state.hasError}
          type="text"
          value={value}
          onChange={(e) => this.handleChange(e, !_readonly37)}
          readOnly={_readonly37}
          placeholder={this._placeholderw}
          maxLength="29"
        />
        {this.__valueFlag && <em className="vflag">{this.__valueFlag}</em>}
      </RF>
    )
  }

  renderViewElement() {
    const c = super.renderViewElement()
    
    if (this.state.value && (this.state.value + '').includes('-')) {
      return React.cloneElement(c, { className: 'form-control-plaintext text-danger' })
    } else {
      return c
    }
  }

  componentDidMount() {
    super.componentDidMount()
    
    if (this.props.calcFormula && !this.props.onView) __calcFormula(this)
  }

  onEditModeChanged(destroy) {
    if (destroy);
    else {
      this.setState({ value: this._removeComma(this.state.value) })
    }
  }

  
  _removeComma(n) {
    if (n === null || n === undefined || n === '') return ''
    if (n === '-') return n 
    if ((n + '').substring(0, 1) === '*') return n 
    if (n) n = $cleanNumber(n)
    if (isNaN(n)) return ''
    return n 
  }
}

class RbFormDecimal extends RbFormNumber {
  constructor(props) {
    super(props)
    
    if (props.decimalType && props.decimalType !== '0') {
      this.__valueFlag = props.decimalType
    }
  }
}

class RbFormNText extends RbFormElement {
  constructor(props) {
    super(props)

    this._height = this.props.useMdedit ? 0 : ~~this.props.height
    if (this._height && this._height > 0) {
      if (this._height === 1) this._height = 37
      else this._height = this._height * 20 + 12
    }
  }

  renderElement() {
    const _readonly37 = this.state.readonly
    const props = this.props

    return (
      <RF>
        <textarea
          ref={(c) => {
            this._fieldValue = c
            this._height > 0 && c && $(c).attr('style', `height:${this._height}px !important`)
          }}
          className={`form-control form-control-sm row3x ${props.useCode && 'formula-code'} ${this.state.hasError && 'is-invalid'} ${props.useMdedit && _readonly37 ? 'cm-readonly' : ''}`}
          title={this.state.hasError}
          value={this.state.value || ''}
          onChange={(e) => this.handleChange(e, !_readonly37)}
          readOnly={_readonly37}
          placeholder={this._placeholderw}
          maxLength="6000"
        />
        {props.useMdedit && !_readonly37 && <input type="file" className="hide" accept="image/*" data-noname="true" ref={(c) => (this._fieldValue__upload = c)} />}
      </RF>
    )
  }

  renderViewElement() {
    if (!this.state.value) return super.renderViewElement()

    const style = {}
    if (this._height > 0) style.maxHeight = this._height

    if (this.props.useMdedit) {
      return (
        <div className="form-control-plaintext mdedit-content" ref={(c) => (this._textarea = c)} style={style}>
          <Md2Html markdown={this.state.value} />
        </div>
      )
    } else {
      let text2 = this.state.value.replace(/</g, '&lt;').replace(/\n/g, '<br/>')
      if (this.props.useCode) text2 = text2.replace(/\s/g, '&nbsp;')

      return (
        <RF>
          <div className={`form-control-plaintext ${this.props.useCode && 'formula-code'}`} ref={(c) => (this._textarea = c)} style={style}>
            {WrapHtml(text2)}
          </div>

          <div className={`ntext-action ${window.__LAB_SHOWNTEXTACTION || this.props.useCode ? '' : 'hide'}`}>
            <a title={$L('展开/收起')} onClick={() => $(this._textarea).toggleClass('ntext-expand')}>
              <i className="mdi mdi-arrow-expand" />
            </a>
            <a ref={(c) => (this._actionCopy = c)} onClick={() => {}}>
              <i className="mdi mdi-content-copy" />
            </a>
          </div>
        </RF>
      )
    }
  }

  componentDidMount() {
    super.componentDidMount()
    this.props.onView && this.onEditModeChanged(true)
  }

  UNSAFE_componentWillUpdate(nextProps, nextState) {
    
    if (this.state.editMode && !nextState.editMode) {
      if (this._SimpleMDE) {
        this._SimpleMDE.toTextArea()
        this._SimpleMDE = null
      }
    }
  }

  onEditModeChanged(destroy) {
    if (this._textarea) {
      if (destroy) {
        $(this._textarea).perfectScrollbar()
      } else {
        $(this._textarea).perfectScrollbar('destroy')
      }
    }

    if (this.props.useMdedit && !destroy) this._initMde()

    if (this._actionCopy) {
      const that = this
      const initCopy = function () {
        $clipboard($(that._actionCopy), that.state.value)
      }
      if (window.ClipboardJS) {
        initCopy()
      } else {
        $getScript('/assets/lib/clipboard.min.js', initCopy)
      }
    }
  }

  setValue(val) {
    super.setValue(val)
    if (this.props.useMdedit) this._SimpleMDE.value(val || '')
  }

  _initMde() {
    const _readonly37 = this.state.readonly

    const mde = new SimpleMDE({
      element: this._fieldValue,
      status: false,
      autoDownloadFontAwesome: false,
      spellChecker: false,
      
      toolbar: _readonly37 ? false : DEFAULT_MDE_TOOLBAR(this),
    })
    this._SimpleMDE = mde

    function _mdeFocus() {
      setTimeout(() => {
        mde.codemirror.focus()
        mde.codemirror.setCursor(mde.codemirror.lineCount(), 0) 
      }, 100)
    }

    if (_readonly37) {
      mde.codemirror.setOption('readOnly', true)
    } else {
      $createUploader(this._fieldValue__upload, null, (res) => {
        const pos = mde.codemirror.getCursor()
        mde.codemirror.setSelection(pos, pos)
        mde.codemirror.replaceSelection(`![${$L('图片')}](${rb.baseUrl}/filex/img/${res.key})`)
        _mdeFocus()
      })
      if (this.props.onView) _mdeFocus()

      mde.codemirror.on('changes', () => {
        $setTimeout(
          () => {
            this.setState({ value: mde.value() }, () => this.checkValue())
          },
          200,
          'mde-update-event'
        )
      })
      mde.codemirror.on('paste', (_mde, e) => {
        const data = e.clipboardData || window.clipboardData
        if (data && data.items && data.files && data.files.length > 0) {
          $stopEvent(e, true)
          this._fieldValue__upload.files = data.files
          $(this._fieldValue__upload).trigger('change')
        }
      })
    }
  }
}

class RbFormDateTime extends RbFormElement {
  renderElement() {
    const _readonly37 = this.state.readonly
    if (_readonly37) return super.renderElement()

    return (
      <div className="input-group has-append">
        <input
          ref={(c) => (this._fieldValue = c)}
          className={'form-control form-control-sm ' + (this.state.hasError ? 'is-invalid' : '')}
          title={this.state.hasError}
          type="text"
          value={this.state.value || ''}
          onChange={(e) => this.handleChange(e, !_readonly37)}
          placeholder={this._placeholderw}
          maxLength="20"
        />
        <span className={'zmdi zmdi-close clean ' + (this.state.value ? '' : 'hide')} onClick={() => this.handleClear()} />
        <div className="input-group-append">
          <button className="btn btn-secondary" type="button" ref={(c) => (this._fieldValue__icon = c)}>
            <i className={`icon zmdi zmdi-${this._icon || 'calendar'}`} />
          </button>
        </div>
      </div>
    )
  }

  onEditModeChanged(destroy) {
    const _readonly37 = this.state.readonly

    if (destroy) {
      if (this.__datetimepicker) {
        this.__datetimepicker.datetimepicker('remove')
        this.__datetimepicker = null
      }
    } else if (!_readonly37) {
      const format = (this.props.datetimeFormat || this.props.dateFormat).replace('mm', 'ii').toLowerCase()
      let minView = 0
      let startView = 'month'
      if (format.length === 4) minView = startView = 'decade' 
      else if (format.length === 7) minView = startView = 'year' 
      else if (format.length === 10) minView = 'month' 
      else if (format.length === 13) minView = 'day' 

      const that = this
      this.__datetimepicker = $(this._fieldValue)
        .datetimepicker({
          format: format || 'yyyy-mm-dd hh:ii:ss',
          minView: minView,
          startView: startView,
          pickerPosition: this._getAutoPosition(),
          minuteStep: window.__LAB_MINUTESTEP || 5,
          todayBtn: true,
        })
        .on('changeDate', function () {
          const val = $(this).val()
          that.handleChange({ target: { value: val } }, true)
        })

      $(this._fieldValue__icon).on('click', () => this.__datetimepicker.datetimepicker('show'))
    }
  }

  
  _getAutoPosition() {
    const wh = $(document.body).height() || 9999,
      wt = $(this._fieldValue).offset().top
    return wt + 280 < wh ? 'bottom-right' : 'top-right'
  }

  componentDidMount() {
    super.componentDidMount()
    
    if (this.props.calcFormula && !this.props.onView) __calcFormula(this)
  }
}

class RbFormTime extends RbFormDateTime {
  constructor(props) {
    super(props)
    this._icon = 'time'
  }

  onEditModeChanged(destroy) {
    const _readonly37 = this.state.readonly

    if (destroy) {
      super.onEditModeChanged(destroy)
    } else if (!_readonly37) {
      const format = (this.props.timeFormat || 'hh:ii:ss').replace('mm', 'ii').toLowerCase()
      const minView = format.length === 2 ? 1 : 0

      const that = this
      this.__datetimepicker = $(this._fieldValue)
        .datetimepicker({
          format: format,
          startView: 1,
          minView: minView,
          maxView: 1,
          pickerPosition: this._getAutoPosition(),
          minuteStep: window.__LAB_MINUTESTEP || 5,
          title: $L('选择时间'),
        })
        .on('changeDate', function () {
          const val = $(this).val()
          that.handleChange({ target: { value: val } }, true)
        })

      $(this._fieldValue__icon).on('click', () => this.__datetimepicker.datetimepicker('show'))
    }
  }
}

class RbFormImage extends RbFormElement {
  constructor(props) {
    super(props)
    this._htmlid = `${props.field}-${$random()}-input`

    if (props.value) this.state.value = [...props.value] 

    if (this.props.uploadNumber) {
      this.__minUpload = ~~(this.props.uploadNumber.split(',')[0] || 0)
      this.__maxUpload = ~~(this.props.uploadNumber.split(',')[1] || 9)
    } else {
      this.__minUpload = 0
      this.__maxUpload = 9
    }

    
    this._captureType = 0
    if (props.imageCapture) this._captureType += 2
    if (props.imageCaptureDef) this._captureType += 1
    if (this._captureType === 0) this._captureType = 1
  }

  renderElement() {
    const _readonly37 = this.state.readonly
    const value = this.state.value || []
    const showUpload = value.length < this.__maxUpload && !_readonly37

    if (value.length === 0) {
      if (_readonly37) {
        return (
          <div className="form-control-plaintext text-muted">
            <i className="mdi mdi-information-outline" /> {$L('只读')}
          </div>
        )
      }
    }

    return (
      <div className="img-field" ref={(c) => (this._$dropArea = c)}>
        {value.map((item, idx) => {
          return (
            <span key={item}>
              <a title={$fileCutName(item)} className="img-thumbnail img-upload" onClick={() => this._filePreview(value, idx)}>
                <img src={this._formatUrl(item)} alt="IMG" />
                {!_readonly37 && (
                  <b title={$L('移除')} onClick={(e) => this.removeItem(item, e)}>
                    <span className="zmdi zmdi-close" />
                  </b>
                )}
              </a>
            </span>
          )
        })}
        <span title={$L('拖动或点击选择图片。需要 %s 个', `${this.__minUpload}~${this.__maxUpload}`)} className={`position-relative ${!showUpload && 'hide'}`}>
          <input ref={(c) => (this._fieldValue__input = c)} type="file" className="inputfile" id={this._htmlid} accept="image/*" multiple />
          <label htmlFor={this._htmlid} className="img-thumbnail img-upload" onClick={(e) => this._fileClick(e)}>
            {this._captureType === 2 ? <span className="mdi mdi-camera down-2" /> : <span className="zmdi zmdi-image-alt down-2" />}
          </label>
          {this._captureType === 3 && (
            <RF>
              <label className="dropdown-toggle" data-toggle="dropdown">
                <i className="icon zmdi zmdi-chevron-down" />
              </label>
              <div className="dropdown-menu dropdown-menu-sm">
                <a className="dropdown-item" onClick={() => this._fileClick(null, 2)}>
                  <i className="icon mdi mdi-camera" /> {$L('拍摄')}
                </a>
              </div>
            </RF>
          )}
        </span>
        <input ref={(c) => (this._fieldValue = c)} type="hidden" value={value} />
      </div>
    )
  }

  renderViewElement() {
    const value = this.state.value
    if ($empty(value)) return super.renderViewElement()

    return (
      <div className="img-field">
        {value.map((item, idx) => {
          return (
            <span key={item}>
              <a title={$fileCutName(item)} onClick={() => this._filePreview(value, idx)} className="img-thumbnail img-upload zoom-in">
                <img src={this._formatUrl(item)} alt="IMG" />
              </a>
            </span>
          )
        })}
      </div>
    )
  }

  _formatUrl(urlKey) {
    if (urlKey.startsWith('http://') || urlKey.startsWith('https://')) return urlKey
    else return `${rb.baseUrl}/filex/img/${urlKey}?imageView2/2/w/100/interlace/1/q/100`
  }

  _filePreview(urlKey, idx) {
    const p = parent || window
    p.RbPreview.create(urlKey, idx)
  }

  _fileClick(e, forceType) {
    if (this._captureType === 2 || forceType === 2) {
      e && $stopEvent(e, true)
      if (rb.commercial < 1) {
        RbHighbar.error(WrapHtml($L('免费版不支持此功能 [(查看详情)](https://getrebuild.com/docs/rbv-features)')))
        return
      }

      const w = $(window).width() <= 1280 ? 768 : 1024
      renderRbcomp(
        <MediaCapturer
          title={$L('拍摄')}
          width={w}
          useWhite
          disposeOnHide
          type={this._captureTypeMedia || 'image'}
          forceFile
          watermark={window.__LAB_CAPTUREWATERMARK}
          callback={(fileKey) => {
            const paths = this.state.value || []
            if (paths.length < this.__maxUpload) {
              paths.push(fileKey)
              this.handleChange({ target: { value: paths } }, true)
            }
          }}
        />
      )
    }
    
  }

  onEditModeChanged(destroy) {
    if (destroy) {
      
    } else {
      if (!this._fieldValue__input) {
        console.log('No element `_fieldValue__input` defined :', this.props.field)
        return
      }

      $multipleUploader(this._fieldValue__input, (res) => {
        const paths = this.state.value || []
        
        if (paths.length < this.__maxUpload) {
          let hasByName = $fileCutName(res.key)
          hasByName = paths.find((x) => $fileCutName(x) === hasByName)
          if (!hasByName) {
            paths.push(res.key)
            this.handleChange({ target: { value: paths } }, true)
          }
        }
      })

      
      if (this._$dropArea && (this._captureType === 1 || this._captureType === 3)) {
        const that = this
        $dropUpload(this._$dropArea, function (files) {
          if (!files || files.length === 0) return false
          that._fieldValue__input.files = files
          $(that._fieldValue__input).trigger('change')
        })
      }
    }
  }
  removeItem(item, e) {
    e && $stopEvent(e, true)
    const paths = this.state.value || []
    paths.remove(item)
    this.handleChange({ target: { value: paths } }, true)
  }

  isValueError() {
    const err = super.isValueError()
    if (err) return err
    const ups = (this.state.value || []).length
    if (this.__minUpload > 0 && ups < this.__minUpload) return $L('至少需要上传 %d 个', this.__minUpload)
    if (this.__maxUpload < ups) return $L('最多允许上传 %d 个', this.__maxUpload)
  }
}

class RbFormFile extends RbFormImage {
  constructor(props) {
    super(props)

    
    if (this._captureType >= 2) {
      let _fileSuffix = props.fileSuffix || 'image/*; video/*'
      const img = _fileSuffix.includes('image/*')
      const vid = _fileSuffix.includes('video/*')
      if (img && vid) this._captureTypeMedia = '*'
      else if (img) this._captureTypeMedia = 'image'
      else if (vid) this._captureTypeMedia = 'video'
    }
  }

  renderElement() {
    const _readonly37 = this.state.readonly
    const value = this.state.value || []
    const showUpload = value.length < this.__maxUpload && !_readonly37

    if (value.length === 0 && _readonly37) {
      return (
        <div className="form-control-plaintext text-muted">
          <i className="mdi mdi-information-outline" /> {$L('只读')}
        </div>
      )
    }

    return (
      <div className="file-field" ref={(c) => (this._$dropArea = c)}>
        {value.map((item) => {
          const fileName = $fileCutName(item)
          return (
            <div key={item} className="img-thumbnail" title={fileName} onClick={() => this._filePreview(item)}>
              {this._renderFileIcon(fileName, item)}
              {!_readonly37 && (
                <b title={$L('移除')} onClick={(e) => this.removeItem(item, e)}>
                  <span className="zmdi zmdi-close" />
                </b>
              )}
            </div>
          )
        })}
        <div className={`file-select ${showUpload ? '' : 'hide'}`}>
          <input type="file" className="inputfile" ref={(c) => (this._fieldValue__input = c)} id={this._htmlid} accept={this.props.fileSuffix || null} multiple />
          <label htmlFor={this._htmlid} title={$L('拖动或点击选择文件。需要 %s 个', `${this.__minUpload}~${this.__maxUpload}`)} className="btn-secondary" onClick={(e) => this._fileClick(e)}>
            {this._captureType === 2 ? <span className="mdi mdi-camera" /> : <span className="zmdi zmdi-upload" />}
            <span className="ml-1">{$L('上传文件')}</span>
          </label>
          {this._captureType === 3 && (
            <RF>
              <label className="dropdown-toggle btn-secondary" data-toggle="dropdown">
                <i className="icon zmdi zmdi-chevron-down" />
              </label>
              <div className="dropdown-menu dropdown-menu-sm">
                <a className="dropdown-item" onClick={() => this._fileClick(null, 2)}>
                  <i className="icon mdi mdi-camera" /> {$L('拍摄')}
                </a>
              </div>
            </RF>
          )}
        </div>
        <input ref={(c) => (this._fieldValue = c)} type="hidden" value={value} />
      </div>
    )
  }

  renderViewElement() {
    const value = this.state.value
    if ($empty(value)) return super.renderViewElement()

    return (
      <div className="file-field">
        {value.map((item) => {
          const fileName = $fileCutName(item)
          return (
            <a key={item} title={fileName} onClick={() => this._filePreview(item)} className="img-thumbnail">
              {this._renderFileIcon(fileName, item)}
            </a>
          )
        })}
      </div>
    )
  }

  _renderFileIcon(fileName, file) {
    const isImage = $isImage(fileName)
    return (
      <RF>
        <i className={`file-icon ${isImage && 'image'}`} data-type={$fileExtName(fileName)}>
          {isImage && <img src={this._formatUrl(file)} />}
        </i>
        <span>{fileName}</span>
      </RF>
    )
  }
}

class RbFormPickList extends RbFormElement {
  constructor(props) {
    super(props)

    const options = [...props.options]
    if (props.value) {
      
      let deleted = true
      $(options).each(function () {
        
        if (this.id == props.value) {
          deleted = false
          return false
        }
      })

      if (deleted) {
        options.push({ id: props.value, text: '[DELETED]' })
      }
    }
    this._options = options
  }

  renderElement() {
    const keyName = `${this.state.field}-option-`
    return (
      <select ref={(c) => (this._fieldValue = c)} className="form-control form-control-sm" defaultValue={this.state.value || ''}>
        <option value="" />
        {this._options.map((item) => {
          return (
            <option key={`${keyName}${item.id}`} value={item.id} disabled={$isSysMask(item.text)}>
              {item.text}
            </option>
          )
        })}
      </select>
    )
  }

  renderViewElement() {
    return super.renderViewElement(__findOptionText(this.state.options, this.state.value, true))
  }

  onEditModeChanged(destroy) {
    if (destroy) {
      super.onEditModeChanged(destroy)
    } else {
      this.__select2 = $(this._fieldValue).select2({
        placeholder: $L('选择%s', this.props.label),
      })

      const that = this
      this.__select2.on('change', function (e) {
        const val = e.target.value
        that.handleChange({ target: { value: val } }, true)
      })

      const _readonly37 = this.state.readonly
      if (_readonly37) $(this._fieldValue).attr('disabled', true)
    }
  }

  isValueUnchanged() {
    if (this._isNew === true) return false
    return super.isValueUnchanged()
  }

  setValue(val) {
    if (val && typeof val === 'object') val = val.id
    this.__select2.val(val).trigger('change')
  }
}

class RbFormReference extends RbFormElement {
  constructor(props) {
    super(props)
    this._hasDataFilter = props.referenceDataFilter && (props.referenceDataFilter.items || []).length > 0
  }

  renderElement() {
    const _readonly37 = this.state.readonly
    const quickNew = this.props.referenceQuickNew && !this.props.onView

    return (
      <div className="input-group has-append">
        <select ref={(c) => (this._fieldValue = c)} className="form-control form-control-sm" title={this._hasDataFilter ? $L('当前字段已启用数据过滤') : null} multiple={this._multiple === true} />
        {!_readonly37 && (
          <div className="input-group-append">
            <button className="btn btn-secondary" type="button" onClick={() => this.showSearcher()}>
              <i className="icon zmdi zmdi-search" />
            </button>
            {quickNew && (
              <button className="btn btn-secondary" type="button" onClick={() => this.quickNew()} title={$L('新建')}>
                <i className="icon zmdi zmdi-plus" />
              </button>
            )}
          </div>
        )}
      </div>
    )
  }

  renderViewElement() {
    const value = this.state.value
    if ($empty(value)) return super.renderViewElement()

    if (typeof value === 'string') return <div className="form-control-plaintext">{value}</div>
    if (!value.id) return <div className="form-control-plaintext">{value.text}</div>

    return (
      <div className="form-control-plaintext">
        <a href={`#!/View/${value.entity}/${value.id}`} onClick={this._clickView}>
          {value.text}
        </a>
      </div>
    )
  }
  _renderViewElement() {
    return super.renderViewElement()
  }

  _clickView = (e) => window.RbViewPage && window.RbViewPage.clickView(e.target)

  componentDidMount() {
    super.componentDidMount()

    
    const props = this.props
    if (this._isNew && props.value && props.value.id) {
      setTimeout(() => this.triggerAutoFillin(props.value.id), 500)
    }
  }

  onEditModeChanged(destroy) {
    const $$$form = this.props.$$$parent

    if (destroy) {
      super.onEditModeChanged(destroy)
    } else {
      this.__select2 = $initReferenceSelect2(this._fieldValue, {
        name: this.props.field,
        label: this.props.label,
        entity: $$$form.props.entity,
        wrapQuery: (query) => {
          const cascadingValue = this._getCascadingFieldValue()
          return cascadingValue ? { cascadingValue, ...query } : query
        },
        placeholder: this._placeholderw,
        templateResult: function (res) {
          const $span = $('<span class="code-append"></span>').attr('title', res.text).text(res.text)
          if (res.id) {
            $(`<a title="${$L('在新页面打开')}"><i class="zmdi zmdi-open-in-new"></i></a>`)
              .appendTo($span)
              .on('mousedown', (e) => {
                $stopEvent(e, true)
                window.open(`${rb.baseUrl}/app/redirect?id=${res.id}&type=newtab`)
              })
          }
          return $span
        },
      })

      const val = this.state.value
      if (val) this.setValue(val)

      const that = this
      this.__select2.on('change', function (e) {
        const v = $(e.target).val()
        if (v && typeof v === 'string') {
          __addRecentlyUse(v)
          that.triggerAutoFillin(v)

          
          
          const _cascadingFieldChild = that.props._cascadingFieldChild || ''
          if ($$$form._ProTables && !$$$form._inAutoFillin && _cascadingFieldChild.includes('.')) {
            const _ProTable = $$$form._ProTables[_cascadingFieldChild.split('.')[0]]
            if (_ProTable) {
              const field = _cascadingFieldChild.split('$$$$')[0].split('.')[1]
              _ProTable.setFieldNull(field)
              console.log('Clean details ...', field)
            }
          }
        }

        that.handleChange({ target: { value: v } }, true)
      })

      const _readonly37 = this.state.readonly
      if (_readonly37) $(this._fieldValue).attr('disabled', true)
    }
  }

  componentWillUnmount() {
    super.componentWillUnmount()

    if (this._ReferenceSearcher) {
      this._ReferenceSearcher.destroy()
      this._ReferenceSearcher = null
    }
  }

  _getCascadingFieldValue() {
    const props = this.props
    if (typeof props.getCascadingFieldValue === 'function') {
      return props.getCascadingFieldValue(this)
    }

    
    let cascadingField
    if (props._cascadingFieldParent) {
      cascadingField = props._cascadingFieldParent.split('$$$$')[0]
    } else if (props._cascadingFieldChild) {
      cascadingField = props._cascadingFieldChild.split('$$$$')[0]
      
      if (cascadingField && cascadingField.includes('.')) return null
    }
    if (!cascadingField) return null

    let $$$parent = props.$$$parent

    
    if ($$$parent._InlineForm && (props._cascadingFieldParent || '').includes('.')) {
      $$$parent = $$$parent.props.$$$main
      cascadingField = cascadingField.split('.')[1]
    }

    let v
    if (this.props.onView) {
      v = ($$$parent.__ViewData || {})[cascadingField]

      
      if (!v && props._cascadingFieldParentValue) {
        v = { id: props._cascadingFieldParentValue }
      }
    } else {
      const fieldComp = $$$parent.refs[`fieldcomp-${cascadingField}`]
      v = fieldComp ? fieldComp.getValue() : null

      
      if (!fieldComp && props._cascadingFieldParentValue) {
        v = { id: props._cascadingFieldParentValue }
      }
    }

    if (v && Array.isArray(v)) v = v[0] 
    return v ? v.id || v : null
  }

  
  triggerAutoFillin(value) {
    if (this.props.onView) return

    const $$$form = this.props.$$$parent
    const url = `/app/entity/extras/fillin-value?entity=${$$$form.props.entity}&field=${this.props.field}&source=${value}`
    $.get(url, (res) => {
      if (res.error_code === 0 && res.data.length > 0) {
        const fillin2main = []
        const fillin2this = []
        res.data.forEach((item) => {
          if (item.target.includes('.')) {
            fillin2main.push({ ...item, target: item.target.split('.')[1] })
          } else {
            fillin2this.push(item)
          }
        })

        if (fillin2this.length > 0) {
          $$$form.setAutoFillin(fillin2this)
        }
        
        if (fillin2main.length > 0 && $$$form._InlineForm) {
          const $$$formMain = $$$form.props.$$$main
          $$$formMain && $$$formMain.setAutoFillin(fillin2main)
        }
      }
    })
  }

  isValueUnchanged() {
    const oldv = this.state.newValue === undefined ? (this.props.value || {}).id : (this.state.newValue || {}).id
    return $same(oldv, this.state.value)
  }

  setValue(val) {
    if (val) {
      const o = new Option(val.text, val.id, true, true)
      this.__select2.append(o).trigger('change')
    } else {
      this.__select2.val(null).trigger('change')
    }
  }

  showSearcher() {
    const that = this
    window.referenceSearch__call = function (selected) {
      that.showSearcher_call(selected, that)
      that._ReferenceSearcher.hide()
    }

    const url = `${rb.baseUrl}/app/entity/reference-search?field=${this.props.field}.${this.props.$$$parent.props.entity}&cascadingValue=${this._getCascadingFieldValue() || ''}`
    if (!this._ReferenceSearcher_Url) this._ReferenceSearcher_Url = url

    if (this._ReferenceSearcher && this._ReferenceSearcher_Url === url) {
      this._ReferenceSearcher.show()
    } else {
      if (this._ReferenceSearcher) {
        this._ReferenceSearcher.destroy()
        this._ReferenceSearcher = null
      }
      this._ReferenceSearcher_Url = url

      
      renderRbcomp(<ReferenceSearcher url={url} title={$L('选择%s', this.props.label)} useWhite maximize />, function () {
        that._ReferenceSearcher = this
      })
    }
  }

  showSearcher_call(selected, that) {
    const id = selected[0]
    if ($(that._fieldValue).find(`option[value="${id}"]`).length > 0) {
      that.__select2.val(id).trigger('change')
    } else {
      $.get(`/commons/search/read-labels?ids=${id}`, (res) => {
        const _data = res.data || {}
        const o = new Option(_data[id], id, true, true)
        that.__select2.append(o).trigger('change')
      })
    }

    
    const $$$parent = this.props.$$$parent
    if (selected.length > 1 && $$$parent._InlineForm) {
      const _ProTable = $$$parent.props.$$$parent
      $.get(`/commons/search/read-labels?ids=${selected.join(',')}`, (res) => {
        const _data = res.data || {}
        for (let i = 1; i < selected.length; i++) {
          const id = selected[i]
          const v = {
            [this.props.field]: {
              id: id,
              text: _data[id],
            },
          }
          setTimeout(() => _ProTable.addNew(v), 20 * i)
        }
      })
    }
  }

  quickNew() {
    const e = this.props.referenceEntity
    RbFormModal.create({ title: $L('新建%s', e.entityLabel), entity: e.entity, icon: e.icon, postAfter: (id) => this.showSearcher_call([id], this) }, true)
  }
}

class RbFormN2NReference extends RbFormReference {
  constructor(props) {
    super(props)
    this._multiple = true
  }

  renderViewElement() {
    const value = this.state.value
    if ($empty(value)) return super._renderViewElement()
    if (typeof value === 'string') return <div className="form-control-plaintext">{value}</div>

    return (
      <div className="form-control-plaintext multi-values">
        {value.map((item) => {
          return (
            <a key={item.id} href={`#!/View/${item.entity}/${item.id}`} onClick={this._clickView}>
              {item.text}
            </a>
          )
        })}
      </div>
    )
  }

  isValueUnchanged() {
    let oldvArray = this.state.newValue || this.props.value || []
    let oldv = []
    oldvArray.forEach((s) => oldv.push(s.id))
    return $same(oldv.join(','), this.state.value)
  }

  handleChange(e, checkValue) {
    let val = e.target.value
    if (val && typeof val === 'object') val = val.join(',')
    super.handleChange({ target: { value: val } }, checkValue)
  }

  
  setValue(val, append) {
    if (val && val.length > 0) {
      let currentIds = this.state.value || '' 

      if (!append) {
        this.__select2.val(null).trigger('change')
        currentIds = ''
      }

      const ids = []
      val.forEach((item) => {
        if (!currentIds.includes(item.id)) {
          const o = new Option(item.text, item.id, true, true)
          this.__select2.append(o)
          ids.push(item.id)
        }
      })

      if (ids.length > 0) {
        let ss = ids.join(',')
        if (append && currentIds && currentIds !== '') ss = currentIds + ',' + ss
        this.handleChange({ target: { value: ss } }, true)
      }
    } else {
      this.__select2.val(null).trigger('change')
    }
  }

  showSearcher_call(selected, that) {
    const ids = selected.join(',')
    $.get(`/commons/search/read-labels?ids=${ids}`, (res) => {
      const val = []
      for (let k in res.data) {
        val.push({ id: k, text: res.data[k] })
      }
      that.setValue(val, true)
    })
    __addRecentlyUse(ids)

    
    if (selected[0] && this.props._cascadingFieldParent) {
      this.triggerAutoFillin(selected[0])
    }
  }

  onEditModeChanged(destroy) {
    super.onEditModeChanged(destroy)
    if (!destroy && this.__select2) {
      this.__select2.on('select2:select', (e) => __addRecentlyUse(e.params.data.id))
    }
  }
}


class RbFormAnyReference extends RbFormReference {}

class RbFormClassification extends RbFormElement {
  renderElement() {
    const _readonly37 = this.state.readonly

    return (
      <div className="input-group has-append">
        <select ref={(c) => (this._fieldValue = c)} className="form-control form-control-sm" />
        {!_readonly37 && (
          <div className="input-group-append">
            <button className="btn btn-secondary" type="button" onClick={this.showSelector}>
              <i className="icon zmdi zmdi-search" />
            </button>
          </div>
        )}
      </div>
    )
  }

  renderViewElement() {
    let text = this.state.value
    if (text && text.color) {
      text = (
        <span className="badge" style={$tagStyle2(text.color)}>
          {text.text}
        </span>
      )
    } else if (text) {
      text = <span className="badge text-dark">{text.text}</span>
    }
    return super.renderViewElement(text)
  }

  onEditModeChanged(destroy) {
    if (destroy) {
      super.onEditModeChanged(destroy)
      this.__cached = null
      if (this.__selector) {
        this.__selector.hide(true)
        this.__selector = null
      }
    } else {
      this.__select2 = $initReferenceSelect2(this._fieldValue, {
        name: this.props.field,
        label: this.props.label,
        entity: this.props.$$$parent.props.entity,
        searchType: 'classification',
        templateResult: function (res) {
          const $span = $('<span class="code-append"></span>').attr('title', res.text).text(res.text)
          res.code && $(`<em>${res.code}</em>`).appendTo($span)
          return $span
        },
      })

      const value = this.state.value
      value && this._setClassificationValue(value)

      this.__select2.on('change', () => {
        const v = this.__select2.val()
        if (v) __addRecentlyUse(`${v}&type=d${this.props.classification}:${this.props.openLevel}`)
        this.handleChange({ target: { value: v } }, true)
      })

      const _readonly37 = this.state.readonly
      if (_readonly37) $(this._fieldValue).attr('disabled', true)
    }
  }

  isValueUnchanged() {
    const oldv = this.state.newValue === undefined ? (this.props.value || {}).id : (this.state.newValue || {}).id
    return $same(oldv, this.state.value)
  }

  setValue(val) {
    if (val && val.id) this._setClassificationValue(val)
    else this.__select2.val(null).trigger('change')
  }

  showSelector = () => {
    if (this.__selector) this.__selector.show()
    else {
      const p = this.props
      const that = this
      renderRbcomp(
        
        <ClassificationSelector entity={p.$$$parent.state.entity} field={p.field} label={p.label} openLevel={p.openLevel} onSelect={(s) => this._setClassificationValue(s)} keepModalOpen={true} />,
        null,
        function () {
          that.__selector = this
        }
      )
    }
  }

  _setClassificationValue(s) {
    if (!s.id) return

    const data = this.__cached || {}

    if (data[s.id]) {
      this.__select2.val(s.id).trigger('change')
    } else if (this._fieldValue) {
      const o = new Option(s.text, s.id, true, true)
      $(this._fieldValue).append(o).trigger('change')
      data[s.id] = s.text
      this.__cached = data
    }
  }
}

class RbFormMultiSelect extends RbFormElement {
  renderElement() {
    if ((this.props.options || []).length === 0) {
      return <div className="form-control-plaintext text-danger">{$L('未配置')}</div>
    }

    const _readonly37 = this.state.readonly
    const maskValue = this._getMaskValue()

    return (
      <div className="mt-1" ref={(c) => (this._fieldValue__wrap = c)}>
        {(this.props.options || []).map((item) => {
          return (
            <label key={`mask-${item.mask}`} className="custom-control custom-checkbox custom-control-inline">
              <input
                className="custom-control-input"
                name={`checkbox-${this.props.field}`}
                type="checkbox"
                checked={(maskValue & item.mask) !== 0}
                value={item.mask}
                onChange={this._changeValue}
                disabled={_readonly37 || $isSysMask(item.text)}
              />
              <span className="custom-control-label">{item.text}</span>
            </label>
          )
        })}
      </div>
    )
  }

  renderViewElement() {
    if (!this.state.value) return super.renderViewElement()

    const maskValue = this._getMaskValue()
    return <div className="form-control-plaintext multi-values">{__findMultiTexts(this.props.options, maskValue, true)}</div>
  }

  _changeValue = () => {
    let maskValue = 0
    $(this._fieldValue__wrap)
      .find('input:checked')
      .each(function () {
        maskValue += ~~$(this).val()
      })

    this.handleChange({ target: { value: maskValue === 0 ? null : maskValue } }, true)
  }

  _getMaskValue() {
    const val = this.state.value
    if (!val) return 0
    return typeof val === 'object' ? val.id : val
  }

  setValue(val) {
    
    if (typeof val === 'object') val = val.id || val
    super.setValue(val)
  }
}

class RbFormBool extends RbFormElement {
  _Options = {
    T: $L('是'),
    F: $L('否'),
  }

  constructor(props) {
    super(props)
    this._htmlid = `${props.field}-${$random()}_`
  }

  renderElement() {
    const _readonly37 = this.state.readonly

    return (
      <div className="mt-1">
        <label className="custom-control custom-radio custom-control-inline mb-1">
          <input className="custom-control-input" name={`${this._htmlid}T`} type="radio" checked={this.state.value === 'T'} data-value="T" onChange={this._changeValue} disabled={_readonly37} />
          <span className="custom-control-label">{this._Options['T']}</span>
        </label>
        <label className="custom-control custom-radio custom-control-inline mb-1">
          <input className="custom-control-input" name={`${this._htmlid}F`} type="radio" checked={this.state.value === 'F'} data-value="F" onChange={this._changeValue} disabled={_readonly37} />
          <span className="custom-control-label">{this._Options['F']}</span>
        </label>
      </div>
    )
  }

  renderViewElement() {
    return super.renderViewElement(this.state.value ? this._Options[this.state.value] : null)
  }

  _changeValue = (e) => {
    const val = e.target.dataset.value
    this.handleChange({ target: { value: val } }, true)
  }
}

class RbFormState extends RbFormPickList {}

class RbFormBarcode extends RbFormElement {
  renderElement() {
    if (this.state.value) return this.renderViewElement()

    return (
      <div className="form-control-plaintext barcode text-muted">
        {$L('自动值')} ({this.props.barcodeType === 'BARCODE' ? $L('条形码') : $L('二维码')})
      </div>
    )
  }

  renderViewElement() {
    if (!this.state.value) return super.renderViewElement()

    const isbar = this.props.barcodeType === 'BARCODE'
    const codeUrl = `${rb.baseUrl}/commons/barcode/render${isbar ? '' : '-qr'}?t=${$encode(this.state.value)}`
    return (
      <div className="img-field barcode">
        <a
          className={`img-thumbnail pointer ${isbar && 'w-auto'}`}
          title={this.state.value}
          onClick={() => {
            RbAlert.create(
              <div className="mb-3 text-center">
                <img src={`${codeUrl}&w=${isbar ? 64 * 2 : 80 * 3}`} alt={this.state.value} style={{ maxWidth: '100%' }} />
                {!isbar && <div className="text-muted mt-2 mb-1 text-break text-bold">{this.state.value}</div>}
              </div>,
              {
                type: 'clear',
              }
            )
          }}>
          <img src={codeUrl} alt={this.state.value} />
        </a>
      </div>
    )
  }
}

class RbFormAvatar extends RbFormElement {
  constructor(props) {
    super(props)
    this._htmlid = `${props.field}-${$random()}-input`
  }

  renderElement() {
    const _readonly37 = this.state.readonly

    return (
      <div className="img-field avatar">
        <span title={_readonly37 ? null : $L('选择头像')}>
          {!_readonly37 && <input ref={(c) => (this._fieldValue__input = c)} type="file" className="inputfile" id={this._htmlid} accept="image/*" />}
          <label htmlFor={this._htmlid} className="img-thumbnail img-upload" disabled={_readonly37}>
            <img src={this._formatUrl(this.state.value)} alt="Avatar" />
            {!_readonly37 && this.state.value && (
              <b
                title={$L('移除')}
                onClick={(e) => {
                  $stopEvent(e, true)
                  this.handleClear()
                }}>
                <span className="zmdi zmdi-close" />
              </b>
            )}
          </label>
        </span>
      </div>
    )
  }

  renderViewElement() {
    return (
      <div className="img-field avatar">
        <a className="img-thumbnail img-upload" style={{ cursor: 'default' }}>
          <img src={this._formatUrl(this.state.value)} alt="Avatar" />
        </a>
      </div>
    )
  }

  _formatUrl(urlKey) {
    if (urlKey && (urlKey.startsWith('http://') || urlKey.startsWith('https://'))) return urlKey
    else return rb.baseUrl + (urlKey ? `/filex/img/${urlKey}?imageView2/2/w/100/interlace/1/q/100` : '/assets/img/avatar.png')
  }

  onEditModeChanged(destroy) {
    if (destroy) {
      
    } else {
      let mp
      const mp_end = function () {
        setTimeout(() => {
          if (mp) mp.end()
          mp = null
        }, 510)
      }

      $createUploader(
        this._fieldValue__input,
        (res) => {
          if (!mp) mp = new Mprogress({ template: 2, start: true })
          mp.set(res.percent / 100) 
        },
        (res) => {
          mp_end()
          this.handleChange({ target: { value: res.key } }, true)
        },
        () => mp_end()
      )
    }
  }
}

class RbFormLocation extends RbFormElement {
  constructor(props) {
    super(props)
    this._autoLocation = props.locationAutoLocation && this._isNew && !props.value
  }

  renderElement() {
    const _readonly37 = this.state.readonly
    const lnglat = this._parseLnglat(this.state.value)

    if (_readonly37) {
      return (
        <RF>
          {super.renderElement(lnglat ? lnglat.text : null)}
          {this._autoLocation && (
            <em className="vflag">
              <i className="zmdi zmdi-pin-drop flash infinite slow fs-14" ref={(c) => (this._$icon = c)} />
            </em>
          )}
        </RF>
      )
    }

    return (
      <div className="input-group has-append">
        <input
          type="text"
          ref={(c) => (this._fieldValue = c)}
          className={`form-control form-control-sm bg-white ${this.state.hasError ? 'is-invalid' : ''}`}
          title={this.state.hasError}
          value={lnglat ? lnglat.text || '' : ''}
          onChange={(e) => this.handleChange(e)}
          readOnly
          placeholder={this._placeholderw}
          onClick={() => this._showMap(lnglat)}
        />

        <span className={`zmdi zmdi-close clean ${this.state.value ? '' : 'hide'}`} onClick={() => this.handleClear()} title={$L('清除')} />
        <div className="input-group-append">
          <button className="btn btn-secondary" type="button" onClick={() => this._showMap(lnglat)}>
            <i className="icon zmdi zmdi-pin-drop flash infinite slow" ref={(c) => (this._$icon = c)} />
          </button>
        </div>
      </div>
    )
  }

  renderViewElement() {
    if (!this.state.value) return super.renderViewElement()

    const lnglat = this._parseLnglat(this.state.value)
    return this.props.locationMapOnView ? (
      <div>
        <div className="form-control-plaintext">{lnglat.text}</div>
        <div className="map-show">
          <BaiduMap lnglat={lnglat} ref={(c) => (this._BaiduMap = c)} disableScrollWheelZoom />
        </div>
      </div>
    ) : (
      <div className="form-control-plaintext">
        <a
          href={`#!/Map:${lnglat.lng || ''}:${lnglat.lat || ''}`}
          onClick={(e) => {
            $stopEvent(e, true)
            BaiduMapModal.view(lnglat)
          }}>
          {lnglat.text}
        </a>
      </div>
    )
  }

  _parseLnglat(val) {
    if (!val) return null
    if (typeof val === 'object') return val

    const vals = val.split('$$$$')
    const lnglat = vals[1] ? vals[1].split(',') : null 
    return {
      text: vals[0],
      lng: lnglat ? lnglat[0] : null,
      lat: lnglat ? lnglat[1] : null,
    }
  }

  _showMap(lnglat) {
    if (this._BaiduMapModal) {
      this._BaiduMapModal.show()
    } else {
      const that = this
      renderRbcomp(
        <BaiduMapModal
          canPin
          lnglat={lnglat}
          title={$L('选取位置')}
          onConfirm={(lnglat) => {
            const val = lnglat && lnglat.text ? `${lnglat.text}$$$$${lnglat.lng || 0},${lnglat.lat || 0}` : null
            that.handleChange({ target: { value: val } }, true)
          }}
          useWhite
        />,
        null,
        function () {
          that._BaiduMapModal = this
        }
      )
    }
  }

  onEditModeChanged(destroy) {
    if (destroy) {
      
    }
  }

  componentDidMount() {
    super.componentDidMount()

    if (this._autoLocation) {
      $(this._$icon).addClass('animated')
      
      $autoLocation((v) => {
        v = v && v.text ? `${v.text}$$$$${v.lng},${v.lat}` : null
        v && this.handleChange({ target: { value: v } }, true)

        if (this.props.readonly) $(this._$icon).remove()
        else $(this._$icon).removeClass('animated')
      })
    }
  }

  componentWillUnmount() {
    super.componentWillUnmount()
    if (this._BaiduMapModal) {
      this._BaiduMapModal.destroy()
      this._BaiduMapModal = null
    }
  }
}

class RbFormSign extends RbFormElement {
  renderElement() {
    const _readonly37 = this.state.readonly
    const value = this.state.value

    return (
      <div className="img-field sign sign-edit">
        <span title={_readonly37 ? null : $L('签名')}>
          <label
            className="img-thumbnail img-upload"
            onClick={() => {
              if (!_readonly37) {
                this._openSignPad((v) => {
                  this.handleChange({ target: { value: v || null } }, true)
                })
              }
            }}
            disabled={_readonly37}>
            {value ? <img src={value} alt="SIGN" /> : <span className="mdi mdi-file-sign" />}
          </label>
        </span>
      </div>
    )
  }

  renderViewElement() {
    if (!this.state.value) return super.renderViewElement()

    return (
      <div className="img-field sign">
        <a className="img-thumbnail img-upload">
          <img src={this.state.value} alt="SIGN" />
        </a>
      </div>
    )
  }

  _openSignPad(onConfirm) {
    if (this._SignPad) {
      this._SignPad.show(true)
    } else {
      const that = this
      renderRbcomp(<SignPad onConfirm={onConfirm} />, function () {
        that._SignPad = this
      })
    }
  }
}

class RbFormTag extends RbFormElement {
  constructor(props) {
    super(props)

    this._initOptions()
    this.__maxSelect = props.tagMaxSelect || 9
  }

  renderElement() {
    const keyName = `${this.state.field}-tag-`
    return (
      <select ref={(c) => (this._fieldValue = c)} className="form-control form-control-sm" multiple defaultValue={this._selected}>
        {this._options.map((item) => {
          return (
            <option key={`${keyName}${item.name}`} value={item.name}>
              {item.name}
            </option>
          )
        })}
      </select>
    )
  }

  renderViewElement() {
    if (!this.state.value) return super.renderViewElement()

    return <div className="form-control-plaintext multi-values">{__findTagTexts(this.props.options, this.state.value)}</div>
  }

  _initOptions() {
    const props = this.props

    let options = [...props.options]
    let selected = []
    if (this._isNew) {
      props.options.forEach((item) => {
        if (item.default) selected.push(item.name)
      })
    } else if (this.state.value) {
      let value = this.state.value
      if (typeof value === 'string') value = value.split('$$$$') 

      value.forEach((name) => {
        selected.push(name)
        const found = props.options.find((x) => x.name === name)
        if (!found) options.push({ name: name })
      })
    }
    this._options = options
    this._selected = selected
  }

  onEditModeChanged(destroy) {
    if (destroy) {
      super.onEditModeChanged(destroy)
      this._initOptions()
    } else {
      this.__select2 = $(this._fieldValue).select2({
        placeholder: this.props.readonlyw > 0 ? this._placeholderw : $L('输入%s', this.props.label),
        maximumSelectionLength: this.__maxSelect,
        tags: true,
        language: {
          noResults: function () {
            return $L('输入后回车')
          },
        },
        theme: 'default select2-tag',
      })

      const that = this
      this.__select2.on('change', function (e) {
        const mVal = $(e.currentTarget).val()
        that.handleChange({ target: { value: mVal.join('$$$$') } }, true)
      })

      const _readonly37 = this.state.readonly
      if (_readonly37) $(this._fieldValue).attr('disabled', true)
    }
  }

  setValue(val) {
    if (val && typeof val === 'object') val = val.join('$$$$')
    super.setValue(val)

    
    if ($empty(val)) {
      this.__select2.val(null).trigger('change')
    } else {
      const names = []
      val.split('$$$$').forEach((name) => {
        if (!names.includes(name)) {
          const o = new Option(name, name, true, true)
          this.__select2.append(o)
          names.push(name)
        }
      })
    }
  }
}


class RbFormUnsupportted extends RbFormElement {
  renderElement() {
    return <div className="form-control-plaintext text-danger">UNSUPPORTTED</div>
  }

  renderViewElement() {
    return this.renderElement()
  }
}


class RbFormDivider extends React.Component {
  constructor(props) {
    super(props)
    this.state = { collapsed: false }
  }

  render() {
    if (this.props.breaked === true) {
      return <div className="form-line-breaked"></div>
    }

    return (
      <div className={`form-line hover -v33 ${this.state.collapsed && 'collapsed'}`} ref={(c) => (this._$formLine = c)}>
        <fieldset>
          <legend onClick={() => this._toggle()} title={$L('展开/收起')}>
            {this.props.label && <span>{this.props.label}</span>}
          </legend>
        </fieldset>
      </div>
    )
  }

  _toggle() {
    let collapsed = null
    let $next = $(this._$formLine)
    while (($next = $next.next()).length > 0) {
      if ($next.hasClass('form-line') || $next.hasClass('footer')) break
      $next.toggleClass('hide')
      if (collapsed === null) collapsed = $next.hasClass('hide')
    }
    this.setState({ collapsed })
  }
}


class RbFormRefform extends React.Component {
  constructor(props) {
    super(props)
    this.state = {}
  }

  render() {
    if (!this.state.formComponent) return null
    return (
      <div className={`rbview-form form-layout refform ${window.__LAB_VERTICALLAYOUT && 'vertical38'}`} ref={(c) => (this._viewForm = c)}>
        {this.state.formComponent || 'LOADING'}
      </div>
    )
  }

  componentDidMount() {
    const v = this.props.refvalue
    const $$$parent = this.props.$$$parent
    
    if (v && $$$parent && ($$$parent.__nestDepth || 0) < 3) {
      this._renderViewFrom({ id: v[0], entity: v[1] })
    }
  }

  _renderViewFrom(props) {
    $.get(`/app/${props.entity}/view-model?id=${props.id}&layout=${this.props.speclayout || ''}`, (res) => {
      
      if (res.error_code > 0 || !!res.data.error) {
        const err = res.data.error || res.error_msg
        this.setState({ formComponent: <div className="text-danger">{err}</div> })
        return
      }

      this.__nestDepth = (this.props.$$$parent.__nestDepth || 0) + 1
      this.__ViewData = {}

      const VFORM = (
        <RF>
          <a title={$L('在新页面打开')} className="close open-in-new" href={`${rb.baseUrl}/app/redirect?id=${props.id}&type=newtab`} target="_blank">
            <i className="icon zmdi zmdi-open-in-new" />
          </a>
          <div className="row">
            {res.data.elements.map((item) => {
              if (![TYPE_DIVIDER, TYPE_REFFORM].includes(item.field)) this.__ViewData[item.field] = item.value
              item.$$$parent = this
              
              return detectViewElement(item, props.entity)
            })}
          </div>
        </RF>
      )
      this.setState({ formComponent: VFORM })
    })
  }
}


var detectElement = function (item, entity) {
  if (!item.key) item.key = `field-${item.field === TYPE_DIVIDER || item.field === TYPE_REFFORM ? $random() : item.field}`

  if (entity && window._CustomizedForms) {
    const c = window._CustomizedForms.useFormElement(entity, item)
    if (c) return c
  }

  if (item.type === 'TEXT' || item.type === 'SERIES') {
    return <RbFormText {...item} />
  } else if (item.type === 'NTEXT') {
    return <RbFormNText {...item} />
  } else if (item.type === 'URL') {
    return <RbFormUrl {...item} />
  } else if (item.type === 'EMAIL') {
    return <RbFormEMail {...item} maxLength="100" />
  } else if (item.type === 'PHONE') {
    return <RbFormPhone {...item} maxLength="40" />
  } else if (item.type === 'NUMBER') {
    return <RbFormNumber {...item} />
  } else if (item.type === 'DECIMAL') {
    return <RbFormDecimal {...item} />
  } else if (item.type === 'IMAGE') {
    return <RbFormImage {...item} />
  } else if (item.type === 'FILE') {
    return <RbFormFile {...item} />
  } else if (item.type === 'DATETIME' || item.type === 'DATE') {
    return <RbFormDateTime {...item} />
  } else if (item.type === 'TIME') {
    return <RbFormTime {...item} />
  } else if (item.type === 'PICKLIST') {
    return <RbFormPickList {...item} />
  } else if (item.type === 'REFERENCE') {
    return <RbFormReference {...item} />
  } else if (item.type === 'N2NREFERENCE') {
    return <RbFormN2NReference {...item} />
  } else if (item.type === 'ANYREFERENCE') {
    return <RbFormAnyReference {...item} readonly />
  } else if (item.type === 'CLASSIFICATION') {
    return <RbFormClassification {...item} />
  } else if (item.type === 'MULTISELECT') {
    return <RbFormMultiSelect {...item} />
  } else if (item.type === 'BOOL') {
    return <RbFormBool {...item} />
  } else if (item.type === 'STATE') {
    return <RbFormState {...item} />
  } else if (item.type === 'BARCODE') {
    return <RbFormBarcode {...item} readonly />
  } else if (item.type === 'AVATAR') {
    return <RbFormAvatar {...item} />
  } else if (item.type === 'LOCATION') {
    return <RbFormLocation {...item} />
  } else if (item.type === 'SIGN') {
    return <RbFormSign {...item} />
  } else if (item.type === 'TAG') {
    return <RbFormTag {...item} />
  } else if (item.field === TYPE_DIVIDER || item.field === '$LINE$') {
    return <RbFormDivider {...item} />
  } else if (item.field === TYPE_REFFORM) {
    return <RbFormRefform {...item} />
  } else {
    return <RbFormUnsupportted {...item} />
  }
}


const __findOptionText = function (options, value, useColor) {
  if ((options || []).length === 0 || !value) return null
  
  const o = options.find((x) => x.id == value)

  let text = (o || {}).text || `[${value.toUpperCase()}]`
  if (useColor) {
    if (o && o.color) {
      text = (
        <span className="badge" style={$tagStyle2(o.color)}>
          {text}
        </span>
      )
    } else {
      text = <span className="badge text-dark">{text}</span>
    }
  }
  return text
}


const __findMultiTexts = function (options, maskValue, useColor) {
  const texts = []
  options.map((o) => {
    if ((maskValue & o.mask) !== 0) {
      const style2 = o.color && useColor ? { borderColor: o.color, backgroundColor: o.color, color: '#fff' } : null
      const text = (
        <span key={`mask-${o.mask}`} style={style2}>
          {o.text}
        </span>
      )
      texts.push(text)
    }
  })
  return texts
}


const __findTagTexts = function (options, value) {
  if (typeof value === 'string') value = value.split('$$$$')

  const texts = []
  value.map((name) => {
    let item = options.find((x) => x.name === name)
    if (!item) item = { name: name }

    const text = (
      <span key={`tag-${item.name}`} style={$tagStyle2(item.color)}>
        {item.name}
      </span>
    )
    texts.push(text)
  })
  return texts
}


const __addRecentlyUse = function (id) {
  if (id && typeof id === 'string') {
    $.post(`/commons/search/recently-add?id=${id}`)
  }
}


const __calcFormula = function (fieldComp) {
  const watchFields = fieldComp.props.calcFormula.match(/\{([a-z0-9]+)}/gi) || []
  const $$$parent = fieldComp.props.$$$parent

  const evalUrl = `/app/entity/extras/eval-calc-formula?entity=${$$$parent.props.entity}&field=${fieldComp.props.field}`
  setTimeout(() => {
    const calcFormulaValues = {}
    let _timer

    
    watchFields.forEach((item) => {
      const name = item.substr(1, item.length - 2)
      const c = $$$parent.refs[`fieldcomp-${name}`]
      if (c && !$empty(c.state.value)) {
        calcFormulaValues[name] = c.state.value
      } else if (item === '{NOW}') {
        
        calcFormulaValues[name] = '{NOW}'
      }
    })

    
    $$$parent.onFieldValueChange((s) => {
      if (!watchFields.includes(`{${s.name}}`)) return false
      if (rb.env === 'dev') console.log('onFieldValueChange for calcFormula :', s, fieldComp.props.field)

      if ($empty(s.value)) delete calcFormulaValues[s.name]
      else calcFormulaValues[s.name] = s.value

      if (_timer) {
        clearTimeout(_timer)
        _timer = null
      }

      
      _timer = setTimeout(() => {
        $.post(evalUrl, JSON.stringify(calcFormulaValues), (res) => {
          if (__isSameValue38(fieldComp.getValue(), res.data)) return false
          if (res.data) fieldComp.setValue(res.data)
          else fieldComp.setValue(null)
        })
      }, 300)
      return true
    })

    
    if (fieldComp._isNew) {
      $.post(evalUrl, JSON.stringify(calcFormulaValues), (res) => {
        if (__isSameValue38(fieldComp.getValue(), res.data)) return false
        if (res.data) fieldComp.setValue(res.data)
        else fieldComp.setValue(null)
      })
    }
  }, 600) 
}
function __isSameValue38(a, b) {
  if ($same(a, b)) return true
  try {
    
    return parseFloat(a) == parseFloat(b)
  } catch (err) {
    
  }
}
