/*!
Copyright (c) REBUILD <https://getrebuild.com/> and/or its owners. All rights reserved.

rebuild is dual-licensed under commercial and open source licenses (GPLv3).
See LICENSE and COMMERCIAL in the project root for license information.
*/

package com.rebuild.core.configuration.general;

import cn.devezhao.persist4j.Entity;
import cn.devezhao.persist4j.engine.ID;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.rebuild.TestSupport;
import com.rebuild.core.metadata.MetadataHelper;
import com.rebuild.core.privileges.UserService;
import com.rebuild.utils.JSONUtils;
import org.junit.jupiter.api.Test;


class FormsBuilderTest extends TestSupport {

    @Test
    void testModel() {
        JSON newModel = FormsBuilder.instance.buildForm(TestAllFields, UserService.ADMIN_USER, null);
        System.out.println(newModel);

        JSON editModel = FormsBuilder.instance.buildForm("User", UserService.ADMIN_USER, UserService.SYSTEM_USER);
        System.out.println(editModel);
    }

    @Test
    void testViewModel() {
        JSON viewModel = FormsBuilder.instance.buildView("User", UserService.ADMIN_USER, UserService.SYSTEM_USER);
        System.out.println(viewModel);
    }

    @Test
    void testSetFormInitialValue() {
        Entity SalesOrder999 = MetadataHelper.getEntity(SalesOrder);
        Entity SalesOrderItem999 = MetadataHelper.getEntity(SalesOrderItem);

        JSONObject initial = JSONUtils.toJSONObject(FormsBuilder.DV_MAINID, ID.newId(SalesOrder999.getEntityCode()));

        JSONArray elements = new JSONArray();
        JSONObject el = new JSONObject();
        el.put("field", "SalesOrder999Id");
        elements.add(el);

        JSONObject mockModel = new JSONObject();
        mockModel.put("elements", elements);

        FormsBuilder.instance.setFormInitialValue(SalesOrderItem999, mockModel, initial);
    }
}
