﻿using System;
using System.Data;
using System.Collections.Generic;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Text;
using EKETEAM.FrameWork;
using EKETEAM.Data;
using LitJson;

namespace eFrameWork.Manage
{
    public partial class ModelItems_Prints : System.Web.UI.Page
    {
        public string ModelID = eParameters.QueryString("modelid");
        private eUser user;
        public string linkArrys = "";
        private DataRow _modelinfo;
        public DataRow ModelInfo
        {
            get
            {
                if (_modelinfo == null)
                {
                    DataTable dt = eBase.DataBase.getDataTable("select * from a_eke_sysModels where ModelID='" + ModelID + "'");
                    if (dt.Rows.Count > 0) _modelinfo = dt.Rows[0];
                }
                return _modelinfo;
            }
        }
        private JsonData controljson;
        public JsonData ControlJson
        {
            get
            {
                if (controljson == null)
                {
                    controljson = new JsonData();
                    controljson.SetJsonType(JsonType.Array);
                    appendModelJson(controljson, ModelID);
                }
                return controljson;
            }
        }
        private void appendModelJson(JsonData jd, string modelid)
        {
            DataTable tb = eBase.DataBase.getDataTable("select modelid,mc from a_eke_sysModels where ModelID='" + modelid + "'");
            if (tb.Rows.Count == 0) return;
            DataRow row = tb.Rows[0];
            JsonData model = new JsonData();
            model["name"] = row["mc"].ToString();
            JsonData items = new JsonData();
            items.SetJsonType(JsonType.Array);
            appendModelItems(items, modelid);
            appendSubModel(items, modelid);
            model["items"] = items;
            jd.Add(model);

            //eBase.Writeln(modelid);
            DataTable dt = eBase.DataBase.getDataTable("select modelid,mc from a_eke_sysModels where ParentID='" + modelid + "' and JoinMore=0 and JoinType>0 and show=1 and deltag=0");
            foreach (DataRow dr in dt.Rows)
            {
                appendModelJson(jd, dr["modelid"].ToString());
            }
        }
        private void appendModelItems(JsonData items, string modelid)
        {
            string sql = "select ModelItemID,MC,Code,CustomCode,Num from a_eke_sysModelItems";
            sql += " where delTag=0 and ModelID='" + modelid + "' ";
            //sql += " and Code not in ('delTime','delUser','delTag') and MC not in ('序号','操作')";
            sql += " and isnull(Code,'') not in ('delTime','delUser','delTag') and MC not in ('操作')";
            sql += " order by num";


            sql = "select * from (";
            sql += "select ModelItemID,MC,Code,CustomCode,Num from a_eke_sysModelItems ";
            sql += " where delTag=0 and ModelID='" + modelid + "' ";
            //sql += " and isnull(Code,'') not in ('delTime','delUser','delTag') and MC not in ('序号','操作') ";
            sql += " and isnull(Code,'') not in ('delTime','delUser','delTag') and isnull(MC,'') not in ('操作') ";
            sql += " union ";
            sql += " select b.ModelItemID,b.MC,b.Code,b.CustomCode,b.Num from a_eke_sysModels a ";
            sql += " inner join a_eke_sysModelItems b on a.ModelID=b.ModelID ";
            sql += " where a.JoinMore=0 and b.delTag=0 and a.ParentID ='" + modelid + "' ";
            //sql += "and isnull( b.Code,'') not in ('" + tb.primaryKey + "','addTime','addUser','editTime','editUser','delTime','delUser','delTag') ";
            sql += "and isnull( b.Code,'') not in ('addTime','addUser','editTime','editUser','delTime','delUser','delTag') ";
            //sql += " and b.MC not in ('序号','操作') and b.primaryKey=0";
            sql += " and isnull(b.MC,'') not in ('序号','操作')";
            sql += ") as c order by c.Num";


            DataTable tb = eBase.DataBase.getDataTable(sql);
            //eBase.PrintDataTable(tb);
            foreach (DataRow dr in tb.Rows)
            {
                if (dr["Code"].ToString().Length > 0)
                {
                    JsonData item = new JsonData();
                    item["type"] = "data";
                    item["name"] = dr["MC"].ToString().Length > 0 ? dr["MC"].ToString() : dr["Code"].ToString();
                    item["code"] = dr["Code"].ToString();
                    items.Add(item);
                }
            }



        }
        private void appendSubModel(JsonData items, string modelid)
        {
            DataTable tb = eBase.DataBase.getDataTable("SELECT ModelID,MC FROM a_eke_sysModels where ParentID='" + modelid + "' and show=1 and delTag=0 and JoinMore=1 and Auto=1");
            foreach (DataRow dr in tb.Rows)
            {
                JsonData item = new JsonData();
                item["type"] = "model";
                item["name"] = dr["MC"].ToString();
                item["modelid"] = dr["ModelID"].ToString();
                items.Add(item);
            }
        }
        protected void Page_Load(object sender, EventArgs e)
        {
            user = new eUser("Manage");
            user.Check();
            Response.Write("<a href=\"http://help.eketeam.com/1/104.html\" style=\"float:right;\" target=\"_blank\" title=\"eFrameWork开发框架\"><img src=\"images/help.gif\"></a>");



            string sql = "select * from (";
            sql += "select ModelItemID,MC,Code,CustomCode,Num from a_eke_sysModelItems ";
            sql += " where delTag=0 and ModelID='" + ModelID + "' ";
            //sql += " and isnull(Code,'') not in ('delTime','delUser','delTag') and MC not in ('序号','操作') ";
            sql += " and isnull(Code,'') not in ('delTime','delUser','delTag') and isnull(MC,'') not in ('操作') ";
            sql += " union ";
            sql += " select b.ModelItemID,b.MC,b.Code,b.CustomCode,b.Num from a_eke_sysModels a ";
            sql += " inner join a_eke_sysModelItems b on a.ModelID=b.ModelID ";
            sql += " where a.JoinMore=0 and b.delTag=0 and a.ParentID ='" + ModelID + "' ";
            //sql += "and isnull( b.Code,'') not in ('" + tb.primaryKey + "','addTime','addUser','editTime','editUser','delTime','delUser','delTag') ";
            sql += "and isnull( b.Code,'') not in ('addTime','addUser','editTime','editUser','delTime','delUser','delTag') ";
            //sql += " and b.MC not in ('序号','操作') and b.primaryKey=0";
            sql += " and isnull(b.MC,'') not in ('序号','操作')";
            sql += ") as c order by c.Num";
            //eBase.WriteDiv(sql);
            DataTable items = eBase.DataBase.getDataTable(sql);
            for (int i = 0; i < items.Rows.Count; i++)
            {
                string code = items.Rows[i]["Code"].ToString();
                if (code.Length == 0) code = items.Rows[i]["CustomCode"].ToString();
                if (code.Length > 0)
                {
                    if (linkArrys.Length > 0) linkArrys += ",";
                    linkArrys += "'data," + code + "," + (items.Rows[i]["MC"].ToString().Length > 0 ? items.Rows[i]["MC"].ToString() : code) + " (" + code + ")" + "'";
                }
            }
            //eBase.WriteDiv(linkArrys);

            items = eBase.DataBase.getDataTable("SELECT ModelID,MC FROM a_eke_sysModels where ParentID='" + ModelID + "' and show=1 and delTag=0 and JoinMore=1 and Auto=1");
            foreach (DataRow dr in items.Rows)
            {
                if (linkArrys.Length > 0) linkArrys += ",";
                linkArrys += "'model," + dr["ModelID"].ToString().ToLower() + ",模块：" + dr["MC"].ToString() + "'";
            }


            if (eConfig.showHelp())
            {
                Response.Write("<h1 class=\"tips\" style=\"margin-bottom:6px;\">打印</h1>\n");
            }
            Response.Write("<script>\r\n");
            Response.Write("var ControlJson = " + ControlJson.ToJson() + ";\r\n");
            Response.Write("var linkArrys = [" + linkArrys + "];\r\n");
            Response.Write("</script>\r\n");
            Response.Write("<dl class=\"ePanel\">\n");
            Response.Write("<dt><h1 onclick=\"showPanel(this);\"><a href=\"javascript:;\" class=\"\" onfocus=\"this.blur();\"></a>默认打印</h1></dt>\n");
            Response.Write("<dd style=\"padding:8px 8px 0px 8px;\">");

            #region 列表
            Response.Write("<dl class=\"ePanel\">\n");
            Response.Write("<dt><h1 onclick=\"showPanel(this);\"><a href=\"javascript:;\" class=\"cur\" onfocus=\"this.blur();\"></a>列表</h1></dt>\n");
            Response.Write("<dd style=\"display:none;\">");
            #region 头部HTML
            Response.Write("头部HTML：<br>");
            string ListPrintHTMLStart = ModelInfo["ListPrintHTMLStart"].ToString();
            if (ListPrintHTMLStart.Length == 0 )
            {
                StringBuilder sb = new StringBuilder();
                sb.Append("<!DOCTYPE html>\n");
                sb.Append("<html>\n");
                sb.Append("<head>\n");
                sb.Append("<title>打印</title>\n");
                sb.Append("<meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\" />\n");
                sb.Append("<link href=\"../Plugins/eControls/default/style.css\" rel=\"stylesheet\" type=\"text/css\" />\n");
                sb.Append("<style type=\"text/css\" media=\"print\">@media print {.btnprint{display:none;}}</style>\n");
                sb.Append("</head>\n");
                sb.Append("<body>\n");
                ListPrintHTMLStart = sb.ToString();
            }
            Response.Write("<textarea htmltag=\"true\" id=\"ListPrintHTMLStart\" name=\"ListPrintHTMLStart\" style=\"width:95%;height:100px;\" on_Blur=\"setModel(this,'ListPrintHTMLStart');\" oldvalue=\"" + HttpUtility.HtmlEncode(ListPrintHTMLStart) + "\">" + HttpUtility.HtmlEncode(ListPrintHTMLStart) + "</textarea><br>\n");
            Response.Write("<input type=\"button\" name=\"Submit\" onclick=\"setModel(ListPrintHTMLStart,'ListPrintHTMLStart');\" value=\" 保  存 \" style=\"padding:3px 10px 3px 10px;\" /><br>\n");
            #endregion
            #region 尾部HTML
            Response.Write("尾部HTML：<br>");
            string ListPrintHTMLEnd = ModelInfo["ListPrintHTMLEnd"].ToString();
            if (ListPrintHTMLEnd.Length == 0)
            {
                ListPrintHTMLEnd = "</body>\n</html>";
            }
            Response.Write("<textarea htmltag=\"true\" id=\"ListPrintHTMLEnd\" name=\"ListPrintHTMLEnd\" style=\"width:95%;height:100px;\"  on_Blur=\"setModel(this,'ListPrintHTMLEnd');\" oldvalue=\"" + HttpUtility.HtmlEncode(ListPrintHTMLEnd) + "\">" + HttpUtility.HtmlEncode(ListPrintHTMLEnd) + "</textarea><br>\n");
            Response.Write("<input type=\"button\" name=\"Submit\" onclick=\"setModel(ListPrintHTMLEnd,'ListPrintHTMLEnd');\" value=\" 保  存 \" style=\"padding:3px 10px 3px 10px;\" /><br>\n");
            #endregion
            Response.Write("</dd>\n");
            Response.Write("</dl>\n");
            #endregion

            #region 详细
            Response.Write("<dl class=\"ePanel\">\n");
            Response.Write("<dt><h1 onclick=\"showPanel(this);\"><a href=\"javascript:;\" class=\"cur\" onfocus=\"this.blur();\"></a>详细</h1></dt>\n");
            Response.Write("<dd style=\"display:none;\">");
            #region 头部HTML
            Response.Write("头部HTML：<br>");
            string printHTMLStart = ModelInfo["printHTMLStart"].ToString();
            if (printHTMLStart.Length == 0)
            {
                StringBuilder sb = new StringBuilder();
                sb.Append("<!DOCTYPE html>\n");
                sb.Append("<html>\n");
                sb.Append("<head>\n");
                sb.Append("<title>打印</title>\n");
                sb.Append("<meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\" />\n");
                sb.Append("<link href=\"../Plugins/eControls/default/style.css\" rel=\"stylesheet\" type=\"text/css\" />\n");
                sb.Append("</head>\n");
                sb.Append("<body>\n");
                printHTMLStart = sb.ToString();
            }
            Response.Write("<textarea htmltag=\"true\" id=\"printHTMLStart\" name=\"printHTMLStart\" style=\"width:95%;height:100px;\"  on_Blur=\"setModel(this,'printHTMLStart');\" oldvalue=\"" + HttpUtility.HtmlEncode(printHTMLStart) + "\">" + HttpUtility.HtmlEncode(printHTMLStart) + "</textarea><br>\n");
            Response.Write("<input type=\"button\" name=\"Submit\" onclick=\"setModel(printHTMLStart,'printHTMLStart');\" value=\" 保  存 \" style=\"padding:3px 10px 3px 10px;\" /><br>\n");
            #endregion
            #region 循环HTML
            Response.Write("循环HTML：<a href=\"javascript:;\" onclick=\"insertData('printHTML');\" style=\"color:#0066CC;\">引用数据</a><br>");
            //Response.Write("引用数据：");
            //Response.Write("<br>");
            string printHTML = ModelInfo["PrintHTML"].ToString();
            if (printHTML.Length == 0 )
            {
                StringBuilder sb = new StringBuilder();
                sb.Append("<table class=\"eDataView\" width=\"600\" cellspacing=\"0\" cellpadding=\"0\" border=\"0\">\n");
                sb.Append("<tbody>\n");
                sb.Append("<tr>\n");
                sb.Append("<td class=\"title\" width=\"120\">标题：</td>\n");
                sb.Append("<td class=\"content\">内容</td>\n");
                sb.Append("</tr>\n");
                sb.Append("<tr>\n");
                sb.Append("<td class=\"title\">标题：</td>\n");
                sb.Append("<td class=\"content\">内容</td>\n");
                sb.Append("</tr>\n");
                sb.Append("</tbody>\n");
                sb.Append("</table>\n");


                sb.Append("<table class=\"eDataTable\" width=\"600\" cellspacing=\"0\" cellpadding=\"0\" border=\"0\">\n");
                sb.Append("<thead>\n");
                sb.Append("<tr>\n");
                sb.Append("<td width=\"80\">序号</td>\n");
                sb.Append("<td>审核流程</td>\n");
                sb.Append("</tr>\n");
                sb.Append("</thead>\n");
                sb.Append("<tbody>\n");
                sb.Append("<tr>\n");
                sb.Append("<td height=\"40\">1</td>\n");
                sb.Append("<td title=\"部门确认\">部门确认</td>\n");
                sb.Append("</tr>\n");
                sb.Append("\n");
                sb.Append("<tr class=\"alternating\" eclass=\"alternating\">\n");
                sb.Append("<td height=\"40\">2</td>\n");
                sb.Append("<td title=\"总经办确认\">总经办确认</td>\n");
                sb.Append("</tr>\n");
                sb.Append("</tbody>\n");
                sb.Append("</table>\n");
                printHTML = sb.ToString();
            }
            Response.Write("<textarea htmltag=\"true\" id=\"printHTML\" name=\"printHTML\" style=\"width:95%;height:100px;\"  on_Blur=\"setModel(this,'printHTML');\" oldvalue=\"" + HttpUtility.HtmlEncode(printHTML) + "\">" + HttpUtility.HtmlEncode(printHTML) + "</textarea><br>\n");
            Response.Write("<input type=\"button\" name=\"Submit\" onclick=\"setModel(printHTML,'printHTML');\" value=\" 保  存 \" style=\"padding:3px 10px 3px 10px;\" /><br>\n");
            #endregion
            #region 尾部HTML
            Response.Write("尾部HTML：<br>");
            string printHTMLEnd = ModelInfo["printHTMLEnd"].ToString();
            if (printHTMLEnd.Length == 0)
            {
                printHTMLEnd = "</body>\n</html>";
            }
            Response.Write("<textarea htmltag=\"true\" id=\"printHTMLEnd\" name=\"printHTMLEnd\" style=\"width:95%;height:100px;\"  on_Blur=\"setModel(this,'printHTMLEnd');\" oldvalue=\"" + HttpUtility.HtmlEncode(printHTMLEnd) + "\">" + HttpUtility.HtmlEncode(printHTMLEnd) + "</textarea><br>\n");
            Response.Write("<input type=\"button\" name=\"Submit\" onclick=\"setModel(printHTMLEnd,'printHTMLEnd');\" value=\" 保  存 \" style=\"padding:3px 10px 3px 10px;\" /><br>\n");
            #endregion
            Response.Write("</dd>\n");
            Response.Write("</dl>\n");
            #endregion
            Response.Write("</dd>\n");
            Response.Write("</dl>\n");

            Response.Write("<input type=\"button\" name=\"Submit\" onclick=\"addprint(this);\" value=\" 增加打印格式 \" style=\"padding:3px 10px 3px 10px;margin-bottom:8px;\" /><br>\n");


            #region 其他打印
            DataTable dt = eBase.DataBase.getDataTable("select * from a_eke_sysModelPrints where ModelID='" + ModelID + "' and deltag=0 order by addTime");
            //Response.Write(dt.Rows.Count.ToString());
            int idx = 1;
            foreach (DataRow dr in dt.Rows)
            {
                Response.Write("<dl class=\"ePanel\">\n");
                Response.Write("<dt><h1 onclick=\"showPanel(this);\"><a href=\"javascript:;\" class=\"cur\" onfocus=\"this.blur();\"></a>" + dr["MC"].ToString() + "</h1></dt>\n");
                Response.Write("<dd style=\"display:none;padding:8px 8px 0px 8px;\">");
                Response.Write("名称：<input type=\"text\" value=\"" + dr["MC"].ToString() + "\" oldvalue=\"" + dr["MC"].ToString() + "\" class=\"edit\" style=\"width:90px;\" onBlur=\"setPrint(this,'" + dr["ModelPrintID"].ToString() + "','mc');\" />&nbsp;&nbsp;");
                Response.Write("编码：<input type=\"text\" value=\"" + dr["name"].ToString() + "\" oldvalue=\"" + dr["name"].ToString() + "\" class=\"edit\" style=\"width:90px;\" onBlur=\"setPrint(this,'" + dr["ModelPrintID"].ToString() + "','name');\" />&nbsp;&nbsp;");

                Response.Write("<dl class=\"ePanel\" style=\"margin-top:8px;\">\n");
                Response.Write("<dt><h1 onclick=\"showPanel(this);\"><a href=\"javascript:;\" class=\"cur\" onfocus=\"this.blur();\"></a>列表</h1></dt>\n");
                Response.Write("<dd style=\"display:none;\">");
                #region 头部HTML
                Response.Write("头部HTML：<br>");
                ListPrintHTMLStart = dr["ListPrintHTMLStart"].ToString();
                if (ListPrintHTMLStart.Length == 0)
                {
                    StringBuilder sb = new StringBuilder();
                    sb.Append("<!DOCTYPE html>\n");
                    sb.Append("<html>\n");
                    sb.Append("<head>\n");
                    sb.Append("<title>打印</title>\n");
                    sb.Append("<meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\" />\n");
                    sb.Append("<link href=\"../Plugins/eControls/default/style.css\" rel=\"stylesheet\" type=\"text/css\" />\n");
                    sb.Append("<style type=\"text/css\" media=\"print\">@media print {.btnprint{display:none;}}</style>\n");
                    sb.Append("</head>\n");
                    sb.Append("<body>\n");
                    ListPrintHTMLStart = sb.ToString();
                }
                Response.Write("<textarea htmltag=\"true\" style=\"width:95%;height:100px;\" on_Blur=\"setPrint(this,'" + dr["ModelPrintID"].ToString() + "','ListPrintHTMLStart');\" oldvalue=\"" + HttpUtility.HtmlEncode(ListPrintHTMLStart) + "\">" + HttpUtility.HtmlEncode(ListPrintHTMLStart) + "</textarea><br>\n");
                Response.Write("<input type=\"button\" name=\"Submit\" onclick=\"setPrint2(this,'" + dr["ModelPrintID"].ToString() + "','ListPrintHTMLStart');\" value=\" 保  存 \" style=\"padding:3px 10px 3px 10px;\" /><br>\n");
                #endregion
                #region 尾部HTML
                Response.Write("尾部HTML：<br>");
                ListPrintHTMLEnd = dr["ListPrintHTMLEnd"].ToString();
                if (ListPrintHTMLEnd.Length == 0 )
                {
                    ListPrintHTMLEnd = "</body>\n</html>";
                }
                Response.Write("<textarea htmltag=\"true\" style=\"width:95%;height:100px;\"  on_Blur=\"setPrint(this,'" + dr["ModelPrintID"].ToString() + "','ListPrintHTMLEnd');\" oldvalue=\"" + HttpUtility.HtmlEncode(ListPrintHTMLEnd) + "\">" + HttpUtility.HtmlEncode(ListPrintHTMLEnd) + "</textarea><br>\n");
                Response.Write("<input type=\"button\" name=\"Submit\" onclick=\"setPrint2(this,'" + dr["ModelPrintID"].ToString() + "','ListPrintHTMLEnd');\" value=\" 保  存 \" style=\"padding:3px 10px 3px 10px;\" /><br>\n");
                #endregion
                Response.Write("</dd>\n");
                Response.Write("</dl>\n");


                Response.Write("<dl class=\"ePanel\">\n");
                Response.Write("<dt><h1 onclick=\"showPanel(this);\"><a href=\"javascript:;\" class=\"cur\" onfocus=\"this.blur();\"></a>详细</h1></dt>\n");
                Response.Write("<dd style=\"display:none;\">");
                #region 头部HTML
                Response.Write("头部HTML：<br>");
                printHTMLStart = dr["printHTMLStart"].ToString();
                if (printHTMLStart.Length == 0 )
                {
                    StringBuilder sb = new StringBuilder();
                    sb.Append("<!DOCTYPE html>\n");
                    sb.Append("<html>\n");
                    sb.Append("<head>\n");
                    sb.Append("<title>打印</title>\n");
                    sb.Append("<meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\" />\n");
                    sb.Append("<link href=\"../Plugins/eControls/default/style.css\" rel=\"stylesheet\" type=\"text/css\" />\n");
                    sb.Append("</head>\n");
                    sb.Append("<body>\n");
                    printHTMLStart = sb.ToString();
                }
                Response.Write("<textarea htmltag=\"true\" style=\"width:95%;height:100px;\"  on_Blur=\"setPrint(this,'" + dr["ModelPrintID"].ToString() + "','printHTMLStart');\" oldvalue=\"" + HttpUtility.HtmlEncode(printHTMLStart) + "\">" + HttpUtility.HtmlEncode(printHTMLStart) + "</textarea><br>\n");
                Response.Write("<input type=\"button\" name=\"Submit\" onclick=\"setPrint2(this,'" + dr["ModelPrintID"].ToString() + "','printHTMLStart');\" value=\" 保  存 \" style=\"padding:3px 10px 3px 10px;\" /><br>\n");
                #endregion
                #region 循环HTML
                Response.Write("循环HTML：<a href=\"javascript:;\" onclick=\"insertData('printHTML" + idx.ToString() + "');\" style=\"color:#0066CC;\">引用数据</a><br>");
                printHTML = dr["PrintHTML"].ToString();
                if (printHTML.Length == 0)
                {
                    StringBuilder sb = new StringBuilder();
                    sb.Append("<table class=\"eDataView\" width=\"600\" cellspacing=\"0\" cellpadding=\"0\" border=\"0\">\n");
                    sb.Append("<tbody>\n");
                    sb.Append("<tr>\n");
                    sb.Append("<td class=\"title\" width=\"120\">标题：</td>\n");
                    sb.Append("<td class=\"content\">内容</td>\n");
                    sb.Append("</tr>\n");
                    sb.Append("<tr>\n");
                    sb.Append("<td class=\"title\">标题：</td>\n");
                    sb.Append("<td class=\"content\">内容</td>\n");
                    sb.Append("</tr>\n");
                    sb.Append("</tbody>\n");
                    sb.Append("</table>\n");


                    sb.Append("<table class=\"eDataTable\" width=\"600\" cellspacing=\"0\" cellpadding=\"0\" border=\"0\">\n");
                    sb.Append("<thead>\n");
                    sb.Append("<tr>\n");
                    sb.Append("<td width=\"80\">序号</td>\n");
                    sb.Append("<td>审核流程</td>\n");
                    sb.Append("</tr>\n");
                    sb.Append("</thead>\n");
                    sb.Append("<tbody>\n");
                    sb.Append("<tr>\n");
                    sb.Append("<td height=\"40\">1</td>\n");
                    sb.Append("<td title=\"部门确认\">部门确认</td>\n");
                    sb.Append("</tr>\n");
                    sb.Append("\n");
                    sb.Append("<tr class=\"alternating\" eclass=\"alternating\">\n");
                    sb.Append("<td height=\"40\">2</td>\n");
                    sb.Append("<td title=\"总经办确认\">总经办确认</td>\n");
                    sb.Append("</tr>\n");
                    sb.Append("</tbody>\n");
                    sb.Append("</table>\n");
                    printHTML = sb.ToString();
                }
                Response.Write("<textarea id=\"printHTML" + idx.ToString() + "\" htmltag=\"true\" style=\"width:95%;height:100px;\"  on_Blur=\"setPrint(this,'" + dr["ModelPrintID"].ToString() + "','printHTML');\" oldvalue=\"" + HttpUtility.HtmlEncode(printHTML) + "\">" + HttpUtility.HtmlEncode(printHTML) + "</textarea><br>\n");
                Response.Write("<input type=\"button\" name=\"Submit\" onclick=\"setPrint2(this,'" + dr["ModelPrintID"].ToString() + "','printHTML');\" value=\" 保  存 \" style=\"padding:3px 10px 3px 10px;\" /><br>\n");
                #endregion
                #region 尾部HTML
                Response.Write("尾部HTML：<br>");
                printHTMLEnd = dr["printHTMLEnd"].ToString();
                if (printHTMLEnd.Length == 0)
                {
                    printHTMLEnd = "</body>\n</html>";
                }
                Response.Write("<textarea htmltag=\"true\"  style=\"width:95%;height:100px;\"  on_Blur=\"setPrint(this,'" + dr["ModelPrintID"].ToString() + "','printHTMLEnd');\" oldvalue=\"" + HttpUtility.HtmlEncode(printHTMLEnd) + "\">" + HttpUtility.HtmlEncode(printHTMLEnd) + "</textarea><br>\n");
                Response.Write("<input type=\"button\" name=\"Submit\" onclick=\"setPrint2(this,'" + dr["ModelPrintID"].ToString() + "','printHTMLEnd');\" value=\" 保  存 \" style=\"padding:3px 10px 3px 10px;\" /><br>\n");
                #endregion
                Response.Write("</dd>\n");
                Response.Write("</dl>\n");



                Response.Write("</dd>\n");
                Response.Write("</dl>\n");
                idx++;
            }
            #endregion


            /*
            eList elist = new eList("a_eke_sysActions");
            elist.Where.Add("ModelID='" + modelid + "' ");
            elist.OrderBy.Add("addTime");
            elist.Bind(Rep);

            System.IO.StringWriter sw = new System.IO.StringWriter();
            HtmlTextWriter htw = new HtmlTextWriter(sw);
            Rep.RenderControl(htw);
            Rep.Visible = false;//不输出，要在获取后设，不然取不到内容。
            Response.Write(sw.ToString());
            */
            Response.End();
        }
    }
}