﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using EKETEAM.FrameWork;


public partial class Plugins_barCode : System.Web.UI.Page
{
    protected void Page_Load(object sender, EventArgs e)
    {
        string type = Request["type"] == null ? "code128" : Request["type"].ToString();
        string num = Request["num"] == null ? "290324498102" : Request["num"].ToString();
        int BarWeight = Request["BarWeight"] == null ? 2 : Convert.ToInt32(Request["BarWeight"]);

        int Height = 0;

        System.IO.MemoryStream ms = new System.IO.MemoryStream();
        System.Drawing.Image image;
        switch (type)
        {
            case "code39":
                Height = Request["Height"] == null ? 120 : Convert.ToInt32(Request["Height"]);
                image = BarCodeHelper.get39Image(num, BarWeight, Height);
                image.Save(ms, System.Drawing.Imaging.ImageFormat.Jpeg);
                break;
            case "code128":
                Height = Request["Height"] == null ? 120 : Convert.ToInt32(Request["Height"]);
                image = BarCodeHelper.MakeBarcodeImage(num, BarWeight, true);
                image.Save(ms, System.Drawing.Imaging.ImageFormat.Jpeg);
                break;
            case "ean13":
                Height = Request["Height"] == null ? 90 : Convert.ToInt32(Request["Height"]);
                image = BarCodeHelper.getEAN13Image(num, BarWeight, Height);
                image.Save(ms, System.Drawing.Imaging.ImageFormat.Jpeg);
                break;
        }
        Response.ClearContent();
        Response.ContentType = "image/jpeg";
        Response.BinaryWrite(ms.ToArray());
        Response.End();
    }
}