<?php


namespace Module\Vendor\Provider\Captcha;

use Illuminate\Support\Facades\View;
use ModStart\Core\Input\InputPackage;
use ModStart\Core\Input\Response;
use ModStart\Misc\Captcha\CaptchaFacade;

class DefaultCaptchaProvider extends AbstractCaptchaProvider
{
    public function name()
    {
        return 'default';
    }

    public function title()
    {
        return '图片验证码';
    }


    public function render()
    {
        return View::make('module::Vendor.View.widget.captcha.default')->render();
    }

    public function validate()
    {
        $input = InputPackage::buildFromInput();
        $captcha = $input->getTrimString('captcha');
        if (!CaptchaFacade::check($captcha)) {
            return Response::generate(-1, '图片验证码错误', null, '[js]$(\'[data-captcha]\').click();');
        }
        return Response::generateSuccess();
    }
}
