# 缓存

缓存在各个领域用得非常广泛，例如 CPU 的三级缓存，可加速从主内存中获取数据到处理器。Halo 的主要应用以博客为主，页面更新不会特别频繁，大多数情况下，实时渲染的结果都是没有变化的。如果能够缓存这些不经常变更的页面，可减少数据库访问，加快访问速度。

Halo 采用由 Spring 框架提供的 Caching 作为缓存框架。该缓存框架面对各种缓存实现，提供了统一的访问入口，后续更换缓存仅需修改少量代码和配置。

Halo 默认提供了 CacheProperties 用于启用/禁用缓存，示例如下：

```yaml
halo:
  caches:
    page:
      disabled: true
    others:
      disabled: false
```

# 页面缓存

页面缓存包括缓存响应体、响应头和响应状态。页面缓存规则如下：

1. 仅缓存模板引擎所渲染的页面。
2. 仅缓存 `Content-Type` 为 `text/html` 的页面。
3. 仅缓存响应状态为 `HTTP 200（OK）`。
4. 请求访问为 `GET`。

缓存详情见下表：

| 术语   | 值              |
|------|----------------|
| 名称   | `page`         |
| 失效时间 | 距最近一次访问 `1` 小时 |
| 缓存数量 | `10,000` 个     |
