/* tslint:disable */
/* eslint-disable */
/**
 * Halo
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: 2.20.10-SNAPSHOT
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


import type { Configuration } from '../configuration';
import type { AxiosPromise, AxiosInstance, RawAxiosRequestConfig } from 'axios';
import globalAxios from 'axios';
// Some imports not used depending on template conditions
// @ts-ignore
import { DUMMY_BASE_URL, assertParamExists, setApiKeyToObject, setBasicAuthToObject, setBearerAuthToObject, setOAuthToObject, setSearchParams, serializeDataIfNeeded, toPathString, createRequestFunction } from '../common';
// @ts-ignore
import { BASE_PATH, COLLECTION_FORMATS, RequestArgs, BaseAPI, RequiredError, operationServerMap } from '../base';
// @ts-ignore
import { Comment } from '../models';
// @ts-ignore
import { CommentList } from '../models';
// @ts-ignore
import { JsonPatchInner } from '../models';
/**
 * CommentV1alpha1Api - axios parameter creator
 * @export
 */
export const CommentV1alpha1ApiAxiosParamCreator = function (configuration?: Configuration) {
    return {
        /**
         * Create Comment
         * @param {Comment} [comment] Fresh comment
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        createComment: async (comment?: Comment, options: RawAxiosRequestConfig = {}): Promise<RequestArgs> => {
            const localVarPath = `/apis/content.halo.run/v1alpha1/comments`;
            // use dummy base URL string because the URL constructor only accepts absolute URLs.
            const localVarUrlObj = new URL(localVarPath, DUMMY_BASE_URL);
            let baseOptions;
            if (configuration) {
                baseOptions = configuration.baseOptions;
            }

            const localVarRequestOptions = { method: 'POST', ...baseOptions, ...options};
            const localVarHeaderParameter = {} as any;
            const localVarQueryParameter = {} as any;

            // authentication basicAuth required
            // http basic authentication required
            setBasicAuthToObject(localVarRequestOptions, configuration)

            // authentication bearerAuth required
            // http bearer authentication required
            await setBearerAuthToObject(localVarHeaderParameter, configuration)


    
            localVarHeaderParameter['Content-Type'] = 'application/json';

            setSearchParams(localVarUrlObj, localVarQueryParameter);
            let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
            localVarRequestOptions.headers = {...localVarHeaderParameter, ...headersFromBaseOptions, ...options.headers};
            localVarRequestOptions.data = serializeDataIfNeeded(comment, localVarRequestOptions, configuration)

            return {
                url: toPathString(localVarUrlObj),
                options: localVarRequestOptions,
            };
        },
        /**
         * Delete Comment
         * @param {string} name Name of comment
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        deleteComment: async (name: string, options: RawAxiosRequestConfig = {}): Promise<RequestArgs> => {
            // verify required parameter 'name' is not null or undefined
            assertParamExists('deleteComment', 'name', name)
            const localVarPath = `/apis/content.halo.run/v1alpha1/comments/{name}`
                .replace(`{${"name"}}`, encodeURIComponent(String(name)));
            // use dummy base URL string because the URL constructor only accepts absolute URLs.
            const localVarUrlObj = new URL(localVarPath, DUMMY_BASE_URL);
            let baseOptions;
            if (configuration) {
                baseOptions = configuration.baseOptions;
            }

            const localVarRequestOptions = { method: 'DELETE', ...baseOptions, ...options};
            const localVarHeaderParameter = {} as any;
            const localVarQueryParameter = {} as any;

            // authentication basicAuth required
            // http basic authentication required
            setBasicAuthToObject(localVarRequestOptions, configuration)

            // authentication bearerAuth required
            // http bearer authentication required
            await setBearerAuthToObject(localVarHeaderParameter, configuration)


    
            setSearchParams(localVarUrlObj, localVarQueryParameter);
            let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
            localVarRequestOptions.headers = {...localVarHeaderParameter, ...headersFromBaseOptions, ...options.headers};

            return {
                url: toPathString(localVarUrlObj),
                options: localVarRequestOptions,
            };
        },
        /**
         * Get Comment
         * @param {string} name Name of comment
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        getComment: async (name: string, options: RawAxiosRequestConfig = {}): Promise<RequestArgs> => {
            // verify required parameter 'name' is not null or undefined
            assertParamExists('getComment', 'name', name)
            const localVarPath = `/apis/content.halo.run/v1alpha1/comments/{name}`
                .replace(`{${"name"}}`, encodeURIComponent(String(name)));
            // use dummy base URL string because the URL constructor only accepts absolute URLs.
            const localVarUrlObj = new URL(localVarPath, DUMMY_BASE_URL);
            let baseOptions;
            if (configuration) {
                baseOptions = configuration.baseOptions;
            }

            const localVarRequestOptions = { method: 'GET', ...baseOptions, ...options};
            const localVarHeaderParameter = {} as any;
            const localVarQueryParameter = {} as any;

            // authentication basicAuth required
            // http basic authentication required
            setBasicAuthToObject(localVarRequestOptions, configuration)

            // authentication bearerAuth required
            // http bearer authentication required
            await setBearerAuthToObject(localVarHeaderParameter, configuration)


    
            setSearchParams(localVarUrlObj, localVarQueryParameter);
            let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
            localVarRequestOptions.headers = {...localVarHeaderParameter, ...headersFromBaseOptions, ...options.headers};

            return {
                url: toPathString(localVarUrlObj),
                options: localVarRequestOptions,
            };
        },
        /**
         * List Comment
         * @param {number} [page] Page number. Default is 0.
         * @param {number} [size] Size number. Default is 0.
         * @param {Array<string>} [labelSelector] Label selector. e.g.: hidden!&#x3D;true
         * @param {Array<string>} [fieldSelector] Field selector. e.g.: metadata.name&#x3D;&#x3D;halo
         * @param {Array<string>} [sort] Sorting criteria in the format: property,(asc|desc). Default sort order is ascending. Multiple sort criteria are supported.
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        listComment: async (page?: number, size?: number, labelSelector?: Array<string>, fieldSelector?: Array<string>, sort?: Array<string>, options: RawAxiosRequestConfig = {}): Promise<RequestArgs> => {
            const localVarPath = `/apis/content.halo.run/v1alpha1/comments`;
            // use dummy base URL string because the URL constructor only accepts absolute URLs.
            const localVarUrlObj = new URL(localVarPath, DUMMY_BASE_URL);
            let baseOptions;
            if (configuration) {
                baseOptions = configuration.baseOptions;
            }

            const localVarRequestOptions = { method: 'GET', ...baseOptions, ...options};
            const localVarHeaderParameter = {} as any;
            const localVarQueryParameter = {} as any;

            // authentication basicAuth required
            // http basic authentication required
            setBasicAuthToObject(localVarRequestOptions, configuration)

            // authentication bearerAuth required
            // http bearer authentication required
            await setBearerAuthToObject(localVarHeaderParameter, configuration)

            if (page !== undefined) {
                localVarQueryParameter['page'] = page;
            }

            if (size !== undefined) {
                localVarQueryParameter['size'] = size;
            }

            if (labelSelector) {
                localVarQueryParameter['labelSelector'] = labelSelector;
            }

            if (fieldSelector) {
                localVarQueryParameter['fieldSelector'] = fieldSelector;
            }

            if (sort) {
                localVarQueryParameter['sort'] = sort;
            }


    
            setSearchParams(localVarUrlObj, localVarQueryParameter);
            let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
            localVarRequestOptions.headers = {...localVarHeaderParameter, ...headersFromBaseOptions, ...options.headers};

            return {
                url: toPathString(localVarUrlObj),
                options: localVarRequestOptions,
            };
        },
        /**
         * Patch Comment
         * @param {string} name Name of comment
         * @param {Array<JsonPatchInner>} [jsonPatchInner] 
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        patchComment: async (name: string, jsonPatchInner?: Array<JsonPatchInner>, options: RawAxiosRequestConfig = {}): Promise<RequestArgs> => {
            // verify required parameter 'name' is not null or undefined
            assertParamExists('patchComment', 'name', name)
            const localVarPath = `/apis/content.halo.run/v1alpha1/comments/{name}`
                .replace(`{${"name"}}`, encodeURIComponent(String(name)));
            // use dummy base URL string because the URL constructor only accepts absolute URLs.
            const localVarUrlObj = new URL(localVarPath, DUMMY_BASE_URL);
            let baseOptions;
            if (configuration) {
                baseOptions = configuration.baseOptions;
            }

            const localVarRequestOptions = { method: 'PATCH', ...baseOptions, ...options};
            const localVarHeaderParameter = {} as any;
            const localVarQueryParameter = {} as any;

            // authentication basicAuth required
            // http basic authentication required
            setBasicAuthToObject(localVarRequestOptions, configuration)

            // authentication bearerAuth required
            // http bearer authentication required
            await setBearerAuthToObject(localVarHeaderParameter, configuration)


    
            localVarHeaderParameter['Content-Type'] = 'application/json-patch+json';

            setSearchParams(localVarUrlObj, localVarQueryParameter);
            let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
            localVarRequestOptions.headers = {...localVarHeaderParameter, ...headersFromBaseOptions, ...options.headers};
            localVarRequestOptions.data = serializeDataIfNeeded(jsonPatchInner, localVarRequestOptions, configuration)

            return {
                url: toPathString(localVarUrlObj),
                options: localVarRequestOptions,
            };
        },
        /**
         * Update Comment
         * @param {string} name Name of comment
         * @param {Comment} [comment] Updated comment
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        updateComment: async (name: string, comment?: Comment, options: RawAxiosRequestConfig = {}): Promise<RequestArgs> => {
            // verify required parameter 'name' is not null or undefined
            assertParamExists('updateComment', 'name', name)
            const localVarPath = `/apis/content.halo.run/v1alpha1/comments/{name}`
                .replace(`{${"name"}}`, encodeURIComponent(String(name)));
            // use dummy base URL string because the URL constructor only accepts absolute URLs.
            const localVarUrlObj = new URL(localVarPath, DUMMY_BASE_URL);
            let baseOptions;
            if (configuration) {
                baseOptions = configuration.baseOptions;
            }

            const localVarRequestOptions = { method: 'PUT', ...baseOptions, ...options};
            const localVarHeaderParameter = {} as any;
            const localVarQueryParameter = {} as any;

            // authentication basicAuth required
            // http basic authentication required
            setBasicAuthToObject(localVarRequestOptions, configuration)

            // authentication bearerAuth required
            // http bearer authentication required
            await setBearerAuthToObject(localVarHeaderParameter, configuration)


    
            localVarHeaderParameter['Content-Type'] = 'application/json';

            setSearchParams(localVarUrlObj, localVarQueryParameter);
            let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
            localVarRequestOptions.headers = {...localVarHeaderParameter, ...headersFromBaseOptions, ...options.headers};
            localVarRequestOptions.data = serializeDataIfNeeded(comment, localVarRequestOptions, configuration)

            return {
                url: toPathString(localVarUrlObj),
                options: localVarRequestOptions,
            };
        },
    }
};

/**
 * CommentV1alpha1Api - functional programming interface
 * @export
 */
export const CommentV1alpha1ApiFp = function(configuration?: Configuration) {
    const localVarAxiosParamCreator = CommentV1alpha1ApiAxiosParamCreator(configuration)
    return {
        /**
         * Create Comment
         * @param {Comment} [comment] Fresh comment
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        async createComment(comment?: Comment, options?: RawAxiosRequestConfig): Promise<(axios?: AxiosInstance, basePath?: string) => AxiosPromise<Comment>> {
            const localVarAxiosArgs = await localVarAxiosParamCreator.createComment(comment, options);
            const localVarOperationServerIndex = configuration?.serverIndex ?? 0;
            const localVarOperationServerBasePath = operationServerMap['CommentV1alpha1Api.createComment']?.[localVarOperationServerIndex]?.url;
            return (axios, basePath) => createRequestFunction(localVarAxiosArgs, globalAxios, BASE_PATH, configuration)(axios, localVarOperationServerBasePath || basePath);
        },
        /**
         * Delete Comment
         * @param {string} name Name of comment
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        async deleteComment(name: string, options?: RawAxiosRequestConfig): Promise<(axios?: AxiosInstance, basePath?: string) => AxiosPromise<void>> {
            const localVarAxiosArgs = await localVarAxiosParamCreator.deleteComment(name, options);
            const localVarOperationServerIndex = configuration?.serverIndex ?? 0;
            const localVarOperationServerBasePath = operationServerMap['CommentV1alpha1Api.deleteComment']?.[localVarOperationServerIndex]?.url;
            return (axios, basePath) => createRequestFunction(localVarAxiosArgs, globalAxios, BASE_PATH, configuration)(axios, localVarOperationServerBasePath || basePath);
        },
        /**
         * Get Comment
         * @param {string} name Name of comment
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        async getComment(name: string, options?: RawAxiosRequestConfig): Promise<(axios?: AxiosInstance, basePath?: string) => AxiosPromise<Comment>> {
            const localVarAxiosArgs = await localVarAxiosParamCreator.getComment(name, options);
            const localVarOperationServerIndex = configuration?.serverIndex ?? 0;
            const localVarOperationServerBasePath = operationServerMap['CommentV1alpha1Api.getComment']?.[localVarOperationServerIndex]?.url;
            return (axios, basePath) => createRequestFunction(localVarAxiosArgs, globalAxios, BASE_PATH, configuration)(axios, localVarOperationServerBasePath || basePath);
        },
        /**
         * List Comment
         * @param {number} [page] Page number. Default is 0.
         * @param {number} [size] Size number. Default is 0.
         * @param {Array<string>} [labelSelector] Label selector. e.g.: hidden!&#x3D;true
         * @param {Array<string>} [fieldSelector] Field selector. e.g.: metadata.name&#x3D;&#x3D;halo
         * @param {Array<string>} [sort] Sorting criteria in the format: property,(asc|desc). Default sort order is ascending. Multiple sort criteria are supported.
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        async listComment(page?: number, size?: number, labelSelector?: Array<string>, fieldSelector?: Array<string>, sort?: Array<string>, options?: RawAxiosRequestConfig): Promise<(axios?: AxiosInstance, basePath?: string) => AxiosPromise<CommentList>> {
            const localVarAxiosArgs = await localVarAxiosParamCreator.listComment(page, size, labelSelector, fieldSelector, sort, options);
            const localVarOperationServerIndex = configuration?.serverIndex ?? 0;
            const localVarOperationServerBasePath = operationServerMap['CommentV1alpha1Api.listComment']?.[localVarOperationServerIndex]?.url;
            return (axios, basePath) => createRequestFunction(localVarAxiosArgs, globalAxios, BASE_PATH, configuration)(axios, localVarOperationServerBasePath || basePath);
        },
        /**
         * Patch Comment
         * @param {string} name Name of comment
         * @param {Array<JsonPatchInner>} [jsonPatchInner] 
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        async patchComment(name: string, jsonPatchInner?: Array<JsonPatchInner>, options?: RawAxiosRequestConfig): Promise<(axios?: AxiosInstance, basePath?: string) => AxiosPromise<Comment>> {
            const localVarAxiosArgs = await localVarAxiosParamCreator.patchComment(name, jsonPatchInner, options);
            const localVarOperationServerIndex = configuration?.serverIndex ?? 0;
            const localVarOperationServerBasePath = operationServerMap['CommentV1alpha1Api.patchComment']?.[localVarOperationServerIndex]?.url;
            return (axios, basePath) => createRequestFunction(localVarAxiosArgs, globalAxios, BASE_PATH, configuration)(axios, localVarOperationServerBasePath || basePath);
        },
        /**
         * Update Comment
         * @param {string} name Name of comment
         * @param {Comment} [comment] Updated comment
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        async updateComment(name: string, comment?: Comment, options?: RawAxiosRequestConfig): Promise<(axios?: AxiosInstance, basePath?: string) => AxiosPromise<Comment>> {
            const localVarAxiosArgs = await localVarAxiosParamCreator.updateComment(name, comment, options);
            const localVarOperationServerIndex = configuration?.serverIndex ?? 0;
            const localVarOperationServerBasePath = operationServerMap['CommentV1alpha1Api.updateComment']?.[localVarOperationServerIndex]?.url;
            return (axios, basePath) => createRequestFunction(localVarAxiosArgs, globalAxios, BASE_PATH, configuration)(axios, localVarOperationServerBasePath || basePath);
        },
    }
};

/**
 * CommentV1alpha1Api - factory interface
 * @export
 */
export const CommentV1alpha1ApiFactory = function (configuration?: Configuration, basePath?: string, axios?: AxiosInstance) {
    const localVarFp = CommentV1alpha1ApiFp(configuration)
    return {
        /**
         * Create Comment
         * @param {CommentV1alpha1ApiCreateCommentRequest} requestParameters Request parameters.
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        createComment(requestParameters: CommentV1alpha1ApiCreateCommentRequest = {}, options?: RawAxiosRequestConfig): AxiosPromise<Comment> {
            return localVarFp.createComment(requestParameters.comment, options).then((request) => request(axios, basePath));
        },
        /**
         * Delete Comment
         * @param {CommentV1alpha1ApiDeleteCommentRequest} requestParameters Request parameters.
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        deleteComment(requestParameters: CommentV1alpha1ApiDeleteCommentRequest, options?: RawAxiosRequestConfig): AxiosPromise<void> {
            return localVarFp.deleteComment(requestParameters.name, options).then((request) => request(axios, basePath));
        },
        /**
         * Get Comment
         * @param {CommentV1alpha1ApiGetCommentRequest} requestParameters Request parameters.
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        getComment(requestParameters: CommentV1alpha1ApiGetCommentRequest, options?: RawAxiosRequestConfig): AxiosPromise<Comment> {
            return localVarFp.getComment(requestParameters.name, options).then((request) => request(axios, basePath));
        },
        /**
         * List Comment
         * @param {CommentV1alpha1ApiListCommentRequest} requestParameters Request parameters.
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        listComment(requestParameters: CommentV1alpha1ApiListCommentRequest = {}, options?: RawAxiosRequestConfig): AxiosPromise<CommentList> {
            return localVarFp.listComment(requestParameters.page, requestParameters.size, requestParameters.labelSelector, requestParameters.fieldSelector, requestParameters.sort, options).then((request) => request(axios, basePath));
        },
        /**
         * Patch Comment
         * @param {CommentV1alpha1ApiPatchCommentRequest} requestParameters Request parameters.
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        patchComment(requestParameters: CommentV1alpha1ApiPatchCommentRequest, options?: RawAxiosRequestConfig): AxiosPromise<Comment> {
            return localVarFp.patchComment(requestParameters.name, requestParameters.jsonPatchInner, options).then((request) => request(axios, basePath));
        },
        /**
         * Update Comment
         * @param {CommentV1alpha1ApiUpdateCommentRequest} requestParameters Request parameters.
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        updateComment(requestParameters: CommentV1alpha1ApiUpdateCommentRequest, options?: RawAxiosRequestConfig): AxiosPromise<Comment> {
            return localVarFp.updateComment(requestParameters.name, requestParameters.comment, options).then((request) => request(axios, basePath));
        },
    };
};

/**
 * Request parameters for createComment operation in CommentV1alpha1Api.
 * @export
 * @interface CommentV1alpha1ApiCreateCommentRequest
 */
export interface CommentV1alpha1ApiCreateCommentRequest {
    /**
     * Fresh comment
     * @type {Comment}
     * @memberof CommentV1alpha1ApiCreateComment
     */
    readonly comment?: Comment
}

/**
 * Request parameters for deleteComment operation in CommentV1alpha1Api.
 * @export
 * @interface CommentV1alpha1ApiDeleteCommentRequest
 */
export interface CommentV1alpha1ApiDeleteCommentRequest {
    /**
     * Name of comment
     * @type {string}
     * @memberof CommentV1alpha1ApiDeleteComment
     */
    readonly name: string
}

/**
 * Request parameters for getComment operation in CommentV1alpha1Api.
 * @export
 * @interface CommentV1alpha1ApiGetCommentRequest
 */
export interface CommentV1alpha1ApiGetCommentRequest {
    /**
     * Name of comment
     * @type {string}
     * @memberof CommentV1alpha1ApiGetComment
     */
    readonly name: string
}

/**
 * Request parameters for listComment operation in CommentV1alpha1Api.
 * @export
 * @interface CommentV1alpha1ApiListCommentRequest
 */
export interface CommentV1alpha1ApiListCommentRequest {
    /**
     * Page number. Default is 0.
     * @type {number}
     * @memberof CommentV1alpha1ApiListComment
     */
    readonly page?: number

    /**
     * Size number. Default is 0.
     * @type {number}
     * @memberof CommentV1alpha1ApiListComment
     */
    readonly size?: number

    /**
     * Label selector. e.g.: hidden!&#x3D;true
     * @type {Array<string>}
     * @memberof CommentV1alpha1ApiListComment
     */
    readonly labelSelector?: Array<string>

    /**
     * Field selector. e.g.: metadata.name&#x3D;&#x3D;halo
     * @type {Array<string>}
     * @memberof CommentV1alpha1ApiListComment
     */
    readonly fieldSelector?: Array<string>

    /**
     * Sorting criteria in the format: property,(asc|desc). Default sort order is ascending. Multiple sort criteria are supported.
     * @type {Array<string>}
     * @memberof CommentV1alpha1ApiListComment
     */
    readonly sort?: Array<string>
}

/**
 * Request parameters for patchComment operation in CommentV1alpha1Api.
 * @export
 * @interface CommentV1alpha1ApiPatchCommentRequest
 */
export interface CommentV1alpha1ApiPatchCommentRequest {
    /**
     * Name of comment
     * @type {string}
     * @memberof CommentV1alpha1ApiPatchComment
     */
    readonly name: string

    /**
     * 
     * @type {Array<JsonPatchInner>}
     * @memberof CommentV1alpha1ApiPatchComment
     */
    readonly jsonPatchInner?: Array<JsonPatchInner>
}

/**
 * Request parameters for updateComment operation in CommentV1alpha1Api.
 * @export
 * @interface CommentV1alpha1ApiUpdateCommentRequest
 */
export interface CommentV1alpha1ApiUpdateCommentRequest {
    /**
     * Name of comment
     * @type {string}
     * @memberof CommentV1alpha1ApiUpdateComment
     */
    readonly name: string

    /**
     * Updated comment
     * @type {Comment}
     * @memberof CommentV1alpha1ApiUpdateComment
     */
    readonly comment?: Comment
}

/**
 * CommentV1alpha1Api - object-oriented interface
 * @export
 * @class CommentV1alpha1Api
 * @extends {BaseAPI}
 */
export class CommentV1alpha1Api extends BaseAPI {
    /**
     * Create Comment
     * @param {CommentV1alpha1ApiCreateCommentRequest} requestParameters Request parameters.
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof CommentV1alpha1Api
     */
    public createComment(requestParameters: CommentV1alpha1ApiCreateCommentRequest = {}, options?: RawAxiosRequestConfig) {
        return CommentV1alpha1ApiFp(this.configuration).createComment(requestParameters.comment, options).then((request) => request(this.axios, this.basePath));
    }

    /**
     * Delete Comment
     * @param {CommentV1alpha1ApiDeleteCommentRequest} requestParameters Request parameters.
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof CommentV1alpha1Api
     */
    public deleteComment(requestParameters: CommentV1alpha1ApiDeleteCommentRequest, options?: RawAxiosRequestConfig) {
        return CommentV1alpha1ApiFp(this.configuration).deleteComment(requestParameters.name, options).then((request) => request(this.axios, this.basePath));
    }

    /**
     * Get Comment
     * @param {CommentV1alpha1ApiGetCommentRequest} requestParameters Request parameters.
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof CommentV1alpha1Api
     */
    public getComment(requestParameters: CommentV1alpha1ApiGetCommentRequest, options?: RawAxiosRequestConfig) {
        return CommentV1alpha1ApiFp(this.configuration).getComment(requestParameters.name, options).then((request) => request(this.axios, this.basePath));
    }

    /**
     * List Comment
     * @param {CommentV1alpha1ApiListCommentRequest} requestParameters Request parameters.
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof CommentV1alpha1Api
     */
    public listComment(requestParameters: CommentV1alpha1ApiListCommentRequest = {}, options?: RawAxiosRequestConfig) {
        return CommentV1alpha1ApiFp(this.configuration).listComment(requestParameters.page, requestParameters.size, requestParameters.labelSelector, requestParameters.fieldSelector, requestParameters.sort, options).then((request) => request(this.axios, this.basePath));
    }

    /**
     * Patch Comment
     * @param {CommentV1alpha1ApiPatchCommentRequest} requestParameters Request parameters.
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof CommentV1alpha1Api
     */
    public patchComment(requestParameters: CommentV1alpha1ApiPatchCommentRequest, options?: RawAxiosRequestConfig) {
        return CommentV1alpha1ApiFp(this.configuration).patchComment(requestParameters.name, requestParameters.jsonPatchInner, options).then((request) => request(this.axios, this.basePath));
    }

    /**
     * Update Comment
     * @param {CommentV1alpha1ApiUpdateCommentRequest} requestParameters Request parameters.
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof CommentV1alpha1Api
     */
    public updateComment(requestParameters: CommentV1alpha1ApiUpdateCommentRequest, options?: RawAxiosRequestConfig) {
        return CommentV1alpha1ApiFp(this.configuration).updateComment(requestParameters.name, requestParameters.comment, options).then((request) => request(this.axios, this.basePath));
    }
}

