/* tslint:disable */
/* eslint-disable */
/**
 * Halo
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: 2.20.10-SNAPSHOT
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


import type { Configuration } from '../configuration';
import type { AxiosPromise, AxiosInstance, RawAxiosRequestConfig } from 'axios';
import globalAxios from 'axios';
// Some imports not used depending on template conditions
// @ts-ignore
import { DUMMY_BASE_URL, assertParamExists, setApiKeyToObject, setBasicAuthToObject, setBearerAuthToObject, setOAuthToObject, setSearchParams, serializeDataIfNeeded, toPathString, createRequestFunction } from '../common';
// @ts-ignore
import { BASE_PATH, COLLECTION_FORMATS, RequestArgs, BaseAPI, RequiredError, operationServerMap } from '../base';
// @ts-ignore
import { Comment } from '../models';
// @ts-ignore
import { CommentRequest } from '../models';
// @ts-ignore
import { ListedCommentList } from '../models';
// @ts-ignore
import { Reply } from '../models';
// @ts-ignore
import { ReplyRequest } from '../models';
/**
 * CommentV1alpha1ConsoleApi - axios parameter creator
 * @export
 */
export const CommentV1alpha1ConsoleApiAxiosParamCreator = function (configuration?: Configuration) {
    return {
        /**
         * Create a comment.
         * @param {CommentRequest} commentRequest 
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        createComment: async (commentRequest: CommentRequest, options: RawAxiosRequestConfig = {}): Promise<RequestArgs> => {
            // verify required parameter 'commentRequest' is not null or undefined
            assertParamExists('createComment', 'commentRequest', commentRequest)
            const localVarPath = `/apis/api.console.halo.run/v1alpha1/comments`;
            // use dummy base URL string because the URL constructor only accepts absolute URLs.
            const localVarUrlObj = new URL(localVarPath, DUMMY_BASE_URL);
            let baseOptions;
            if (configuration) {
                baseOptions = configuration.baseOptions;
            }

            const localVarRequestOptions = { method: 'POST', ...baseOptions, ...options};
            const localVarHeaderParameter = {} as any;
            const localVarQueryParameter = {} as any;

            // authentication basicAuth required
            // http basic authentication required
            setBasicAuthToObject(localVarRequestOptions, configuration)

            // authentication bearerAuth required
            // http bearer authentication required
            await setBearerAuthToObject(localVarHeaderParameter, configuration)


    
            localVarHeaderParameter['Content-Type'] = 'application/json';

            setSearchParams(localVarUrlObj, localVarQueryParameter);
            let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
            localVarRequestOptions.headers = {...localVarHeaderParameter, ...headersFromBaseOptions, ...options.headers};
            localVarRequestOptions.data = serializeDataIfNeeded(commentRequest, localVarRequestOptions, configuration)

            return {
                url: toPathString(localVarUrlObj),
                options: localVarRequestOptions,
            };
        },
        /**
         * Create a reply.
         * @param {string} name 
         * @param {ReplyRequest} replyRequest 
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        createReply: async (name: string, replyRequest: ReplyRequest, options: RawAxiosRequestConfig = {}): Promise<RequestArgs> => {
            // verify required parameter 'name' is not null or undefined
            assertParamExists('createReply', 'name', name)
            // verify required parameter 'replyRequest' is not null or undefined
            assertParamExists('createReply', 'replyRequest', replyRequest)
            const localVarPath = `/apis/api.console.halo.run/v1alpha1/comments/{name}/reply`
                .replace(`{${"name"}}`, encodeURIComponent(String(name)));
            // use dummy base URL string because the URL constructor only accepts absolute URLs.
            const localVarUrlObj = new URL(localVarPath, DUMMY_BASE_URL);
            let baseOptions;
            if (configuration) {
                baseOptions = configuration.baseOptions;
            }

            const localVarRequestOptions = { method: 'POST', ...baseOptions, ...options};
            const localVarHeaderParameter = {} as any;
            const localVarQueryParameter = {} as any;

            // authentication basicAuth required
            // http basic authentication required
            setBasicAuthToObject(localVarRequestOptions, configuration)

            // authentication bearerAuth required
            // http bearer authentication required
            await setBearerAuthToObject(localVarHeaderParameter, configuration)


    
            localVarHeaderParameter['Content-Type'] = 'application/json';

            setSearchParams(localVarUrlObj, localVarQueryParameter);
            let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
            localVarRequestOptions.headers = {...localVarHeaderParameter, ...headersFromBaseOptions, ...options.headers};
            localVarRequestOptions.data = serializeDataIfNeeded(replyRequest, localVarRequestOptions, configuration)

            return {
                url: toPathString(localVarUrlObj),
                options: localVarRequestOptions,
            };
        },
        /**
         * List comments.
         * @param {number} [page] Page number. Default is 0.
         * @param {number} [size] Size number. Default is 0.
         * @param {Array<string>} [labelSelector] Label selector. e.g.: hidden!&#x3D;true
         * @param {Array<string>} [fieldSelector] Field selector. e.g.: metadata.name&#x3D;&#x3D;halo
         * @param {Array<string>} [sort] Sorting criteria in the format: property,(asc|desc). Default sort order is ascending. Multiple sort criteria are supported.
         * @param {string} [keyword] Comments filtered by keyword.
         * @param {string} [ownerKind] Commenter kind.
         * @param {string} [ownerName] Commenter name.
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        listComments: async (page?: number, size?: number, labelSelector?: Array<string>, fieldSelector?: Array<string>, sort?: Array<string>, keyword?: string, ownerKind?: string, ownerName?: string, options: RawAxiosRequestConfig = {}): Promise<RequestArgs> => {
            const localVarPath = `/apis/api.console.halo.run/v1alpha1/comments`;
            // use dummy base URL string because the URL constructor only accepts absolute URLs.
            const localVarUrlObj = new URL(localVarPath, DUMMY_BASE_URL);
            let baseOptions;
            if (configuration) {
                baseOptions = configuration.baseOptions;
            }

            const localVarRequestOptions = { method: 'GET', ...baseOptions, ...options};
            const localVarHeaderParameter = {} as any;
            const localVarQueryParameter = {} as any;

            // authentication basicAuth required
            // http basic authentication required
            setBasicAuthToObject(localVarRequestOptions, configuration)

            // authentication bearerAuth required
            // http bearer authentication required
            await setBearerAuthToObject(localVarHeaderParameter, configuration)

            if (page !== undefined) {
                localVarQueryParameter['page'] = page;
            }

            if (size !== undefined) {
                localVarQueryParameter['size'] = size;
            }

            if (labelSelector) {
                localVarQueryParameter['labelSelector'] = labelSelector;
            }

            if (fieldSelector) {
                localVarQueryParameter['fieldSelector'] = fieldSelector;
            }

            if (sort) {
                localVarQueryParameter['sort'] = sort;
            }

            if (keyword !== undefined) {
                localVarQueryParameter['keyword'] = keyword;
            }

            if (ownerKind !== undefined) {
                localVarQueryParameter['ownerKind'] = ownerKind;
            }

            if (ownerName !== undefined) {
                localVarQueryParameter['ownerName'] = ownerName;
            }


    
            setSearchParams(localVarUrlObj, localVarQueryParameter);
            let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
            localVarRequestOptions.headers = {...localVarHeaderParameter, ...headersFromBaseOptions, ...options.headers};

            return {
                url: toPathString(localVarUrlObj),
                options: localVarRequestOptions,
            };
        },
    }
};

/**
 * CommentV1alpha1ConsoleApi - functional programming interface
 * @export
 */
export const CommentV1alpha1ConsoleApiFp = function(configuration?: Configuration) {
    const localVarAxiosParamCreator = CommentV1alpha1ConsoleApiAxiosParamCreator(configuration)
    return {
        /**
         * Create a comment.
         * @param {CommentRequest} commentRequest 
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        async createComment(commentRequest: CommentRequest, options?: RawAxiosRequestConfig): Promise<(axios?: AxiosInstance, basePath?: string) => AxiosPromise<Comment>> {
            const localVarAxiosArgs = await localVarAxiosParamCreator.createComment(commentRequest, options);
            const localVarOperationServerIndex = configuration?.serverIndex ?? 0;
            const localVarOperationServerBasePath = operationServerMap['CommentV1alpha1ConsoleApi.createComment']?.[localVarOperationServerIndex]?.url;
            return (axios, basePath) => createRequestFunction(localVarAxiosArgs, globalAxios, BASE_PATH, configuration)(axios, localVarOperationServerBasePath || basePath);
        },
        /**
         * Create a reply.
         * @param {string} name 
         * @param {ReplyRequest} replyRequest 
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        async createReply(name: string, replyRequest: ReplyRequest, options?: RawAxiosRequestConfig): Promise<(axios?: AxiosInstance, basePath?: string) => AxiosPromise<Reply>> {
            const localVarAxiosArgs = await localVarAxiosParamCreator.createReply(name, replyRequest, options);
            const localVarOperationServerIndex = configuration?.serverIndex ?? 0;
            const localVarOperationServerBasePath = operationServerMap['CommentV1alpha1ConsoleApi.createReply']?.[localVarOperationServerIndex]?.url;
            return (axios, basePath) => createRequestFunction(localVarAxiosArgs, globalAxios, BASE_PATH, configuration)(axios, localVarOperationServerBasePath || basePath);
        },
        /**
         * List comments.
         * @param {number} [page] Page number. Default is 0.
         * @param {number} [size] Size number. Default is 0.
         * @param {Array<string>} [labelSelector] Label selector. e.g.: hidden!&#x3D;true
         * @param {Array<string>} [fieldSelector] Field selector. e.g.: metadata.name&#x3D;&#x3D;halo
         * @param {Array<string>} [sort] Sorting criteria in the format: property,(asc|desc). Default sort order is ascending. Multiple sort criteria are supported.
         * @param {string} [keyword] Comments filtered by keyword.
         * @param {string} [ownerKind] Commenter kind.
         * @param {string} [ownerName] Commenter name.
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        async listComments(page?: number, size?: number, labelSelector?: Array<string>, fieldSelector?: Array<string>, sort?: Array<string>, keyword?: string, ownerKind?: string, ownerName?: string, options?: RawAxiosRequestConfig): Promise<(axios?: AxiosInstance, basePath?: string) => AxiosPromise<ListedCommentList>> {
            const localVarAxiosArgs = await localVarAxiosParamCreator.listComments(page, size, labelSelector, fieldSelector, sort, keyword, ownerKind, ownerName, options);
            const localVarOperationServerIndex = configuration?.serverIndex ?? 0;
            const localVarOperationServerBasePath = operationServerMap['CommentV1alpha1ConsoleApi.listComments']?.[localVarOperationServerIndex]?.url;
            return (axios, basePath) => createRequestFunction(localVarAxiosArgs, globalAxios, BASE_PATH, configuration)(axios, localVarOperationServerBasePath || basePath);
        },
    }
};

/**
 * CommentV1alpha1ConsoleApi - factory interface
 * @export
 */
export const CommentV1alpha1ConsoleApiFactory = function (configuration?: Configuration, basePath?: string, axios?: AxiosInstance) {
    const localVarFp = CommentV1alpha1ConsoleApiFp(configuration)
    return {
        /**
         * Create a comment.
         * @param {CommentV1alpha1ConsoleApiCreateCommentRequest} requestParameters Request parameters.
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        createComment(requestParameters: CommentV1alpha1ConsoleApiCreateCommentRequest, options?: RawAxiosRequestConfig): AxiosPromise<Comment> {
            return localVarFp.createComment(requestParameters.commentRequest, options).then((request) => request(axios, basePath));
        },
        /**
         * Create a reply.
         * @param {CommentV1alpha1ConsoleApiCreateReplyRequest} requestParameters Request parameters.
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        createReply(requestParameters: CommentV1alpha1ConsoleApiCreateReplyRequest, options?: RawAxiosRequestConfig): AxiosPromise<Reply> {
            return localVarFp.createReply(requestParameters.name, requestParameters.replyRequest, options).then((request) => request(axios, basePath));
        },
        /**
         * List comments.
         * @param {CommentV1alpha1ConsoleApiListCommentsRequest} requestParameters Request parameters.
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        listComments(requestParameters: CommentV1alpha1ConsoleApiListCommentsRequest = {}, options?: RawAxiosRequestConfig): AxiosPromise<ListedCommentList> {
            return localVarFp.listComments(requestParameters.page, requestParameters.size, requestParameters.labelSelector, requestParameters.fieldSelector, requestParameters.sort, requestParameters.keyword, requestParameters.ownerKind, requestParameters.ownerName, options).then((request) => request(axios, basePath));
        },
    };
};

/**
 * Request parameters for createComment operation in CommentV1alpha1ConsoleApi.
 * @export
 * @interface CommentV1alpha1ConsoleApiCreateCommentRequest
 */
export interface CommentV1alpha1ConsoleApiCreateCommentRequest {
    /**
     * 
     * @type {CommentRequest}
     * @memberof CommentV1alpha1ConsoleApiCreateComment
     */
    readonly commentRequest: CommentRequest
}

/**
 * Request parameters for createReply operation in CommentV1alpha1ConsoleApi.
 * @export
 * @interface CommentV1alpha1ConsoleApiCreateReplyRequest
 */
export interface CommentV1alpha1ConsoleApiCreateReplyRequest {
    /**
     * 
     * @type {string}
     * @memberof CommentV1alpha1ConsoleApiCreateReply
     */
    readonly name: string

    /**
     * 
     * @type {ReplyRequest}
     * @memberof CommentV1alpha1ConsoleApiCreateReply
     */
    readonly replyRequest: ReplyRequest
}

/**
 * Request parameters for listComments operation in CommentV1alpha1ConsoleApi.
 * @export
 * @interface CommentV1alpha1ConsoleApiListCommentsRequest
 */
export interface CommentV1alpha1ConsoleApiListCommentsRequest {
    /**
     * Page number. Default is 0.
     * @type {number}
     * @memberof CommentV1alpha1ConsoleApiListComments
     */
    readonly page?: number

    /**
     * Size number. Default is 0.
     * @type {number}
     * @memberof CommentV1alpha1ConsoleApiListComments
     */
    readonly size?: number

    /**
     * Label selector. e.g.: hidden!&#x3D;true
     * @type {Array<string>}
     * @memberof CommentV1alpha1ConsoleApiListComments
     */
    readonly labelSelector?: Array<string>

    /**
     * Field selector. e.g.: metadata.name&#x3D;&#x3D;halo
     * @type {Array<string>}
     * @memberof CommentV1alpha1ConsoleApiListComments
     */
    readonly fieldSelector?: Array<string>

    /**
     * Sorting criteria in the format: property,(asc|desc). Default sort order is ascending. Multiple sort criteria are supported.
     * @type {Array<string>}
     * @memberof CommentV1alpha1ConsoleApiListComments
     */
    readonly sort?: Array<string>

    /**
     * Comments filtered by keyword.
     * @type {string}
     * @memberof CommentV1alpha1ConsoleApiListComments
     */
    readonly keyword?: string

    /**
     * Commenter kind.
     * @type {string}
     * @memberof CommentV1alpha1ConsoleApiListComments
     */
    readonly ownerKind?: string

    /**
     * Commenter name.
     * @type {string}
     * @memberof CommentV1alpha1ConsoleApiListComments
     */
    readonly ownerName?: string
}

/**
 * CommentV1alpha1ConsoleApi - object-oriented interface
 * @export
 * @class CommentV1alpha1ConsoleApi
 * @extends {BaseAPI}
 */
export class CommentV1alpha1ConsoleApi extends BaseAPI {
    /**
     * Create a comment.
     * @param {CommentV1alpha1ConsoleApiCreateCommentRequest} requestParameters Request parameters.
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof CommentV1alpha1ConsoleApi
     */
    public createComment(requestParameters: CommentV1alpha1ConsoleApiCreateCommentRequest, options?: RawAxiosRequestConfig) {
        return CommentV1alpha1ConsoleApiFp(this.configuration).createComment(requestParameters.commentRequest, options).then((request) => request(this.axios, this.basePath));
    }

    /**
     * Create a reply.
     * @param {CommentV1alpha1ConsoleApiCreateReplyRequest} requestParameters Request parameters.
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof CommentV1alpha1ConsoleApi
     */
    public createReply(requestParameters: CommentV1alpha1ConsoleApiCreateReplyRequest, options?: RawAxiosRequestConfig) {
        return CommentV1alpha1ConsoleApiFp(this.configuration).createReply(requestParameters.name, requestParameters.replyRequest, options).then((request) => request(this.axios, this.basePath));
    }

    /**
     * List comments.
     * @param {CommentV1alpha1ConsoleApiListCommentsRequest} requestParameters Request parameters.
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof CommentV1alpha1ConsoleApi
     */
    public listComments(requestParameters: CommentV1alpha1ConsoleApiListCommentsRequest = {}, options?: RawAxiosRequestConfig) {
        return CommentV1alpha1ConsoleApiFp(this.configuration).listComments(requestParameters.page, requestParameters.size, requestParameters.labelSelector, requestParameters.fieldSelector, requestParameters.sort, requestParameters.keyword, requestParameters.ownerKind, requestParameters.ownerName, options).then((request) => request(this.axios, this.basePath));
    }
}

