/* tslint:disable */
/* eslint-disable */
/**
 * Halo
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: 2.20.10-SNAPSHOT
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


import type { Configuration } from '../configuration';
import type { AxiosPromise, AxiosInstance, RawAxiosRequestConfig } from 'axios';
import globalAxios from 'axios';
// Some imports not used depending on template conditions
// @ts-ignore
import { DUMMY_BASE_URL, assertParamExists, setApiKeyToObject, setBasicAuthToObject, setBearerAuthToObject, setOAuthToObject, setSearchParams, serializeDataIfNeeded, toPathString, createRequestFunction } from '../common';
// @ts-ignore
import { BASE_PATH, COLLECTION_FORMATS, RequestArgs, BaseAPI, RequiredError, operationServerMap } from '../base';
// @ts-ignore
import { Counter } from '../models';
// @ts-ignore
import { CounterList } from '../models';
// @ts-ignore
import { JsonPatchInner } from '../models';
/**
 * CounterV1alpha1Api - axios parameter creator
 * @export
 */
export const CounterV1alpha1ApiAxiosParamCreator = function (configuration?: Configuration) {
    return {
        /**
         * Create Counter
         * @param {Counter} [counter] Fresh counter
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        createCounter: async (counter?: Counter, options: RawAxiosRequestConfig = {}): Promise<RequestArgs> => {
            const localVarPath = `/apis/metrics.halo.run/v1alpha1/counters`;
            // use dummy base URL string because the URL constructor only accepts absolute URLs.
            const localVarUrlObj = new URL(localVarPath, DUMMY_BASE_URL);
            let baseOptions;
            if (configuration) {
                baseOptions = configuration.baseOptions;
            }

            const localVarRequestOptions = { method: 'POST', ...baseOptions, ...options};
            const localVarHeaderParameter = {} as any;
            const localVarQueryParameter = {} as any;

            // authentication basicAuth required
            // http basic authentication required
            setBasicAuthToObject(localVarRequestOptions, configuration)

            // authentication bearerAuth required
            // http bearer authentication required
            await setBearerAuthToObject(localVarHeaderParameter, configuration)


    
            localVarHeaderParameter['Content-Type'] = 'application/json';

            setSearchParams(localVarUrlObj, localVarQueryParameter);
            let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
            localVarRequestOptions.headers = {...localVarHeaderParameter, ...headersFromBaseOptions, ...options.headers};
            localVarRequestOptions.data = serializeDataIfNeeded(counter, localVarRequestOptions, configuration)

            return {
                url: toPathString(localVarUrlObj),
                options: localVarRequestOptions,
            };
        },
        /**
         * Delete Counter
         * @param {string} name Name of counter
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        deleteCounter: async (name: string, options: RawAxiosRequestConfig = {}): Promise<RequestArgs> => {
            // verify required parameter 'name' is not null or undefined
            assertParamExists('deleteCounter', 'name', name)
            const localVarPath = `/apis/metrics.halo.run/v1alpha1/counters/{name}`
                .replace(`{${"name"}}`, encodeURIComponent(String(name)));
            // use dummy base URL string because the URL constructor only accepts absolute URLs.
            const localVarUrlObj = new URL(localVarPath, DUMMY_BASE_URL);
            let baseOptions;
            if (configuration) {
                baseOptions = configuration.baseOptions;
            }

            const localVarRequestOptions = { method: 'DELETE', ...baseOptions, ...options};
            const localVarHeaderParameter = {} as any;
            const localVarQueryParameter = {} as any;

            // authentication basicAuth required
            // http basic authentication required
            setBasicAuthToObject(localVarRequestOptions, configuration)

            // authentication bearerAuth required
            // http bearer authentication required
            await setBearerAuthToObject(localVarHeaderParameter, configuration)


    
            setSearchParams(localVarUrlObj, localVarQueryParameter);
            let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
            localVarRequestOptions.headers = {...localVarHeaderParameter, ...headersFromBaseOptions, ...options.headers};

            return {
                url: toPathString(localVarUrlObj),
                options: localVarRequestOptions,
            };
        },
        /**
         * Get Counter
         * @param {string} name Name of counter
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        getCounter: async (name: string, options: RawAxiosRequestConfig = {}): Promise<RequestArgs> => {
            // verify required parameter 'name' is not null or undefined
            assertParamExists('getCounter', 'name', name)
            const localVarPath = `/apis/metrics.halo.run/v1alpha1/counters/{name}`
                .replace(`{${"name"}}`, encodeURIComponent(String(name)));
            // use dummy base URL string because the URL constructor only accepts absolute URLs.
            const localVarUrlObj = new URL(localVarPath, DUMMY_BASE_URL);
            let baseOptions;
            if (configuration) {
                baseOptions = configuration.baseOptions;
            }

            const localVarRequestOptions = { method: 'GET', ...baseOptions, ...options};
            const localVarHeaderParameter = {} as any;
            const localVarQueryParameter = {} as any;

            // authentication basicAuth required
            // http basic authentication required
            setBasicAuthToObject(localVarRequestOptions, configuration)

            // authentication bearerAuth required
            // http bearer authentication required
            await setBearerAuthToObject(localVarHeaderParameter, configuration)


    
            setSearchParams(localVarUrlObj, localVarQueryParameter);
            let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
            localVarRequestOptions.headers = {...localVarHeaderParameter, ...headersFromBaseOptions, ...options.headers};

            return {
                url: toPathString(localVarUrlObj),
                options: localVarRequestOptions,
            };
        },
        /**
         * List Counter
         * @param {number} [page] Page number. Default is 0.
         * @param {number} [size] Size number. Default is 0.
         * @param {Array<string>} [labelSelector] Label selector. e.g.: hidden!&#x3D;true
         * @param {Array<string>} [fieldSelector] Field selector. e.g.: metadata.name&#x3D;&#x3D;halo
         * @param {Array<string>} [sort] Sorting criteria in the format: property,(asc|desc). Default sort order is ascending. Multiple sort criteria are supported.
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        listCounter: async (page?: number, size?: number, labelSelector?: Array<string>, fieldSelector?: Array<string>, sort?: Array<string>, options: RawAxiosRequestConfig = {}): Promise<RequestArgs> => {
            const localVarPath = `/apis/metrics.halo.run/v1alpha1/counters`;
            // use dummy base URL string because the URL constructor only accepts absolute URLs.
            const localVarUrlObj = new URL(localVarPath, DUMMY_BASE_URL);
            let baseOptions;
            if (configuration) {
                baseOptions = configuration.baseOptions;
            }

            const localVarRequestOptions = { method: 'GET', ...baseOptions, ...options};
            const localVarHeaderParameter = {} as any;
            const localVarQueryParameter = {} as any;

            // authentication basicAuth required
            // http basic authentication required
            setBasicAuthToObject(localVarRequestOptions, configuration)

            // authentication bearerAuth required
            // http bearer authentication required
            await setBearerAuthToObject(localVarHeaderParameter, configuration)

            if (page !== undefined) {
                localVarQueryParameter['page'] = page;
            }

            if (size !== undefined) {
                localVarQueryParameter['size'] = size;
            }

            if (labelSelector) {
                localVarQueryParameter['labelSelector'] = labelSelector;
            }

            if (fieldSelector) {
                localVarQueryParameter['fieldSelector'] = fieldSelector;
            }

            if (sort) {
                localVarQueryParameter['sort'] = sort;
            }


    
            setSearchParams(localVarUrlObj, localVarQueryParameter);
            let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
            localVarRequestOptions.headers = {...localVarHeaderParameter, ...headersFromBaseOptions, ...options.headers};

            return {
                url: toPathString(localVarUrlObj),
                options: localVarRequestOptions,
            };
        },
        /**
         * Patch Counter
         * @param {string} name Name of counter
         * @param {Array<JsonPatchInner>} [jsonPatchInner] 
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        patchCounter: async (name: string, jsonPatchInner?: Array<JsonPatchInner>, options: RawAxiosRequestConfig = {}): Promise<RequestArgs> => {
            // verify required parameter 'name' is not null or undefined
            assertParamExists('patchCounter', 'name', name)
            const localVarPath = `/apis/metrics.halo.run/v1alpha1/counters/{name}`
                .replace(`{${"name"}}`, encodeURIComponent(String(name)));
            // use dummy base URL string because the URL constructor only accepts absolute URLs.
            const localVarUrlObj = new URL(localVarPath, DUMMY_BASE_URL);
            let baseOptions;
            if (configuration) {
                baseOptions = configuration.baseOptions;
            }

            const localVarRequestOptions = { method: 'PATCH', ...baseOptions, ...options};
            const localVarHeaderParameter = {} as any;
            const localVarQueryParameter = {} as any;

            // authentication basicAuth required
            // http basic authentication required
            setBasicAuthToObject(localVarRequestOptions, configuration)

            // authentication bearerAuth required
            // http bearer authentication required
            await setBearerAuthToObject(localVarHeaderParameter, configuration)


    
            localVarHeaderParameter['Content-Type'] = 'application/json-patch+json';

            setSearchParams(localVarUrlObj, localVarQueryParameter);
            let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
            localVarRequestOptions.headers = {...localVarHeaderParameter, ...headersFromBaseOptions, ...options.headers};
            localVarRequestOptions.data = serializeDataIfNeeded(jsonPatchInner, localVarRequestOptions, configuration)

            return {
                url: toPathString(localVarUrlObj),
                options: localVarRequestOptions,
            };
        },
        /**
         * Update Counter
         * @param {string} name Name of counter
         * @param {Counter} [counter] Updated counter
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        updateCounter: async (name: string, counter?: Counter, options: RawAxiosRequestConfig = {}): Promise<RequestArgs> => {
            // verify required parameter 'name' is not null or undefined
            assertParamExists('updateCounter', 'name', name)
            const localVarPath = `/apis/metrics.halo.run/v1alpha1/counters/{name}`
                .replace(`{${"name"}}`, encodeURIComponent(String(name)));
            // use dummy base URL string because the URL constructor only accepts absolute URLs.
            const localVarUrlObj = new URL(localVarPath, DUMMY_BASE_URL);
            let baseOptions;
            if (configuration) {
                baseOptions = configuration.baseOptions;
            }

            const localVarRequestOptions = { method: 'PUT', ...baseOptions, ...options};
            const localVarHeaderParameter = {} as any;
            const localVarQueryParameter = {} as any;

            // authentication basicAuth required
            // http basic authentication required
            setBasicAuthToObject(localVarRequestOptions, configuration)

            // authentication bearerAuth required
            // http bearer authentication required
            await setBearerAuthToObject(localVarHeaderParameter, configuration)


    
            localVarHeaderParameter['Content-Type'] = 'application/json';

            setSearchParams(localVarUrlObj, localVarQueryParameter);
            let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
            localVarRequestOptions.headers = {...localVarHeaderParameter, ...headersFromBaseOptions, ...options.headers};
            localVarRequestOptions.data = serializeDataIfNeeded(counter, localVarRequestOptions, configuration)

            return {
                url: toPathString(localVarUrlObj),
                options: localVarRequestOptions,
            };
        },
    }
};

/**
 * CounterV1alpha1Api - functional programming interface
 * @export
 */
export const CounterV1alpha1ApiFp = function(configuration?: Configuration) {
    const localVarAxiosParamCreator = CounterV1alpha1ApiAxiosParamCreator(configuration)
    return {
        /**
         * Create Counter
         * @param {Counter} [counter] Fresh counter
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        async createCounter(counter?: Counter, options?: RawAxiosRequestConfig): Promise<(axios?: AxiosInstance, basePath?: string) => AxiosPromise<Counter>> {
            const localVarAxiosArgs = await localVarAxiosParamCreator.createCounter(counter, options);
            const localVarOperationServerIndex = configuration?.serverIndex ?? 0;
            const localVarOperationServerBasePath = operationServerMap['CounterV1alpha1Api.createCounter']?.[localVarOperationServerIndex]?.url;
            return (axios, basePath) => createRequestFunction(localVarAxiosArgs, globalAxios, BASE_PATH, configuration)(axios, localVarOperationServerBasePath || basePath);
        },
        /**
         * Delete Counter
         * @param {string} name Name of counter
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        async deleteCounter(name: string, options?: RawAxiosRequestConfig): Promise<(axios?: AxiosInstance, basePath?: string) => AxiosPromise<void>> {
            const localVarAxiosArgs = await localVarAxiosParamCreator.deleteCounter(name, options);
            const localVarOperationServerIndex = configuration?.serverIndex ?? 0;
            const localVarOperationServerBasePath = operationServerMap['CounterV1alpha1Api.deleteCounter']?.[localVarOperationServerIndex]?.url;
            return (axios, basePath) => createRequestFunction(localVarAxiosArgs, globalAxios, BASE_PATH, configuration)(axios, localVarOperationServerBasePath || basePath);
        },
        /**
         * Get Counter
         * @param {string} name Name of counter
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        async getCounter(name: string, options?: RawAxiosRequestConfig): Promise<(axios?: AxiosInstance, basePath?: string) => AxiosPromise<Counter>> {
            const localVarAxiosArgs = await localVarAxiosParamCreator.getCounter(name, options);
            const localVarOperationServerIndex = configuration?.serverIndex ?? 0;
            const localVarOperationServerBasePath = operationServerMap['CounterV1alpha1Api.getCounter']?.[localVarOperationServerIndex]?.url;
            return (axios, basePath) => createRequestFunction(localVarAxiosArgs, globalAxios, BASE_PATH, configuration)(axios, localVarOperationServerBasePath || basePath);
        },
        /**
         * List Counter
         * @param {number} [page] Page number. Default is 0.
         * @param {number} [size] Size number. Default is 0.
         * @param {Array<string>} [labelSelector] Label selector. e.g.: hidden!&#x3D;true
         * @param {Array<string>} [fieldSelector] Field selector. e.g.: metadata.name&#x3D;&#x3D;halo
         * @param {Array<string>} [sort] Sorting criteria in the format: property,(asc|desc). Default sort order is ascending. Multiple sort criteria are supported.
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        async listCounter(page?: number, size?: number, labelSelector?: Array<string>, fieldSelector?: Array<string>, sort?: Array<string>, options?: RawAxiosRequestConfig): Promise<(axios?: AxiosInstance, basePath?: string) => AxiosPromise<CounterList>> {
            const localVarAxiosArgs = await localVarAxiosParamCreator.listCounter(page, size, labelSelector, fieldSelector, sort, options);
            const localVarOperationServerIndex = configuration?.serverIndex ?? 0;
            const localVarOperationServerBasePath = operationServerMap['CounterV1alpha1Api.listCounter']?.[localVarOperationServerIndex]?.url;
            return (axios, basePath) => createRequestFunction(localVarAxiosArgs, globalAxios, BASE_PATH, configuration)(axios, localVarOperationServerBasePath || basePath);
        },
        /**
         * Patch Counter
         * @param {string} name Name of counter
         * @param {Array<JsonPatchInner>} [jsonPatchInner] 
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        async patchCounter(name: string, jsonPatchInner?: Array<JsonPatchInner>, options?: RawAxiosRequestConfig): Promise<(axios?: AxiosInstance, basePath?: string) => AxiosPromise<Counter>> {
            const localVarAxiosArgs = await localVarAxiosParamCreator.patchCounter(name, jsonPatchInner, options);
            const localVarOperationServerIndex = configuration?.serverIndex ?? 0;
            const localVarOperationServerBasePath = operationServerMap['CounterV1alpha1Api.patchCounter']?.[localVarOperationServerIndex]?.url;
            return (axios, basePath) => createRequestFunction(localVarAxiosArgs, globalAxios, BASE_PATH, configuration)(axios, localVarOperationServerBasePath || basePath);
        },
        /**
         * Update Counter
         * @param {string} name Name of counter
         * @param {Counter} [counter] Updated counter
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        async updateCounter(name: string, counter?: Counter, options?: RawAxiosRequestConfig): Promise<(axios?: AxiosInstance, basePath?: string) => AxiosPromise<Counter>> {
            const localVarAxiosArgs = await localVarAxiosParamCreator.updateCounter(name, counter, options);
            const localVarOperationServerIndex = configuration?.serverIndex ?? 0;
            const localVarOperationServerBasePath = operationServerMap['CounterV1alpha1Api.updateCounter']?.[localVarOperationServerIndex]?.url;
            return (axios, basePath) => createRequestFunction(localVarAxiosArgs, globalAxios, BASE_PATH, configuration)(axios, localVarOperationServerBasePath || basePath);
        },
    }
};

/**
 * CounterV1alpha1Api - factory interface
 * @export
 */
export const CounterV1alpha1ApiFactory = function (configuration?: Configuration, basePath?: string, axios?: AxiosInstance) {
    const localVarFp = CounterV1alpha1ApiFp(configuration)
    return {
        /**
         * Create Counter
         * @param {CounterV1alpha1ApiCreateCounterRequest} requestParameters Request parameters.
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        createCounter(requestParameters: CounterV1alpha1ApiCreateCounterRequest = {}, options?: RawAxiosRequestConfig): AxiosPromise<Counter> {
            return localVarFp.createCounter(requestParameters.counter, options).then((request) => request(axios, basePath));
        },
        /**
         * Delete Counter
         * @param {CounterV1alpha1ApiDeleteCounterRequest} requestParameters Request parameters.
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        deleteCounter(requestParameters: CounterV1alpha1ApiDeleteCounterRequest, options?: RawAxiosRequestConfig): AxiosPromise<void> {
            return localVarFp.deleteCounter(requestParameters.name, options).then((request) => request(axios, basePath));
        },
        /**
         * Get Counter
         * @param {CounterV1alpha1ApiGetCounterRequest} requestParameters Request parameters.
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        getCounter(requestParameters: CounterV1alpha1ApiGetCounterRequest, options?: RawAxiosRequestConfig): AxiosPromise<Counter> {
            return localVarFp.getCounter(requestParameters.name, options).then((request) => request(axios, basePath));
        },
        /**
         * List Counter
         * @param {CounterV1alpha1ApiListCounterRequest} requestParameters Request parameters.
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        listCounter(requestParameters: CounterV1alpha1ApiListCounterRequest = {}, options?: RawAxiosRequestConfig): AxiosPromise<CounterList> {
            return localVarFp.listCounter(requestParameters.page, requestParameters.size, requestParameters.labelSelector, requestParameters.fieldSelector, requestParameters.sort, options).then((request) => request(axios, basePath));
        },
        /**
         * Patch Counter
         * @param {CounterV1alpha1ApiPatchCounterRequest} requestParameters Request parameters.
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        patchCounter(requestParameters: CounterV1alpha1ApiPatchCounterRequest, options?: RawAxiosRequestConfig): AxiosPromise<Counter> {
            return localVarFp.patchCounter(requestParameters.name, requestParameters.jsonPatchInner, options).then((request) => request(axios, basePath));
        },
        /**
         * Update Counter
         * @param {CounterV1alpha1ApiUpdateCounterRequest} requestParameters Request parameters.
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        updateCounter(requestParameters: CounterV1alpha1ApiUpdateCounterRequest, options?: RawAxiosRequestConfig): AxiosPromise<Counter> {
            return localVarFp.updateCounter(requestParameters.name, requestParameters.counter, options).then((request) => request(axios, basePath));
        },
    };
};

/**
 * Request parameters for createCounter operation in CounterV1alpha1Api.
 * @export
 * @interface CounterV1alpha1ApiCreateCounterRequest
 */
export interface CounterV1alpha1ApiCreateCounterRequest {
    /**
     * Fresh counter
     * @type {Counter}
     * @memberof CounterV1alpha1ApiCreateCounter
     */
    readonly counter?: Counter
}

/**
 * Request parameters for deleteCounter operation in CounterV1alpha1Api.
 * @export
 * @interface CounterV1alpha1ApiDeleteCounterRequest
 */
export interface CounterV1alpha1ApiDeleteCounterRequest {
    /**
     * Name of counter
     * @type {string}
     * @memberof CounterV1alpha1ApiDeleteCounter
     */
    readonly name: string
}

/**
 * Request parameters for getCounter operation in CounterV1alpha1Api.
 * @export
 * @interface CounterV1alpha1ApiGetCounterRequest
 */
export interface CounterV1alpha1ApiGetCounterRequest {
    /**
     * Name of counter
     * @type {string}
     * @memberof CounterV1alpha1ApiGetCounter
     */
    readonly name: string
}

/**
 * Request parameters for listCounter operation in CounterV1alpha1Api.
 * @export
 * @interface CounterV1alpha1ApiListCounterRequest
 */
export interface CounterV1alpha1ApiListCounterRequest {
    /**
     * Page number. Default is 0.
     * @type {number}
     * @memberof CounterV1alpha1ApiListCounter
     */
    readonly page?: number

    /**
     * Size number. Default is 0.
     * @type {number}
     * @memberof CounterV1alpha1ApiListCounter
     */
    readonly size?: number

    /**
     * Label selector. e.g.: hidden!&#x3D;true
     * @type {Array<string>}
     * @memberof CounterV1alpha1ApiListCounter
     */
    readonly labelSelector?: Array<string>

    /**
     * Field selector. e.g.: metadata.name&#x3D;&#x3D;halo
     * @type {Array<string>}
     * @memberof CounterV1alpha1ApiListCounter
     */
    readonly fieldSelector?: Array<string>

    /**
     * Sorting criteria in the format: property,(asc|desc). Default sort order is ascending. Multiple sort criteria are supported.
     * @type {Array<string>}
     * @memberof CounterV1alpha1ApiListCounter
     */
    readonly sort?: Array<string>
}

/**
 * Request parameters for patchCounter operation in CounterV1alpha1Api.
 * @export
 * @interface CounterV1alpha1ApiPatchCounterRequest
 */
export interface CounterV1alpha1ApiPatchCounterRequest {
    /**
     * Name of counter
     * @type {string}
     * @memberof CounterV1alpha1ApiPatchCounter
     */
    readonly name: string

    /**
     * 
     * @type {Array<JsonPatchInner>}
     * @memberof CounterV1alpha1ApiPatchCounter
     */
    readonly jsonPatchInner?: Array<JsonPatchInner>
}

/**
 * Request parameters for updateCounter operation in CounterV1alpha1Api.
 * @export
 * @interface CounterV1alpha1ApiUpdateCounterRequest
 */
export interface CounterV1alpha1ApiUpdateCounterRequest {
    /**
     * Name of counter
     * @type {string}
     * @memberof CounterV1alpha1ApiUpdateCounter
     */
    readonly name: string

    /**
     * Updated counter
     * @type {Counter}
     * @memberof CounterV1alpha1ApiUpdateCounter
     */
    readonly counter?: Counter
}

/**
 * CounterV1alpha1Api - object-oriented interface
 * @export
 * @class CounterV1alpha1Api
 * @extends {BaseAPI}
 */
export class CounterV1alpha1Api extends BaseAPI {
    /**
     * Create Counter
     * @param {CounterV1alpha1ApiCreateCounterRequest} requestParameters Request parameters.
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof CounterV1alpha1Api
     */
    public createCounter(requestParameters: CounterV1alpha1ApiCreateCounterRequest = {}, options?: RawAxiosRequestConfig) {
        return CounterV1alpha1ApiFp(this.configuration).createCounter(requestParameters.counter, options).then((request) => request(this.axios, this.basePath));
    }

    /**
     * Delete Counter
     * @param {CounterV1alpha1ApiDeleteCounterRequest} requestParameters Request parameters.
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof CounterV1alpha1Api
     */
    public deleteCounter(requestParameters: CounterV1alpha1ApiDeleteCounterRequest, options?: RawAxiosRequestConfig) {
        return CounterV1alpha1ApiFp(this.configuration).deleteCounter(requestParameters.name, options).then((request) => request(this.axios, this.basePath));
    }

    /**
     * Get Counter
     * @param {CounterV1alpha1ApiGetCounterRequest} requestParameters Request parameters.
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof CounterV1alpha1Api
     */
    public getCounter(requestParameters: CounterV1alpha1ApiGetCounterRequest, options?: RawAxiosRequestConfig) {
        return CounterV1alpha1ApiFp(this.configuration).getCounter(requestParameters.name, options).then((request) => request(this.axios, this.basePath));
    }

    /**
     * List Counter
     * @param {CounterV1alpha1ApiListCounterRequest} requestParameters Request parameters.
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof CounterV1alpha1Api
     */
    public listCounter(requestParameters: CounterV1alpha1ApiListCounterRequest = {}, options?: RawAxiosRequestConfig) {
        return CounterV1alpha1ApiFp(this.configuration).listCounter(requestParameters.page, requestParameters.size, requestParameters.labelSelector, requestParameters.fieldSelector, requestParameters.sort, options).then((request) => request(this.axios, this.basePath));
    }

    /**
     * Patch Counter
     * @param {CounterV1alpha1ApiPatchCounterRequest} requestParameters Request parameters.
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof CounterV1alpha1Api
     */
    public patchCounter(requestParameters: CounterV1alpha1ApiPatchCounterRequest, options?: RawAxiosRequestConfig) {
        return CounterV1alpha1ApiFp(this.configuration).patchCounter(requestParameters.name, requestParameters.jsonPatchInner, options).then((request) => request(this.axios, this.basePath));
    }

    /**
     * Update Counter
     * @param {CounterV1alpha1ApiUpdateCounterRequest} requestParameters Request parameters.
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof CounterV1alpha1Api
     */
    public updateCounter(requestParameters: CounterV1alpha1ApiUpdateCounterRequest, options?: RawAxiosRequestConfig) {
        return CounterV1alpha1ApiFp(this.configuration).updateCounter(requestParameters.name, requestParameters.counter, options).then((request) => request(this.axios, this.basePath));
    }
}

