/* tslint:disable */
/* eslint-disable */
/**
 * Halo
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: 2.20.10-SNAPSHOT
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


import type { Configuration } from '../configuration';
import type { AxiosPromise, AxiosInstance, RawAxiosRequestConfig } from 'axios';
import globalAxios from 'axios';
// Some imports not used depending on template conditions
// @ts-ignore
import { DUMMY_BASE_URL, assertParamExists, setApiKeyToObject, setBasicAuthToObject, setBearerAuthToObject, setOAuthToObject, setSearchParams, serializeDataIfNeeded, toPathString, createRequestFunction } from '../common';
// @ts-ignore
import { BASE_PATH, COLLECTION_FORMATS, RequestArgs, BaseAPI, RequiredError, operationServerMap } from '../base';
// @ts-ignore
import { Device } from '../models';
// @ts-ignore
import { DeviceList } from '../models';
// @ts-ignore
import { JsonPatchInner } from '../models';
/**
 * DeviceV1alpha1Api - axios parameter creator
 * @export
 */
export const DeviceV1alpha1ApiAxiosParamCreator = function (configuration?: Configuration) {
    return {
        /**
         * Create Device
         * @param {Device} [device] Fresh device
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        createDevice: async (device?: Device, options: RawAxiosRequestConfig = {}): Promise<RequestArgs> => {
            const localVarPath = `/apis/security.halo.run/v1alpha1/devices`;
            // use dummy base URL string because the URL constructor only accepts absolute URLs.
            const localVarUrlObj = new URL(localVarPath, DUMMY_BASE_URL);
            let baseOptions;
            if (configuration) {
                baseOptions = configuration.baseOptions;
            }

            const localVarRequestOptions = { method: 'POST', ...baseOptions, ...options};
            const localVarHeaderParameter = {} as any;
            const localVarQueryParameter = {} as any;

            // authentication basicAuth required
            // http basic authentication required
            setBasicAuthToObject(localVarRequestOptions, configuration)

            // authentication bearerAuth required
            // http bearer authentication required
            await setBearerAuthToObject(localVarHeaderParameter, configuration)


    
            localVarHeaderParameter['Content-Type'] = 'application/json';

            setSearchParams(localVarUrlObj, localVarQueryParameter);
            let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
            localVarRequestOptions.headers = {...localVarHeaderParameter, ...headersFromBaseOptions, ...options.headers};
            localVarRequestOptions.data = serializeDataIfNeeded(device, localVarRequestOptions, configuration)

            return {
                url: toPathString(localVarUrlObj),
                options: localVarRequestOptions,
            };
        },
        /**
         * Delete Device
         * @param {string} name Name of device
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        deleteDevice: async (name: string, options: RawAxiosRequestConfig = {}): Promise<RequestArgs> => {
            // verify required parameter 'name' is not null or undefined
            assertParamExists('deleteDevice', 'name', name)
            const localVarPath = `/apis/security.halo.run/v1alpha1/devices/{name}`
                .replace(`{${"name"}}`, encodeURIComponent(String(name)));
            // use dummy base URL string because the URL constructor only accepts absolute URLs.
            const localVarUrlObj = new URL(localVarPath, DUMMY_BASE_URL);
            let baseOptions;
            if (configuration) {
                baseOptions = configuration.baseOptions;
            }

            const localVarRequestOptions = { method: 'DELETE', ...baseOptions, ...options};
            const localVarHeaderParameter = {} as any;
            const localVarQueryParameter = {} as any;

            // authentication basicAuth required
            // http basic authentication required
            setBasicAuthToObject(localVarRequestOptions, configuration)

            // authentication bearerAuth required
            // http bearer authentication required
            await setBearerAuthToObject(localVarHeaderParameter, configuration)


    
            setSearchParams(localVarUrlObj, localVarQueryParameter);
            let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
            localVarRequestOptions.headers = {...localVarHeaderParameter, ...headersFromBaseOptions, ...options.headers};

            return {
                url: toPathString(localVarUrlObj),
                options: localVarRequestOptions,
            };
        },
        /**
         * Get Device
         * @param {string} name Name of device
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        getDevice: async (name: string, options: RawAxiosRequestConfig = {}): Promise<RequestArgs> => {
            // verify required parameter 'name' is not null or undefined
            assertParamExists('getDevice', 'name', name)
            const localVarPath = `/apis/security.halo.run/v1alpha1/devices/{name}`
                .replace(`{${"name"}}`, encodeURIComponent(String(name)));
            // use dummy base URL string because the URL constructor only accepts absolute URLs.
            const localVarUrlObj = new URL(localVarPath, DUMMY_BASE_URL);
            let baseOptions;
            if (configuration) {
                baseOptions = configuration.baseOptions;
            }

            const localVarRequestOptions = { method: 'GET', ...baseOptions, ...options};
            const localVarHeaderParameter = {} as any;
            const localVarQueryParameter = {} as any;

            // authentication basicAuth required
            // http basic authentication required
            setBasicAuthToObject(localVarRequestOptions, configuration)

            // authentication bearerAuth required
            // http bearer authentication required
            await setBearerAuthToObject(localVarHeaderParameter, configuration)


    
            setSearchParams(localVarUrlObj, localVarQueryParameter);
            let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
            localVarRequestOptions.headers = {...localVarHeaderParameter, ...headersFromBaseOptions, ...options.headers};

            return {
                url: toPathString(localVarUrlObj),
                options: localVarRequestOptions,
            };
        },
        /**
         * List Device
         * @param {number} [page] Page number. Default is 0.
         * @param {number} [size] Size number. Default is 0.
         * @param {Array<string>} [labelSelector] Label selector. e.g.: hidden!&#x3D;true
         * @param {Array<string>} [fieldSelector] Field selector. e.g.: metadata.name&#x3D;&#x3D;halo
         * @param {Array<string>} [sort] Sorting criteria in the format: property,(asc|desc). Default sort order is ascending. Multiple sort criteria are supported.
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        listDevice: async (page?: number, size?: number, labelSelector?: Array<string>, fieldSelector?: Array<string>, sort?: Array<string>, options: RawAxiosRequestConfig = {}): Promise<RequestArgs> => {
            const localVarPath = `/apis/security.halo.run/v1alpha1/devices`;
            // use dummy base URL string because the URL constructor only accepts absolute URLs.
            const localVarUrlObj = new URL(localVarPath, DUMMY_BASE_URL);
            let baseOptions;
            if (configuration) {
                baseOptions = configuration.baseOptions;
            }

            const localVarRequestOptions = { method: 'GET', ...baseOptions, ...options};
            const localVarHeaderParameter = {} as any;
            const localVarQueryParameter = {} as any;

            // authentication basicAuth required
            // http basic authentication required
            setBasicAuthToObject(localVarRequestOptions, configuration)

            // authentication bearerAuth required
            // http bearer authentication required
            await setBearerAuthToObject(localVarHeaderParameter, configuration)

            if (page !== undefined) {
                localVarQueryParameter['page'] = page;
            }

            if (size !== undefined) {
                localVarQueryParameter['size'] = size;
            }

            if (labelSelector) {
                localVarQueryParameter['labelSelector'] = labelSelector;
            }

            if (fieldSelector) {
                localVarQueryParameter['fieldSelector'] = fieldSelector;
            }

            if (sort) {
                localVarQueryParameter['sort'] = sort;
            }


    
            setSearchParams(localVarUrlObj, localVarQueryParameter);
            let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
            localVarRequestOptions.headers = {...localVarHeaderParameter, ...headersFromBaseOptions, ...options.headers};

            return {
                url: toPathString(localVarUrlObj),
                options: localVarRequestOptions,
            };
        },
        /**
         * Patch Device
         * @param {string} name Name of device
         * @param {Array<JsonPatchInner>} [jsonPatchInner] 
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        patchDevice: async (name: string, jsonPatchInner?: Array<JsonPatchInner>, options: RawAxiosRequestConfig = {}): Promise<RequestArgs> => {
            // verify required parameter 'name' is not null or undefined
            assertParamExists('patchDevice', 'name', name)
            const localVarPath = `/apis/security.halo.run/v1alpha1/devices/{name}`
                .replace(`{${"name"}}`, encodeURIComponent(String(name)));
            // use dummy base URL string because the URL constructor only accepts absolute URLs.
            const localVarUrlObj = new URL(localVarPath, DUMMY_BASE_URL);
            let baseOptions;
            if (configuration) {
                baseOptions = configuration.baseOptions;
            }

            const localVarRequestOptions = { method: 'PATCH', ...baseOptions, ...options};
            const localVarHeaderParameter = {} as any;
            const localVarQueryParameter = {} as any;

            // authentication basicAuth required
            // http basic authentication required
            setBasicAuthToObject(localVarRequestOptions, configuration)

            // authentication bearerAuth required
            // http bearer authentication required
            await setBearerAuthToObject(localVarHeaderParameter, configuration)


    
            localVarHeaderParameter['Content-Type'] = 'application/json-patch+json';

            setSearchParams(localVarUrlObj, localVarQueryParameter);
            let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
            localVarRequestOptions.headers = {...localVarHeaderParameter, ...headersFromBaseOptions, ...options.headers};
            localVarRequestOptions.data = serializeDataIfNeeded(jsonPatchInner, localVarRequestOptions, configuration)

            return {
                url: toPathString(localVarUrlObj),
                options: localVarRequestOptions,
            };
        },
        /**
         * Update Device
         * @param {string} name Name of device
         * @param {Device} [device] Updated device
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        updateDevice: async (name: string, device?: Device, options: RawAxiosRequestConfig = {}): Promise<RequestArgs> => {
            // verify required parameter 'name' is not null or undefined
            assertParamExists('updateDevice', 'name', name)
            const localVarPath = `/apis/security.halo.run/v1alpha1/devices/{name}`
                .replace(`{${"name"}}`, encodeURIComponent(String(name)));
            // use dummy base URL string because the URL constructor only accepts absolute URLs.
            const localVarUrlObj = new URL(localVarPath, DUMMY_BASE_URL);
            let baseOptions;
            if (configuration) {
                baseOptions = configuration.baseOptions;
            }

            const localVarRequestOptions = { method: 'PUT', ...baseOptions, ...options};
            const localVarHeaderParameter = {} as any;
            const localVarQueryParameter = {} as any;

            // authentication basicAuth required
            // http basic authentication required
            setBasicAuthToObject(localVarRequestOptions, configuration)

            // authentication bearerAuth required
            // http bearer authentication required
            await setBearerAuthToObject(localVarHeaderParameter, configuration)


    
            localVarHeaderParameter['Content-Type'] = 'application/json';

            setSearchParams(localVarUrlObj, localVarQueryParameter);
            let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
            localVarRequestOptions.headers = {...localVarHeaderParameter, ...headersFromBaseOptions, ...options.headers};
            localVarRequestOptions.data = serializeDataIfNeeded(device, localVarRequestOptions, configuration)

            return {
                url: toPathString(localVarUrlObj),
                options: localVarRequestOptions,
            };
        },
    }
};

/**
 * DeviceV1alpha1Api - functional programming interface
 * @export
 */
export const DeviceV1alpha1ApiFp = function(configuration?: Configuration) {
    const localVarAxiosParamCreator = DeviceV1alpha1ApiAxiosParamCreator(configuration)
    return {
        /**
         * Create Device
         * @param {Device} [device] Fresh device
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        async createDevice(device?: Device, options?: RawAxiosRequestConfig): Promise<(axios?: AxiosInstance, basePath?: string) => AxiosPromise<Device>> {
            const localVarAxiosArgs = await localVarAxiosParamCreator.createDevice(device, options);
            const localVarOperationServerIndex = configuration?.serverIndex ?? 0;
            const localVarOperationServerBasePath = operationServerMap['DeviceV1alpha1Api.createDevice']?.[localVarOperationServerIndex]?.url;
            return (axios, basePath) => createRequestFunction(localVarAxiosArgs, globalAxios, BASE_PATH, configuration)(axios, localVarOperationServerBasePath || basePath);
        },
        /**
         * Delete Device
         * @param {string} name Name of device
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        async deleteDevice(name: string, options?: RawAxiosRequestConfig): Promise<(axios?: AxiosInstance, basePath?: string) => AxiosPromise<void>> {
            const localVarAxiosArgs = await localVarAxiosParamCreator.deleteDevice(name, options);
            const localVarOperationServerIndex = configuration?.serverIndex ?? 0;
            const localVarOperationServerBasePath = operationServerMap['DeviceV1alpha1Api.deleteDevice']?.[localVarOperationServerIndex]?.url;
            return (axios, basePath) => createRequestFunction(localVarAxiosArgs, globalAxios, BASE_PATH, configuration)(axios, localVarOperationServerBasePath || basePath);
        },
        /**
         * Get Device
         * @param {string} name Name of device
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        async getDevice(name: string, options?: RawAxiosRequestConfig): Promise<(axios?: AxiosInstance, basePath?: string) => AxiosPromise<Device>> {
            const localVarAxiosArgs = await localVarAxiosParamCreator.getDevice(name, options);
            const localVarOperationServerIndex = configuration?.serverIndex ?? 0;
            const localVarOperationServerBasePath = operationServerMap['DeviceV1alpha1Api.getDevice']?.[localVarOperationServerIndex]?.url;
            return (axios, basePath) => createRequestFunction(localVarAxiosArgs, globalAxios, BASE_PATH, configuration)(axios, localVarOperationServerBasePath || basePath);
        },
        /**
         * List Device
         * @param {number} [page] Page number. Default is 0.
         * @param {number} [size] Size number. Default is 0.
         * @param {Array<string>} [labelSelector] Label selector. e.g.: hidden!&#x3D;true
         * @param {Array<string>} [fieldSelector] Field selector. e.g.: metadata.name&#x3D;&#x3D;halo
         * @param {Array<string>} [sort] Sorting criteria in the format: property,(asc|desc). Default sort order is ascending. Multiple sort criteria are supported.
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        async listDevice(page?: number, size?: number, labelSelector?: Array<string>, fieldSelector?: Array<string>, sort?: Array<string>, options?: RawAxiosRequestConfig): Promise<(axios?: AxiosInstance, basePath?: string) => AxiosPromise<DeviceList>> {
            const localVarAxiosArgs = await localVarAxiosParamCreator.listDevice(page, size, labelSelector, fieldSelector, sort, options);
            const localVarOperationServerIndex = configuration?.serverIndex ?? 0;
            const localVarOperationServerBasePath = operationServerMap['DeviceV1alpha1Api.listDevice']?.[localVarOperationServerIndex]?.url;
            return (axios, basePath) => createRequestFunction(localVarAxiosArgs, globalAxios, BASE_PATH, configuration)(axios, localVarOperationServerBasePath || basePath);
        },
        /**
         * Patch Device
         * @param {string} name Name of device
         * @param {Array<JsonPatchInner>} [jsonPatchInner] 
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        async patchDevice(name: string, jsonPatchInner?: Array<JsonPatchInner>, options?: RawAxiosRequestConfig): Promise<(axios?: AxiosInstance, basePath?: string) => AxiosPromise<Device>> {
            const localVarAxiosArgs = await localVarAxiosParamCreator.patchDevice(name, jsonPatchInner, options);
            const localVarOperationServerIndex = configuration?.serverIndex ?? 0;
            const localVarOperationServerBasePath = operationServerMap['DeviceV1alpha1Api.patchDevice']?.[localVarOperationServerIndex]?.url;
            return (axios, basePath) => createRequestFunction(localVarAxiosArgs, globalAxios, BASE_PATH, configuration)(axios, localVarOperationServerBasePath || basePath);
        },
        /**
         * Update Device
         * @param {string} name Name of device
         * @param {Device} [device] Updated device
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        async updateDevice(name: string, device?: Device, options?: RawAxiosRequestConfig): Promise<(axios?: AxiosInstance, basePath?: string) => AxiosPromise<Device>> {
            const localVarAxiosArgs = await localVarAxiosParamCreator.updateDevice(name, device, options);
            const localVarOperationServerIndex = configuration?.serverIndex ?? 0;
            const localVarOperationServerBasePath = operationServerMap['DeviceV1alpha1Api.updateDevice']?.[localVarOperationServerIndex]?.url;
            return (axios, basePath) => createRequestFunction(localVarAxiosArgs, globalAxios, BASE_PATH, configuration)(axios, localVarOperationServerBasePath || basePath);
        },
    }
};

/**
 * DeviceV1alpha1Api - factory interface
 * @export
 */
export const DeviceV1alpha1ApiFactory = function (configuration?: Configuration, basePath?: string, axios?: AxiosInstance) {
    const localVarFp = DeviceV1alpha1ApiFp(configuration)
    return {
        /**
         * Create Device
         * @param {DeviceV1alpha1ApiCreateDeviceRequest} requestParameters Request parameters.
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        createDevice(requestParameters: DeviceV1alpha1ApiCreateDeviceRequest = {}, options?: RawAxiosRequestConfig): AxiosPromise<Device> {
            return localVarFp.createDevice(requestParameters.device, options).then((request) => request(axios, basePath));
        },
        /**
         * Delete Device
         * @param {DeviceV1alpha1ApiDeleteDeviceRequest} requestParameters Request parameters.
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        deleteDevice(requestParameters: DeviceV1alpha1ApiDeleteDeviceRequest, options?: RawAxiosRequestConfig): AxiosPromise<void> {
            return localVarFp.deleteDevice(requestParameters.name, options).then((request) => request(axios, basePath));
        },
        /**
         * Get Device
         * @param {DeviceV1alpha1ApiGetDeviceRequest} requestParameters Request parameters.
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        getDevice(requestParameters: DeviceV1alpha1ApiGetDeviceRequest, options?: RawAxiosRequestConfig): AxiosPromise<Device> {
            return localVarFp.getDevice(requestParameters.name, options).then((request) => request(axios, basePath));
        },
        /**
         * List Device
         * @param {DeviceV1alpha1ApiListDeviceRequest} requestParameters Request parameters.
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        listDevice(requestParameters: DeviceV1alpha1ApiListDeviceRequest = {}, options?: RawAxiosRequestConfig): AxiosPromise<DeviceList> {
            return localVarFp.listDevice(requestParameters.page, requestParameters.size, requestParameters.labelSelector, requestParameters.fieldSelector, requestParameters.sort, options).then((request) => request(axios, basePath));
        },
        /**
         * Patch Device
         * @param {DeviceV1alpha1ApiPatchDeviceRequest} requestParameters Request parameters.
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        patchDevice(requestParameters: DeviceV1alpha1ApiPatchDeviceRequest, options?: RawAxiosRequestConfig): AxiosPromise<Device> {
            return localVarFp.patchDevice(requestParameters.name, requestParameters.jsonPatchInner, options).then((request) => request(axios, basePath));
        },
        /**
         * Update Device
         * @param {DeviceV1alpha1ApiUpdateDeviceRequest} requestParameters Request parameters.
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        updateDevice(requestParameters: DeviceV1alpha1ApiUpdateDeviceRequest, options?: RawAxiosRequestConfig): AxiosPromise<Device> {
            return localVarFp.updateDevice(requestParameters.name, requestParameters.device, options).then((request) => request(axios, basePath));
        },
    };
};

/**
 * Request parameters for createDevice operation in DeviceV1alpha1Api.
 * @export
 * @interface DeviceV1alpha1ApiCreateDeviceRequest
 */
export interface DeviceV1alpha1ApiCreateDeviceRequest {
    /**
     * Fresh device
     * @type {Device}
     * @memberof DeviceV1alpha1ApiCreateDevice
     */
    readonly device?: Device
}

/**
 * Request parameters for deleteDevice operation in DeviceV1alpha1Api.
 * @export
 * @interface DeviceV1alpha1ApiDeleteDeviceRequest
 */
export interface DeviceV1alpha1ApiDeleteDeviceRequest {
    /**
     * Name of device
     * @type {string}
     * @memberof DeviceV1alpha1ApiDeleteDevice
     */
    readonly name: string
}

/**
 * Request parameters for getDevice operation in DeviceV1alpha1Api.
 * @export
 * @interface DeviceV1alpha1ApiGetDeviceRequest
 */
export interface DeviceV1alpha1ApiGetDeviceRequest {
    /**
     * Name of device
     * @type {string}
     * @memberof DeviceV1alpha1ApiGetDevice
     */
    readonly name: string
}

/**
 * Request parameters for listDevice operation in DeviceV1alpha1Api.
 * @export
 * @interface DeviceV1alpha1ApiListDeviceRequest
 */
export interface DeviceV1alpha1ApiListDeviceRequest {
    /**
     * Page number. Default is 0.
     * @type {number}
     * @memberof DeviceV1alpha1ApiListDevice
     */
    readonly page?: number

    /**
     * Size number. Default is 0.
     * @type {number}
     * @memberof DeviceV1alpha1ApiListDevice
     */
    readonly size?: number

    /**
     * Label selector. e.g.: hidden!&#x3D;true
     * @type {Array<string>}
     * @memberof DeviceV1alpha1ApiListDevice
     */
    readonly labelSelector?: Array<string>

    /**
     * Field selector. e.g.: metadata.name&#x3D;&#x3D;halo
     * @type {Array<string>}
     * @memberof DeviceV1alpha1ApiListDevice
     */
    readonly fieldSelector?: Array<string>

    /**
     * Sorting criteria in the format: property,(asc|desc). Default sort order is ascending. Multiple sort criteria are supported.
     * @type {Array<string>}
     * @memberof DeviceV1alpha1ApiListDevice
     */
    readonly sort?: Array<string>
}

/**
 * Request parameters for patchDevice operation in DeviceV1alpha1Api.
 * @export
 * @interface DeviceV1alpha1ApiPatchDeviceRequest
 */
export interface DeviceV1alpha1ApiPatchDeviceRequest {
    /**
     * Name of device
     * @type {string}
     * @memberof DeviceV1alpha1ApiPatchDevice
     */
    readonly name: string

    /**
     * 
     * @type {Array<JsonPatchInner>}
     * @memberof DeviceV1alpha1ApiPatchDevice
     */
    readonly jsonPatchInner?: Array<JsonPatchInner>
}

/**
 * Request parameters for updateDevice operation in DeviceV1alpha1Api.
 * @export
 * @interface DeviceV1alpha1ApiUpdateDeviceRequest
 */
export interface DeviceV1alpha1ApiUpdateDeviceRequest {
    /**
     * Name of device
     * @type {string}
     * @memberof DeviceV1alpha1ApiUpdateDevice
     */
    readonly name: string

    /**
     * Updated device
     * @type {Device}
     * @memberof DeviceV1alpha1ApiUpdateDevice
     */
    readonly device?: Device
}

/**
 * DeviceV1alpha1Api - object-oriented interface
 * @export
 * @class DeviceV1alpha1Api
 * @extends {BaseAPI}
 */
export class DeviceV1alpha1Api extends BaseAPI {
    /**
     * Create Device
     * @param {DeviceV1alpha1ApiCreateDeviceRequest} requestParameters Request parameters.
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof DeviceV1alpha1Api
     */
    public createDevice(requestParameters: DeviceV1alpha1ApiCreateDeviceRequest = {}, options?: RawAxiosRequestConfig) {
        return DeviceV1alpha1ApiFp(this.configuration).createDevice(requestParameters.device, options).then((request) => request(this.axios, this.basePath));
    }

    /**
     * Delete Device
     * @param {DeviceV1alpha1ApiDeleteDeviceRequest} requestParameters Request parameters.
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof DeviceV1alpha1Api
     */
    public deleteDevice(requestParameters: DeviceV1alpha1ApiDeleteDeviceRequest, options?: RawAxiosRequestConfig) {
        return DeviceV1alpha1ApiFp(this.configuration).deleteDevice(requestParameters.name, options).then((request) => request(this.axios, this.basePath));
    }

    /**
     * Get Device
     * @param {DeviceV1alpha1ApiGetDeviceRequest} requestParameters Request parameters.
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof DeviceV1alpha1Api
     */
    public getDevice(requestParameters: DeviceV1alpha1ApiGetDeviceRequest, options?: RawAxiosRequestConfig) {
        return DeviceV1alpha1ApiFp(this.configuration).getDevice(requestParameters.name, options).then((request) => request(this.axios, this.basePath));
    }

    /**
     * List Device
     * @param {DeviceV1alpha1ApiListDeviceRequest} requestParameters Request parameters.
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof DeviceV1alpha1Api
     */
    public listDevice(requestParameters: DeviceV1alpha1ApiListDeviceRequest = {}, options?: RawAxiosRequestConfig) {
        return DeviceV1alpha1ApiFp(this.configuration).listDevice(requestParameters.page, requestParameters.size, requestParameters.labelSelector, requestParameters.fieldSelector, requestParameters.sort, options).then((request) => request(this.axios, this.basePath));
    }

    /**
     * Patch Device
     * @param {DeviceV1alpha1ApiPatchDeviceRequest} requestParameters Request parameters.
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof DeviceV1alpha1Api
     */
    public patchDevice(requestParameters: DeviceV1alpha1ApiPatchDeviceRequest, options?: RawAxiosRequestConfig) {
        return DeviceV1alpha1ApiFp(this.configuration).patchDevice(requestParameters.name, requestParameters.jsonPatchInner, options).then((request) => request(this.axios, this.basePath));
    }

    /**
     * Update Device
     * @param {DeviceV1alpha1ApiUpdateDeviceRequest} requestParameters Request parameters.
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof DeviceV1alpha1Api
     */
    public updateDevice(requestParameters: DeviceV1alpha1ApiUpdateDeviceRequest, options?: RawAxiosRequestConfig) {
        return DeviceV1alpha1ApiFp(this.configuration).updateDevice(requestParameters.name, requestParameters.device, options).then((request) => request(this.axios, this.basePath));
    }
}

