/* tslint:disable */
/* eslint-disable */
/**
 * Halo
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: 2.20.10-SNAPSHOT
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


import type { Configuration } from '../configuration';
import type { AxiosPromise, AxiosInstance, RawAxiosRequestConfig } from 'axios';
import globalAxios from 'axios';
// Some imports not used depending on template conditions
// @ts-ignore
import { DUMMY_BASE_URL, assertParamExists, setApiKeyToObject, setBasicAuthToObject, setBearerAuthToObject, setOAuthToObject, setSearchParams, serializeDataIfNeeded, toPathString, createRequestFunction } from '../common';
// @ts-ignore
import { BASE_PATH, COLLECTION_FORMATS, RequestArgs, BaseAPI, RequiredError, operationServerMap } from '../base';
// @ts-ignore
import { JsonPatchInner } from '../models';
// @ts-ignore
import { Menu } from '../models';
// @ts-ignore
import { MenuList } from '../models';
/**
 * MenuV1alpha1Api - axios parameter creator
 * @export
 */
export const MenuV1alpha1ApiAxiosParamCreator = function (configuration?: Configuration) {
    return {
        /**
         * Create Menu
         * @param {Menu} [menu] Fresh menu
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        createMenu: async (menu?: Menu, options: RawAxiosRequestConfig = {}): Promise<RequestArgs> => {
            const localVarPath = `/api/v1alpha1/menus`;
            // use dummy base URL string because the URL constructor only accepts absolute URLs.
            const localVarUrlObj = new URL(localVarPath, DUMMY_BASE_URL);
            let baseOptions;
            if (configuration) {
                baseOptions = configuration.baseOptions;
            }

            const localVarRequestOptions = { method: 'POST', ...baseOptions, ...options};
            const localVarHeaderParameter = {} as any;
            const localVarQueryParameter = {} as any;

            // authentication basicAuth required
            // http basic authentication required
            setBasicAuthToObject(localVarRequestOptions, configuration)

            // authentication bearerAuth required
            // http bearer authentication required
            await setBearerAuthToObject(localVarHeaderParameter, configuration)


    
            localVarHeaderParameter['Content-Type'] = 'application/json';

            setSearchParams(localVarUrlObj, localVarQueryParameter);
            let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
            localVarRequestOptions.headers = {...localVarHeaderParameter, ...headersFromBaseOptions, ...options.headers};
            localVarRequestOptions.data = serializeDataIfNeeded(menu, localVarRequestOptions, configuration)

            return {
                url: toPathString(localVarUrlObj),
                options: localVarRequestOptions,
            };
        },
        /**
         * Delete Menu
         * @param {string} name Name of menu
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        deleteMenu: async (name: string, options: RawAxiosRequestConfig = {}): Promise<RequestArgs> => {
            // verify required parameter 'name' is not null or undefined
            assertParamExists('deleteMenu', 'name', name)
            const localVarPath = `/api/v1alpha1/menus/{name}`
                .replace(`{${"name"}}`, encodeURIComponent(String(name)));
            // use dummy base URL string because the URL constructor only accepts absolute URLs.
            const localVarUrlObj = new URL(localVarPath, DUMMY_BASE_URL);
            let baseOptions;
            if (configuration) {
                baseOptions = configuration.baseOptions;
            }

            const localVarRequestOptions = { method: 'DELETE', ...baseOptions, ...options};
            const localVarHeaderParameter = {} as any;
            const localVarQueryParameter = {} as any;

            // authentication basicAuth required
            // http basic authentication required
            setBasicAuthToObject(localVarRequestOptions, configuration)

            // authentication bearerAuth required
            // http bearer authentication required
            await setBearerAuthToObject(localVarHeaderParameter, configuration)


    
            setSearchParams(localVarUrlObj, localVarQueryParameter);
            let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
            localVarRequestOptions.headers = {...localVarHeaderParameter, ...headersFromBaseOptions, ...options.headers};

            return {
                url: toPathString(localVarUrlObj),
                options: localVarRequestOptions,
            };
        },
        /**
         * Get Menu
         * @param {string} name Name of menu
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        getMenu: async (name: string, options: RawAxiosRequestConfig = {}): Promise<RequestArgs> => {
            // verify required parameter 'name' is not null or undefined
            assertParamExists('getMenu', 'name', name)
            const localVarPath = `/api/v1alpha1/menus/{name}`
                .replace(`{${"name"}}`, encodeURIComponent(String(name)));
            // use dummy base URL string because the URL constructor only accepts absolute URLs.
            const localVarUrlObj = new URL(localVarPath, DUMMY_BASE_URL);
            let baseOptions;
            if (configuration) {
                baseOptions = configuration.baseOptions;
            }

            const localVarRequestOptions = { method: 'GET', ...baseOptions, ...options};
            const localVarHeaderParameter = {} as any;
            const localVarQueryParameter = {} as any;

            // authentication basicAuth required
            // http basic authentication required
            setBasicAuthToObject(localVarRequestOptions, configuration)

            // authentication bearerAuth required
            // http bearer authentication required
            await setBearerAuthToObject(localVarHeaderParameter, configuration)


    
            setSearchParams(localVarUrlObj, localVarQueryParameter);
            let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
            localVarRequestOptions.headers = {...localVarHeaderParameter, ...headersFromBaseOptions, ...options.headers};

            return {
                url: toPathString(localVarUrlObj),
                options: localVarRequestOptions,
            };
        },
        /**
         * List Menu
         * @param {number} [page] Page number. Default is 0.
         * @param {number} [size] Size number. Default is 0.
         * @param {Array<string>} [labelSelector] Label selector. e.g.: hidden!&#x3D;true
         * @param {Array<string>} [fieldSelector] Field selector. e.g.: metadata.name&#x3D;&#x3D;halo
         * @param {Array<string>} [sort] Sorting criteria in the format: property,(asc|desc). Default sort order is ascending. Multiple sort criteria are supported.
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        listMenu: async (page?: number, size?: number, labelSelector?: Array<string>, fieldSelector?: Array<string>, sort?: Array<string>, options: RawAxiosRequestConfig = {}): Promise<RequestArgs> => {
            const localVarPath = `/api/v1alpha1/menus`;
            // use dummy base URL string because the URL constructor only accepts absolute URLs.
            const localVarUrlObj = new URL(localVarPath, DUMMY_BASE_URL);
            let baseOptions;
            if (configuration) {
                baseOptions = configuration.baseOptions;
            }

            const localVarRequestOptions = { method: 'GET', ...baseOptions, ...options};
            const localVarHeaderParameter = {} as any;
            const localVarQueryParameter = {} as any;

            // authentication basicAuth required
            // http basic authentication required
            setBasicAuthToObject(localVarRequestOptions, configuration)

            // authentication bearerAuth required
            // http bearer authentication required
            await setBearerAuthToObject(localVarHeaderParameter, configuration)

            if (page !== undefined) {
                localVarQueryParameter['page'] = page;
            }

            if (size !== undefined) {
                localVarQueryParameter['size'] = size;
            }

            if (labelSelector) {
                localVarQueryParameter['labelSelector'] = labelSelector;
            }

            if (fieldSelector) {
                localVarQueryParameter['fieldSelector'] = fieldSelector;
            }

            if (sort) {
                localVarQueryParameter['sort'] = sort;
            }


    
            setSearchParams(localVarUrlObj, localVarQueryParameter);
            let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
            localVarRequestOptions.headers = {...localVarHeaderParameter, ...headersFromBaseOptions, ...options.headers};

            return {
                url: toPathString(localVarUrlObj),
                options: localVarRequestOptions,
            };
        },
        /**
         * Patch Menu
         * @param {string} name Name of menu
         * @param {Array<JsonPatchInner>} [jsonPatchInner] 
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        patchMenu: async (name: string, jsonPatchInner?: Array<JsonPatchInner>, options: RawAxiosRequestConfig = {}): Promise<RequestArgs> => {
            // verify required parameter 'name' is not null or undefined
            assertParamExists('patchMenu', 'name', name)
            const localVarPath = `/api/v1alpha1/menus/{name}`
                .replace(`{${"name"}}`, encodeURIComponent(String(name)));
            // use dummy base URL string because the URL constructor only accepts absolute URLs.
            const localVarUrlObj = new URL(localVarPath, DUMMY_BASE_URL);
            let baseOptions;
            if (configuration) {
                baseOptions = configuration.baseOptions;
            }

            const localVarRequestOptions = { method: 'PATCH', ...baseOptions, ...options};
            const localVarHeaderParameter = {} as any;
            const localVarQueryParameter = {} as any;

            // authentication basicAuth required
            // http basic authentication required
            setBasicAuthToObject(localVarRequestOptions, configuration)

            // authentication bearerAuth required
            // http bearer authentication required
            await setBearerAuthToObject(localVarHeaderParameter, configuration)


    
            localVarHeaderParameter['Content-Type'] = 'application/json-patch+json';

            setSearchParams(localVarUrlObj, localVarQueryParameter);
            let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
            localVarRequestOptions.headers = {...localVarHeaderParameter, ...headersFromBaseOptions, ...options.headers};
            localVarRequestOptions.data = serializeDataIfNeeded(jsonPatchInner, localVarRequestOptions, configuration)

            return {
                url: toPathString(localVarUrlObj),
                options: localVarRequestOptions,
            };
        },
        /**
         * Update Menu
         * @param {string} name Name of menu
         * @param {Menu} [menu] Updated menu
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        updateMenu: async (name: string, menu?: Menu, options: RawAxiosRequestConfig = {}): Promise<RequestArgs> => {
            // verify required parameter 'name' is not null or undefined
            assertParamExists('updateMenu', 'name', name)
            const localVarPath = `/api/v1alpha1/menus/{name}`
                .replace(`{${"name"}}`, encodeURIComponent(String(name)));
            // use dummy base URL string because the URL constructor only accepts absolute URLs.
            const localVarUrlObj = new URL(localVarPath, DUMMY_BASE_URL);
            let baseOptions;
            if (configuration) {
                baseOptions = configuration.baseOptions;
            }

            const localVarRequestOptions = { method: 'PUT', ...baseOptions, ...options};
            const localVarHeaderParameter = {} as any;
            const localVarQueryParameter = {} as any;

            // authentication basicAuth required
            // http basic authentication required
            setBasicAuthToObject(localVarRequestOptions, configuration)

            // authentication bearerAuth required
            // http bearer authentication required
            await setBearerAuthToObject(localVarHeaderParameter, configuration)


    
            localVarHeaderParameter['Content-Type'] = 'application/json';

            setSearchParams(localVarUrlObj, localVarQueryParameter);
            let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
            localVarRequestOptions.headers = {...localVarHeaderParameter, ...headersFromBaseOptions, ...options.headers};
            localVarRequestOptions.data = serializeDataIfNeeded(menu, localVarRequestOptions, configuration)

            return {
                url: toPathString(localVarUrlObj),
                options: localVarRequestOptions,
            };
        },
    }
};

/**
 * MenuV1alpha1Api - functional programming interface
 * @export
 */
export const MenuV1alpha1ApiFp = function(configuration?: Configuration) {
    const localVarAxiosParamCreator = MenuV1alpha1ApiAxiosParamCreator(configuration)
    return {
        /**
         * Create Menu
         * @param {Menu} [menu] Fresh menu
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        async createMenu(menu?: Menu, options?: RawAxiosRequestConfig): Promise<(axios?: AxiosInstance, basePath?: string) => AxiosPromise<Menu>> {
            const localVarAxiosArgs = await localVarAxiosParamCreator.createMenu(menu, options);
            const localVarOperationServerIndex = configuration?.serverIndex ?? 0;
            const localVarOperationServerBasePath = operationServerMap['MenuV1alpha1Api.createMenu']?.[localVarOperationServerIndex]?.url;
            return (axios, basePath) => createRequestFunction(localVarAxiosArgs, globalAxios, BASE_PATH, configuration)(axios, localVarOperationServerBasePath || basePath);
        },
        /**
         * Delete Menu
         * @param {string} name Name of menu
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        async deleteMenu(name: string, options?: RawAxiosRequestConfig): Promise<(axios?: AxiosInstance, basePath?: string) => AxiosPromise<void>> {
            const localVarAxiosArgs = await localVarAxiosParamCreator.deleteMenu(name, options);
            const localVarOperationServerIndex = configuration?.serverIndex ?? 0;
            const localVarOperationServerBasePath = operationServerMap['MenuV1alpha1Api.deleteMenu']?.[localVarOperationServerIndex]?.url;
            return (axios, basePath) => createRequestFunction(localVarAxiosArgs, globalAxios, BASE_PATH, configuration)(axios, localVarOperationServerBasePath || basePath);
        },
        /**
         * Get Menu
         * @param {string} name Name of menu
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        async getMenu(name: string, options?: RawAxiosRequestConfig): Promise<(axios?: AxiosInstance, basePath?: string) => AxiosPromise<Menu>> {
            const localVarAxiosArgs = await localVarAxiosParamCreator.getMenu(name, options);
            const localVarOperationServerIndex = configuration?.serverIndex ?? 0;
            const localVarOperationServerBasePath = operationServerMap['MenuV1alpha1Api.getMenu']?.[localVarOperationServerIndex]?.url;
            return (axios, basePath) => createRequestFunction(localVarAxiosArgs, globalAxios, BASE_PATH, configuration)(axios, localVarOperationServerBasePath || basePath);
        },
        /**
         * List Menu
         * @param {number} [page] Page number. Default is 0.
         * @param {number} [size] Size number. Default is 0.
         * @param {Array<string>} [labelSelector] Label selector. e.g.: hidden!&#x3D;true
         * @param {Array<string>} [fieldSelector] Field selector. e.g.: metadata.name&#x3D;&#x3D;halo
         * @param {Array<string>} [sort] Sorting criteria in the format: property,(asc|desc). Default sort order is ascending. Multiple sort criteria are supported.
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        async listMenu(page?: number, size?: number, labelSelector?: Array<string>, fieldSelector?: Array<string>, sort?: Array<string>, options?: RawAxiosRequestConfig): Promise<(axios?: AxiosInstance, basePath?: string) => AxiosPromise<MenuList>> {
            const localVarAxiosArgs = await localVarAxiosParamCreator.listMenu(page, size, labelSelector, fieldSelector, sort, options);
            const localVarOperationServerIndex = configuration?.serverIndex ?? 0;
            const localVarOperationServerBasePath = operationServerMap['MenuV1alpha1Api.listMenu']?.[localVarOperationServerIndex]?.url;
            return (axios, basePath) => createRequestFunction(localVarAxiosArgs, globalAxios, BASE_PATH, configuration)(axios, localVarOperationServerBasePath || basePath);
        },
        /**
         * Patch Menu
         * @param {string} name Name of menu
         * @param {Array<JsonPatchInner>} [jsonPatchInner] 
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        async patchMenu(name: string, jsonPatchInner?: Array<JsonPatchInner>, options?: RawAxiosRequestConfig): Promise<(axios?: AxiosInstance, basePath?: string) => AxiosPromise<Menu>> {
            const localVarAxiosArgs = await localVarAxiosParamCreator.patchMenu(name, jsonPatchInner, options);
            const localVarOperationServerIndex = configuration?.serverIndex ?? 0;
            const localVarOperationServerBasePath = operationServerMap['MenuV1alpha1Api.patchMenu']?.[localVarOperationServerIndex]?.url;
            return (axios, basePath) => createRequestFunction(localVarAxiosArgs, globalAxios, BASE_PATH, configuration)(axios, localVarOperationServerBasePath || basePath);
        },
        /**
         * Update Menu
         * @param {string} name Name of menu
         * @param {Menu} [menu] Updated menu
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        async updateMenu(name: string, menu?: Menu, options?: RawAxiosRequestConfig): Promise<(axios?: AxiosInstance, basePath?: string) => AxiosPromise<Menu>> {
            const localVarAxiosArgs = await localVarAxiosParamCreator.updateMenu(name, menu, options);
            const localVarOperationServerIndex = configuration?.serverIndex ?? 0;
            const localVarOperationServerBasePath = operationServerMap['MenuV1alpha1Api.updateMenu']?.[localVarOperationServerIndex]?.url;
            return (axios, basePath) => createRequestFunction(localVarAxiosArgs, globalAxios, BASE_PATH, configuration)(axios, localVarOperationServerBasePath || basePath);
        },
    }
};

/**
 * MenuV1alpha1Api - factory interface
 * @export
 */
export const MenuV1alpha1ApiFactory = function (configuration?: Configuration, basePath?: string, axios?: AxiosInstance) {
    const localVarFp = MenuV1alpha1ApiFp(configuration)
    return {
        /**
         * Create Menu
         * @param {MenuV1alpha1ApiCreateMenuRequest} requestParameters Request parameters.
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        createMenu(requestParameters: MenuV1alpha1ApiCreateMenuRequest = {}, options?: RawAxiosRequestConfig): AxiosPromise<Menu> {
            return localVarFp.createMenu(requestParameters.menu, options).then((request) => request(axios, basePath));
        },
        /**
         * Delete Menu
         * @param {MenuV1alpha1ApiDeleteMenuRequest} requestParameters Request parameters.
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        deleteMenu(requestParameters: MenuV1alpha1ApiDeleteMenuRequest, options?: RawAxiosRequestConfig): AxiosPromise<void> {
            return localVarFp.deleteMenu(requestParameters.name, options).then((request) => request(axios, basePath));
        },
        /**
         * Get Menu
         * @param {MenuV1alpha1ApiGetMenuRequest} requestParameters Request parameters.
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        getMenu(requestParameters: MenuV1alpha1ApiGetMenuRequest, options?: RawAxiosRequestConfig): AxiosPromise<Menu> {
            return localVarFp.getMenu(requestParameters.name, options).then((request) => request(axios, basePath));
        },
        /**
         * List Menu
         * @param {MenuV1alpha1ApiListMenuRequest} requestParameters Request parameters.
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        listMenu(requestParameters: MenuV1alpha1ApiListMenuRequest = {}, options?: RawAxiosRequestConfig): AxiosPromise<MenuList> {
            return localVarFp.listMenu(requestParameters.page, requestParameters.size, requestParameters.labelSelector, requestParameters.fieldSelector, requestParameters.sort, options).then((request) => request(axios, basePath));
        },
        /**
         * Patch Menu
         * @param {MenuV1alpha1ApiPatchMenuRequest} requestParameters Request parameters.
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        patchMenu(requestParameters: MenuV1alpha1ApiPatchMenuRequest, options?: RawAxiosRequestConfig): AxiosPromise<Menu> {
            return localVarFp.patchMenu(requestParameters.name, requestParameters.jsonPatchInner, options).then((request) => request(axios, basePath));
        },
        /**
         * Update Menu
         * @param {MenuV1alpha1ApiUpdateMenuRequest} requestParameters Request parameters.
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        updateMenu(requestParameters: MenuV1alpha1ApiUpdateMenuRequest, options?: RawAxiosRequestConfig): AxiosPromise<Menu> {
            return localVarFp.updateMenu(requestParameters.name, requestParameters.menu, options).then((request) => request(axios, basePath));
        },
    };
};

/**
 * Request parameters for createMenu operation in MenuV1alpha1Api.
 * @export
 * @interface MenuV1alpha1ApiCreateMenuRequest
 */
export interface MenuV1alpha1ApiCreateMenuRequest {
    /**
     * Fresh menu
     * @type {Menu}
     * @memberof MenuV1alpha1ApiCreateMenu
     */
    readonly menu?: Menu
}

/**
 * Request parameters for deleteMenu operation in MenuV1alpha1Api.
 * @export
 * @interface MenuV1alpha1ApiDeleteMenuRequest
 */
export interface MenuV1alpha1ApiDeleteMenuRequest {
    /**
     * Name of menu
     * @type {string}
     * @memberof MenuV1alpha1ApiDeleteMenu
     */
    readonly name: string
}

/**
 * Request parameters for getMenu operation in MenuV1alpha1Api.
 * @export
 * @interface MenuV1alpha1ApiGetMenuRequest
 */
export interface MenuV1alpha1ApiGetMenuRequest {
    /**
     * Name of menu
     * @type {string}
     * @memberof MenuV1alpha1ApiGetMenu
     */
    readonly name: string
}

/**
 * Request parameters for listMenu operation in MenuV1alpha1Api.
 * @export
 * @interface MenuV1alpha1ApiListMenuRequest
 */
export interface MenuV1alpha1ApiListMenuRequest {
    /**
     * Page number. Default is 0.
     * @type {number}
     * @memberof MenuV1alpha1ApiListMenu
     */
    readonly page?: number

    /**
     * Size number. Default is 0.
     * @type {number}
     * @memberof MenuV1alpha1ApiListMenu
     */
    readonly size?: number

    /**
     * Label selector. e.g.: hidden!&#x3D;true
     * @type {Array<string>}
     * @memberof MenuV1alpha1ApiListMenu
     */
    readonly labelSelector?: Array<string>

    /**
     * Field selector. e.g.: metadata.name&#x3D;&#x3D;halo
     * @type {Array<string>}
     * @memberof MenuV1alpha1ApiListMenu
     */
    readonly fieldSelector?: Array<string>

    /**
     * Sorting criteria in the format: property,(asc|desc). Default sort order is ascending. Multiple sort criteria are supported.
     * @type {Array<string>}
     * @memberof MenuV1alpha1ApiListMenu
     */
    readonly sort?: Array<string>
}

/**
 * Request parameters for patchMenu operation in MenuV1alpha1Api.
 * @export
 * @interface MenuV1alpha1ApiPatchMenuRequest
 */
export interface MenuV1alpha1ApiPatchMenuRequest {
    /**
     * Name of menu
     * @type {string}
     * @memberof MenuV1alpha1ApiPatchMenu
     */
    readonly name: string

    /**
     * 
     * @type {Array<JsonPatchInner>}
     * @memberof MenuV1alpha1ApiPatchMenu
     */
    readonly jsonPatchInner?: Array<JsonPatchInner>
}

/**
 * Request parameters for updateMenu operation in MenuV1alpha1Api.
 * @export
 * @interface MenuV1alpha1ApiUpdateMenuRequest
 */
export interface MenuV1alpha1ApiUpdateMenuRequest {
    /**
     * Name of menu
     * @type {string}
     * @memberof MenuV1alpha1ApiUpdateMenu
     */
    readonly name: string

    /**
     * Updated menu
     * @type {Menu}
     * @memberof MenuV1alpha1ApiUpdateMenu
     */
    readonly menu?: Menu
}

/**
 * MenuV1alpha1Api - object-oriented interface
 * @export
 * @class MenuV1alpha1Api
 * @extends {BaseAPI}
 */
export class MenuV1alpha1Api extends BaseAPI {
    /**
     * Create Menu
     * @param {MenuV1alpha1ApiCreateMenuRequest} requestParameters Request parameters.
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof MenuV1alpha1Api
     */
    public createMenu(requestParameters: MenuV1alpha1ApiCreateMenuRequest = {}, options?: RawAxiosRequestConfig) {
        return MenuV1alpha1ApiFp(this.configuration).createMenu(requestParameters.menu, options).then((request) => request(this.axios, this.basePath));
    }

    /**
     * Delete Menu
     * @param {MenuV1alpha1ApiDeleteMenuRequest} requestParameters Request parameters.
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof MenuV1alpha1Api
     */
    public deleteMenu(requestParameters: MenuV1alpha1ApiDeleteMenuRequest, options?: RawAxiosRequestConfig) {
        return MenuV1alpha1ApiFp(this.configuration).deleteMenu(requestParameters.name, options).then((request) => request(this.axios, this.basePath));
    }

    /**
     * Get Menu
     * @param {MenuV1alpha1ApiGetMenuRequest} requestParameters Request parameters.
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof MenuV1alpha1Api
     */
    public getMenu(requestParameters: MenuV1alpha1ApiGetMenuRequest, options?: RawAxiosRequestConfig) {
        return MenuV1alpha1ApiFp(this.configuration).getMenu(requestParameters.name, options).then((request) => request(this.axios, this.basePath));
    }

    /**
     * List Menu
     * @param {MenuV1alpha1ApiListMenuRequest} requestParameters Request parameters.
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof MenuV1alpha1Api
     */
    public listMenu(requestParameters: MenuV1alpha1ApiListMenuRequest = {}, options?: RawAxiosRequestConfig) {
        return MenuV1alpha1ApiFp(this.configuration).listMenu(requestParameters.page, requestParameters.size, requestParameters.labelSelector, requestParameters.fieldSelector, requestParameters.sort, options).then((request) => request(this.axios, this.basePath));
    }

    /**
     * Patch Menu
     * @param {MenuV1alpha1ApiPatchMenuRequest} requestParameters Request parameters.
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof MenuV1alpha1Api
     */
    public patchMenu(requestParameters: MenuV1alpha1ApiPatchMenuRequest, options?: RawAxiosRequestConfig) {
        return MenuV1alpha1ApiFp(this.configuration).patchMenu(requestParameters.name, requestParameters.jsonPatchInner, options).then((request) => request(this.axios, this.basePath));
    }

    /**
     * Update Menu
     * @param {MenuV1alpha1ApiUpdateMenuRequest} requestParameters Request parameters.
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof MenuV1alpha1Api
     */
    public updateMenu(requestParameters: MenuV1alpha1ApiUpdateMenuRequest, options?: RawAxiosRequestConfig) {
        return MenuV1alpha1ApiFp(this.configuration).updateMenu(requestParameters.name, requestParameters.menu, options).then((request) => request(this.axios, this.basePath));
    }
}

