/* tslint:disable */
/* eslint-disable */
/**
 * Halo
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: 2.20.10-SNAPSHOT
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


import type { Configuration } from '../configuration';
import type { AxiosPromise, AxiosInstance, RawAxiosRequestConfig } from 'axios';
import globalAxios from 'axios';
// Some imports not used depending on template conditions
// @ts-ignore
import { DUMMY_BASE_URL, assertParamExists, setApiKeyToObject, setBasicAuthToObject, setBearerAuthToObject, setOAuthToObject, setSearchParams, serializeDataIfNeeded, toPathString, createRequestFunction } from '../common';
// @ts-ignore
import { BASE_PATH, COLLECTION_FORMATS, RequestArgs, BaseAPI, RequiredError, operationServerMap } from '../base';
// @ts-ignore
import { JsonPatchInner } from '../models';
// @ts-ignore
import { Notification } from '../models';
// @ts-ignore
import { NotificationList } from '../models';
/**
 * NotificationV1alpha1Api - axios parameter creator
 * @export
 */
export const NotificationV1alpha1ApiAxiosParamCreator = function (configuration?: Configuration) {
    return {
        /**
         * Create Notification
         * @param {Notification} [notification] Fresh notification
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        createNotification: async (notification?: Notification, options: RawAxiosRequestConfig = {}): Promise<RequestArgs> => {
            const localVarPath = `/apis/notification.halo.run/v1alpha1/notifications`;
            // use dummy base URL string because the URL constructor only accepts absolute URLs.
            const localVarUrlObj = new URL(localVarPath, DUMMY_BASE_URL);
            let baseOptions;
            if (configuration) {
                baseOptions = configuration.baseOptions;
            }

            const localVarRequestOptions = { method: 'POST', ...baseOptions, ...options};
            const localVarHeaderParameter = {} as any;
            const localVarQueryParameter = {} as any;

            // authentication basicAuth required
            // http basic authentication required
            setBasicAuthToObject(localVarRequestOptions, configuration)

            // authentication bearerAuth required
            // http bearer authentication required
            await setBearerAuthToObject(localVarHeaderParameter, configuration)


    
            localVarHeaderParameter['Content-Type'] = 'application/json';

            setSearchParams(localVarUrlObj, localVarQueryParameter);
            let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
            localVarRequestOptions.headers = {...localVarHeaderParameter, ...headersFromBaseOptions, ...options.headers};
            localVarRequestOptions.data = serializeDataIfNeeded(notification, localVarRequestOptions, configuration)

            return {
                url: toPathString(localVarUrlObj),
                options: localVarRequestOptions,
            };
        },
        /**
         * Delete Notification
         * @param {string} name Name of notification
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        deleteNotification: async (name: string, options: RawAxiosRequestConfig = {}): Promise<RequestArgs> => {
            // verify required parameter 'name' is not null or undefined
            assertParamExists('deleteNotification', 'name', name)
            const localVarPath = `/apis/notification.halo.run/v1alpha1/notifications/{name}`
                .replace(`{${"name"}}`, encodeURIComponent(String(name)));
            // use dummy base URL string because the URL constructor only accepts absolute URLs.
            const localVarUrlObj = new URL(localVarPath, DUMMY_BASE_URL);
            let baseOptions;
            if (configuration) {
                baseOptions = configuration.baseOptions;
            }

            const localVarRequestOptions = { method: 'DELETE', ...baseOptions, ...options};
            const localVarHeaderParameter = {} as any;
            const localVarQueryParameter = {} as any;

            // authentication basicAuth required
            // http basic authentication required
            setBasicAuthToObject(localVarRequestOptions, configuration)

            // authentication bearerAuth required
            // http bearer authentication required
            await setBearerAuthToObject(localVarHeaderParameter, configuration)


    
            setSearchParams(localVarUrlObj, localVarQueryParameter);
            let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
            localVarRequestOptions.headers = {...localVarHeaderParameter, ...headersFromBaseOptions, ...options.headers};

            return {
                url: toPathString(localVarUrlObj),
                options: localVarRequestOptions,
            };
        },
        /**
         * Get Notification
         * @param {string} name Name of notification
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        getNotification: async (name: string, options: RawAxiosRequestConfig = {}): Promise<RequestArgs> => {
            // verify required parameter 'name' is not null or undefined
            assertParamExists('getNotification', 'name', name)
            const localVarPath = `/apis/notification.halo.run/v1alpha1/notifications/{name}`
                .replace(`{${"name"}}`, encodeURIComponent(String(name)));
            // use dummy base URL string because the URL constructor only accepts absolute URLs.
            const localVarUrlObj = new URL(localVarPath, DUMMY_BASE_URL);
            let baseOptions;
            if (configuration) {
                baseOptions = configuration.baseOptions;
            }

            const localVarRequestOptions = { method: 'GET', ...baseOptions, ...options};
            const localVarHeaderParameter = {} as any;
            const localVarQueryParameter = {} as any;

            // authentication basicAuth required
            // http basic authentication required
            setBasicAuthToObject(localVarRequestOptions, configuration)

            // authentication bearerAuth required
            // http bearer authentication required
            await setBearerAuthToObject(localVarHeaderParameter, configuration)


    
            setSearchParams(localVarUrlObj, localVarQueryParameter);
            let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
            localVarRequestOptions.headers = {...localVarHeaderParameter, ...headersFromBaseOptions, ...options.headers};

            return {
                url: toPathString(localVarUrlObj),
                options: localVarRequestOptions,
            };
        },
        /**
         * List Notification
         * @param {number} [page] Page number. Default is 0.
         * @param {number} [size] Size number. Default is 0.
         * @param {Array<string>} [labelSelector] Label selector. e.g.: hidden!&#x3D;true
         * @param {Array<string>} [fieldSelector] Field selector. e.g.: metadata.name&#x3D;&#x3D;halo
         * @param {Array<string>} [sort] Sorting criteria in the format: property,(asc|desc). Default sort order is ascending. Multiple sort criteria are supported.
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        listNotification: async (page?: number, size?: number, labelSelector?: Array<string>, fieldSelector?: Array<string>, sort?: Array<string>, options: RawAxiosRequestConfig = {}): Promise<RequestArgs> => {
            const localVarPath = `/apis/notification.halo.run/v1alpha1/notifications`;
            // use dummy base URL string because the URL constructor only accepts absolute URLs.
            const localVarUrlObj = new URL(localVarPath, DUMMY_BASE_URL);
            let baseOptions;
            if (configuration) {
                baseOptions = configuration.baseOptions;
            }

            const localVarRequestOptions = { method: 'GET', ...baseOptions, ...options};
            const localVarHeaderParameter = {} as any;
            const localVarQueryParameter = {} as any;

            // authentication basicAuth required
            // http basic authentication required
            setBasicAuthToObject(localVarRequestOptions, configuration)

            // authentication bearerAuth required
            // http bearer authentication required
            await setBearerAuthToObject(localVarHeaderParameter, configuration)

            if (page !== undefined) {
                localVarQueryParameter['page'] = page;
            }

            if (size !== undefined) {
                localVarQueryParameter['size'] = size;
            }

            if (labelSelector) {
                localVarQueryParameter['labelSelector'] = labelSelector;
            }

            if (fieldSelector) {
                localVarQueryParameter['fieldSelector'] = fieldSelector;
            }

            if (sort) {
                localVarQueryParameter['sort'] = sort;
            }


    
            setSearchParams(localVarUrlObj, localVarQueryParameter);
            let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
            localVarRequestOptions.headers = {...localVarHeaderParameter, ...headersFromBaseOptions, ...options.headers};

            return {
                url: toPathString(localVarUrlObj),
                options: localVarRequestOptions,
            };
        },
        /**
         * Patch Notification
         * @param {string} name Name of notification
         * @param {Array<JsonPatchInner>} [jsonPatchInner] 
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        patchNotification: async (name: string, jsonPatchInner?: Array<JsonPatchInner>, options: RawAxiosRequestConfig = {}): Promise<RequestArgs> => {
            // verify required parameter 'name' is not null or undefined
            assertParamExists('patchNotification', 'name', name)
            const localVarPath = `/apis/notification.halo.run/v1alpha1/notifications/{name}`
                .replace(`{${"name"}}`, encodeURIComponent(String(name)));
            // use dummy base URL string because the URL constructor only accepts absolute URLs.
            const localVarUrlObj = new URL(localVarPath, DUMMY_BASE_URL);
            let baseOptions;
            if (configuration) {
                baseOptions = configuration.baseOptions;
            }

            const localVarRequestOptions = { method: 'PATCH', ...baseOptions, ...options};
            const localVarHeaderParameter = {} as any;
            const localVarQueryParameter = {} as any;

            // authentication basicAuth required
            // http basic authentication required
            setBasicAuthToObject(localVarRequestOptions, configuration)

            // authentication bearerAuth required
            // http bearer authentication required
            await setBearerAuthToObject(localVarHeaderParameter, configuration)


    
            localVarHeaderParameter['Content-Type'] = 'application/json-patch+json';

            setSearchParams(localVarUrlObj, localVarQueryParameter);
            let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
            localVarRequestOptions.headers = {...localVarHeaderParameter, ...headersFromBaseOptions, ...options.headers};
            localVarRequestOptions.data = serializeDataIfNeeded(jsonPatchInner, localVarRequestOptions, configuration)

            return {
                url: toPathString(localVarUrlObj),
                options: localVarRequestOptions,
            };
        },
        /**
         * Update Notification
         * @param {string} name Name of notification
         * @param {Notification} [notification] Updated notification
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        updateNotification: async (name: string, notification?: Notification, options: RawAxiosRequestConfig = {}): Promise<RequestArgs> => {
            // verify required parameter 'name' is not null or undefined
            assertParamExists('updateNotification', 'name', name)
            const localVarPath = `/apis/notification.halo.run/v1alpha1/notifications/{name}`
                .replace(`{${"name"}}`, encodeURIComponent(String(name)));
            // use dummy base URL string because the URL constructor only accepts absolute URLs.
            const localVarUrlObj = new URL(localVarPath, DUMMY_BASE_URL);
            let baseOptions;
            if (configuration) {
                baseOptions = configuration.baseOptions;
            }

            const localVarRequestOptions = { method: 'PUT', ...baseOptions, ...options};
            const localVarHeaderParameter = {} as any;
            const localVarQueryParameter = {} as any;

            // authentication basicAuth required
            // http basic authentication required
            setBasicAuthToObject(localVarRequestOptions, configuration)

            // authentication bearerAuth required
            // http bearer authentication required
            await setBearerAuthToObject(localVarHeaderParameter, configuration)


    
            localVarHeaderParameter['Content-Type'] = 'application/json';

            setSearchParams(localVarUrlObj, localVarQueryParameter);
            let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
            localVarRequestOptions.headers = {...localVarHeaderParameter, ...headersFromBaseOptions, ...options.headers};
            localVarRequestOptions.data = serializeDataIfNeeded(notification, localVarRequestOptions, configuration)

            return {
                url: toPathString(localVarUrlObj),
                options: localVarRequestOptions,
            };
        },
    }
};

/**
 * NotificationV1alpha1Api - functional programming interface
 * @export
 */
export const NotificationV1alpha1ApiFp = function(configuration?: Configuration) {
    const localVarAxiosParamCreator = NotificationV1alpha1ApiAxiosParamCreator(configuration)
    return {
        /**
         * Create Notification
         * @param {Notification} [notification] Fresh notification
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        async createNotification(notification?: Notification, options?: RawAxiosRequestConfig): Promise<(axios?: AxiosInstance, basePath?: string) => AxiosPromise<Notification>> {
            const localVarAxiosArgs = await localVarAxiosParamCreator.createNotification(notification, options);
            const localVarOperationServerIndex = configuration?.serverIndex ?? 0;
            const localVarOperationServerBasePath = operationServerMap['NotificationV1alpha1Api.createNotification']?.[localVarOperationServerIndex]?.url;
            return (axios, basePath) => createRequestFunction(localVarAxiosArgs, globalAxios, BASE_PATH, configuration)(axios, localVarOperationServerBasePath || basePath);
        },
        /**
         * Delete Notification
         * @param {string} name Name of notification
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        async deleteNotification(name: string, options?: RawAxiosRequestConfig): Promise<(axios?: AxiosInstance, basePath?: string) => AxiosPromise<void>> {
            const localVarAxiosArgs = await localVarAxiosParamCreator.deleteNotification(name, options);
            const localVarOperationServerIndex = configuration?.serverIndex ?? 0;
            const localVarOperationServerBasePath = operationServerMap['NotificationV1alpha1Api.deleteNotification']?.[localVarOperationServerIndex]?.url;
            return (axios, basePath) => createRequestFunction(localVarAxiosArgs, globalAxios, BASE_PATH, configuration)(axios, localVarOperationServerBasePath || basePath);
        },
        /**
         * Get Notification
         * @param {string} name Name of notification
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        async getNotification(name: string, options?: RawAxiosRequestConfig): Promise<(axios?: AxiosInstance, basePath?: string) => AxiosPromise<Notification>> {
            const localVarAxiosArgs = await localVarAxiosParamCreator.getNotification(name, options);
            const localVarOperationServerIndex = configuration?.serverIndex ?? 0;
            const localVarOperationServerBasePath = operationServerMap['NotificationV1alpha1Api.getNotification']?.[localVarOperationServerIndex]?.url;
            return (axios, basePath) => createRequestFunction(localVarAxiosArgs, globalAxios, BASE_PATH, configuration)(axios, localVarOperationServerBasePath || basePath);
        },
        /**
         * List Notification
         * @param {number} [page] Page number. Default is 0.
         * @param {number} [size] Size number. Default is 0.
         * @param {Array<string>} [labelSelector] Label selector. e.g.: hidden!&#x3D;true
         * @param {Array<string>} [fieldSelector] Field selector. e.g.: metadata.name&#x3D;&#x3D;halo
         * @param {Array<string>} [sort] Sorting criteria in the format: property,(asc|desc). Default sort order is ascending. Multiple sort criteria are supported.
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        async listNotification(page?: number, size?: number, labelSelector?: Array<string>, fieldSelector?: Array<string>, sort?: Array<string>, options?: RawAxiosRequestConfig): Promise<(axios?: AxiosInstance, basePath?: string) => AxiosPromise<NotificationList>> {
            const localVarAxiosArgs = await localVarAxiosParamCreator.listNotification(page, size, labelSelector, fieldSelector, sort, options);
            const localVarOperationServerIndex = configuration?.serverIndex ?? 0;
            const localVarOperationServerBasePath = operationServerMap['NotificationV1alpha1Api.listNotification']?.[localVarOperationServerIndex]?.url;
            return (axios, basePath) => createRequestFunction(localVarAxiosArgs, globalAxios, BASE_PATH, configuration)(axios, localVarOperationServerBasePath || basePath);
        },
        /**
         * Patch Notification
         * @param {string} name Name of notification
         * @param {Array<JsonPatchInner>} [jsonPatchInner] 
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        async patchNotification(name: string, jsonPatchInner?: Array<JsonPatchInner>, options?: RawAxiosRequestConfig): Promise<(axios?: AxiosInstance, basePath?: string) => AxiosPromise<Notification>> {
            const localVarAxiosArgs = await localVarAxiosParamCreator.patchNotification(name, jsonPatchInner, options);
            const localVarOperationServerIndex = configuration?.serverIndex ?? 0;
            const localVarOperationServerBasePath = operationServerMap['NotificationV1alpha1Api.patchNotification']?.[localVarOperationServerIndex]?.url;
            return (axios, basePath) => createRequestFunction(localVarAxiosArgs, globalAxios, BASE_PATH, configuration)(axios, localVarOperationServerBasePath || basePath);
        },
        /**
         * Update Notification
         * @param {string} name Name of notification
         * @param {Notification} [notification] Updated notification
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        async updateNotification(name: string, notification?: Notification, options?: RawAxiosRequestConfig): Promise<(axios?: AxiosInstance, basePath?: string) => AxiosPromise<Notification>> {
            const localVarAxiosArgs = await localVarAxiosParamCreator.updateNotification(name, notification, options);
            const localVarOperationServerIndex = configuration?.serverIndex ?? 0;
            const localVarOperationServerBasePath = operationServerMap['NotificationV1alpha1Api.updateNotification']?.[localVarOperationServerIndex]?.url;
            return (axios, basePath) => createRequestFunction(localVarAxiosArgs, globalAxios, BASE_PATH, configuration)(axios, localVarOperationServerBasePath || basePath);
        },
    }
};

/**
 * NotificationV1alpha1Api - factory interface
 * @export
 */
export const NotificationV1alpha1ApiFactory = function (configuration?: Configuration, basePath?: string, axios?: AxiosInstance) {
    const localVarFp = NotificationV1alpha1ApiFp(configuration)
    return {
        /**
         * Create Notification
         * @param {NotificationV1alpha1ApiCreateNotificationRequest} requestParameters Request parameters.
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        createNotification(requestParameters: NotificationV1alpha1ApiCreateNotificationRequest = {}, options?: RawAxiosRequestConfig): AxiosPromise<Notification> {
            return localVarFp.createNotification(requestParameters.notification, options).then((request) => request(axios, basePath));
        },
        /**
         * Delete Notification
         * @param {NotificationV1alpha1ApiDeleteNotificationRequest} requestParameters Request parameters.
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        deleteNotification(requestParameters: NotificationV1alpha1ApiDeleteNotificationRequest, options?: RawAxiosRequestConfig): AxiosPromise<void> {
            return localVarFp.deleteNotification(requestParameters.name, options).then((request) => request(axios, basePath));
        },
        /**
         * Get Notification
         * @param {NotificationV1alpha1ApiGetNotificationRequest} requestParameters Request parameters.
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        getNotification(requestParameters: NotificationV1alpha1ApiGetNotificationRequest, options?: RawAxiosRequestConfig): AxiosPromise<Notification> {
            return localVarFp.getNotification(requestParameters.name, options).then((request) => request(axios, basePath));
        },
        /**
         * List Notification
         * @param {NotificationV1alpha1ApiListNotificationRequest} requestParameters Request parameters.
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        listNotification(requestParameters: NotificationV1alpha1ApiListNotificationRequest = {}, options?: RawAxiosRequestConfig): AxiosPromise<NotificationList> {
            return localVarFp.listNotification(requestParameters.page, requestParameters.size, requestParameters.labelSelector, requestParameters.fieldSelector, requestParameters.sort, options).then((request) => request(axios, basePath));
        },
        /**
         * Patch Notification
         * @param {NotificationV1alpha1ApiPatchNotificationRequest} requestParameters Request parameters.
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        patchNotification(requestParameters: NotificationV1alpha1ApiPatchNotificationRequest, options?: RawAxiosRequestConfig): AxiosPromise<Notification> {
            return localVarFp.patchNotification(requestParameters.name, requestParameters.jsonPatchInner, options).then((request) => request(axios, basePath));
        },
        /**
         * Update Notification
         * @param {NotificationV1alpha1ApiUpdateNotificationRequest} requestParameters Request parameters.
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        updateNotification(requestParameters: NotificationV1alpha1ApiUpdateNotificationRequest, options?: RawAxiosRequestConfig): AxiosPromise<Notification> {
            return localVarFp.updateNotification(requestParameters.name, requestParameters.notification, options).then((request) => request(axios, basePath));
        },
    };
};

/**
 * Request parameters for createNotification operation in NotificationV1alpha1Api.
 * @export
 * @interface NotificationV1alpha1ApiCreateNotificationRequest
 */
export interface NotificationV1alpha1ApiCreateNotificationRequest {
    /**
     * Fresh notification
     * @type {Notification}
     * @memberof NotificationV1alpha1ApiCreateNotification
     */
    readonly notification?: Notification
}

/**
 * Request parameters for deleteNotification operation in NotificationV1alpha1Api.
 * @export
 * @interface NotificationV1alpha1ApiDeleteNotificationRequest
 */
export interface NotificationV1alpha1ApiDeleteNotificationRequest {
    /**
     * Name of notification
     * @type {string}
     * @memberof NotificationV1alpha1ApiDeleteNotification
     */
    readonly name: string
}

/**
 * Request parameters for getNotification operation in NotificationV1alpha1Api.
 * @export
 * @interface NotificationV1alpha1ApiGetNotificationRequest
 */
export interface NotificationV1alpha1ApiGetNotificationRequest {
    /**
     * Name of notification
     * @type {string}
     * @memberof NotificationV1alpha1ApiGetNotification
     */
    readonly name: string
}

/**
 * Request parameters for listNotification operation in NotificationV1alpha1Api.
 * @export
 * @interface NotificationV1alpha1ApiListNotificationRequest
 */
export interface NotificationV1alpha1ApiListNotificationRequest {
    /**
     * Page number. Default is 0.
     * @type {number}
     * @memberof NotificationV1alpha1ApiListNotification
     */
    readonly page?: number

    /**
     * Size number. Default is 0.
     * @type {number}
     * @memberof NotificationV1alpha1ApiListNotification
     */
    readonly size?: number

    /**
     * Label selector. e.g.: hidden!&#x3D;true
     * @type {Array<string>}
     * @memberof NotificationV1alpha1ApiListNotification
     */
    readonly labelSelector?: Array<string>

    /**
     * Field selector. e.g.: metadata.name&#x3D;&#x3D;halo
     * @type {Array<string>}
     * @memberof NotificationV1alpha1ApiListNotification
     */
    readonly fieldSelector?: Array<string>

    /**
     * Sorting criteria in the format: property,(asc|desc). Default sort order is ascending. Multiple sort criteria are supported.
     * @type {Array<string>}
     * @memberof NotificationV1alpha1ApiListNotification
     */
    readonly sort?: Array<string>
}

/**
 * Request parameters for patchNotification operation in NotificationV1alpha1Api.
 * @export
 * @interface NotificationV1alpha1ApiPatchNotificationRequest
 */
export interface NotificationV1alpha1ApiPatchNotificationRequest {
    /**
     * Name of notification
     * @type {string}
     * @memberof NotificationV1alpha1ApiPatchNotification
     */
    readonly name: string

    /**
     * 
     * @type {Array<JsonPatchInner>}
     * @memberof NotificationV1alpha1ApiPatchNotification
     */
    readonly jsonPatchInner?: Array<JsonPatchInner>
}

/**
 * Request parameters for updateNotification operation in NotificationV1alpha1Api.
 * @export
 * @interface NotificationV1alpha1ApiUpdateNotificationRequest
 */
export interface NotificationV1alpha1ApiUpdateNotificationRequest {
    /**
     * Name of notification
     * @type {string}
     * @memberof NotificationV1alpha1ApiUpdateNotification
     */
    readonly name: string

    /**
     * Updated notification
     * @type {Notification}
     * @memberof NotificationV1alpha1ApiUpdateNotification
     */
    readonly notification?: Notification
}

/**
 * NotificationV1alpha1Api - object-oriented interface
 * @export
 * @class NotificationV1alpha1Api
 * @extends {BaseAPI}
 */
export class NotificationV1alpha1Api extends BaseAPI {
    /**
     * Create Notification
     * @param {NotificationV1alpha1ApiCreateNotificationRequest} requestParameters Request parameters.
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof NotificationV1alpha1Api
     */
    public createNotification(requestParameters: NotificationV1alpha1ApiCreateNotificationRequest = {}, options?: RawAxiosRequestConfig) {
        return NotificationV1alpha1ApiFp(this.configuration).createNotification(requestParameters.notification, options).then((request) => request(this.axios, this.basePath));
    }

    /**
     * Delete Notification
     * @param {NotificationV1alpha1ApiDeleteNotificationRequest} requestParameters Request parameters.
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof NotificationV1alpha1Api
     */
    public deleteNotification(requestParameters: NotificationV1alpha1ApiDeleteNotificationRequest, options?: RawAxiosRequestConfig) {
        return NotificationV1alpha1ApiFp(this.configuration).deleteNotification(requestParameters.name, options).then((request) => request(this.axios, this.basePath));
    }

    /**
     * Get Notification
     * @param {NotificationV1alpha1ApiGetNotificationRequest} requestParameters Request parameters.
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof NotificationV1alpha1Api
     */
    public getNotification(requestParameters: NotificationV1alpha1ApiGetNotificationRequest, options?: RawAxiosRequestConfig) {
        return NotificationV1alpha1ApiFp(this.configuration).getNotification(requestParameters.name, options).then((request) => request(this.axios, this.basePath));
    }

    /**
     * List Notification
     * @param {NotificationV1alpha1ApiListNotificationRequest} requestParameters Request parameters.
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof NotificationV1alpha1Api
     */
    public listNotification(requestParameters: NotificationV1alpha1ApiListNotificationRequest = {}, options?: RawAxiosRequestConfig) {
        return NotificationV1alpha1ApiFp(this.configuration).listNotification(requestParameters.page, requestParameters.size, requestParameters.labelSelector, requestParameters.fieldSelector, requestParameters.sort, options).then((request) => request(this.axios, this.basePath));
    }

    /**
     * Patch Notification
     * @param {NotificationV1alpha1ApiPatchNotificationRequest} requestParameters Request parameters.
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof NotificationV1alpha1Api
     */
    public patchNotification(requestParameters: NotificationV1alpha1ApiPatchNotificationRequest, options?: RawAxiosRequestConfig) {
        return NotificationV1alpha1ApiFp(this.configuration).patchNotification(requestParameters.name, requestParameters.jsonPatchInner, options).then((request) => request(this.axios, this.basePath));
    }

    /**
     * Update Notification
     * @param {NotificationV1alpha1ApiUpdateNotificationRequest} requestParameters Request parameters.
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof NotificationV1alpha1Api
     */
    public updateNotification(requestParameters: NotificationV1alpha1ApiUpdateNotificationRequest, options?: RawAxiosRequestConfig) {
        return NotificationV1alpha1ApiFp(this.configuration).updateNotification(requestParameters.name, requestParameters.notification, options).then((request) => request(this.axios, this.basePath));
    }
}

