/* tslint:disable */
/* eslint-disable */
/**
 * Halo
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: 2.20.10-SNAPSHOT
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


import type { Configuration } from '../configuration';
import type { AxiosPromise, AxiosInstance, RawAxiosRequestConfig } from 'axios';
import globalAxios from 'axios';
// Some imports not used depending on template conditions
// @ts-ignore
import { DUMMY_BASE_URL, assertParamExists, setApiKeyToObject, setBasicAuthToObject, setBearerAuthToObject, setOAuthToObject, setSearchParams, serializeDataIfNeeded, toPathString, createRequestFunction } from '../common';
// @ts-ignore
import { BASE_PATH, COLLECTION_FORMATS, RequestArgs, BaseAPI, RequiredError, operationServerMap } from '../base';
/**
 * NotifierV1alpha1UcApi - axios parameter creator
 * @export
 */
export const NotifierV1alpha1UcApiAxiosParamCreator = function (configuration?: Configuration) {
    return {
        /**
         * Fetch receiver config of notifier
         * @param {string} name Notifier name
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        fetchReceiverConfig: async (name: string, options: RawAxiosRequestConfig = {}): Promise<RequestArgs> => {
            // verify required parameter 'name' is not null or undefined
            assertParamExists('fetchReceiverConfig', 'name', name)
            const localVarPath = `/apis/api.notification.halo.run/v1alpha1/notifiers/{name}/receiver-config`
                .replace(`{${"name"}}`, encodeURIComponent(String(name)));
            // use dummy base URL string because the URL constructor only accepts absolute URLs.
            const localVarUrlObj = new URL(localVarPath, DUMMY_BASE_URL);
            let baseOptions;
            if (configuration) {
                baseOptions = configuration.baseOptions;
            }

            const localVarRequestOptions = { method: 'GET', ...baseOptions, ...options};
            const localVarHeaderParameter = {} as any;
            const localVarQueryParameter = {} as any;

            // authentication basicAuth required
            // http basic authentication required
            setBasicAuthToObject(localVarRequestOptions, configuration)

            // authentication bearerAuth required
            // http bearer authentication required
            await setBearerAuthToObject(localVarHeaderParameter, configuration)


    
            setSearchParams(localVarUrlObj, localVarQueryParameter);
            let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
            localVarRequestOptions.headers = {...localVarHeaderParameter, ...headersFromBaseOptions, ...options.headers};

            return {
                url: toPathString(localVarUrlObj),
                options: localVarRequestOptions,
            };
        },
        /**
         * Save receiver config of notifier
         * @param {string} name Notifier name
         * @param {object} body 
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        saveReceiverConfig: async (name: string, body: object, options: RawAxiosRequestConfig = {}): Promise<RequestArgs> => {
            // verify required parameter 'name' is not null or undefined
            assertParamExists('saveReceiverConfig', 'name', name)
            // verify required parameter 'body' is not null or undefined
            assertParamExists('saveReceiverConfig', 'body', body)
            const localVarPath = `/apis/api.notification.halo.run/v1alpha1/notifiers/{name}/receiver-config`
                .replace(`{${"name"}}`, encodeURIComponent(String(name)));
            // use dummy base URL string because the URL constructor only accepts absolute URLs.
            const localVarUrlObj = new URL(localVarPath, DUMMY_BASE_URL);
            let baseOptions;
            if (configuration) {
                baseOptions = configuration.baseOptions;
            }

            const localVarRequestOptions = { method: 'POST', ...baseOptions, ...options};
            const localVarHeaderParameter = {} as any;
            const localVarQueryParameter = {} as any;

            // authentication basicAuth required
            // http basic authentication required
            setBasicAuthToObject(localVarRequestOptions, configuration)

            // authentication bearerAuth required
            // http bearer authentication required
            await setBearerAuthToObject(localVarHeaderParameter, configuration)


    
            localVarHeaderParameter['Content-Type'] = 'application/json';

            setSearchParams(localVarUrlObj, localVarQueryParameter);
            let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
            localVarRequestOptions.headers = {...localVarHeaderParameter, ...headersFromBaseOptions, ...options.headers};
            localVarRequestOptions.data = serializeDataIfNeeded(body, localVarRequestOptions, configuration)

            return {
                url: toPathString(localVarUrlObj),
                options: localVarRequestOptions,
            };
        },
    }
};

/**
 * NotifierV1alpha1UcApi - functional programming interface
 * @export
 */
export const NotifierV1alpha1UcApiFp = function(configuration?: Configuration) {
    const localVarAxiosParamCreator = NotifierV1alpha1UcApiAxiosParamCreator(configuration)
    return {
        /**
         * Fetch receiver config of notifier
         * @param {string} name Notifier name
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        async fetchReceiverConfig(name: string, options?: RawAxiosRequestConfig): Promise<(axios?: AxiosInstance, basePath?: string) => AxiosPromise<object>> {
            const localVarAxiosArgs = await localVarAxiosParamCreator.fetchReceiverConfig(name, options);
            const localVarOperationServerIndex = configuration?.serverIndex ?? 0;
            const localVarOperationServerBasePath = operationServerMap['NotifierV1alpha1UcApi.fetchReceiverConfig']?.[localVarOperationServerIndex]?.url;
            return (axios, basePath) => createRequestFunction(localVarAxiosArgs, globalAxios, BASE_PATH, configuration)(axios, localVarOperationServerBasePath || basePath);
        },
        /**
         * Save receiver config of notifier
         * @param {string} name Notifier name
         * @param {object} body 
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        async saveReceiverConfig(name: string, body: object, options?: RawAxiosRequestConfig): Promise<(axios?: AxiosInstance, basePath?: string) => AxiosPromise<void>> {
            const localVarAxiosArgs = await localVarAxiosParamCreator.saveReceiverConfig(name, body, options);
            const localVarOperationServerIndex = configuration?.serverIndex ?? 0;
            const localVarOperationServerBasePath = operationServerMap['NotifierV1alpha1UcApi.saveReceiverConfig']?.[localVarOperationServerIndex]?.url;
            return (axios, basePath) => createRequestFunction(localVarAxiosArgs, globalAxios, BASE_PATH, configuration)(axios, localVarOperationServerBasePath || basePath);
        },
    }
};

/**
 * NotifierV1alpha1UcApi - factory interface
 * @export
 */
export const NotifierV1alpha1UcApiFactory = function (configuration?: Configuration, basePath?: string, axios?: AxiosInstance) {
    const localVarFp = NotifierV1alpha1UcApiFp(configuration)
    return {
        /**
         * Fetch receiver config of notifier
         * @param {NotifierV1alpha1UcApiFetchReceiverConfigRequest} requestParameters Request parameters.
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        fetchReceiverConfig(requestParameters: NotifierV1alpha1UcApiFetchReceiverConfigRequest, options?: RawAxiosRequestConfig): AxiosPromise<object> {
            return localVarFp.fetchReceiverConfig(requestParameters.name, options).then((request) => request(axios, basePath));
        },
        /**
         * Save receiver config of notifier
         * @param {NotifierV1alpha1UcApiSaveReceiverConfigRequest} requestParameters Request parameters.
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        saveReceiverConfig(requestParameters: NotifierV1alpha1UcApiSaveReceiverConfigRequest, options?: RawAxiosRequestConfig): AxiosPromise<void> {
            return localVarFp.saveReceiverConfig(requestParameters.name, requestParameters.body, options).then((request) => request(axios, basePath));
        },
    };
};

/**
 * Request parameters for fetchReceiverConfig operation in NotifierV1alpha1UcApi.
 * @export
 * @interface NotifierV1alpha1UcApiFetchReceiverConfigRequest
 */
export interface NotifierV1alpha1UcApiFetchReceiverConfigRequest {
    /**
     * Notifier name
     * @type {string}
     * @memberof NotifierV1alpha1UcApiFetchReceiverConfig
     */
    readonly name: string
}

/**
 * Request parameters for saveReceiverConfig operation in NotifierV1alpha1UcApi.
 * @export
 * @interface NotifierV1alpha1UcApiSaveReceiverConfigRequest
 */
export interface NotifierV1alpha1UcApiSaveReceiverConfigRequest {
    /**
     * Notifier name
     * @type {string}
     * @memberof NotifierV1alpha1UcApiSaveReceiverConfig
     */
    readonly name: string

    /**
     * 
     * @type {object}
     * @memberof NotifierV1alpha1UcApiSaveReceiverConfig
     */
    readonly body: object
}

/**
 * NotifierV1alpha1UcApi - object-oriented interface
 * @export
 * @class NotifierV1alpha1UcApi
 * @extends {BaseAPI}
 */
export class NotifierV1alpha1UcApi extends BaseAPI {
    /**
     * Fetch receiver config of notifier
     * @param {NotifierV1alpha1UcApiFetchReceiverConfigRequest} requestParameters Request parameters.
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof NotifierV1alpha1UcApi
     */
    public fetchReceiverConfig(requestParameters: NotifierV1alpha1UcApiFetchReceiverConfigRequest, options?: RawAxiosRequestConfig) {
        return NotifierV1alpha1UcApiFp(this.configuration).fetchReceiverConfig(requestParameters.name, options).then((request) => request(this.axios, this.basePath));
    }

    /**
     * Save receiver config of notifier
     * @param {NotifierV1alpha1UcApiSaveReceiverConfigRequest} requestParameters Request parameters.
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof NotifierV1alpha1UcApi
     */
    public saveReceiverConfig(requestParameters: NotifierV1alpha1UcApiSaveReceiverConfigRequest, options?: RawAxiosRequestConfig) {
        return NotifierV1alpha1UcApiFp(this.configuration).saveReceiverConfig(requestParameters.name, requestParameters.body, options).then((request) => request(this.axios, this.basePath));
    }
}

