/* tslint:disable */
/* eslint-disable */
/**
 * Halo
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: 2.20.10-SNAPSHOT
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


import type { Configuration } from '../configuration';
import type { AxiosPromise, AxiosInstance, RawAxiosRequestConfig } from 'axios';
import globalAxios from 'axios';
// Some imports not used depending on template conditions
// @ts-ignore
import { DUMMY_BASE_URL, assertParamExists, setApiKeyToObject, setBasicAuthToObject, setBearerAuthToObject, setOAuthToObject, setSearchParams, serializeDataIfNeeded, toPathString, createRequestFunction } from '../common';
// @ts-ignore
import { BASE_PATH, COLLECTION_FORMATS, RequestArgs, BaseAPI, RequiredError, operationServerMap } from '../base';
// @ts-ignore
import { JsonPatchInner } from '../models';
// @ts-ignore
import { PersonalAccessToken } from '../models';
// @ts-ignore
import { PersonalAccessTokenList } from '../models';
/**
 * PersonalAccessTokenV1alpha1Api - axios parameter creator
 * @export
 */
export const PersonalAccessTokenV1alpha1ApiAxiosParamCreator = function (configuration?: Configuration) {
    return {
        /**
         * Create PersonalAccessToken
         * @param {PersonalAccessToken} [personalAccessToken] Fresh personalaccesstoken
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        createPersonalAccessToken: async (personalAccessToken?: PersonalAccessToken, options: RawAxiosRequestConfig = {}): Promise<RequestArgs> => {
            const localVarPath = `/apis/security.halo.run/v1alpha1/personalaccesstokens`;
            // use dummy base URL string because the URL constructor only accepts absolute URLs.
            const localVarUrlObj = new URL(localVarPath, DUMMY_BASE_URL);
            let baseOptions;
            if (configuration) {
                baseOptions = configuration.baseOptions;
            }

            const localVarRequestOptions = { method: 'POST', ...baseOptions, ...options};
            const localVarHeaderParameter = {} as any;
            const localVarQueryParameter = {} as any;

            // authentication basicAuth required
            // http basic authentication required
            setBasicAuthToObject(localVarRequestOptions, configuration)

            // authentication bearerAuth required
            // http bearer authentication required
            await setBearerAuthToObject(localVarHeaderParameter, configuration)


    
            localVarHeaderParameter['Content-Type'] = 'application/json';

            setSearchParams(localVarUrlObj, localVarQueryParameter);
            let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
            localVarRequestOptions.headers = {...localVarHeaderParameter, ...headersFromBaseOptions, ...options.headers};
            localVarRequestOptions.data = serializeDataIfNeeded(personalAccessToken, localVarRequestOptions, configuration)

            return {
                url: toPathString(localVarUrlObj),
                options: localVarRequestOptions,
            };
        },
        /**
         * Delete PersonalAccessToken
         * @param {string} name Name of personalaccesstoken
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        deletePersonalAccessToken: async (name: string, options: RawAxiosRequestConfig = {}): Promise<RequestArgs> => {
            // verify required parameter 'name' is not null or undefined
            assertParamExists('deletePersonalAccessToken', 'name', name)
            const localVarPath = `/apis/security.halo.run/v1alpha1/personalaccesstokens/{name}`
                .replace(`{${"name"}}`, encodeURIComponent(String(name)));
            // use dummy base URL string because the URL constructor only accepts absolute URLs.
            const localVarUrlObj = new URL(localVarPath, DUMMY_BASE_URL);
            let baseOptions;
            if (configuration) {
                baseOptions = configuration.baseOptions;
            }

            const localVarRequestOptions = { method: 'DELETE', ...baseOptions, ...options};
            const localVarHeaderParameter = {} as any;
            const localVarQueryParameter = {} as any;

            // authentication basicAuth required
            // http basic authentication required
            setBasicAuthToObject(localVarRequestOptions, configuration)

            // authentication bearerAuth required
            // http bearer authentication required
            await setBearerAuthToObject(localVarHeaderParameter, configuration)


    
            setSearchParams(localVarUrlObj, localVarQueryParameter);
            let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
            localVarRequestOptions.headers = {...localVarHeaderParameter, ...headersFromBaseOptions, ...options.headers};

            return {
                url: toPathString(localVarUrlObj),
                options: localVarRequestOptions,
            };
        },
        /**
         * Get PersonalAccessToken
         * @param {string} name Name of personalaccesstoken
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        getPersonalAccessToken: async (name: string, options: RawAxiosRequestConfig = {}): Promise<RequestArgs> => {
            // verify required parameter 'name' is not null or undefined
            assertParamExists('getPersonalAccessToken', 'name', name)
            const localVarPath = `/apis/security.halo.run/v1alpha1/personalaccesstokens/{name}`
                .replace(`{${"name"}}`, encodeURIComponent(String(name)));
            // use dummy base URL string because the URL constructor only accepts absolute URLs.
            const localVarUrlObj = new URL(localVarPath, DUMMY_BASE_URL);
            let baseOptions;
            if (configuration) {
                baseOptions = configuration.baseOptions;
            }

            const localVarRequestOptions = { method: 'GET', ...baseOptions, ...options};
            const localVarHeaderParameter = {} as any;
            const localVarQueryParameter = {} as any;

            // authentication basicAuth required
            // http basic authentication required
            setBasicAuthToObject(localVarRequestOptions, configuration)

            // authentication bearerAuth required
            // http bearer authentication required
            await setBearerAuthToObject(localVarHeaderParameter, configuration)


    
            setSearchParams(localVarUrlObj, localVarQueryParameter);
            let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
            localVarRequestOptions.headers = {...localVarHeaderParameter, ...headersFromBaseOptions, ...options.headers};

            return {
                url: toPathString(localVarUrlObj),
                options: localVarRequestOptions,
            };
        },
        /**
         * List PersonalAccessToken
         * @param {number} [page] Page number. Default is 0.
         * @param {number} [size] Size number. Default is 0.
         * @param {Array<string>} [labelSelector] Label selector. e.g.: hidden!&#x3D;true
         * @param {Array<string>} [fieldSelector] Field selector. e.g.: metadata.name&#x3D;&#x3D;halo
         * @param {Array<string>} [sort] Sorting criteria in the format: property,(asc|desc). Default sort order is ascending. Multiple sort criteria are supported.
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        listPersonalAccessToken: async (page?: number, size?: number, labelSelector?: Array<string>, fieldSelector?: Array<string>, sort?: Array<string>, options: RawAxiosRequestConfig = {}): Promise<RequestArgs> => {
            const localVarPath = `/apis/security.halo.run/v1alpha1/personalaccesstokens`;
            // use dummy base URL string because the URL constructor only accepts absolute URLs.
            const localVarUrlObj = new URL(localVarPath, DUMMY_BASE_URL);
            let baseOptions;
            if (configuration) {
                baseOptions = configuration.baseOptions;
            }

            const localVarRequestOptions = { method: 'GET', ...baseOptions, ...options};
            const localVarHeaderParameter = {} as any;
            const localVarQueryParameter = {} as any;

            // authentication basicAuth required
            // http basic authentication required
            setBasicAuthToObject(localVarRequestOptions, configuration)

            // authentication bearerAuth required
            // http bearer authentication required
            await setBearerAuthToObject(localVarHeaderParameter, configuration)

            if (page !== undefined) {
                localVarQueryParameter['page'] = page;
            }

            if (size !== undefined) {
                localVarQueryParameter['size'] = size;
            }

            if (labelSelector) {
                localVarQueryParameter['labelSelector'] = labelSelector;
            }

            if (fieldSelector) {
                localVarQueryParameter['fieldSelector'] = fieldSelector;
            }

            if (sort) {
                localVarQueryParameter['sort'] = sort;
            }


    
            setSearchParams(localVarUrlObj, localVarQueryParameter);
            let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
            localVarRequestOptions.headers = {...localVarHeaderParameter, ...headersFromBaseOptions, ...options.headers};

            return {
                url: toPathString(localVarUrlObj),
                options: localVarRequestOptions,
            };
        },
        /**
         * Patch PersonalAccessToken
         * @param {string} name Name of personalaccesstoken
         * @param {Array<JsonPatchInner>} [jsonPatchInner] 
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        patchPersonalAccessToken: async (name: string, jsonPatchInner?: Array<JsonPatchInner>, options: RawAxiosRequestConfig = {}): Promise<RequestArgs> => {
            // verify required parameter 'name' is not null or undefined
            assertParamExists('patchPersonalAccessToken', 'name', name)
            const localVarPath = `/apis/security.halo.run/v1alpha1/personalaccesstokens/{name}`
                .replace(`{${"name"}}`, encodeURIComponent(String(name)));
            // use dummy base URL string because the URL constructor only accepts absolute URLs.
            const localVarUrlObj = new URL(localVarPath, DUMMY_BASE_URL);
            let baseOptions;
            if (configuration) {
                baseOptions = configuration.baseOptions;
            }

            const localVarRequestOptions = { method: 'PATCH', ...baseOptions, ...options};
            const localVarHeaderParameter = {} as any;
            const localVarQueryParameter = {} as any;

            // authentication basicAuth required
            // http basic authentication required
            setBasicAuthToObject(localVarRequestOptions, configuration)

            // authentication bearerAuth required
            // http bearer authentication required
            await setBearerAuthToObject(localVarHeaderParameter, configuration)


    
            localVarHeaderParameter['Content-Type'] = 'application/json-patch+json';

            setSearchParams(localVarUrlObj, localVarQueryParameter);
            let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
            localVarRequestOptions.headers = {...localVarHeaderParameter, ...headersFromBaseOptions, ...options.headers};
            localVarRequestOptions.data = serializeDataIfNeeded(jsonPatchInner, localVarRequestOptions, configuration)

            return {
                url: toPathString(localVarUrlObj),
                options: localVarRequestOptions,
            };
        },
        /**
         * Update PersonalAccessToken
         * @param {string} name Name of personalaccesstoken
         * @param {PersonalAccessToken} [personalAccessToken] Updated personalaccesstoken
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        updatePersonalAccessToken: async (name: string, personalAccessToken?: PersonalAccessToken, options: RawAxiosRequestConfig = {}): Promise<RequestArgs> => {
            // verify required parameter 'name' is not null or undefined
            assertParamExists('updatePersonalAccessToken', 'name', name)
            const localVarPath = `/apis/security.halo.run/v1alpha1/personalaccesstokens/{name}`
                .replace(`{${"name"}}`, encodeURIComponent(String(name)));
            // use dummy base URL string because the URL constructor only accepts absolute URLs.
            const localVarUrlObj = new URL(localVarPath, DUMMY_BASE_URL);
            let baseOptions;
            if (configuration) {
                baseOptions = configuration.baseOptions;
            }

            const localVarRequestOptions = { method: 'PUT', ...baseOptions, ...options};
            const localVarHeaderParameter = {} as any;
            const localVarQueryParameter = {} as any;

            // authentication basicAuth required
            // http basic authentication required
            setBasicAuthToObject(localVarRequestOptions, configuration)

            // authentication bearerAuth required
            // http bearer authentication required
            await setBearerAuthToObject(localVarHeaderParameter, configuration)


    
            localVarHeaderParameter['Content-Type'] = 'application/json';

            setSearchParams(localVarUrlObj, localVarQueryParameter);
            let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
            localVarRequestOptions.headers = {...localVarHeaderParameter, ...headersFromBaseOptions, ...options.headers};
            localVarRequestOptions.data = serializeDataIfNeeded(personalAccessToken, localVarRequestOptions, configuration)

            return {
                url: toPathString(localVarUrlObj),
                options: localVarRequestOptions,
            };
        },
    }
};

/**
 * PersonalAccessTokenV1alpha1Api - functional programming interface
 * @export
 */
export const PersonalAccessTokenV1alpha1ApiFp = function(configuration?: Configuration) {
    const localVarAxiosParamCreator = PersonalAccessTokenV1alpha1ApiAxiosParamCreator(configuration)
    return {
        /**
         * Create PersonalAccessToken
         * @param {PersonalAccessToken} [personalAccessToken] Fresh personalaccesstoken
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        async createPersonalAccessToken(personalAccessToken?: PersonalAccessToken, options?: RawAxiosRequestConfig): Promise<(axios?: AxiosInstance, basePath?: string) => AxiosPromise<PersonalAccessToken>> {
            const localVarAxiosArgs = await localVarAxiosParamCreator.createPersonalAccessToken(personalAccessToken, options);
            const localVarOperationServerIndex = configuration?.serverIndex ?? 0;
            const localVarOperationServerBasePath = operationServerMap['PersonalAccessTokenV1alpha1Api.createPersonalAccessToken']?.[localVarOperationServerIndex]?.url;
            return (axios, basePath) => createRequestFunction(localVarAxiosArgs, globalAxios, BASE_PATH, configuration)(axios, localVarOperationServerBasePath || basePath);
        },
        /**
         * Delete PersonalAccessToken
         * @param {string} name Name of personalaccesstoken
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        async deletePersonalAccessToken(name: string, options?: RawAxiosRequestConfig): Promise<(axios?: AxiosInstance, basePath?: string) => AxiosPromise<void>> {
            const localVarAxiosArgs = await localVarAxiosParamCreator.deletePersonalAccessToken(name, options);
            const localVarOperationServerIndex = configuration?.serverIndex ?? 0;
            const localVarOperationServerBasePath = operationServerMap['PersonalAccessTokenV1alpha1Api.deletePersonalAccessToken']?.[localVarOperationServerIndex]?.url;
            return (axios, basePath) => createRequestFunction(localVarAxiosArgs, globalAxios, BASE_PATH, configuration)(axios, localVarOperationServerBasePath || basePath);
        },
        /**
         * Get PersonalAccessToken
         * @param {string} name Name of personalaccesstoken
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        async getPersonalAccessToken(name: string, options?: RawAxiosRequestConfig): Promise<(axios?: AxiosInstance, basePath?: string) => AxiosPromise<PersonalAccessToken>> {
            const localVarAxiosArgs = await localVarAxiosParamCreator.getPersonalAccessToken(name, options);
            const localVarOperationServerIndex = configuration?.serverIndex ?? 0;
            const localVarOperationServerBasePath = operationServerMap['PersonalAccessTokenV1alpha1Api.getPersonalAccessToken']?.[localVarOperationServerIndex]?.url;
            return (axios, basePath) => createRequestFunction(localVarAxiosArgs, globalAxios, BASE_PATH, configuration)(axios, localVarOperationServerBasePath || basePath);
        },
        /**
         * List PersonalAccessToken
         * @param {number} [page] Page number. Default is 0.
         * @param {number} [size] Size number. Default is 0.
         * @param {Array<string>} [labelSelector] Label selector. e.g.: hidden!&#x3D;true
         * @param {Array<string>} [fieldSelector] Field selector. e.g.: metadata.name&#x3D;&#x3D;halo
         * @param {Array<string>} [sort] Sorting criteria in the format: property,(asc|desc). Default sort order is ascending. Multiple sort criteria are supported.
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        async listPersonalAccessToken(page?: number, size?: number, labelSelector?: Array<string>, fieldSelector?: Array<string>, sort?: Array<string>, options?: RawAxiosRequestConfig): Promise<(axios?: AxiosInstance, basePath?: string) => AxiosPromise<PersonalAccessTokenList>> {
            const localVarAxiosArgs = await localVarAxiosParamCreator.listPersonalAccessToken(page, size, labelSelector, fieldSelector, sort, options);
            const localVarOperationServerIndex = configuration?.serverIndex ?? 0;
            const localVarOperationServerBasePath = operationServerMap['PersonalAccessTokenV1alpha1Api.listPersonalAccessToken']?.[localVarOperationServerIndex]?.url;
            return (axios, basePath) => createRequestFunction(localVarAxiosArgs, globalAxios, BASE_PATH, configuration)(axios, localVarOperationServerBasePath || basePath);
        },
        /**
         * Patch PersonalAccessToken
         * @param {string} name Name of personalaccesstoken
         * @param {Array<JsonPatchInner>} [jsonPatchInner] 
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        async patchPersonalAccessToken(name: string, jsonPatchInner?: Array<JsonPatchInner>, options?: RawAxiosRequestConfig): Promise<(axios?: AxiosInstance, basePath?: string) => AxiosPromise<PersonalAccessToken>> {
            const localVarAxiosArgs = await localVarAxiosParamCreator.patchPersonalAccessToken(name, jsonPatchInner, options);
            const localVarOperationServerIndex = configuration?.serverIndex ?? 0;
            const localVarOperationServerBasePath = operationServerMap['PersonalAccessTokenV1alpha1Api.patchPersonalAccessToken']?.[localVarOperationServerIndex]?.url;
            return (axios, basePath) => createRequestFunction(localVarAxiosArgs, globalAxios, BASE_PATH, configuration)(axios, localVarOperationServerBasePath || basePath);
        },
        /**
         * Update PersonalAccessToken
         * @param {string} name Name of personalaccesstoken
         * @param {PersonalAccessToken} [personalAccessToken] Updated personalaccesstoken
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        async updatePersonalAccessToken(name: string, personalAccessToken?: PersonalAccessToken, options?: RawAxiosRequestConfig): Promise<(axios?: AxiosInstance, basePath?: string) => AxiosPromise<PersonalAccessToken>> {
            const localVarAxiosArgs = await localVarAxiosParamCreator.updatePersonalAccessToken(name, personalAccessToken, options);
            const localVarOperationServerIndex = configuration?.serverIndex ?? 0;
            const localVarOperationServerBasePath = operationServerMap['PersonalAccessTokenV1alpha1Api.updatePersonalAccessToken']?.[localVarOperationServerIndex]?.url;
            return (axios, basePath) => createRequestFunction(localVarAxiosArgs, globalAxios, BASE_PATH, configuration)(axios, localVarOperationServerBasePath || basePath);
        },
    }
};

/**
 * PersonalAccessTokenV1alpha1Api - factory interface
 * @export
 */
export const PersonalAccessTokenV1alpha1ApiFactory = function (configuration?: Configuration, basePath?: string, axios?: AxiosInstance) {
    const localVarFp = PersonalAccessTokenV1alpha1ApiFp(configuration)
    return {
        /**
         * Create PersonalAccessToken
         * @param {PersonalAccessTokenV1alpha1ApiCreatePersonalAccessTokenRequest} requestParameters Request parameters.
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        createPersonalAccessToken(requestParameters: PersonalAccessTokenV1alpha1ApiCreatePersonalAccessTokenRequest = {}, options?: RawAxiosRequestConfig): AxiosPromise<PersonalAccessToken> {
            return localVarFp.createPersonalAccessToken(requestParameters.personalAccessToken, options).then((request) => request(axios, basePath));
        },
        /**
         * Delete PersonalAccessToken
         * @param {PersonalAccessTokenV1alpha1ApiDeletePersonalAccessTokenRequest} requestParameters Request parameters.
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        deletePersonalAccessToken(requestParameters: PersonalAccessTokenV1alpha1ApiDeletePersonalAccessTokenRequest, options?: RawAxiosRequestConfig): AxiosPromise<void> {
            return localVarFp.deletePersonalAccessToken(requestParameters.name, options).then((request) => request(axios, basePath));
        },
        /**
         * Get PersonalAccessToken
         * @param {PersonalAccessTokenV1alpha1ApiGetPersonalAccessTokenRequest} requestParameters Request parameters.
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        getPersonalAccessToken(requestParameters: PersonalAccessTokenV1alpha1ApiGetPersonalAccessTokenRequest, options?: RawAxiosRequestConfig): AxiosPromise<PersonalAccessToken> {
            return localVarFp.getPersonalAccessToken(requestParameters.name, options).then((request) => request(axios, basePath));
        },
        /**
         * List PersonalAccessToken
         * @param {PersonalAccessTokenV1alpha1ApiListPersonalAccessTokenRequest} requestParameters Request parameters.
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        listPersonalAccessToken(requestParameters: PersonalAccessTokenV1alpha1ApiListPersonalAccessTokenRequest = {}, options?: RawAxiosRequestConfig): AxiosPromise<PersonalAccessTokenList> {
            return localVarFp.listPersonalAccessToken(requestParameters.page, requestParameters.size, requestParameters.labelSelector, requestParameters.fieldSelector, requestParameters.sort, options).then((request) => request(axios, basePath));
        },
        /**
         * Patch PersonalAccessToken
         * @param {PersonalAccessTokenV1alpha1ApiPatchPersonalAccessTokenRequest} requestParameters Request parameters.
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        patchPersonalAccessToken(requestParameters: PersonalAccessTokenV1alpha1ApiPatchPersonalAccessTokenRequest, options?: RawAxiosRequestConfig): AxiosPromise<PersonalAccessToken> {
            return localVarFp.patchPersonalAccessToken(requestParameters.name, requestParameters.jsonPatchInner, options).then((request) => request(axios, basePath));
        },
        /**
         * Update PersonalAccessToken
         * @param {PersonalAccessTokenV1alpha1ApiUpdatePersonalAccessTokenRequest} requestParameters Request parameters.
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        updatePersonalAccessToken(requestParameters: PersonalAccessTokenV1alpha1ApiUpdatePersonalAccessTokenRequest, options?: RawAxiosRequestConfig): AxiosPromise<PersonalAccessToken> {
            return localVarFp.updatePersonalAccessToken(requestParameters.name, requestParameters.personalAccessToken, options).then((request) => request(axios, basePath));
        },
    };
};

/**
 * Request parameters for createPersonalAccessToken operation in PersonalAccessTokenV1alpha1Api.
 * @export
 * @interface PersonalAccessTokenV1alpha1ApiCreatePersonalAccessTokenRequest
 */
export interface PersonalAccessTokenV1alpha1ApiCreatePersonalAccessTokenRequest {
    /**
     * Fresh personalaccesstoken
     * @type {PersonalAccessToken}
     * @memberof PersonalAccessTokenV1alpha1ApiCreatePersonalAccessToken
     */
    readonly personalAccessToken?: PersonalAccessToken
}

/**
 * Request parameters for deletePersonalAccessToken operation in PersonalAccessTokenV1alpha1Api.
 * @export
 * @interface PersonalAccessTokenV1alpha1ApiDeletePersonalAccessTokenRequest
 */
export interface PersonalAccessTokenV1alpha1ApiDeletePersonalAccessTokenRequest {
    /**
     * Name of personalaccesstoken
     * @type {string}
     * @memberof PersonalAccessTokenV1alpha1ApiDeletePersonalAccessToken
     */
    readonly name: string
}

/**
 * Request parameters for getPersonalAccessToken operation in PersonalAccessTokenV1alpha1Api.
 * @export
 * @interface PersonalAccessTokenV1alpha1ApiGetPersonalAccessTokenRequest
 */
export interface PersonalAccessTokenV1alpha1ApiGetPersonalAccessTokenRequest {
    /**
     * Name of personalaccesstoken
     * @type {string}
     * @memberof PersonalAccessTokenV1alpha1ApiGetPersonalAccessToken
     */
    readonly name: string
}

/**
 * Request parameters for listPersonalAccessToken operation in PersonalAccessTokenV1alpha1Api.
 * @export
 * @interface PersonalAccessTokenV1alpha1ApiListPersonalAccessTokenRequest
 */
export interface PersonalAccessTokenV1alpha1ApiListPersonalAccessTokenRequest {
    /**
     * Page number. Default is 0.
     * @type {number}
     * @memberof PersonalAccessTokenV1alpha1ApiListPersonalAccessToken
     */
    readonly page?: number

    /**
     * Size number. Default is 0.
     * @type {number}
     * @memberof PersonalAccessTokenV1alpha1ApiListPersonalAccessToken
     */
    readonly size?: number

    /**
     * Label selector. e.g.: hidden!&#x3D;true
     * @type {Array<string>}
     * @memberof PersonalAccessTokenV1alpha1ApiListPersonalAccessToken
     */
    readonly labelSelector?: Array<string>

    /**
     * Field selector. e.g.: metadata.name&#x3D;&#x3D;halo
     * @type {Array<string>}
     * @memberof PersonalAccessTokenV1alpha1ApiListPersonalAccessToken
     */
    readonly fieldSelector?: Array<string>

    /**
     * Sorting criteria in the format: property,(asc|desc). Default sort order is ascending. Multiple sort criteria are supported.
     * @type {Array<string>}
     * @memberof PersonalAccessTokenV1alpha1ApiListPersonalAccessToken
     */
    readonly sort?: Array<string>
}

/**
 * Request parameters for patchPersonalAccessToken operation in PersonalAccessTokenV1alpha1Api.
 * @export
 * @interface PersonalAccessTokenV1alpha1ApiPatchPersonalAccessTokenRequest
 */
export interface PersonalAccessTokenV1alpha1ApiPatchPersonalAccessTokenRequest {
    /**
     * Name of personalaccesstoken
     * @type {string}
     * @memberof PersonalAccessTokenV1alpha1ApiPatchPersonalAccessToken
     */
    readonly name: string

    /**
     * 
     * @type {Array<JsonPatchInner>}
     * @memberof PersonalAccessTokenV1alpha1ApiPatchPersonalAccessToken
     */
    readonly jsonPatchInner?: Array<JsonPatchInner>
}

/**
 * Request parameters for updatePersonalAccessToken operation in PersonalAccessTokenV1alpha1Api.
 * @export
 * @interface PersonalAccessTokenV1alpha1ApiUpdatePersonalAccessTokenRequest
 */
export interface PersonalAccessTokenV1alpha1ApiUpdatePersonalAccessTokenRequest {
    /**
     * Name of personalaccesstoken
     * @type {string}
     * @memberof PersonalAccessTokenV1alpha1ApiUpdatePersonalAccessToken
     */
    readonly name: string

    /**
     * Updated personalaccesstoken
     * @type {PersonalAccessToken}
     * @memberof PersonalAccessTokenV1alpha1ApiUpdatePersonalAccessToken
     */
    readonly personalAccessToken?: PersonalAccessToken
}

/**
 * PersonalAccessTokenV1alpha1Api - object-oriented interface
 * @export
 * @class PersonalAccessTokenV1alpha1Api
 * @extends {BaseAPI}
 */
export class PersonalAccessTokenV1alpha1Api extends BaseAPI {
    /**
     * Create PersonalAccessToken
     * @param {PersonalAccessTokenV1alpha1ApiCreatePersonalAccessTokenRequest} requestParameters Request parameters.
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof PersonalAccessTokenV1alpha1Api
     */
    public createPersonalAccessToken(requestParameters: PersonalAccessTokenV1alpha1ApiCreatePersonalAccessTokenRequest = {}, options?: RawAxiosRequestConfig) {
        return PersonalAccessTokenV1alpha1ApiFp(this.configuration).createPersonalAccessToken(requestParameters.personalAccessToken, options).then((request) => request(this.axios, this.basePath));
    }

    /**
     * Delete PersonalAccessToken
     * @param {PersonalAccessTokenV1alpha1ApiDeletePersonalAccessTokenRequest} requestParameters Request parameters.
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof PersonalAccessTokenV1alpha1Api
     */
    public deletePersonalAccessToken(requestParameters: PersonalAccessTokenV1alpha1ApiDeletePersonalAccessTokenRequest, options?: RawAxiosRequestConfig) {
        return PersonalAccessTokenV1alpha1ApiFp(this.configuration).deletePersonalAccessToken(requestParameters.name, options).then((request) => request(this.axios, this.basePath));
    }

    /**
     * Get PersonalAccessToken
     * @param {PersonalAccessTokenV1alpha1ApiGetPersonalAccessTokenRequest} requestParameters Request parameters.
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof PersonalAccessTokenV1alpha1Api
     */
    public getPersonalAccessToken(requestParameters: PersonalAccessTokenV1alpha1ApiGetPersonalAccessTokenRequest, options?: RawAxiosRequestConfig) {
        return PersonalAccessTokenV1alpha1ApiFp(this.configuration).getPersonalAccessToken(requestParameters.name, options).then((request) => request(this.axios, this.basePath));
    }

    /**
     * List PersonalAccessToken
     * @param {PersonalAccessTokenV1alpha1ApiListPersonalAccessTokenRequest} requestParameters Request parameters.
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof PersonalAccessTokenV1alpha1Api
     */
    public listPersonalAccessToken(requestParameters: PersonalAccessTokenV1alpha1ApiListPersonalAccessTokenRequest = {}, options?: RawAxiosRequestConfig) {
        return PersonalAccessTokenV1alpha1ApiFp(this.configuration).listPersonalAccessToken(requestParameters.page, requestParameters.size, requestParameters.labelSelector, requestParameters.fieldSelector, requestParameters.sort, options).then((request) => request(this.axios, this.basePath));
    }

    /**
     * Patch PersonalAccessToken
     * @param {PersonalAccessTokenV1alpha1ApiPatchPersonalAccessTokenRequest} requestParameters Request parameters.
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof PersonalAccessTokenV1alpha1Api
     */
    public patchPersonalAccessToken(requestParameters: PersonalAccessTokenV1alpha1ApiPatchPersonalAccessTokenRequest, options?: RawAxiosRequestConfig) {
        return PersonalAccessTokenV1alpha1ApiFp(this.configuration).patchPersonalAccessToken(requestParameters.name, requestParameters.jsonPatchInner, options).then((request) => request(this.axios, this.basePath));
    }

    /**
     * Update PersonalAccessToken
     * @param {PersonalAccessTokenV1alpha1ApiUpdatePersonalAccessTokenRequest} requestParameters Request parameters.
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof PersonalAccessTokenV1alpha1Api
     */
    public updatePersonalAccessToken(requestParameters: PersonalAccessTokenV1alpha1ApiUpdatePersonalAccessTokenRequest, options?: RawAxiosRequestConfig) {
        return PersonalAccessTokenV1alpha1ApiFp(this.configuration).updatePersonalAccessToken(requestParameters.name, requestParameters.personalAccessToken, options).then((request) => request(this.axios, this.basePath));
    }
}

