/* tslint:disable */
/* eslint-disable */
/**
 * Halo
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: 2.20.10-SNAPSHOT
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


import type { Configuration } from '../configuration';
import type { AxiosPromise, AxiosInstance, RawAxiosRequestConfig } from 'axios';
import globalAxios from 'axios';
// Some imports not used depending on template conditions
// @ts-ignore
import { DUMMY_BASE_URL, assertParamExists, setApiKeyToObject, setBasicAuthToObject, setBearerAuthToObject, setOAuthToObject, setSearchParams, serializeDataIfNeeded, toPathString, createRequestFunction } from '../common';
// @ts-ignore
import { BASE_PATH, COLLECTION_FORMATS, RequestArgs, BaseAPI, RequiredError, operationServerMap } from '../base';
// @ts-ignore
import { JsonPatchInner } from '../models';
// @ts-ignore
import { Plugin } from '../models';
// @ts-ignore
import { PluginList } from '../models';
/**
 * PluginV1alpha1Api - axios parameter creator
 * @export
 */
export const PluginV1alpha1ApiAxiosParamCreator = function (configuration?: Configuration) {
    return {
        /**
         * Create Plugin
         * @param {Plugin} [plugin] Fresh plugin
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        createPlugin: async (plugin?: Plugin, options: RawAxiosRequestConfig = {}): Promise<RequestArgs> => {
            const localVarPath = `/apis/plugin.halo.run/v1alpha1/plugins`;
            // use dummy base URL string because the URL constructor only accepts absolute URLs.
            const localVarUrlObj = new URL(localVarPath, DUMMY_BASE_URL);
            let baseOptions;
            if (configuration) {
                baseOptions = configuration.baseOptions;
            }

            const localVarRequestOptions = { method: 'POST', ...baseOptions, ...options};
            const localVarHeaderParameter = {} as any;
            const localVarQueryParameter = {} as any;

            // authentication basicAuth required
            // http basic authentication required
            setBasicAuthToObject(localVarRequestOptions, configuration)

            // authentication bearerAuth required
            // http bearer authentication required
            await setBearerAuthToObject(localVarHeaderParameter, configuration)


    
            localVarHeaderParameter['Content-Type'] = 'application/json';

            setSearchParams(localVarUrlObj, localVarQueryParameter);
            let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
            localVarRequestOptions.headers = {...localVarHeaderParameter, ...headersFromBaseOptions, ...options.headers};
            localVarRequestOptions.data = serializeDataIfNeeded(plugin, localVarRequestOptions, configuration)

            return {
                url: toPathString(localVarUrlObj),
                options: localVarRequestOptions,
            };
        },
        /**
         * Delete Plugin
         * @param {string} name Name of plugin
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        deletePlugin: async (name: string, options: RawAxiosRequestConfig = {}): Promise<RequestArgs> => {
            // verify required parameter 'name' is not null or undefined
            assertParamExists('deletePlugin', 'name', name)
            const localVarPath = `/apis/plugin.halo.run/v1alpha1/plugins/{name}`
                .replace(`{${"name"}}`, encodeURIComponent(String(name)));
            // use dummy base URL string because the URL constructor only accepts absolute URLs.
            const localVarUrlObj = new URL(localVarPath, DUMMY_BASE_URL);
            let baseOptions;
            if (configuration) {
                baseOptions = configuration.baseOptions;
            }

            const localVarRequestOptions = { method: 'DELETE', ...baseOptions, ...options};
            const localVarHeaderParameter = {} as any;
            const localVarQueryParameter = {} as any;

            // authentication basicAuth required
            // http basic authentication required
            setBasicAuthToObject(localVarRequestOptions, configuration)

            // authentication bearerAuth required
            // http bearer authentication required
            await setBearerAuthToObject(localVarHeaderParameter, configuration)


    
            setSearchParams(localVarUrlObj, localVarQueryParameter);
            let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
            localVarRequestOptions.headers = {...localVarHeaderParameter, ...headersFromBaseOptions, ...options.headers};

            return {
                url: toPathString(localVarUrlObj),
                options: localVarRequestOptions,
            };
        },
        /**
         * Get Plugin
         * @param {string} name Name of plugin
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        getPlugin: async (name: string, options: RawAxiosRequestConfig = {}): Promise<RequestArgs> => {
            // verify required parameter 'name' is not null or undefined
            assertParamExists('getPlugin', 'name', name)
            const localVarPath = `/apis/plugin.halo.run/v1alpha1/plugins/{name}`
                .replace(`{${"name"}}`, encodeURIComponent(String(name)));
            // use dummy base URL string because the URL constructor only accepts absolute URLs.
            const localVarUrlObj = new URL(localVarPath, DUMMY_BASE_URL);
            let baseOptions;
            if (configuration) {
                baseOptions = configuration.baseOptions;
            }

            const localVarRequestOptions = { method: 'GET', ...baseOptions, ...options};
            const localVarHeaderParameter = {} as any;
            const localVarQueryParameter = {} as any;

            // authentication basicAuth required
            // http basic authentication required
            setBasicAuthToObject(localVarRequestOptions, configuration)

            // authentication bearerAuth required
            // http bearer authentication required
            await setBearerAuthToObject(localVarHeaderParameter, configuration)


    
            setSearchParams(localVarUrlObj, localVarQueryParameter);
            let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
            localVarRequestOptions.headers = {...localVarHeaderParameter, ...headersFromBaseOptions, ...options.headers};

            return {
                url: toPathString(localVarUrlObj),
                options: localVarRequestOptions,
            };
        },
        /**
         * List Plugin
         * @param {number} [page] Page number. Default is 0.
         * @param {number} [size] Size number. Default is 0.
         * @param {Array<string>} [labelSelector] Label selector. e.g.: hidden!&#x3D;true
         * @param {Array<string>} [fieldSelector] Field selector. e.g.: metadata.name&#x3D;&#x3D;halo
         * @param {Array<string>} [sort] Sorting criteria in the format: property,(asc|desc). Default sort order is ascending. Multiple sort criteria are supported.
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        listPlugin: async (page?: number, size?: number, labelSelector?: Array<string>, fieldSelector?: Array<string>, sort?: Array<string>, options: RawAxiosRequestConfig = {}): Promise<RequestArgs> => {
            const localVarPath = `/apis/plugin.halo.run/v1alpha1/plugins`;
            // use dummy base URL string because the URL constructor only accepts absolute URLs.
            const localVarUrlObj = new URL(localVarPath, DUMMY_BASE_URL);
            let baseOptions;
            if (configuration) {
                baseOptions = configuration.baseOptions;
            }

            const localVarRequestOptions = { method: 'GET', ...baseOptions, ...options};
            const localVarHeaderParameter = {} as any;
            const localVarQueryParameter = {} as any;

            // authentication basicAuth required
            // http basic authentication required
            setBasicAuthToObject(localVarRequestOptions, configuration)

            // authentication bearerAuth required
            // http bearer authentication required
            await setBearerAuthToObject(localVarHeaderParameter, configuration)

            if (page !== undefined) {
                localVarQueryParameter['page'] = page;
            }

            if (size !== undefined) {
                localVarQueryParameter['size'] = size;
            }

            if (labelSelector) {
                localVarQueryParameter['labelSelector'] = labelSelector;
            }

            if (fieldSelector) {
                localVarQueryParameter['fieldSelector'] = fieldSelector;
            }

            if (sort) {
                localVarQueryParameter['sort'] = sort;
            }


    
            setSearchParams(localVarUrlObj, localVarQueryParameter);
            let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
            localVarRequestOptions.headers = {...localVarHeaderParameter, ...headersFromBaseOptions, ...options.headers};

            return {
                url: toPathString(localVarUrlObj),
                options: localVarRequestOptions,
            };
        },
        /**
         * Patch Plugin
         * @param {string} name Name of plugin
         * @param {Array<JsonPatchInner>} [jsonPatchInner] 
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        patchPlugin: async (name: string, jsonPatchInner?: Array<JsonPatchInner>, options: RawAxiosRequestConfig = {}): Promise<RequestArgs> => {
            // verify required parameter 'name' is not null or undefined
            assertParamExists('patchPlugin', 'name', name)
            const localVarPath = `/apis/plugin.halo.run/v1alpha1/plugins/{name}`
                .replace(`{${"name"}}`, encodeURIComponent(String(name)));
            // use dummy base URL string because the URL constructor only accepts absolute URLs.
            const localVarUrlObj = new URL(localVarPath, DUMMY_BASE_URL);
            let baseOptions;
            if (configuration) {
                baseOptions = configuration.baseOptions;
            }

            const localVarRequestOptions = { method: 'PATCH', ...baseOptions, ...options};
            const localVarHeaderParameter = {} as any;
            const localVarQueryParameter = {} as any;

            // authentication basicAuth required
            // http basic authentication required
            setBasicAuthToObject(localVarRequestOptions, configuration)

            // authentication bearerAuth required
            // http bearer authentication required
            await setBearerAuthToObject(localVarHeaderParameter, configuration)


    
            localVarHeaderParameter['Content-Type'] = 'application/json-patch+json';

            setSearchParams(localVarUrlObj, localVarQueryParameter);
            let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
            localVarRequestOptions.headers = {...localVarHeaderParameter, ...headersFromBaseOptions, ...options.headers};
            localVarRequestOptions.data = serializeDataIfNeeded(jsonPatchInner, localVarRequestOptions, configuration)

            return {
                url: toPathString(localVarUrlObj),
                options: localVarRequestOptions,
            };
        },
        /**
         * Update Plugin
         * @param {string} name Name of plugin
         * @param {Plugin} [plugin] Updated plugin
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        updatePlugin: async (name: string, plugin?: Plugin, options: RawAxiosRequestConfig = {}): Promise<RequestArgs> => {
            // verify required parameter 'name' is not null or undefined
            assertParamExists('updatePlugin', 'name', name)
            const localVarPath = `/apis/plugin.halo.run/v1alpha1/plugins/{name}`
                .replace(`{${"name"}}`, encodeURIComponent(String(name)));
            // use dummy base URL string because the URL constructor only accepts absolute URLs.
            const localVarUrlObj = new URL(localVarPath, DUMMY_BASE_URL);
            let baseOptions;
            if (configuration) {
                baseOptions = configuration.baseOptions;
            }

            const localVarRequestOptions = { method: 'PUT', ...baseOptions, ...options};
            const localVarHeaderParameter = {} as any;
            const localVarQueryParameter = {} as any;

            // authentication basicAuth required
            // http basic authentication required
            setBasicAuthToObject(localVarRequestOptions, configuration)

            // authentication bearerAuth required
            // http bearer authentication required
            await setBearerAuthToObject(localVarHeaderParameter, configuration)


    
            localVarHeaderParameter['Content-Type'] = 'application/json';

            setSearchParams(localVarUrlObj, localVarQueryParameter);
            let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
            localVarRequestOptions.headers = {...localVarHeaderParameter, ...headersFromBaseOptions, ...options.headers};
            localVarRequestOptions.data = serializeDataIfNeeded(plugin, localVarRequestOptions, configuration)

            return {
                url: toPathString(localVarUrlObj),
                options: localVarRequestOptions,
            };
        },
    }
};

/**
 * PluginV1alpha1Api - functional programming interface
 * @export
 */
export const PluginV1alpha1ApiFp = function(configuration?: Configuration) {
    const localVarAxiosParamCreator = PluginV1alpha1ApiAxiosParamCreator(configuration)
    return {
        /**
         * Create Plugin
         * @param {Plugin} [plugin] Fresh plugin
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        async createPlugin(plugin?: Plugin, options?: RawAxiosRequestConfig): Promise<(axios?: AxiosInstance, basePath?: string) => AxiosPromise<Plugin>> {
            const localVarAxiosArgs = await localVarAxiosParamCreator.createPlugin(plugin, options);
            const localVarOperationServerIndex = configuration?.serverIndex ?? 0;
            const localVarOperationServerBasePath = operationServerMap['PluginV1alpha1Api.createPlugin']?.[localVarOperationServerIndex]?.url;
            return (axios, basePath) => createRequestFunction(localVarAxiosArgs, globalAxios, BASE_PATH, configuration)(axios, localVarOperationServerBasePath || basePath);
        },
        /**
         * Delete Plugin
         * @param {string} name Name of plugin
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        async deletePlugin(name: string, options?: RawAxiosRequestConfig): Promise<(axios?: AxiosInstance, basePath?: string) => AxiosPromise<void>> {
            const localVarAxiosArgs = await localVarAxiosParamCreator.deletePlugin(name, options);
            const localVarOperationServerIndex = configuration?.serverIndex ?? 0;
            const localVarOperationServerBasePath = operationServerMap['PluginV1alpha1Api.deletePlugin']?.[localVarOperationServerIndex]?.url;
            return (axios, basePath) => createRequestFunction(localVarAxiosArgs, globalAxios, BASE_PATH, configuration)(axios, localVarOperationServerBasePath || basePath);
        },
        /**
         * Get Plugin
         * @param {string} name Name of plugin
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        async getPlugin(name: string, options?: RawAxiosRequestConfig): Promise<(axios?: AxiosInstance, basePath?: string) => AxiosPromise<Plugin>> {
            const localVarAxiosArgs = await localVarAxiosParamCreator.getPlugin(name, options);
            const localVarOperationServerIndex = configuration?.serverIndex ?? 0;
            const localVarOperationServerBasePath = operationServerMap['PluginV1alpha1Api.getPlugin']?.[localVarOperationServerIndex]?.url;
            return (axios, basePath) => createRequestFunction(localVarAxiosArgs, globalAxios, BASE_PATH, configuration)(axios, localVarOperationServerBasePath || basePath);
        },
        /**
         * List Plugin
         * @param {number} [page] Page number. Default is 0.
         * @param {number} [size] Size number. Default is 0.
         * @param {Array<string>} [labelSelector] Label selector. e.g.: hidden!&#x3D;true
         * @param {Array<string>} [fieldSelector] Field selector. e.g.: metadata.name&#x3D;&#x3D;halo
         * @param {Array<string>} [sort] Sorting criteria in the format: property,(asc|desc). Default sort order is ascending. Multiple sort criteria are supported.
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        async listPlugin(page?: number, size?: number, labelSelector?: Array<string>, fieldSelector?: Array<string>, sort?: Array<string>, options?: RawAxiosRequestConfig): Promise<(axios?: AxiosInstance, basePath?: string) => AxiosPromise<PluginList>> {
            const localVarAxiosArgs = await localVarAxiosParamCreator.listPlugin(page, size, labelSelector, fieldSelector, sort, options);
            const localVarOperationServerIndex = configuration?.serverIndex ?? 0;
            const localVarOperationServerBasePath = operationServerMap['PluginV1alpha1Api.listPlugin']?.[localVarOperationServerIndex]?.url;
            return (axios, basePath) => createRequestFunction(localVarAxiosArgs, globalAxios, BASE_PATH, configuration)(axios, localVarOperationServerBasePath || basePath);
        },
        /**
         * Patch Plugin
         * @param {string} name Name of plugin
         * @param {Array<JsonPatchInner>} [jsonPatchInner] 
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        async patchPlugin(name: string, jsonPatchInner?: Array<JsonPatchInner>, options?: RawAxiosRequestConfig): Promise<(axios?: AxiosInstance, basePath?: string) => AxiosPromise<Plugin>> {
            const localVarAxiosArgs = await localVarAxiosParamCreator.patchPlugin(name, jsonPatchInner, options);
            const localVarOperationServerIndex = configuration?.serverIndex ?? 0;
            const localVarOperationServerBasePath = operationServerMap['PluginV1alpha1Api.patchPlugin']?.[localVarOperationServerIndex]?.url;
            return (axios, basePath) => createRequestFunction(localVarAxiosArgs, globalAxios, BASE_PATH, configuration)(axios, localVarOperationServerBasePath || basePath);
        },
        /**
         * Update Plugin
         * @param {string} name Name of plugin
         * @param {Plugin} [plugin] Updated plugin
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        async updatePlugin(name: string, plugin?: Plugin, options?: RawAxiosRequestConfig): Promise<(axios?: AxiosInstance, basePath?: string) => AxiosPromise<Plugin>> {
            const localVarAxiosArgs = await localVarAxiosParamCreator.updatePlugin(name, plugin, options);
            const localVarOperationServerIndex = configuration?.serverIndex ?? 0;
            const localVarOperationServerBasePath = operationServerMap['PluginV1alpha1Api.updatePlugin']?.[localVarOperationServerIndex]?.url;
            return (axios, basePath) => createRequestFunction(localVarAxiosArgs, globalAxios, BASE_PATH, configuration)(axios, localVarOperationServerBasePath || basePath);
        },
    }
};

/**
 * PluginV1alpha1Api - factory interface
 * @export
 */
export const PluginV1alpha1ApiFactory = function (configuration?: Configuration, basePath?: string, axios?: AxiosInstance) {
    const localVarFp = PluginV1alpha1ApiFp(configuration)
    return {
        /**
         * Create Plugin
         * @param {PluginV1alpha1ApiCreatePluginRequest} requestParameters Request parameters.
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        createPlugin(requestParameters: PluginV1alpha1ApiCreatePluginRequest = {}, options?: RawAxiosRequestConfig): AxiosPromise<Plugin> {
            return localVarFp.createPlugin(requestParameters.plugin, options).then((request) => request(axios, basePath));
        },
        /**
         * Delete Plugin
         * @param {PluginV1alpha1ApiDeletePluginRequest} requestParameters Request parameters.
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        deletePlugin(requestParameters: PluginV1alpha1ApiDeletePluginRequest, options?: RawAxiosRequestConfig): AxiosPromise<void> {
            return localVarFp.deletePlugin(requestParameters.name, options).then((request) => request(axios, basePath));
        },
        /**
         * Get Plugin
         * @param {PluginV1alpha1ApiGetPluginRequest} requestParameters Request parameters.
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        getPlugin(requestParameters: PluginV1alpha1ApiGetPluginRequest, options?: RawAxiosRequestConfig): AxiosPromise<Plugin> {
            return localVarFp.getPlugin(requestParameters.name, options).then((request) => request(axios, basePath));
        },
        /**
         * List Plugin
         * @param {PluginV1alpha1ApiListPluginRequest} requestParameters Request parameters.
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        listPlugin(requestParameters: PluginV1alpha1ApiListPluginRequest = {}, options?: RawAxiosRequestConfig): AxiosPromise<PluginList> {
            return localVarFp.listPlugin(requestParameters.page, requestParameters.size, requestParameters.labelSelector, requestParameters.fieldSelector, requestParameters.sort, options).then((request) => request(axios, basePath));
        },
        /**
         * Patch Plugin
         * @param {PluginV1alpha1ApiPatchPluginRequest} requestParameters Request parameters.
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        patchPlugin(requestParameters: PluginV1alpha1ApiPatchPluginRequest, options?: RawAxiosRequestConfig): AxiosPromise<Plugin> {
            return localVarFp.patchPlugin(requestParameters.name, requestParameters.jsonPatchInner, options).then((request) => request(axios, basePath));
        },
        /**
         * Update Plugin
         * @param {PluginV1alpha1ApiUpdatePluginRequest} requestParameters Request parameters.
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        updatePlugin(requestParameters: PluginV1alpha1ApiUpdatePluginRequest, options?: RawAxiosRequestConfig): AxiosPromise<Plugin> {
            return localVarFp.updatePlugin(requestParameters.name, requestParameters.plugin, options).then((request) => request(axios, basePath));
        },
    };
};

/**
 * Request parameters for createPlugin operation in PluginV1alpha1Api.
 * @export
 * @interface PluginV1alpha1ApiCreatePluginRequest
 */
export interface PluginV1alpha1ApiCreatePluginRequest {
    /**
     * Fresh plugin
     * @type {Plugin}
     * @memberof PluginV1alpha1ApiCreatePlugin
     */
    readonly plugin?: Plugin
}

/**
 * Request parameters for deletePlugin operation in PluginV1alpha1Api.
 * @export
 * @interface PluginV1alpha1ApiDeletePluginRequest
 */
export interface PluginV1alpha1ApiDeletePluginRequest {
    /**
     * Name of plugin
     * @type {string}
     * @memberof PluginV1alpha1ApiDeletePlugin
     */
    readonly name: string
}

/**
 * Request parameters for getPlugin operation in PluginV1alpha1Api.
 * @export
 * @interface PluginV1alpha1ApiGetPluginRequest
 */
export interface PluginV1alpha1ApiGetPluginRequest {
    /**
     * Name of plugin
     * @type {string}
     * @memberof PluginV1alpha1ApiGetPlugin
     */
    readonly name: string
}

/**
 * Request parameters for listPlugin operation in PluginV1alpha1Api.
 * @export
 * @interface PluginV1alpha1ApiListPluginRequest
 */
export interface PluginV1alpha1ApiListPluginRequest {
    /**
     * Page number. Default is 0.
     * @type {number}
     * @memberof PluginV1alpha1ApiListPlugin
     */
    readonly page?: number

    /**
     * Size number. Default is 0.
     * @type {number}
     * @memberof PluginV1alpha1ApiListPlugin
     */
    readonly size?: number

    /**
     * Label selector. e.g.: hidden!&#x3D;true
     * @type {Array<string>}
     * @memberof PluginV1alpha1ApiListPlugin
     */
    readonly labelSelector?: Array<string>

    /**
     * Field selector. e.g.: metadata.name&#x3D;&#x3D;halo
     * @type {Array<string>}
     * @memberof PluginV1alpha1ApiListPlugin
     */
    readonly fieldSelector?: Array<string>

    /**
     * Sorting criteria in the format: property,(asc|desc). Default sort order is ascending. Multiple sort criteria are supported.
     * @type {Array<string>}
     * @memberof PluginV1alpha1ApiListPlugin
     */
    readonly sort?: Array<string>
}

/**
 * Request parameters for patchPlugin operation in PluginV1alpha1Api.
 * @export
 * @interface PluginV1alpha1ApiPatchPluginRequest
 */
export interface PluginV1alpha1ApiPatchPluginRequest {
    /**
     * Name of plugin
     * @type {string}
     * @memberof PluginV1alpha1ApiPatchPlugin
     */
    readonly name: string

    /**
     * 
     * @type {Array<JsonPatchInner>}
     * @memberof PluginV1alpha1ApiPatchPlugin
     */
    readonly jsonPatchInner?: Array<JsonPatchInner>
}

/**
 * Request parameters for updatePlugin operation in PluginV1alpha1Api.
 * @export
 * @interface PluginV1alpha1ApiUpdatePluginRequest
 */
export interface PluginV1alpha1ApiUpdatePluginRequest {
    /**
     * Name of plugin
     * @type {string}
     * @memberof PluginV1alpha1ApiUpdatePlugin
     */
    readonly name: string

    /**
     * Updated plugin
     * @type {Plugin}
     * @memberof PluginV1alpha1ApiUpdatePlugin
     */
    readonly plugin?: Plugin
}

/**
 * PluginV1alpha1Api - object-oriented interface
 * @export
 * @class PluginV1alpha1Api
 * @extends {BaseAPI}
 */
export class PluginV1alpha1Api extends BaseAPI {
    /**
     * Create Plugin
     * @param {PluginV1alpha1ApiCreatePluginRequest} requestParameters Request parameters.
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof PluginV1alpha1Api
     */
    public createPlugin(requestParameters: PluginV1alpha1ApiCreatePluginRequest = {}, options?: RawAxiosRequestConfig) {
        return PluginV1alpha1ApiFp(this.configuration).createPlugin(requestParameters.plugin, options).then((request) => request(this.axios, this.basePath));
    }

    /**
     * Delete Plugin
     * @param {PluginV1alpha1ApiDeletePluginRequest} requestParameters Request parameters.
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof PluginV1alpha1Api
     */
    public deletePlugin(requestParameters: PluginV1alpha1ApiDeletePluginRequest, options?: RawAxiosRequestConfig) {
        return PluginV1alpha1ApiFp(this.configuration).deletePlugin(requestParameters.name, options).then((request) => request(this.axios, this.basePath));
    }

    /**
     * Get Plugin
     * @param {PluginV1alpha1ApiGetPluginRequest} requestParameters Request parameters.
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof PluginV1alpha1Api
     */
    public getPlugin(requestParameters: PluginV1alpha1ApiGetPluginRequest, options?: RawAxiosRequestConfig) {
        return PluginV1alpha1ApiFp(this.configuration).getPlugin(requestParameters.name, options).then((request) => request(this.axios, this.basePath));
    }

    /**
     * List Plugin
     * @param {PluginV1alpha1ApiListPluginRequest} requestParameters Request parameters.
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof PluginV1alpha1Api
     */
    public listPlugin(requestParameters: PluginV1alpha1ApiListPluginRequest = {}, options?: RawAxiosRequestConfig) {
        return PluginV1alpha1ApiFp(this.configuration).listPlugin(requestParameters.page, requestParameters.size, requestParameters.labelSelector, requestParameters.fieldSelector, requestParameters.sort, options).then((request) => request(this.axios, this.basePath));
    }

    /**
     * Patch Plugin
     * @param {PluginV1alpha1ApiPatchPluginRequest} requestParameters Request parameters.
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof PluginV1alpha1Api
     */
    public patchPlugin(requestParameters: PluginV1alpha1ApiPatchPluginRequest, options?: RawAxiosRequestConfig) {
        return PluginV1alpha1ApiFp(this.configuration).patchPlugin(requestParameters.name, requestParameters.jsonPatchInner, options).then((request) => request(this.axios, this.basePath));
    }

    /**
     * Update Plugin
     * @param {PluginV1alpha1ApiUpdatePluginRequest} requestParameters Request parameters.
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof PluginV1alpha1Api
     */
    public updatePlugin(requestParameters: PluginV1alpha1ApiUpdatePluginRequest, options?: RawAxiosRequestConfig) {
        return PluginV1alpha1ApiFp(this.configuration).updatePlugin(requestParameters.name, requestParameters.plugin, options).then((request) => request(this.axios, this.basePath));
    }
}

