/* tslint:disable */
/* eslint-disable */
/**
 * Halo
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: 2.20.10-SNAPSHOT
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


import type { Configuration } from '../configuration';
import type { AxiosPromise, AxiosInstance, RawAxiosRequestConfig } from 'axios';
import globalAxios from 'axios';
// Some imports not used depending on template conditions
// @ts-ignore
import { DUMMY_BASE_URL, assertParamExists, setApiKeyToObject, setBasicAuthToObject, setBearerAuthToObject, setOAuthToObject, setSearchParams, serializeDataIfNeeded, toPathString, createRequestFunction } from '../common';
// @ts-ignore
import { BASE_PATH, COLLECTION_FORMATS, RequestArgs, BaseAPI, RequiredError, operationServerMap } from '../base';
// @ts-ignore
import { ConfigMap } from '../models';
// @ts-ignore
import { InstallFromUriRequest } from '../models';
// @ts-ignore
import { Plugin } from '../models';
// @ts-ignore
import { PluginList } from '../models';
// @ts-ignore
import { PluginRunningStateRequest } from '../models';
// @ts-ignore
import { Setting } from '../models';
// @ts-ignore
import { UpgradeFromUriRequest } from '../models';
/**
 * PluginV1alpha1ConsoleApi - axios parameter creator
 * @export
 */
export const PluginV1alpha1ConsoleApiAxiosParamCreator = function (configuration?: Configuration) {
    return {
        /**
         * Change the running state of a plugin by name.
         * @param {string} name 
         * @param {PluginRunningStateRequest} pluginRunningStateRequest 
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        changePluginRunningState: async (name: string, pluginRunningStateRequest: PluginRunningStateRequest, options: RawAxiosRequestConfig = {}): Promise<RequestArgs> => {
            // verify required parameter 'name' is not null or undefined
            assertParamExists('changePluginRunningState', 'name', name)
            // verify required parameter 'pluginRunningStateRequest' is not null or undefined
            assertParamExists('changePluginRunningState', 'pluginRunningStateRequest', pluginRunningStateRequest)
            const localVarPath = `/apis/api.console.halo.run/v1alpha1/plugins/{name}/plugin-state`
                .replace(`{${"name"}}`, encodeURIComponent(String(name)));
            // use dummy base URL string because the URL constructor only accepts absolute URLs.
            const localVarUrlObj = new URL(localVarPath, DUMMY_BASE_URL);
            let baseOptions;
            if (configuration) {
                baseOptions = configuration.baseOptions;
            }

            const localVarRequestOptions = { method: 'PUT', ...baseOptions, ...options};
            const localVarHeaderParameter = {} as any;
            const localVarQueryParameter = {} as any;

            // authentication basicAuth required
            // http basic authentication required
            setBasicAuthToObject(localVarRequestOptions, configuration)

            // authentication bearerAuth required
            // http bearer authentication required
            await setBearerAuthToObject(localVarHeaderParameter, configuration)


    
            localVarHeaderParameter['Content-Type'] = 'application/json';

            setSearchParams(localVarUrlObj, localVarQueryParameter);
            let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
            localVarRequestOptions.headers = {...localVarHeaderParameter, ...headersFromBaseOptions, ...options.headers};
            localVarRequestOptions.data = serializeDataIfNeeded(pluginRunningStateRequest, localVarRequestOptions, configuration)

            return {
                url: toPathString(localVarUrlObj),
                options: localVarRequestOptions,
            };
        },
        /**
         * Merge all CSS bundles of enabled plugins into one.
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        fetchCssBundle: async (options: RawAxiosRequestConfig = {}): Promise<RequestArgs> => {
            const localVarPath = `/apis/api.console.halo.run/v1alpha1/plugins/-/bundle.css`;
            // use dummy base URL string because the URL constructor only accepts absolute URLs.
            const localVarUrlObj = new URL(localVarPath, DUMMY_BASE_URL);
            let baseOptions;
            if (configuration) {
                baseOptions = configuration.baseOptions;
            }

            const localVarRequestOptions = { method: 'GET', ...baseOptions, ...options};
            const localVarHeaderParameter = {} as any;
            const localVarQueryParameter = {} as any;

            // authentication basicAuth required
            // http basic authentication required
            setBasicAuthToObject(localVarRequestOptions, configuration)

            // authentication bearerAuth required
            // http bearer authentication required
            await setBearerAuthToObject(localVarHeaderParameter, configuration)


    
            setSearchParams(localVarUrlObj, localVarQueryParameter);
            let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
            localVarRequestOptions.headers = {...localVarHeaderParameter, ...headersFromBaseOptions, ...options.headers};

            return {
                url: toPathString(localVarUrlObj),
                options: localVarRequestOptions,
            };
        },
        /**
         * Merge all JS bundles of enabled plugins into one.
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        fetchJsBundle: async (options: RawAxiosRequestConfig = {}): Promise<RequestArgs> => {
            const localVarPath = `/apis/api.console.halo.run/v1alpha1/plugins/-/bundle.js`;
            // use dummy base URL string because the URL constructor only accepts absolute URLs.
            const localVarUrlObj = new URL(localVarPath, DUMMY_BASE_URL);
            let baseOptions;
            if (configuration) {
                baseOptions = configuration.baseOptions;
            }

            const localVarRequestOptions = { method: 'GET', ...baseOptions, ...options};
            const localVarHeaderParameter = {} as any;
            const localVarQueryParameter = {} as any;

            // authentication basicAuth required
            // http basic authentication required
            setBasicAuthToObject(localVarRequestOptions, configuration)

            // authentication bearerAuth required
            // http bearer authentication required
            await setBearerAuthToObject(localVarHeaderParameter, configuration)


    
            setSearchParams(localVarUrlObj, localVarQueryParameter);
            let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
            localVarRequestOptions.headers = {...localVarHeaderParameter, ...headersFromBaseOptions, ...options.headers};

            return {
                url: toPathString(localVarUrlObj),
                options: localVarRequestOptions,
            };
        },
        /**
         * Fetch configMap of plugin by configured configMapName. it is deprecated since 2.20.0
         * @param {string} name 
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        fetchPluginConfig: async (name: string, options: RawAxiosRequestConfig = {}): Promise<RequestArgs> => {
            // verify required parameter 'name' is not null or undefined
            assertParamExists('fetchPluginConfig', 'name', name)
            const localVarPath = `/apis/api.console.halo.run/v1alpha1/plugins/{name}/config`
                .replace(`{${"name"}}`, encodeURIComponent(String(name)));
            // use dummy base URL string because the URL constructor only accepts absolute URLs.
            const localVarUrlObj = new URL(localVarPath, DUMMY_BASE_URL);
            let baseOptions;
            if (configuration) {
                baseOptions = configuration.baseOptions;
            }

            const localVarRequestOptions = { method: 'GET', ...baseOptions, ...options};
            const localVarHeaderParameter = {} as any;
            const localVarQueryParameter = {} as any;

            // authentication basicAuth required
            // http basic authentication required
            setBasicAuthToObject(localVarRequestOptions, configuration)

            // authentication bearerAuth required
            // http bearer authentication required
            await setBearerAuthToObject(localVarHeaderParameter, configuration)


    
            setSearchParams(localVarUrlObj, localVarQueryParameter);
            let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
            localVarRequestOptions.headers = {...localVarHeaderParameter, ...headersFromBaseOptions, ...options.headers};

            return {
                url: toPathString(localVarUrlObj),
                options: localVarRequestOptions,
            };
        },
        /**
         * Fetch converted json config of plugin by configured configMapName.
         * @param {string} name 
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        fetchPluginJsonConfig: async (name: string, options: RawAxiosRequestConfig = {}): Promise<RequestArgs> => {
            // verify required parameter 'name' is not null or undefined
            assertParamExists('fetchPluginJsonConfig', 'name', name)
            const localVarPath = `/apis/api.console.halo.run/v1alpha1/plugins/{name}/json-config`
                .replace(`{${"name"}}`, encodeURIComponent(String(name)));
            // use dummy base URL string because the URL constructor only accepts absolute URLs.
            const localVarUrlObj = new URL(localVarPath, DUMMY_BASE_URL);
            let baseOptions;
            if (configuration) {
                baseOptions = configuration.baseOptions;
            }

            const localVarRequestOptions = { method: 'GET', ...baseOptions, ...options};
            const localVarHeaderParameter = {} as any;
            const localVarQueryParameter = {} as any;

            // authentication basicAuth required
            // http basic authentication required
            setBasicAuthToObject(localVarRequestOptions, configuration)

            // authentication bearerAuth required
            // http bearer authentication required
            await setBearerAuthToObject(localVarHeaderParameter, configuration)


    
            setSearchParams(localVarUrlObj, localVarQueryParameter);
            let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
            localVarRequestOptions.headers = {...localVarHeaderParameter, ...headersFromBaseOptions, ...options.headers};

            return {
                url: toPathString(localVarUrlObj),
                options: localVarRequestOptions,
            };
        },
        /**
         * Fetch setting of plugin.
         * @param {string} name 
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        fetchPluginSetting: async (name: string, options: RawAxiosRequestConfig = {}): Promise<RequestArgs> => {
            // verify required parameter 'name' is not null or undefined
            assertParamExists('fetchPluginSetting', 'name', name)
            const localVarPath = `/apis/api.console.halo.run/v1alpha1/plugins/{name}/setting`
                .replace(`{${"name"}}`, encodeURIComponent(String(name)));
            // use dummy base URL string because the URL constructor only accepts absolute URLs.
            const localVarUrlObj = new URL(localVarPath, DUMMY_BASE_URL);
            let baseOptions;
            if (configuration) {
                baseOptions = configuration.baseOptions;
            }

            const localVarRequestOptions = { method: 'GET', ...baseOptions, ...options};
            const localVarHeaderParameter = {} as any;
            const localVarQueryParameter = {} as any;

            // authentication basicAuth required
            // http basic authentication required
            setBasicAuthToObject(localVarRequestOptions, configuration)

            // authentication bearerAuth required
            // http bearer authentication required
            await setBearerAuthToObject(localVarHeaderParameter, configuration)


    
            setSearchParams(localVarUrlObj, localVarQueryParameter);
            let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
            localVarRequestOptions.headers = {...localVarHeaderParameter, ...headersFromBaseOptions, ...options.headers};

            return {
                url: toPathString(localVarUrlObj),
                options: localVarRequestOptions,
            };
        },
        /**
         * Install a plugin by uploading a Jar file.
         * @param {File} [file] 
         * @param {string} [presetName] Plugin preset name. We will find the plugin from plugin presets
         * @param {InstallPluginSourceEnum} [source] Install source. Default is file.
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        installPlugin: async (file?: File, presetName?: string, source?: InstallPluginSourceEnum, options: RawAxiosRequestConfig = {}): Promise<RequestArgs> => {
            const localVarPath = `/apis/api.console.halo.run/v1alpha1/plugins/install`;
            // use dummy base URL string because the URL constructor only accepts absolute URLs.
            const localVarUrlObj = new URL(localVarPath, DUMMY_BASE_URL);
            let baseOptions;
            if (configuration) {
                baseOptions = configuration.baseOptions;
            }

            const localVarRequestOptions = { method: 'POST', ...baseOptions, ...options};
            const localVarHeaderParameter = {} as any;
            const localVarQueryParameter = {} as any;
            const localVarFormParams = new ((configuration && configuration.formDataCtor) || FormData)();

            // authentication basicAuth required
            // http basic authentication required
            setBasicAuthToObject(localVarRequestOptions, configuration)

            // authentication bearerAuth required
            // http bearer authentication required
            await setBearerAuthToObject(localVarHeaderParameter, configuration)


            if (file !== undefined) { 
                localVarFormParams.append('file', file as any);
            }
    
            if (presetName !== undefined) { 
                localVarFormParams.append('presetName', presetName as any);
            }
    
            if (source !== undefined) { 
                localVarFormParams.append('source', source as any);
            }
    
    
            localVarHeaderParameter['Content-Type'] = 'multipart/form-data';
    
            setSearchParams(localVarUrlObj, localVarQueryParameter);
            let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
            localVarRequestOptions.headers = {...localVarHeaderParameter, ...headersFromBaseOptions, ...options.headers};
            localVarRequestOptions.data = localVarFormParams;

            return {
                url: toPathString(localVarUrlObj),
                options: localVarRequestOptions,
            };
        },
        /**
         * Install a plugin from uri.
         * @param {InstallFromUriRequest} installFromUriRequest 
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        installPluginFromUri: async (installFromUriRequest: InstallFromUriRequest, options: RawAxiosRequestConfig = {}): Promise<RequestArgs> => {
            // verify required parameter 'installFromUriRequest' is not null or undefined
            assertParamExists('installPluginFromUri', 'installFromUriRequest', installFromUriRequest)
            const localVarPath = `/apis/api.console.halo.run/v1alpha1/plugins/-/install-from-uri`;
            // use dummy base URL string because the URL constructor only accepts absolute URLs.
            const localVarUrlObj = new URL(localVarPath, DUMMY_BASE_URL);
            let baseOptions;
            if (configuration) {
                baseOptions = configuration.baseOptions;
            }

            const localVarRequestOptions = { method: 'POST', ...baseOptions, ...options};
            const localVarHeaderParameter = {} as any;
            const localVarQueryParameter = {} as any;

            // authentication basicAuth required
            // http basic authentication required
            setBasicAuthToObject(localVarRequestOptions, configuration)

            // authentication bearerAuth required
            // http bearer authentication required
            await setBearerAuthToObject(localVarHeaderParameter, configuration)


    
            localVarHeaderParameter['Content-Type'] = 'application/json';

            setSearchParams(localVarUrlObj, localVarQueryParameter);
            let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
            localVarRequestOptions.headers = {...localVarHeaderParameter, ...headersFromBaseOptions, ...options.headers};
            localVarRequestOptions.data = serializeDataIfNeeded(installFromUriRequest, localVarRequestOptions, configuration)

            return {
                url: toPathString(localVarUrlObj),
                options: localVarRequestOptions,
            };
        },
        /**
         * List plugins using query criteria and sort params
         * @param {number} [page] Page number. Default is 0.
         * @param {number} [size] Size number. Default is 0.
         * @param {Array<string>} [labelSelector] Label selector. e.g.: hidden!&#x3D;true
         * @param {Array<string>} [fieldSelector] Field selector. e.g.: metadata.name&#x3D;&#x3D;halo
         * @param {Array<string>} [sort] Sorting criteria in the format: property,(asc|desc). Default sort order is ascending. Multiple sort criteria are supported.
         * @param {string} [keyword] Keyword of plugin name or description
         * @param {boolean} [enabled] Whether the plugin is enabled
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        listPlugins: async (page?: number, size?: number, labelSelector?: Array<string>, fieldSelector?: Array<string>, sort?: Array<string>, keyword?: string, enabled?: boolean, options: RawAxiosRequestConfig = {}): Promise<RequestArgs> => {
            const localVarPath = `/apis/api.console.halo.run/v1alpha1/plugins`;
            // use dummy base URL string because the URL constructor only accepts absolute URLs.
            const localVarUrlObj = new URL(localVarPath, DUMMY_BASE_URL);
            let baseOptions;
            if (configuration) {
                baseOptions = configuration.baseOptions;
            }

            const localVarRequestOptions = { method: 'GET', ...baseOptions, ...options};
            const localVarHeaderParameter = {} as any;
            const localVarQueryParameter = {} as any;

            // authentication basicAuth required
            // http basic authentication required
            setBasicAuthToObject(localVarRequestOptions, configuration)

            // authentication bearerAuth required
            // http bearer authentication required
            await setBearerAuthToObject(localVarHeaderParameter, configuration)

            if (page !== undefined) {
                localVarQueryParameter['page'] = page;
            }

            if (size !== undefined) {
                localVarQueryParameter['size'] = size;
            }

            if (labelSelector) {
                localVarQueryParameter['labelSelector'] = labelSelector;
            }

            if (fieldSelector) {
                localVarQueryParameter['fieldSelector'] = fieldSelector;
            }

            if (sort) {
                localVarQueryParameter['sort'] = sort;
            }

            if (keyword !== undefined) {
                localVarQueryParameter['keyword'] = keyword;
            }

            if (enabled !== undefined) {
                localVarQueryParameter['enabled'] = enabled;
            }


    
            setSearchParams(localVarUrlObj, localVarQueryParameter);
            let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
            localVarRequestOptions.headers = {...localVarHeaderParameter, ...headersFromBaseOptions, ...options.headers};

            return {
                url: toPathString(localVarUrlObj),
                options: localVarRequestOptions,
            };
        },
        /**
         * Reload a plugin by name.
         * @param {string} name 
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        reloadPlugin: async (name: string, options: RawAxiosRequestConfig = {}): Promise<RequestArgs> => {
            // verify required parameter 'name' is not null or undefined
            assertParamExists('reloadPlugin', 'name', name)
            const localVarPath = `/apis/api.console.halo.run/v1alpha1/plugins/{name}/reload`
                .replace(`{${"name"}}`, encodeURIComponent(String(name)));
            // use dummy base URL string because the URL constructor only accepts absolute URLs.
            const localVarUrlObj = new URL(localVarPath, DUMMY_BASE_URL);
            let baseOptions;
            if (configuration) {
                baseOptions = configuration.baseOptions;
            }

            const localVarRequestOptions = { method: 'PUT', ...baseOptions, ...options};
            const localVarHeaderParameter = {} as any;
            const localVarQueryParameter = {} as any;

            // authentication basicAuth required
            // http basic authentication required
            setBasicAuthToObject(localVarRequestOptions, configuration)

            // authentication bearerAuth required
            // http bearer authentication required
            await setBearerAuthToObject(localVarHeaderParameter, configuration)


    
            setSearchParams(localVarUrlObj, localVarQueryParameter);
            let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
            localVarRequestOptions.headers = {...localVarHeaderParameter, ...headersFromBaseOptions, ...options.headers};

            return {
                url: toPathString(localVarUrlObj),
                options: localVarRequestOptions,
            };
        },
        /**
         * Reset the configMap of plugin setting.
         * @param {string} name 
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        resetPluginConfig: async (name: string, options: RawAxiosRequestConfig = {}): Promise<RequestArgs> => {
            // verify required parameter 'name' is not null or undefined
            assertParamExists('resetPluginConfig', 'name', name)
            const localVarPath = `/apis/api.console.halo.run/v1alpha1/plugins/{name}/reset-config`
                .replace(`{${"name"}}`, encodeURIComponent(String(name)));
            // use dummy base URL string because the URL constructor only accepts absolute URLs.
            const localVarUrlObj = new URL(localVarPath, DUMMY_BASE_URL);
            let baseOptions;
            if (configuration) {
                baseOptions = configuration.baseOptions;
            }

            const localVarRequestOptions = { method: 'PUT', ...baseOptions, ...options};
            const localVarHeaderParameter = {} as any;
            const localVarQueryParameter = {} as any;

            // authentication basicAuth required
            // http basic authentication required
            setBasicAuthToObject(localVarRequestOptions, configuration)

            // authentication bearerAuth required
            // http bearer authentication required
            await setBearerAuthToObject(localVarHeaderParameter, configuration)


    
            setSearchParams(localVarUrlObj, localVarQueryParameter);
            let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
            localVarRequestOptions.headers = {...localVarHeaderParameter, ...headersFromBaseOptions, ...options.headers};

            return {
                url: toPathString(localVarUrlObj),
                options: localVarRequestOptions,
            };
        },
        /**
         * Update the configMap of plugin setting, it is deprecated since 2.20.0
         * @param {string} name 
         * @param {ConfigMap} configMap 
         * @param {*} [options] Override http request option.
         * @deprecated
         * @throws {RequiredError}
         */
        updatePluginConfig: async (name: string, configMap: ConfigMap, options: RawAxiosRequestConfig = {}): Promise<RequestArgs> => {
            // verify required parameter 'name' is not null or undefined
            assertParamExists('updatePluginConfig', 'name', name)
            // verify required parameter 'configMap' is not null or undefined
            assertParamExists('updatePluginConfig', 'configMap', configMap)
            const localVarPath = `/apis/api.console.halo.run/v1alpha1/plugins/{name}/config`
                .replace(`{${"name"}}`, encodeURIComponent(String(name)));
            // use dummy base URL string because the URL constructor only accepts absolute URLs.
            const localVarUrlObj = new URL(localVarPath, DUMMY_BASE_URL);
            let baseOptions;
            if (configuration) {
                baseOptions = configuration.baseOptions;
            }

            const localVarRequestOptions = { method: 'PUT', ...baseOptions, ...options};
            const localVarHeaderParameter = {} as any;
            const localVarQueryParameter = {} as any;

            // authentication basicAuth required
            // http basic authentication required
            setBasicAuthToObject(localVarRequestOptions, configuration)

            // authentication bearerAuth required
            // http bearer authentication required
            await setBearerAuthToObject(localVarHeaderParameter, configuration)


    
            localVarHeaderParameter['Content-Type'] = 'application/json';

            setSearchParams(localVarUrlObj, localVarQueryParameter);
            let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
            localVarRequestOptions.headers = {...localVarHeaderParameter, ...headersFromBaseOptions, ...options.headers};
            localVarRequestOptions.data = serializeDataIfNeeded(configMap, localVarRequestOptions, configuration)

            return {
                url: toPathString(localVarUrlObj),
                options: localVarRequestOptions,
            };
        },
        /**
         * Update the config of plugin setting.
         * @param {string} name 
         * @param {object} body 
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        updatePluginJsonConfig: async (name: string, body: object, options: RawAxiosRequestConfig = {}): Promise<RequestArgs> => {
            // verify required parameter 'name' is not null or undefined
            assertParamExists('updatePluginJsonConfig', 'name', name)
            // verify required parameter 'body' is not null or undefined
            assertParamExists('updatePluginJsonConfig', 'body', body)
            const localVarPath = `/apis/api.console.halo.run/v1alpha1/plugins/{name}/json-config`
                .replace(`{${"name"}}`, encodeURIComponent(String(name)));
            // use dummy base URL string because the URL constructor only accepts absolute URLs.
            const localVarUrlObj = new URL(localVarPath, DUMMY_BASE_URL);
            let baseOptions;
            if (configuration) {
                baseOptions = configuration.baseOptions;
            }

            const localVarRequestOptions = { method: 'PUT', ...baseOptions, ...options};
            const localVarHeaderParameter = {} as any;
            const localVarQueryParameter = {} as any;

            // authentication basicAuth required
            // http basic authentication required
            setBasicAuthToObject(localVarRequestOptions, configuration)

            // authentication bearerAuth required
            // http bearer authentication required
            await setBearerAuthToObject(localVarHeaderParameter, configuration)


    
            localVarHeaderParameter['Content-Type'] = 'application/json';

            setSearchParams(localVarUrlObj, localVarQueryParameter);
            let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
            localVarRequestOptions.headers = {...localVarHeaderParameter, ...headersFromBaseOptions, ...options.headers};
            localVarRequestOptions.data = serializeDataIfNeeded(body, localVarRequestOptions, configuration)

            return {
                url: toPathString(localVarUrlObj),
                options: localVarRequestOptions,
            };
        },
        /**
         * Upgrade a plugin by uploading a Jar file
         * @param {string} name 
         * @param {File} [file] 
         * @param {string} [presetName] Plugin preset name. We will find the plugin from plugin presets
         * @param {UpgradePluginSourceEnum} [source] Install source. Default is file.
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        upgradePlugin: async (name: string, file?: File, presetName?: string, source?: UpgradePluginSourceEnum, options: RawAxiosRequestConfig = {}): Promise<RequestArgs> => {
            // verify required parameter 'name' is not null or undefined
            assertParamExists('upgradePlugin', 'name', name)
            const localVarPath = `/apis/api.console.halo.run/v1alpha1/plugins/{name}/upgrade`
                .replace(`{${"name"}}`, encodeURIComponent(String(name)));
            // use dummy base URL string because the URL constructor only accepts absolute URLs.
            const localVarUrlObj = new URL(localVarPath, DUMMY_BASE_URL);
            let baseOptions;
            if (configuration) {
                baseOptions = configuration.baseOptions;
            }

            const localVarRequestOptions = { method: 'POST', ...baseOptions, ...options};
            const localVarHeaderParameter = {} as any;
            const localVarQueryParameter = {} as any;
            const localVarFormParams = new ((configuration && configuration.formDataCtor) || FormData)();

            // authentication basicAuth required
            // http basic authentication required
            setBasicAuthToObject(localVarRequestOptions, configuration)

            // authentication bearerAuth required
            // http bearer authentication required
            await setBearerAuthToObject(localVarHeaderParameter, configuration)


            if (file !== undefined) { 
                localVarFormParams.append('file', file as any);
            }
    
            if (presetName !== undefined) { 
                localVarFormParams.append('presetName', presetName as any);
            }
    
            if (source !== undefined) { 
                localVarFormParams.append('source', source as any);
            }
    
    
            localVarHeaderParameter['Content-Type'] = 'multipart/form-data';
    
            setSearchParams(localVarUrlObj, localVarQueryParameter);
            let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
            localVarRequestOptions.headers = {...localVarHeaderParameter, ...headersFromBaseOptions, ...options.headers};
            localVarRequestOptions.data = localVarFormParams;

            return {
                url: toPathString(localVarUrlObj),
                options: localVarRequestOptions,
            };
        },
        /**
         * Upgrade a plugin from uri.
         * @param {string} name 
         * @param {UpgradeFromUriRequest} upgradeFromUriRequest 
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        upgradePluginFromUri: async (name: string, upgradeFromUriRequest: UpgradeFromUriRequest, options: RawAxiosRequestConfig = {}): Promise<RequestArgs> => {
            // verify required parameter 'name' is not null or undefined
            assertParamExists('upgradePluginFromUri', 'name', name)
            // verify required parameter 'upgradeFromUriRequest' is not null or undefined
            assertParamExists('upgradePluginFromUri', 'upgradeFromUriRequest', upgradeFromUriRequest)
            const localVarPath = `/apis/api.console.halo.run/v1alpha1/plugins/{name}/upgrade-from-uri`
                .replace(`{${"name"}}`, encodeURIComponent(String(name)));
            // use dummy base URL string because the URL constructor only accepts absolute URLs.
            const localVarUrlObj = new URL(localVarPath, DUMMY_BASE_URL);
            let baseOptions;
            if (configuration) {
                baseOptions = configuration.baseOptions;
            }

            const localVarRequestOptions = { method: 'POST', ...baseOptions, ...options};
            const localVarHeaderParameter = {} as any;
            const localVarQueryParameter = {} as any;

            // authentication basicAuth required
            // http basic authentication required
            setBasicAuthToObject(localVarRequestOptions, configuration)

            // authentication bearerAuth required
            // http bearer authentication required
            await setBearerAuthToObject(localVarHeaderParameter, configuration)


    
            localVarHeaderParameter['Content-Type'] = 'application/json';

            setSearchParams(localVarUrlObj, localVarQueryParameter);
            let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
            localVarRequestOptions.headers = {...localVarHeaderParameter, ...headersFromBaseOptions, ...options.headers};
            localVarRequestOptions.data = serializeDataIfNeeded(upgradeFromUriRequest, localVarRequestOptions, configuration)

            return {
                url: toPathString(localVarUrlObj),
                options: localVarRequestOptions,
            };
        },
    }
};

/**
 * PluginV1alpha1ConsoleApi - functional programming interface
 * @export
 */
export const PluginV1alpha1ConsoleApiFp = function(configuration?: Configuration) {
    const localVarAxiosParamCreator = PluginV1alpha1ConsoleApiAxiosParamCreator(configuration)
    return {
        /**
         * Change the running state of a plugin by name.
         * @param {string} name 
         * @param {PluginRunningStateRequest} pluginRunningStateRequest 
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        async changePluginRunningState(name: string, pluginRunningStateRequest: PluginRunningStateRequest, options?: RawAxiosRequestConfig): Promise<(axios?: AxiosInstance, basePath?: string) => AxiosPromise<Plugin>> {
            const localVarAxiosArgs = await localVarAxiosParamCreator.changePluginRunningState(name, pluginRunningStateRequest, options);
            const localVarOperationServerIndex = configuration?.serverIndex ?? 0;
            const localVarOperationServerBasePath = operationServerMap['PluginV1alpha1ConsoleApi.changePluginRunningState']?.[localVarOperationServerIndex]?.url;
            return (axios, basePath) => createRequestFunction(localVarAxiosArgs, globalAxios, BASE_PATH, configuration)(axios, localVarOperationServerBasePath || basePath);
        },
        /**
         * Merge all CSS bundles of enabled plugins into one.
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        async fetchCssBundle(options?: RawAxiosRequestConfig): Promise<(axios?: AxiosInstance, basePath?: string) => AxiosPromise<string>> {
            const localVarAxiosArgs = await localVarAxiosParamCreator.fetchCssBundle(options);
            const localVarOperationServerIndex = configuration?.serverIndex ?? 0;
            const localVarOperationServerBasePath = operationServerMap['PluginV1alpha1ConsoleApi.fetchCssBundle']?.[localVarOperationServerIndex]?.url;
            return (axios, basePath) => createRequestFunction(localVarAxiosArgs, globalAxios, BASE_PATH, configuration)(axios, localVarOperationServerBasePath || basePath);
        },
        /**
         * Merge all JS bundles of enabled plugins into one.
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        async fetchJsBundle(options?: RawAxiosRequestConfig): Promise<(axios?: AxiosInstance, basePath?: string) => AxiosPromise<string>> {
            const localVarAxiosArgs = await localVarAxiosParamCreator.fetchJsBundle(options);
            const localVarOperationServerIndex = configuration?.serverIndex ?? 0;
            const localVarOperationServerBasePath = operationServerMap['PluginV1alpha1ConsoleApi.fetchJsBundle']?.[localVarOperationServerIndex]?.url;
            return (axios, basePath) => createRequestFunction(localVarAxiosArgs, globalAxios, BASE_PATH, configuration)(axios, localVarOperationServerBasePath || basePath);
        },
        /**
         * Fetch configMap of plugin by configured configMapName. it is deprecated since 2.20.0
         * @param {string} name 
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        async fetchPluginConfig(name: string, options?: RawAxiosRequestConfig): Promise<(axios?: AxiosInstance, basePath?: string) => AxiosPromise<ConfigMap>> {
            const localVarAxiosArgs = await localVarAxiosParamCreator.fetchPluginConfig(name, options);
            const localVarOperationServerIndex = configuration?.serverIndex ?? 0;
            const localVarOperationServerBasePath = operationServerMap['PluginV1alpha1ConsoleApi.fetchPluginConfig']?.[localVarOperationServerIndex]?.url;
            return (axios, basePath) => createRequestFunction(localVarAxiosArgs, globalAxios, BASE_PATH, configuration)(axios, localVarOperationServerBasePath || basePath);
        },
        /**
         * Fetch converted json config of plugin by configured configMapName.
         * @param {string} name 
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        async fetchPluginJsonConfig(name: string, options?: RawAxiosRequestConfig): Promise<(axios?: AxiosInstance, basePath?: string) => AxiosPromise<object>> {
            const localVarAxiosArgs = await localVarAxiosParamCreator.fetchPluginJsonConfig(name, options);
            const localVarOperationServerIndex = configuration?.serverIndex ?? 0;
            const localVarOperationServerBasePath = operationServerMap['PluginV1alpha1ConsoleApi.fetchPluginJsonConfig']?.[localVarOperationServerIndex]?.url;
            return (axios, basePath) => createRequestFunction(localVarAxiosArgs, globalAxios, BASE_PATH, configuration)(axios, localVarOperationServerBasePath || basePath);
        },
        /**
         * Fetch setting of plugin.
         * @param {string} name 
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        async fetchPluginSetting(name: string, options?: RawAxiosRequestConfig): Promise<(axios?: AxiosInstance, basePath?: string) => AxiosPromise<Setting>> {
            const localVarAxiosArgs = await localVarAxiosParamCreator.fetchPluginSetting(name, options);
            const localVarOperationServerIndex = configuration?.serverIndex ?? 0;
            const localVarOperationServerBasePath = operationServerMap['PluginV1alpha1ConsoleApi.fetchPluginSetting']?.[localVarOperationServerIndex]?.url;
            return (axios, basePath) => createRequestFunction(localVarAxiosArgs, globalAxios, BASE_PATH, configuration)(axios, localVarOperationServerBasePath || basePath);
        },
        /**
         * Install a plugin by uploading a Jar file.
         * @param {File} [file] 
         * @param {string} [presetName] Plugin preset name. We will find the plugin from plugin presets
         * @param {InstallPluginSourceEnum} [source] Install source. Default is file.
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        async installPlugin(file?: File, presetName?: string, source?: InstallPluginSourceEnum, options?: RawAxiosRequestConfig): Promise<(axios?: AxiosInstance, basePath?: string) => AxiosPromise<Plugin>> {
            const localVarAxiosArgs = await localVarAxiosParamCreator.installPlugin(file, presetName, source, options);
            const localVarOperationServerIndex = configuration?.serverIndex ?? 0;
            const localVarOperationServerBasePath = operationServerMap['PluginV1alpha1ConsoleApi.installPlugin']?.[localVarOperationServerIndex]?.url;
            return (axios, basePath) => createRequestFunction(localVarAxiosArgs, globalAxios, BASE_PATH, configuration)(axios, localVarOperationServerBasePath || basePath);
        },
        /**
         * Install a plugin from uri.
         * @param {InstallFromUriRequest} installFromUriRequest 
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        async installPluginFromUri(installFromUriRequest: InstallFromUriRequest, options?: RawAxiosRequestConfig): Promise<(axios?: AxiosInstance, basePath?: string) => AxiosPromise<Plugin>> {
            const localVarAxiosArgs = await localVarAxiosParamCreator.installPluginFromUri(installFromUriRequest, options);
            const localVarOperationServerIndex = configuration?.serverIndex ?? 0;
            const localVarOperationServerBasePath = operationServerMap['PluginV1alpha1ConsoleApi.installPluginFromUri']?.[localVarOperationServerIndex]?.url;
            return (axios, basePath) => createRequestFunction(localVarAxiosArgs, globalAxios, BASE_PATH, configuration)(axios, localVarOperationServerBasePath || basePath);
        },
        /**
         * List plugins using query criteria and sort params
         * @param {number} [page] Page number. Default is 0.
         * @param {number} [size] Size number. Default is 0.
         * @param {Array<string>} [labelSelector] Label selector. e.g.: hidden!&#x3D;true
         * @param {Array<string>} [fieldSelector] Field selector. e.g.: metadata.name&#x3D;&#x3D;halo
         * @param {Array<string>} [sort] Sorting criteria in the format: property,(asc|desc). Default sort order is ascending. Multiple sort criteria are supported.
         * @param {string} [keyword] Keyword of plugin name or description
         * @param {boolean} [enabled] Whether the plugin is enabled
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        async listPlugins(page?: number, size?: number, labelSelector?: Array<string>, fieldSelector?: Array<string>, sort?: Array<string>, keyword?: string, enabled?: boolean, options?: RawAxiosRequestConfig): Promise<(axios?: AxiosInstance, basePath?: string) => AxiosPromise<PluginList>> {
            const localVarAxiosArgs = await localVarAxiosParamCreator.listPlugins(page, size, labelSelector, fieldSelector, sort, keyword, enabled, options);
            const localVarOperationServerIndex = configuration?.serverIndex ?? 0;
            const localVarOperationServerBasePath = operationServerMap['PluginV1alpha1ConsoleApi.listPlugins']?.[localVarOperationServerIndex]?.url;
            return (axios, basePath) => createRequestFunction(localVarAxiosArgs, globalAxios, BASE_PATH, configuration)(axios, localVarOperationServerBasePath || basePath);
        },
        /**
         * Reload a plugin by name.
         * @param {string} name 
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        async reloadPlugin(name: string, options?: RawAxiosRequestConfig): Promise<(axios?: AxiosInstance, basePath?: string) => AxiosPromise<Plugin>> {
            const localVarAxiosArgs = await localVarAxiosParamCreator.reloadPlugin(name, options);
            const localVarOperationServerIndex = configuration?.serverIndex ?? 0;
            const localVarOperationServerBasePath = operationServerMap['PluginV1alpha1ConsoleApi.reloadPlugin']?.[localVarOperationServerIndex]?.url;
            return (axios, basePath) => createRequestFunction(localVarAxiosArgs, globalAxios, BASE_PATH, configuration)(axios, localVarOperationServerBasePath || basePath);
        },
        /**
         * Reset the configMap of plugin setting.
         * @param {string} name 
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        async resetPluginConfig(name: string, options?: RawAxiosRequestConfig): Promise<(axios?: AxiosInstance, basePath?: string) => AxiosPromise<ConfigMap>> {
            const localVarAxiosArgs = await localVarAxiosParamCreator.resetPluginConfig(name, options);
            const localVarOperationServerIndex = configuration?.serverIndex ?? 0;
            const localVarOperationServerBasePath = operationServerMap['PluginV1alpha1ConsoleApi.resetPluginConfig']?.[localVarOperationServerIndex]?.url;
            return (axios, basePath) => createRequestFunction(localVarAxiosArgs, globalAxios, BASE_PATH, configuration)(axios, localVarOperationServerBasePath || basePath);
        },
        /**
         * Update the configMap of plugin setting, it is deprecated since 2.20.0
         * @param {string} name 
         * @param {ConfigMap} configMap 
         * @param {*} [options] Override http request option.
         * @deprecated
         * @throws {RequiredError}
         */
        async updatePluginConfig(name: string, configMap: ConfigMap, options?: RawAxiosRequestConfig): Promise<(axios?: AxiosInstance, basePath?: string) => AxiosPromise<ConfigMap>> {
            const localVarAxiosArgs = await localVarAxiosParamCreator.updatePluginConfig(name, configMap, options);
            const localVarOperationServerIndex = configuration?.serverIndex ?? 0;
            const localVarOperationServerBasePath = operationServerMap['PluginV1alpha1ConsoleApi.updatePluginConfig']?.[localVarOperationServerIndex]?.url;
            return (axios, basePath) => createRequestFunction(localVarAxiosArgs, globalAxios, BASE_PATH, configuration)(axios, localVarOperationServerBasePath || basePath);
        },
        /**
         * Update the config of plugin setting.
         * @param {string} name 
         * @param {object} body 
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        async updatePluginJsonConfig(name: string, body: object, options?: RawAxiosRequestConfig): Promise<(axios?: AxiosInstance, basePath?: string) => AxiosPromise<void>> {
            const localVarAxiosArgs = await localVarAxiosParamCreator.updatePluginJsonConfig(name, body, options);
            const localVarOperationServerIndex = configuration?.serverIndex ?? 0;
            const localVarOperationServerBasePath = operationServerMap['PluginV1alpha1ConsoleApi.updatePluginJsonConfig']?.[localVarOperationServerIndex]?.url;
            return (axios, basePath) => createRequestFunction(localVarAxiosArgs, globalAxios, BASE_PATH, configuration)(axios, localVarOperationServerBasePath || basePath);
        },
        /**
         * Upgrade a plugin by uploading a Jar file
         * @param {string} name 
         * @param {File} [file] 
         * @param {string} [presetName] Plugin preset name. We will find the plugin from plugin presets
         * @param {UpgradePluginSourceEnum} [source] Install source. Default is file.
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        async upgradePlugin(name: string, file?: File, presetName?: string, source?: UpgradePluginSourceEnum, options?: RawAxiosRequestConfig): Promise<(axios?: AxiosInstance, basePath?: string) => AxiosPromise<void>> {
            const localVarAxiosArgs = await localVarAxiosParamCreator.upgradePlugin(name, file, presetName, source, options);
            const localVarOperationServerIndex = configuration?.serverIndex ?? 0;
            const localVarOperationServerBasePath = operationServerMap['PluginV1alpha1ConsoleApi.upgradePlugin']?.[localVarOperationServerIndex]?.url;
            return (axios, basePath) => createRequestFunction(localVarAxiosArgs, globalAxios, BASE_PATH, configuration)(axios, localVarOperationServerBasePath || basePath);
        },
        /**
         * Upgrade a plugin from uri.
         * @param {string} name 
         * @param {UpgradeFromUriRequest} upgradeFromUriRequest 
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        async upgradePluginFromUri(name: string, upgradeFromUriRequest: UpgradeFromUriRequest, options?: RawAxiosRequestConfig): Promise<(axios?: AxiosInstance, basePath?: string) => AxiosPromise<Plugin>> {
            const localVarAxiosArgs = await localVarAxiosParamCreator.upgradePluginFromUri(name, upgradeFromUriRequest, options);
            const localVarOperationServerIndex = configuration?.serverIndex ?? 0;
            const localVarOperationServerBasePath = operationServerMap['PluginV1alpha1ConsoleApi.upgradePluginFromUri']?.[localVarOperationServerIndex]?.url;
            return (axios, basePath) => createRequestFunction(localVarAxiosArgs, globalAxios, BASE_PATH, configuration)(axios, localVarOperationServerBasePath || basePath);
        },
    }
};

/**
 * PluginV1alpha1ConsoleApi - factory interface
 * @export
 */
export const PluginV1alpha1ConsoleApiFactory = function (configuration?: Configuration, basePath?: string, axios?: AxiosInstance) {
    const localVarFp = PluginV1alpha1ConsoleApiFp(configuration)
    return {
        /**
         * Change the running state of a plugin by name.
         * @param {PluginV1alpha1ConsoleApiChangePluginRunningStateRequest} requestParameters Request parameters.
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        changePluginRunningState(requestParameters: PluginV1alpha1ConsoleApiChangePluginRunningStateRequest, options?: RawAxiosRequestConfig): AxiosPromise<Plugin> {
            return localVarFp.changePluginRunningState(requestParameters.name, requestParameters.pluginRunningStateRequest, options).then((request) => request(axios, basePath));
        },
        /**
         * Merge all CSS bundles of enabled plugins into one.
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        fetchCssBundle(options?: RawAxiosRequestConfig): AxiosPromise<string> {
            return localVarFp.fetchCssBundle(options).then((request) => request(axios, basePath));
        },
        /**
         * Merge all JS bundles of enabled plugins into one.
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        fetchJsBundle(options?: RawAxiosRequestConfig): AxiosPromise<string> {
            return localVarFp.fetchJsBundle(options).then((request) => request(axios, basePath));
        },
        /**
         * Fetch configMap of plugin by configured configMapName. it is deprecated since 2.20.0
         * @param {PluginV1alpha1ConsoleApiFetchPluginConfigRequest} requestParameters Request parameters.
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        fetchPluginConfig(requestParameters: PluginV1alpha1ConsoleApiFetchPluginConfigRequest, options?: RawAxiosRequestConfig): AxiosPromise<ConfigMap> {
            return localVarFp.fetchPluginConfig(requestParameters.name, options).then((request) => request(axios, basePath));
        },
        /**
         * Fetch converted json config of plugin by configured configMapName.
         * @param {PluginV1alpha1ConsoleApiFetchPluginJsonConfigRequest} requestParameters Request parameters.
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        fetchPluginJsonConfig(requestParameters: PluginV1alpha1ConsoleApiFetchPluginJsonConfigRequest, options?: RawAxiosRequestConfig): AxiosPromise<object> {
            return localVarFp.fetchPluginJsonConfig(requestParameters.name, options).then((request) => request(axios, basePath));
        },
        /**
         * Fetch setting of plugin.
         * @param {PluginV1alpha1ConsoleApiFetchPluginSettingRequest} requestParameters Request parameters.
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        fetchPluginSetting(requestParameters: PluginV1alpha1ConsoleApiFetchPluginSettingRequest, options?: RawAxiosRequestConfig): AxiosPromise<Setting> {
            return localVarFp.fetchPluginSetting(requestParameters.name, options).then((request) => request(axios, basePath));
        },
        /**
         * Install a plugin by uploading a Jar file.
         * @param {PluginV1alpha1ConsoleApiInstallPluginRequest} requestParameters Request parameters.
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        installPlugin(requestParameters: PluginV1alpha1ConsoleApiInstallPluginRequest = {}, options?: RawAxiosRequestConfig): AxiosPromise<Plugin> {
            return localVarFp.installPlugin(requestParameters.file, requestParameters.presetName, requestParameters.source, options).then((request) => request(axios, basePath));
        },
        /**
         * Install a plugin from uri.
         * @param {PluginV1alpha1ConsoleApiInstallPluginFromUriRequest} requestParameters Request parameters.
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        installPluginFromUri(requestParameters: PluginV1alpha1ConsoleApiInstallPluginFromUriRequest, options?: RawAxiosRequestConfig): AxiosPromise<Plugin> {
            return localVarFp.installPluginFromUri(requestParameters.installFromUriRequest, options).then((request) => request(axios, basePath));
        },
        /**
         * List plugins using query criteria and sort params
         * @param {PluginV1alpha1ConsoleApiListPluginsRequest} requestParameters Request parameters.
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        listPlugins(requestParameters: PluginV1alpha1ConsoleApiListPluginsRequest = {}, options?: RawAxiosRequestConfig): AxiosPromise<PluginList> {
            return localVarFp.listPlugins(requestParameters.page, requestParameters.size, requestParameters.labelSelector, requestParameters.fieldSelector, requestParameters.sort, requestParameters.keyword, requestParameters.enabled, options).then((request) => request(axios, basePath));
        },
        /**
         * Reload a plugin by name.
         * @param {PluginV1alpha1ConsoleApiReloadPluginRequest} requestParameters Request parameters.
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        reloadPlugin(requestParameters: PluginV1alpha1ConsoleApiReloadPluginRequest, options?: RawAxiosRequestConfig): AxiosPromise<Plugin> {
            return localVarFp.reloadPlugin(requestParameters.name, options).then((request) => request(axios, basePath));
        },
        /**
         * Reset the configMap of plugin setting.
         * @param {PluginV1alpha1ConsoleApiResetPluginConfigRequest} requestParameters Request parameters.
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        resetPluginConfig(requestParameters: PluginV1alpha1ConsoleApiResetPluginConfigRequest, options?: RawAxiosRequestConfig): AxiosPromise<ConfigMap> {
            return localVarFp.resetPluginConfig(requestParameters.name, options).then((request) => request(axios, basePath));
        },
        /**
         * Update the configMap of plugin setting, it is deprecated since 2.20.0
         * @param {PluginV1alpha1ConsoleApiUpdatePluginConfigRequest} requestParameters Request parameters.
         * @param {*} [options] Override http request option.
         * @deprecated
         * @throws {RequiredError}
         */
        updatePluginConfig(requestParameters: PluginV1alpha1ConsoleApiUpdatePluginConfigRequest, options?: RawAxiosRequestConfig): AxiosPromise<ConfigMap> {
            return localVarFp.updatePluginConfig(requestParameters.name, requestParameters.configMap, options).then((request) => request(axios, basePath));
        },
        /**
         * Update the config of plugin setting.
         * @param {PluginV1alpha1ConsoleApiUpdatePluginJsonConfigRequest} requestParameters Request parameters.
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        updatePluginJsonConfig(requestParameters: PluginV1alpha1ConsoleApiUpdatePluginJsonConfigRequest, options?: RawAxiosRequestConfig): AxiosPromise<void> {
            return localVarFp.updatePluginJsonConfig(requestParameters.name, requestParameters.body, options).then((request) => request(axios, basePath));
        },
        /**
         * Upgrade a plugin by uploading a Jar file
         * @param {PluginV1alpha1ConsoleApiUpgradePluginRequest} requestParameters Request parameters.
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        upgradePlugin(requestParameters: PluginV1alpha1ConsoleApiUpgradePluginRequest, options?: RawAxiosRequestConfig): AxiosPromise<void> {
            return localVarFp.upgradePlugin(requestParameters.name, requestParameters.file, requestParameters.presetName, requestParameters.source, options).then((request) => request(axios, basePath));
        },
        /**
         * Upgrade a plugin from uri.
         * @param {PluginV1alpha1ConsoleApiUpgradePluginFromUriRequest} requestParameters Request parameters.
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        upgradePluginFromUri(requestParameters: PluginV1alpha1ConsoleApiUpgradePluginFromUriRequest, options?: RawAxiosRequestConfig): AxiosPromise<Plugin> {
            return localVarFp.upgradePluginFromUri(requestParameters.name, requestParameters.upgradeFromUriRequest, options).then((request) => request(axios, basePath));
        },
    };
};

/**
 * Request parameters for changePluginRunningState operation in PluginV1alpha1ConsoleApi.
 * @export
 * @interface PluginV1alpha1ConsoleApiChangePluginRunningStateRequest
 */
export interface PluginV1alpha1ConsoleApiChangePluginRunningStateRequest {
    /**
     * 
     * @type {string}
     * @memberof PluginV1alpha1ConsoleApiChangePluginRunningState
     */
    readonly name: string

    /**
     * 
     * @type {PluginRunningStateRequest}
     * @memberof PluginV1alpha1ConsoleApiChangePluginRunningState
     */
    readonly pluginRunningStateRequest: PluginRunningStateRequest
}

/**
 * Request parameters for fetchPluginConfig operation in PluginV1alpha1ConsoleApi.
 * @export
 * @interface PluginV1alpha1ConsoleApiFetchPluginConfigRequest
 */
export interface PluginV1alpha1ConsoleApiFetchPluginConfigRequest {
    /**
     * 
     * @type {string}
     * @memberof PluginV1alpha1ConsoleApiFetchPluginConfig
     */
    readonly name: string
}

/**
 * Request parameters for fetchPluginJsonConfig operation in PluginV1alpha1ConsoleApi.
 * @export
 * @interface PluginV1alpha1ConsoleApiFetchPluginJsonConfigRequest
 */
export interface PluginV1alpha1ConsoleApiFetchPluginJsonConfigRequest {
    /**
     * 
     * @type {string}
     * @memberof PluginV1alpha1ConsoleApiFetchPluginJsonConfig
     */
    readonly name: string
}

/**
 * Request parameters for fetchPluginSetting operation in PluginV1alpha1ConsoleApi.
 * @export
 * @interface PluginV1alpha1ConsoleApiFetchPluginSettingRequest
 */
export interface PluginV1alpha1ConsoleApiFetchPluginSettingRequest {
    /**
     * 
     * @type {string}
     * @memberof PluginV1alpha1ConsoleApiFetchPluginSetting
     */
    readonly name: string
}

/**
 * Request parameters for installPlugin operation in PluginV1alpha1ConsoleApi.
 * @export
 * @interface PluginV1alpha1ConsoleApiInstallPluginRequest
 */
export interface PluginV1alpha1ConsoleApiInstallPluginRequest {
    /**
     * 
     * @type {File}
     * @memberof PluginV1alpha1ConsoleApiInstallPlugin
     */
    readonly file?: File

    /**
     * Plugin preset name. We will find the plugin from plugin presets
     * @type {string}
     * @memberof PluginV1alpha1ConsoleApiInstallPlugin
     */
    readonly presetName?: string

    /**
     * Install source. Default is file.
     * @type {string}
     * @memberof PluginV1alpha1ConsoleApiInstallPlugin
     */
    readonly source?: InstallPluginSourceEnum
}

/**
 * Request parameters for installPluginFromUri operation in PluginV1alpha1ConsoleApi.
 * @export
 * @interface PluginV1alpha1ConsoleApiInstallPluginFromUriRequest
 */
export interface PluginV1alpha1ConsoleApiInstallPluginFromUriRequest {
    /**
     * 
     * @type {InstallFromUriRequest}
     * @memberof PluginV1alpha1ConsoleApiInstallPluginFromUri
     */
    readonly installFromUriRequest: InstallFromUriRequest
}

/**
 * Request parameters for listPlugins operation in PluginV1alpha1ConsoleApi.
 * @export
 * @interface PluginV1alpha1ConsoleApiListPluginsRequest
 */
export interface PluginV1alpha1ConsoleApiListPluginsRequest {
    /**
     * Page number. Default is 0.
     * @type {number}
     * @memberof PluginV1alpha1ConsoleApiListPlugins
     */
    readonly page?: number

    /**
     * Size number. Default is 0.
     * @type {number}
     * @memberof PluginV1alpha1ConsoleApiListPlugins
     */
    readonly size?: number

    /**
     * Label selector. e.g.: hidden!&#x3D;true
     * @type {Array<string>}
     * @memberof PluginV1alpha1ConsoleApiListPlugins
     */
    readonly labelSelector?: Array<string>

    /**
     * Field selector. e.g.: metadata.name&#x3D;&#x3D;halo
     * @type {Array<string>}
     * @memberof PluginV1alpha1ConsoleApiListPlugins
     */
    readonly fieldSelector?: Array<string>

    /**
     * Sorting criteria in the format: property,(asc|desc). Default sort order is ascending. Multiple sort criteria are supported.
     * @type {Array<string>}
     * @memberof PluginV1alpha1ConsoleApiListPlugins
     */
    readonly sort?: Array<string>

    /**
     * Keyword of plugin name or description
     * @type {string}
     * @memberof PluginV1alpha1ConsoleApiListPlugins
     */
    readonly keyword?: string

    /**
     * Whether the plugin is enabled
     * @type {boolean}
     * @memberof PluginV1alpha1ConsoleApiListPlugins
     */
    readonly enabled?: boolean
}

/**
 * Request parameters for reloadPlugin operation in PluginV1alpha1ConsoleApi.
 * @export
 * @interface PluginV1alpha1ConsoleApiReloadPluginRequest
 */
export interface PluginV1alpha1ConsoleApiReloadPluginRequest {
    /**
     * 
     * @type {string}
     * @memberof PluginV1alpha1ConsoleApiReloadPlugin
     */
    readonly name: string
}

/**
 * Request parameters for resetPluginConfig operation in PluginV1alpha1ConsoleApi.
 * @export
 * @interface PluginV1alpha1ConsoleApiResetPluginConfigRequest
 */
export interface PluginV1alpha1ConsoleApiResetPluginConfigRequest {
    /**
     * 
     * @type {string}
     * @memberof PluginV1alpha1ConsoleApiResetPluginConfig
     */
    readonly name: string
}

/**
 * Request parameters for updatePluginConfig operation in PluginV1alpha1ConsoleApi.
 * @export
 * @interface PluginV1alpha1ConsoleApiUpdatePluginConfigRequest
 */
export interface PluginV1alpha1ConsoleApiUpdatePluginConfigRequest {
    /**
     * 
     * @type {string}
     * @memberof PluginV1alpha1ConsoleApiUpdatePluginConfig
     */
    readonly name: string

    /**
     * 
     * @type {ConfigMap}
     * @memberof PluginV1alpha1ConsoleApiUpdatePluginConfig
     */
    readonly configMap: ConfigMap
}

/**
 * Request parameters for updatePluginJsonConfig operation in PluginV1alpha1ConsoleApi.
 * @export
 * @interface PluginV1alpha1ConsoleApiUpdatePluginJsonConfigRequest
 */
export interface PluginV1alpha1ConsoleApiUpdatePluginJsonConfigRequest {
    /**
     * 
     * @type {string}
     * @memberof PluginV1alpha1ConsoleApiUpdatePluginJsonConfig
     */
    readonly name: string

    /**
     * 
     * @type {object}
     * @memberof PluginV1alpha1ConsoleApiUpdatePluginJsonConfig
     */
    readonly body: object
}

/**
 * Request parameters for upgradePlugin operation in PluginV1alpha1ConsoleApi.
 * @export
 * @interface PluginV1alpha1ConsoleApiUpgradePluginRequest
 */
export interface PluginV1alpha1ConsoleApiUpgradePluginRequest {
    /**
     * 
     * @type {string}
     * @memberof PluginV1alpha1ConsoleApiUpgradePlugin
     */
    readonly name: string

    /**
     * 
     * @type {File}
     * @memberof PluginV1alpha1ConsoleApiUpgradePlugin
     */
    readonly file?: File

    /**
     * Plugin preset name. We will find the plugin from plugin presets
     * @type {string}
     * @memberof PluginV1alpha1ConsoleApiUpgradePlugin
     */
    readonly presetName?: string

    /**
     * Install source. Default is file.
     * @type {string}
     * @memberof PluginV1alpha1ConsoleApiUpgradePlugin
     */
    readonly source?: UpgradePluginSourceEnum
}

/**
 * Request parameters for upgradePluginFromUri operation in PluginV1alpha1ConsoleApi.
 * @export
 * @interface PluginV1alpha1ConsoleApiUpgradePluginFromUriRequest
 */
export interface PluginV1alpha1ConsoleApiUpgradePluginFromUriRequest {
    /**
     * 
     * @type {string}
     * @memberof PluginV1alpha1ConsoleApiUpgradePluginFromUri
     */
    readonly name: string

    /**
     * 
     * @type {UpgradeFromUriRequest}
     * @memberof PluginV1alpha1ConsoleApiUpgradePluginFromUri
     */
    readonly upgradeFromUriRequest: UpgradeFromUriRequest
}

/**
 * PluginV1alpha1ConsoleApi - object-oriented interface
 * @export
 * @class PluginV1alpha1ConsoleApi
 * @extends {BaseAPI}
 */
export class PluginV1alpha1ConsoleApi extends BaseAPI {
    /**
     * Change the running state of a plugin by name.
     * @param {PluginV1alpha1ConsoleApiChangePluginRunningStateRequest} requestParameters Request parameters.
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof PluginV1alpha1ConsoleApi
     */
    public changePluginRunningState(requestParameters: PluginV1alpha1ConsoleApiChangePluginRunningStateRequest, options?: RawAxiosRequestConfig) {
        return PluginV1alpha1ConsoleApiFp(this.configuration).changePluginRunningState(requestParameters.name, requestParameters.pluginRunningStateRequest, options).then((request) => request(this.axios, this.basePath));
    }

    /**
     * Merge all CSS bundles of enabled plugins into one.
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof PluginV1alpha1ConsoleApi
     */
    public fetchCssBundle(options?: RawAxiosRequestConfig) {
        return PluginV1alpha1ConsoleApiFp(this.configuration).fetchCssBundle(options).then((request) => request(this.axios, this.basePath));
    }

    /**
     * Merge all JS bundles of enabled plugins into one.
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof PluginV1alpha1ConsoleApi
     */
    public fetchJsBundle(options?: RawAxiosRequestConfig) {
        return PluginV1alpha1ConsoleApiFp(this.configuration).fetchJsBundle(options).then((request) => request(this.axios, this.basePath));
    }

    /**
     * Fetch configMap of plugin by configured configMapName. it is deprecated since 2.20.0
     * @param {PluginV1alpha1ConsoleApiFetchPluginConfigRequest} requestParameters Request parameters.
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof PluginV1alpha1ConsoleApi
     */
    public fetchPluginConfig(requestParameters: PluginV1alpha1ConsoleApiFetchPluginConfigRequest, options?: RawAxiosRequestConfig) {
        return PluginV1alpha1ConsoleApiFp(this.configuration).fetchPluginConfig(requestParameters.name, options).then((request) => request(this.axios, this.basePath));
    }

    /**
     * Fetch converted json config of plugin by configured configMapName.
     * @param {PluginV1alpha1ConsoleApiFetchPluginJsonConfigRequest} requestParameters Request parameters.
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof PluginV1alpha1ConsoleApi
     */
    public fetchPluginJsonConfig(requestParameters: PluginV1alpha1ConsoleApiFetchPluginJsonConfigRequest, options?: RawAxiosRequestConfig) {
        return PluginV1alpha1ConsoleApiFp(this.configuration).fetchPluginJsonConfig(requestParameters.name, options).then((request) => request(this.axios, this.basePath));
    }

    /**
     * Fetch setting of plugin.
     * @param {PluginV1alpha1ConsoleApiFetchPluginSettingRequest} requestParameters Request parameters.
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof PluginV1alpha1ConsoleApi
     */
    public fetchPluginSetting(requestParameters: PluginV1alpha1ConsoleApiFetchPluginSettingRequest, options?: RawAxiosRequestConfig) {
        return PluginV1alpha1ConsoleApiFp(this.configuration).fetchPluginSetting(requestParameters.name, options).then((request) => request(this.axios, this.basePath));
    }

    /**
     * Install a plugin by uploading a Jar file.
     * @param {PluginV1alpha1ConsoleApiInstallPluginRequest} requestParameters Request parameters.
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof PluginV1alpha1ConsoleApi
     */
    public installPlugin(requestParameters: PluginV1alpha1ConsoleApiInstallPluginRequest = {}, options?: RawAxiosRequestConfig) {
        return PluginV1alpha1ConsoleApiFp(this.configuration).installPlugin(requestParameters.file, requestParameters.presetName, requestParameters.source, options).then((request) => request(this.axios, this.basePath));
    }

    /**
     * Install a plugin from uri.
     * @param {PluginV1alpha1ConsoleApiInstallPluginFromUriRequest} requestParameters Request parameters.
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof PluginV1alpha1ConsoleApi
     */
    public installPluginFromUri(requestParameters: PluginV1alpha1ConsoleApiInstallPluginFromUriRequest, options?: RawAxiosRequestConfig) {
        return PluginV1alpha1ConsoleApiFp(this.configuration).installPluginFromUri(requestParameters.installFromUriRequest, options).then((request) => request(this.axios, this.basePath));
    }

    /**
     * List plugins using query criteria and sort params
     * @param {PluginV1alpha1ConsoleApiListPluginsRequest} requestParameters Request parameters.
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof PluginV1alpha1ConsoleApi
     */
    public listPlugins(requestParameters: PluginV1alpha1ConsoleApiListPluginsRequest = {}, options?: RawAxiosRequestConfig) {
        return PluginV1alpha1ConsoleApiFp(this.configuration).listPlugins(requestParameters.page, requestParameters.size, requestParameters.labelSelector, requestParameters.fieldSelector, requestParameters.sort, requestParameters.keyword, requestParameters.enabled, options).then((request) => request(this.axios, this.basePath));
    }

    /**
     * Reload a plugin by name.
     * @param {PluginV1alpha1ConsoleApiReloadPluginRequest} requestParameters Request parameters.
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof PluginV1alpha1ConsoleApi
     */
    public reloadPlugin(requestParameters: PluginV1alpha1ConsoleApiReloadPluginRequest, options?: RawAxiosRequestConfig) {
        return PluginV1alpha1ConsoleApiFp(this.configuration).reloadPlugin(requestParameters.name, options).then((request) => request(this.axios, this.basePath));
    }

    /**
     * Reset the configMap of plugin setting.
     * @param {PluginV1alpha1ConsoleApiResetPluginConfigRequest} requestParameters Request parameters.
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof PluginV1alpha1ConsoleApi
     */
    public resetPluginConfig(requestParameters: PluginV1alpha1ConsoleApiResetPluginConfigRequest, options?: RawAxiosRequestConfig) {
        return PluginV1alpha1ConsoleApiFp(this.configuration).resetPluginConfig(requestParameters.name, options).then((request) => request(this.axios, this.basePath));
    }

    /**
     * Update the configMap of plugin setting, it is deprecated since 2.20.0
     * @param {PluginV1alpha1ConsoleApiUpdatePluginConfigRequest} requestParameters Request parameters.
     * @param {*} [options] Override http request option.
     * @deprecated
     * @throws {RequiredError}
     * @memberof PluginV1alpha1ConsoleApi
     */
    public updatePluginConfig(requestParameters: PluginV1alpha1ConsoleApiUpdatePluginConfigRequest, options?: RawAxiosRequestConfig) {
        return PluginV1alpha1ConsoleApiFp(this.configuration).updatePluginConfig(requestParameters.name, requestParameters.configMap, options).then((request) => request(this.axios, this.basePath));
    }

    /**
     * Update the config of plugin setting.
     * @param {PluginV1alpha1ConsoleApiUpdatePluginJsonConfigRequest} requestParameters Request parameters.
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof PluginV1alpha1ConsoleApi
     */
    public updatePluginJsonConfig(requestParameters: PluginV1alpha1ConsoleApiUpdatePluginJsonConfigRequest, options?: RawAxiosRequestConfig) {
        return PluginV1alpha1ConsoleApiFp(this.configuration).updatePluginJsonConfig(requestParameters.name, requestParameters.body, options).then((request) => request(this.axios, this.basePath));
    }

    /**
     * Upgrade a plugin by uploading a Jar file
     * @param {PluginV1alpha1ConsoleApiUpgradePluginRequest} requestParameters Request parameters.
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof PluginV1alpha1ConsoleApi
     */
    public upgradePlugin(requestParameters: PluginV1alpha1ConsoleApiUpgradePluginRequest, options?: RawAxiosRequestConfig) {
        return PluginV1alpha1ConsoleApiFp(this.configuration).upgradePlugin(requestParameters.name, requestParameters.file, requestParameters.presetName, requestParameters.source, options).then((request) => request(this.axios, this.basePath));
    }

    /**
     * Upgrade a plugin from uri.
     * @param {PluginV1alpha1ConsoleApiUpgradePluginFromUriRequest} requestParameters Request parameters.
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof PluginV1alpha1ConsoleApi
     */
    public upgradePluginFromUri(requestParameters: PluginV1alpha1ConsoleApiUpgradePluginFromUriRequest, options?: RawAxiosRequestConfig) {
        return PluginV1alpha1ConsoleApiFp(this.configuration).upgradePluginFromUri(requestParameters.name, requestParameters.upgradeFromUriRequest, options).then((request) => request(this.axios, this.basePath));
    }
}

/**
 * @export
 */
export const InstallPluginSourceEnum = {
    File: 'FILE',
    Preset: 'PRESET',
    Url: 'URL'
} as const;
export type InstallPluginSourceEnum = typeof InstallPluginSourceEnum[keyof typeof InstallPluginSourceEnum];
/**
 * @export
 */
export const UpgradePluginSourceEnum = {
    File: 'FILE',
    Preset: 'PRESET',
    Url: 'URL'
} as const;
export type UpgradePluginSourceEnum = typeof UpgradePluginSourceEnum[keyof typeof UpgradePluginSourceEnum];
