/* tslint:disable */
/* eslint-disable */
/**
 * Halo
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: 2.20.10-SNAPSHOT
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


import type { Configuration } from '../configuration';
import type { AxiosPromise, AxiosInstance, RawAxiosRequestConfig } from 'axios';
import globalAxios from 'axios';
// Some imports not used depending on template conditions
// @ts-ignore
import { DUMMY_BASE_URL, assertParamExists, setApiKeyToObject, setBasicAuthToObject, setBearerAuthToObject, setOAuthToObject, setSearchParams, serializeDataIfNeeded, toPathString, createRequestFunction } from '../common';
// @ts-ignore
import { BASE_PATH, COLLECTION_FORMATS, RequestArgs, BaseAPI, RequiredError, operationServerMap } from '../base';
// @ts-ignore
import { JsonPatchInner } from '../models';
// @ts-ignore
import { Policy } from '../models';
// @ts-ignore
import { PolicyList } from '../models';
/**
 * PolicyV1alpha1Api - axios parameter creator
 * @export
 */
export const PolicyV1alpha1ApiAxiosParamCreator = function (configuration?: Configuration) {
    return {
        /**
         * Create Policy
         * @param {Policy} [policy] Fresh policy
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        createPolicy: async (policy?: Policy, options: RawAxiosRequestConfig = {}): Promise<RequestArgs> => {
            const localVarPath = `/apis/storage.halo.run/v1alpha1/policies`;
            // use dummy base URL string because the URL constructor only accepts absolute URLs.
            const localVarUrlObj = new URL(localVarPath, DUMMY_BASE_URL);
            let baseOptions;
            if (configuration) {
                baseOptions = configuration.baseOptions;
            }

            const localVarRequestOptions = { method: 'POST', ...baseOptions, ...options};
            const localVarHeaderParameter = {} as any;
            const localVarQueryParameter = {} as any;

            // authentication basicAuth required
            // http basic authentication required
            setBasicAuthToObject(localVarRequestOptions, configuration)

            // authentication bearerAuth required
            // http bearer authentication required
            await setBearerAuthToObject(localVarHeaderParameter, configuration)


    
            localVarHeaderParameter['Content-Type'] = 'application/json';

            setSearchParams(localVarUrlObj, localVarQueryParameter);
            let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
            localVarRequestOptions.headers = {...localVarHeaderParameter, ...headersFromBaseOptions, ...options.headers};
            localVarRequestOptions.data = serializeDataIfNeeded(policy, localVarRequestOptions, configuration)

            return {
                url: toPathString(localVarUrlObj),
                options: localVarRequestOptions,
            };
        },
        /**
         * Delete Policy
         * @param {string} name Name of policy
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        deletePolicy: async (name: string, options: RawAxiosRequestConfig = {}): Promise<RequestArgs> => {
            // verify required parameter 'name' is not null or undefined
            assertParamExists('deletePolicy', 'name', name)
            const localVarPath = `/apis/storage.halo.run/v1alpha1/policies/{name}`
                .replace(`{${"name"}}`, encodeURIComponent(String(name)));
            // use dummy base URL string because the URL constructor only accepts absolute URLs.
            const localVarUrlObj = new URL(localVarPath, DUMMY_BASE_URL);
            let baseOptions;
            if (configuration) {
                baseOptions = configuration.baseOptions;
            }

            const localVarRequestOptions = { method: 'DELETE', ...baseOptions, ...options};
            const localVarHeaderParameter = {} as any;
            const localVarQueryParameter = {} as any;

            // authentication basicAuth required
            // http basic authentication required
            setBasicAuthToObject(localVarRequestOptions, configuration)

            // authentication bearerAuth required
            // http bearer authentication required
            await setBearerAuthToObject(localVarHeaderParameter, configuration)


    
            setSearchParams(localVarUrlObj, localVarQueryParameter);
            let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
            localVarRequestOptions.headers = {...localVarHeaderParameter, ...headersFromBaseOptions, ...options.headers};

            return {
                url: toPathString(localVarUrlObj),
                options: localVarRequestOptions,
            };
        },
        /**
         * Get Policy
         * @param {string} name Name of policy
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        getPolicy: async (name: string, options: RawAxiosRequestConfig = {}): Promise<RequestArgs> => {
            // verify required parameter 'name' is not null or undefined
            assertParamExists('getPolicy', 'name', name)
            const localVarPath = `/apis/storage.halo.run/v1alpha1/policies/{name}`
                .replace(`{${"name"}}`, encodeURIComponent(String(name)));
            // use dummy base URL string because the URL constructor only accepts absolute URLs.
            const localVarUrlObj = new URL(localVarPath, DUMMY_BASE_URL);
            let baseOptions;
            if (configuration) {
                baseOptions = configuration.baseOptions;
            }

            const localVarRequestOptions = { method: 'GET', ...baseOptions, ...options};
            const localVarHeaderParameter = {} as any;
            const localVarQueryParameter = {} as any;

            // authentication basicAuth required
            // http basic authentication required
            setBasicAuthToObject(localVarRequestOptions, configuration)

            // authentication bearerAuth required
            // http bearer authentication required
            await setBearerAuthToObject(localVarHeaderParameter, configuration)


    
            setSearchParams(localVarUrlObj, localVarQueryParameter);
            let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
            localVarRequestOptions.headers = {...localVarHeaderParameter, ...headersFromBaseOptions, ...options.headers};

            return {
                url: toPathString(localVarUrlObj),
                options: localVarRequestOptions,
            };
        },
        /**
         * List Policy
         * @param {number} [page] Page number. Default is 0.
         * @param {number} [size] Size number. Default is 0.
         * @param {Array<string>} [labelSelector] Label selector. e.g.: hidden!&#x3D;true
         * @param {Array<string>} [fieldSelector] Field selector. e.g.: metadata.name&#x3D;&#x3D;halo
         * @param {Array<string>} [sort] Sorting criteria in the format: property,(asc|desc). Default sort order is ascending. Multiple sort criteria are supported.
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        listPolicy: async (page?: number, size?: number, labelSelector?: Array<string>, fieldSelector?: Array<string>, sort?: Array<string>, options: RawAxiosRequestConfig = {}): Promise<RequestArgs> => {
            const localVarPath = `/apis/storage.halo.run/v1alpha1/policies`;
            // use dummy base URL string because the URL constructor only accepts absolute URLs.
            const localVarUrlObj = new URL(localVarPath, DUMMY_BASE_URL);
            let baseOptions;
            if (configuration) {
                baseOptions = configuration.baseOptions;
            }

            const localVarRequestOptions = { method: 'GET', ...baseOptions, ...options};
            const localVarHeaderParameter = {} as any;
            const localVarQueryParameter = {} as any;

            // authentication basicAuth required
            // http basic authentication required
            setBasicAuthToObject(localVarRequestOptions, configuration)

            // authentication bearerAuth required
            // http bearer authentication required
            await setBearerAuthToObject(localVarHeaderParameter, configuration)

            if (page !== undefined) {
                localVarQueryParameter['page'] = page;
            }

            if (size !== undefined) {
                localVarQueryParameter['size'] = size;
            }

            if (labelSelector) {
                localVarQueryParameter['labelSelector'] = labelSelector;
            }

            if (fieldSelector) {
                localVarQueryParameter['fieldSelector'] = fieldSelector;
            }

            if (sort) {
                localVarQueryParameter['sort'] = sort;
            }


    
            setSearchParams(localVarUrlObj, localVarQueryParameter);
            let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
            localVarRequestOptions.headers = {...localVarHeaderParameter, ...headersFromBaseOptions, ...options.headers};

            return {
                url: toPathString(localVarUrlObj),
                options: localVarRequestOptions,
            };
        },
        /**
         * Patch Policy
         * @param {string} name Name of policy
         * @param {Array<JsonPatchInner>} [jsonPatchInner] 
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        patchPolicy: async (name: string, jsonPatchInner?: Array<JsonPatchInner>, options: RawAxiosRequestConfig = {}): Promise<RequestArgs> => {
            // verify required parameter 'name' is not null or undefined
            assertParamExists('patchPolicy', 'name', name)
            const localVarPath = `/apis/storage.halo.run/v1alpha1/policies/{name}`
                .replace(`{${"name"}}`, encodeURIComponent(String(name)));
            // use dummy base URL string because the URL constructor only accepts absolute URLs.
            const localVarUrlObj = new URL(localVarPath, DUMMY_BASE_URL);
            let baseOptions;
            if (configuration) {
                baseOptions = configuration.baseOptions;
            }

            const localVarRequestOptions = { method: 'PATCH', ...baseOptions, ...options};
            const localVarHeaderParameter = {} as any;
            const localVarQueryParameter = {} as any;

            // authentication basicAuth required
            // http basic authentication required
            setBasicAuthToObject(localVarRequestOptions, configuration)

            // authentication bearerAuth required
            // http bearer authentication required
            await setBearerAuthToObject(localVarHeaderParameter, configuration)


    
            localVarHeaderParameter['Content-Type'] = 'application/json-patch+json';

            setSearchParams(localVarUrlObj, localVarQueryParameter);
            let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
            localVarRequestOptions.headers = {...localVarHeaderParameter, ...headersFromBaseOptions, ...options.headers};
            localVarRequestOptions.data = serializeDataIfNeeded(jsonPatchInner, localVarRequestOptions, configuration)

            return {
                url: toPathString(localVarUrlObj),
                options: localVarRequestOptions,
            };
        },
        /**
         * Update Policy
         * @param {string} name Name of policy
         * @param {Policy} [policy] Updated policy
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        updatePolicy: async (name: string, policy?: Policy, options: RawAxiosRequestConfig = {}): Promise<RequestArgs> => {
            // verify required parameter 'name' is not null or undefined
            assertParamExists('updatePolicy', 'name', name)
            const localVarPath = `/apis/storage.halo.run/v1alpha1/policies/{name}`
                .replace(`{${"name"}}`, encodeURIComponent(String(name)));
            // use dummy base URL string because the URL constructor only accepts absolute URLs.
            const localVarUrlObj = new URL(localVarPath, DUMMY_BASE_URL);
            let baseOptions;
            if (configuration) {
                baseOptions = configuration.baseOptions;
            }

            const localVarRequestOptions = { method: 'PUT', ...baseOptions, ...options};
            const localVarHeaderParameter = {} as any;
            const localVarQueryParameter = {} as any;

            // authentication basicAuth required
            // http basic authentication required
            setBasicAuthToObject(localVarRequestOptions, configuration)

            // authentication bearerAuth required
            // http bearer authentication required
            await setBearerAuthToObject(localVarHeaderParameter, configuration)


    
            localVarHeaderParameter['Content-Type'] = 'application/json';

            setSearchParams(localVarUrlObj, localVarQueryParameter);
            let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
            localVarRequestOptions.headers = {...localVarHeaderParameter, ...headersFromBaseOptions, ...options.headers};
            localVarRequestOptions.data = serializeDataIfNeeded(policy, localVarRequestOptions, configuration)

            return {
                url: toPathString(localVarUrlObj),
                options: localVarRequestOptions,
            };
        },
    }
};

/**
 * PolicyV1alpha1Api - functional programming interface
 * @export
 */
export const PolicyV1alpha1ApiFp = function(configuration?: Configuration) {
    const localVarAxiosParamCreator = PolicyV1alpha1ApiAxiosParamCreator(configuration)
    return {
        /**
         * Create Policy
         * @param {Policy} [policy] Fresh policy
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        async createPolicy(policy?: Policy, options?: RawAxiosRequestConfig): Promise<(axios?: AxiosInstance, basePath?: string) => AxiosPromise<Policy>> {
            const localVarAxiosArgs = await localVarAxiosParamCreator.createPolicy(policy, options);
            const localVarOperationServerIndex = configuration?.serverIndex ?? 0;
            const localVarOperationServerBasePath = operationServerMap['PolicyV1alpha1Api.createPolicy']?.[localVarOperationServerIndex]?.url;
            return (axios, basePath) => createRequestFunction(localVarAxiosArgs, globalAxios, BASE_PATH, configuration)(axios, localVarOperationServerBasePath || basePath);
        },
        /**
         * Delete Policy
         * @param {string} name Name of policy
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        async deletePolicy(name: string, options?: RawAxiosRequestConfig): Promise<(axios?: AxiosInstance, basePath?: string) => AxiosPromise<void>> {
            const localVarAxiosArgs = await localVarAxiosParamCreator.deletePolicy(name, options);
            const localVarOperationServerIndex = configuration?.serverIndex ?? 0;
            const localVarOperationServerBasePath = operationServerMap['PolicyV1alpha1Api.deletePolicy']?.[localVarOperationServerIndex]?.url;
            return (axios, basePath) => createRequestFunction(localVarAxiosArgs, globalAxios, BASE_PATH, configuration)(axios, localVarOperationServerBasePath || basePath);
        },
        /**
         * Get Policy
         * @param {string} name Name of policy
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        async getPolicy(name: string, options?: RawAxiosRequestConfig): Promise<(axios?: AxiosInstance, basePath?: string) => AxiosPromise<Policy>> {
            const localVarAxiosArgs = await localVarAxiosParamCreator.getPolicy(name, options);
            const localVarOperationServerIndex = configuration?.serverIndex ?? 0;
            const localVarOperationServerBasePath = operationServerMap['PolicyV1alpha1Api.getPolicy']?.[localVarOperationServerIndex]?.url;
            return (axios, basePath) => createRequestFunction(localVarAxiosArgs, globalAxios, BASE_PATH, configuration)(axios, localVarOperationServerBasePath || basePath);
        },
        /**
         * List Policy
         * @param {number} [page] Page number. Default is 0.
         * @param {number} [size] Size number. Default is 0.
         * @param {Array<string>} [labelSelector] Label selector. e.g.: hidden!&#x3D;true
         * @param {Array<string>} [fieldSelector] Field selector. e.g.: metadata.name&#x3D;&#x3D;halo
         * @param {Array<string>} [sort] Sorting criteria in the format: property,(asc|desc). Default sort order is ascending. Multiple sort criteria are supported.
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        async listPolicy(page?: number, size?: number, labelSelector?: Array<string>, fieldSelector?: Array<string>, sort?: Array<string>, options?: RawAxiosRequestConfig): Promise<(axios?: AxiosInstance, basePath?: string) => AxiosPromise<PolicyList>> {
            const localVarAxiosArgs = await localVarAxiosParamCreator.listPolicy(page, size, labelSelector, fieldSelector, sort, options);
            const localVarOperationServerIndex = configuration?.serverIndex ?? 0;
            const localVarOperationServerBasePath = operationServerMap['PolicyV1alpha1Api.listPolicy']?.[localVarOperationServerIndex]?.url;
            return (axios, basePath) => createRequestFunction(localVarAxiosArgs, globalAxios, BASE_PATH, configuration)(axios, localVarOperationServerBasePath || basePath);
        },
        /**
         * Patch Policy
         * @param {string} name Name of policy
         * @param {Array<JsonPatchInner>} [jsonPatchInner] 
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        async patchPolicy(name: string, jsonPatchInner?: Array<JsonPatchInner>, options?: RawAxiosRequestConfig): Promise<(axios?: AxiosInstance, basePath?: string) => AxiosPromise<Policy>> {
            const localVarAxiosArgs = await localVarAxiosParamCreator.patchPolicy(name, jsonPatchInner, options);
            const localVarOperationServerIndex = configuration?.serverIndex ?? 0;
            const localVarOperationServerBasePath = operationServerMap['PolicyV1alpha1Api.patchPolicy']?.[localVarOperationServerIndex]?.url;
            return (axios, basePath) => createRequestFunction(localVarAxiosArgs, globalAxios, BASE_PATH, configuration)(axios, localVarOperationServerBasePath || basePath);
        },
        /**
         * Update Policy
         * @param {string} name Name of policy
         * @param {Policy} [policy] Updated policy
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        async updatePolicy(name: string, policy?: Policy, options?: RawAxiosRequestConfig): Promise<(axios?: AxiosInstance, basePath?: string) => AxiosPromise<Policy>> {
            const localVarAxiosArgs = await localVarAxiosParamCreator.updatePolicy(name, policy, options);
            const localVarOperationServerIndex = configuration?.serverIndex ?? 0;
            const localVarOperationServerBasePath = operationServerMap['PolicyV1alpha1Api.updatePolicy']?.[localVarOperationServerIndex]?.url;
            return (axios, basePath) => createRequestFunction(localVarAxiosArgs, globalAxios, BASE_PATH, configuration)(axios, localVarOperationServerBasePath || basePath);
        },
    }
};

/**
 * PolicyV1alpha1Api - factory interface
 * @export
 */
export const PolicyV1alpha1ApiFactory = function (configuration?: Configuration, basePath?: string, axios?: AxiosInstance) {
    const localVarFp = PolicyV1alpha1ApiFp(configuration)
    return {
        /**
         * Create Policy
         * @param {PolicyV1alpha1ApiCreatePolicyRequest} requestParameters Request parameters.
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        createPolicy(requestParameters: PolicyV1alpha1ApiCreatePolicyRequest = {}, options?: RawAxiosRequestConfig): AxiosPromise<Policy> {
            return localVarFp.createPolicy(requestParameters.policy, options).then((request) => request(axios, basePath));
        },
        /**
         * Delete Policy
         * @param {PolicyV1alpha1ApiDeletePolicyRequest} requestParameters Request parameters.
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        deletePolicy(requestParameters: PolicyV1alpha1ApiDeletePolicyRequest, options?: RawAxiosRequestConfig): AxiosPromise<void> {
            return localVarFp.deletePolicy(requestParameters.name, options).then((request) => request(axios, basePath));
        },
        /**
         * Get Policy
         * @param {PolicyV1alpha1ApiGetPolicyRequest} requestParameters Request parameters.
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        getPolicy(requestParameters: PolicyV1alpha1ApiGetPolicyRequest, options?: RawAxiosRequestConfig): AxiosPromise<Policy> {
            return localVarFp.getPolicy(requestParameters.name, options).then((request) => request(axios, basePath));
        },
        /**
         * List Policy
         * @param {PolicyV1alpha1ApiListPolicyRequest} requestParameters Request parameters.
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        listPolicy(requestParameters: PolicyV1alpha1ApiListPolicyRequest = {}, options?: RawAxiosRequestConfig): AxiosPromise<PolicyList> {
            return localVarFp.listPolicy(requestParameters.page, requestParameters.size, requestParameters.labelSelector, requestParameters.fieldSelector, requestParameters.sort, options).then((request) => request(axios, basePath));
        },
        /**
         * Patch Policy
         * @param {PolicyV1alpha1ApiPatchPolicyRequest} requestParameters Request parameters.
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        patchPolicy(requestParameters: PolicyV1alpha1ApiPatchPolicyRequest, options?: RawAxiosRequestConfig): AxiosPromise<Policy> {
            return localVarFp.patchPolicy(requestParameters.name, requestParameters.jsonPatchInner, options).then((request) => request(axios, basePath));
        },
        /**
         * Update Policy
         * @param {PolicyV1alpha1ApiUpdatePolicyRequest} requestParameters Request parameters.
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        updatePolicy(requestParameters: PolicyV1alpha1ApiUpdatePolicyRequest, options?: RawAxiosRequestConfig): AxiosPromise<Policy> {
            return localVarFp.updatePolicy(requestParameters.name, requestParameters.policy, options).then((request) => request(axios, basePath));
        },
    };
};

/**
 * Request parameters for createPolicy operation in PolicyV1alpha1Api.
 * @export
 * @interface PolicyV1alpha1ApiCreatePolicyRequest
 */
export interface PolicyV1alpha1ApiCreatePolicyRequest {
    /**
     * Fresh policy
     * @type {Policy}
     * @memberof PolicyV1alpha1ApiCreatePolicy
     */
    readonly policy?: Policy
}

/**
 * Request parameters for deletePolicy operation in PolicyV1alpha1Api.
 * @export
 * @interface PolicyV1alpha1ApiDeletePolicyRequest
 */
export interface PolicyV1alpha1ApiDeletePolicyRequest {
    /**
     * Name of policy
     * @type {string}
     * @memberof PolicyV1alpha1ApiDeletePolicy
     */
    readonly name: string
}

/**
 * Request parameters for getPolicy operation in PolicyV1alpha1Api.
 * @export
 * @interface PolicyV1alpha1ApiGetPolicyRequest
 */
export interface PolicyV1alpha1ApiGetPolicyRequest {
    /**
     * Name of policy
     * @type {string}
     * @memberof PolicyV1alpha1ApiGetPolicy
     */
    readonly name: string
}

/**
 * Request parameters for listPolicy operation in PolicyV1alpha1Api.
 * @export
 * @interface PolicyV1alpha1ApiListPolicyRequest
 */
export interface PolicyV1alpha1ApiListPolicyRequest {
    /**
     * Page number. Default is 0.
     * @type {number}
     * @memberof PolicyV1alpha1ApiListPolicy
     */
    readonly page?: number

    /**
     * Size number. Default is 0.
     * @type {number}
     * @memberof PolicyV1alpha1ApiListPolicy
     */
    readonly size?: number

    /**
     * Label selector. e.g.: hidden!&#x3D;true
     * @type {Array<string>}
     * @memberof PolicyV1alpha1ApiListPolicy
     */
    readonly labelSelector?: Array<string>

    /**
     * Field selector. e.g.: metadata.name&#x3D;&#x3D;halo
     * @type {Array<string>}
     * @memberof PolicyV1alpha1ApiListPolicy
     */
    readonly fieldSelector?: Array<string>

    /**
     * Sorting criteria in the format: property,(asc|desc). Default sort order is ascending. Multiple sort criteria are supported.
     * @type {Array<string>}
     * @memberof PolicyV1alpha1ApiListPolicy
     */
    readonly sort?: Array<string>
}

/**
 * Request parameters for patchPolicy operation in PolicyV1alpha1Api.
 * @export
 * @interface PolicyV1alpha1ApiPatchPolicyRequest
 */
export interface PolicyV1alpha1ApiPatchPolicyRequest {
    /**
     * Name of policy
     * @type {string}
     * @memberof PolicyV1alpha1ApiPatchPolicy
     */
    readonly name: string

    /**
     * 
     * @type {Array<JsonPatchInner>}
     * @memberof PolicyV1alpha1ApiPatchPolicy
     */
    readonly jsonPatchInner?: Array<JsonPatchInner>
}

/**
 * Request parameters for updatePolicy operation in PolicyV1alpha1Api.
 * @export
 * @interface PolicyV1alpha1ApiUpdatePolicyRequest
 */
export interface PolicyV1alpha1ApiUpdatePolicyRequest {
    /**
     * Name of policy
     * @type {string}
     * @memberof PolicyV1alpha1ApiUpdatePolicy
     */
    readonly name: string

    /**
     * Updated policy
     * @type {Policy}
     * @memberof PolicyV1alpha1ApiUpdatePolicy
     */
    readonly policy?: Policy
}

/**
 * PolicyV1alpha1Api - object-oriented interface
 * @export
 * @class PolicyV1alpha1Api
 * @extends {BaseAPI}
 */
export class PolicyV1alpha1Api extends BaseAPI {
    /**
     * Create Policy
     * @param {PolicyV1alpha1ApiCreatePolicyRequest} requestParameters Request parameters.
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof PolicyV1alpha1Api
     */
    public createPolicy(requestParameters: PolicyV1alpha1ApiCreatePolicyRequest = {}, options?: RawAxiosRequestConfig) {
        return PolicyV1alpha1ApiFp(this.configuration).createPolicy(requestParameters.policy, options).then((request) => request(this.axios, this.basePath));
    }

    /**
     * Delete Policy
     * @param {PolicyV1alpha1ApiDeletePolicyRequest} requestParameters Request parameters.
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof PolicyV1alpha1Api
     */
    public deletePolicy(requestParameters: PolicyV1alpha1ApiDeletePolicyRequest, options?: RawAxiosRequestConfig) {
        return PolicyV1alpha1ApiFp(this.configuration).deletePolicy(requestParameters.name, options).then((request) => request(this.axios, this.basePath));
    }

    /**
     * Get Policy
     * @param {PolicyV1alpha1ApiGetPolicyRequest} requestParameters Request parameters.
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof PolicyV1alpha1Api
     */
    public getPolicy(requestParameters: PolicyV1alpha1ApiGetPolicyRequest, options?: RawAxiosRequestConfig) {
        return PolicyV1alpha1ApiFp(this.configuration).getPolicy(requestParameters.name, options).then((request) => request(this.axios, this.basePath));
    }

    /**
     * List Policy
     * @param {PolicyV1alpha1ApiListPolicyRequest} requestParameters Request parameters.
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof PolicyV1alpha1Api
     */
    public listPolicy(requestParameters: PolicyV1alpha1ApiListPolicyRequest = {}, options?: RawAxiosRequestConfig) {
        return PolicyV1alpha1ApiFp(this.configuration).listPolicy(requestParameters.page, requestParameters.size, requestParameters.labelSelector, requestParameters.fieldSelector, requestParameters.sort, options).then((request) => request(this.axios, this.basePath));
    }

    /**
     * Patch Policy
     * @param {PolicyV1alpha1ApiPatchPolicyRequest} requestParameters Request parameters.
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof PolicyV1alpha1Api
     */
    public patchPolicy(requestParameters: PolicyV1alpha1ApiPatchPolicyRequest, options?: RawAxiosRequestConfig) {
        return PolicyV1alpha1ApiFp(this.configuration).patchPolicy(requestParameters.name, requestParameters.jsonPatchInner, options).then((request) => request(this.axios, this.basePath));
    }

    /**
     * Update Policy
     * @param {PolicyV1alpha1ApiUpdatePolicyRequest} requestParameters Request parameters.
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof PolicyV1alpha1Api
     */
    public updatePolicy(requestParameters: PolicyV1alpha1ApiUpdatePolicyRequest, options?: RawAxiosRequestConfig) {
        return PolicyV1alpha1ApiFp(this.configuration).updatePolicy(requestParameters.name, requestParameters.policy, options).then((request) => request(this.axios, this.basePath));
    }
}

