/* tslint:disable */
/* eslint-disable */
/**
 * Halo
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: 2.20.10-SNAPSHOT
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


import type { Configuration } from '../configuration';
import type { AxiosPromise, AxiosInstance, RawAxiosRequestConfig } from 'axios';
import globalAxios from 'axios';
// Some imports not used depending on template conditions
// @ts-ignore
import { DUMMY_BASE_URL, assertParamExists, setApiKeyToObject, setBasicAuthToObject, setBearerAuthToObject, setOAuthToObject, setSearchParams, serializeDataIfNeeded, toPathString, createRequestFunction } from '../common';
// @ts-ignore
import { BASE_PATH, COLLECTION_FORMATS, RequestArgs, BaseAPI, RequiredError, operationServerMap } from '../base';
// @ts-ignore
import { ListedPostVoList } from '../models';
// @ts-ignore
import { NavigationPostVo } from '../models';
// @ts-ignore
import { PostVo } from '../models';
/**
 * PostV1alpha1PublicApi - axios parameter creator
 * @export
 */
export const PostV1alpha1PublicApiAxiosParamCreator = function (configuration?: Configuration) {
    return {
        /**
         * Gets a post by name.
         * @param {string} name Post name
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        queryPostByName: async (name: string, options: RawAxiosRequestConfig = {}): Promise<RequestArgs> => {
            // verify required parameter 'name' is not null or undefined
            assertParamExists('queryPostByName', 'name', name)
            const localVarPath = `/apis/api.content.halo.run/v1alpha1/posts/{name}`
                .replace(`{${"name"}}`, encodeURIComponent(String(name)));
            // use dummy base URL string because the URL constructor only accepts absolute URLs.
            const localVarUrlObj = new URL(localVarPath, DUMMY_BASE_URL);
            let baseOptions;
            if (configuration) {
                baseOptions = configuration.baseOptions;
            }

            const localVarRequestOptions = { method: 'GET', ...baseOptions, ...options};
            const localVarHeaderParameter = {} as any;
            const localVarQueryParameter = {} as any;

            // authentication basicAuth required
            // http basic authentication required
            setBasicAuthToObject(localVarRequestOptions, configuration)

            // authentication bearerAuth required
            // http bearer authentication required
            await setBearerAuthToObject(localVarHeaderParameter, configuration)


    
            setSearchParams(localVarUrlObj, localVarQueryParameter);
            let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
            localVarRequestOptions.headers = {...localVarHeaderParameter, ...headersFromBaseOptions, ...options.headers};

            return {
                url: toPathString(localVarUrlObj),
                options: localVarRequestOptions,
            };
        },
        /**
         * Gets a post navigation by name.
         * @param {string} name Post name
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        queryPostNavigationByName: async (name: string, options: RawAxiosRequestConfig = {}): Promise<RequestArgs> => {
            // verify required parameter 'name' is not null or undefined
            assertParamExists('queryPostNavigationByName', 'name', name)
            const localVarPath = `/apis/api.content.halo.run/v1alpha1/posts/{name}/navigation`
                .replace(`{${"name"}}`, encodeURIComponent(String(name)));
            // use dummy base URL string because the URL constructor only accepts absolute URLs.
            const localVarUrlObj = new URL(localVarPath, DUMMY_BASE_URL);
            let baseOptions;
            if (configuration) {
                baseOptions = configuration.baseOptions;
            }

            const localVarRequestOptions = { method: 'GET', ...baseOptions, ...options};
            const localVarHeaderParameter = {} as any;
            const localVarQueryParameter = {} as any;

            // authentication basicAuth required
            // http basic authentication required
            setBasicAuthToObject(localVarRequestOptions, configuration)

            // authentication bearerAuth required
            // http bearer authentication required
            await setBearerAuthToObject(localVarHeaderParameter, configuration)


    
            setSearchParams(localVarUrlObj, localVarQueryParameter);
            let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
            localVarRequestOptions.headers = {...localVarHeaderParameter, ...headersFromBaseOptions, ...options.headers};

            return {
                url: toPathString(localVarUrlObj),
                options: localVarRequestOptions,
            };
        },
        /**
         * Lists posts.
         * @param {number} [page] Page number. Default is 0.
         * @param {number} [size] Size number. Default is 0.
         * @param {Array<string>} [labelSelector] Label selector. e.g.: hidden!&#x3D;true
         * @param {Array<string>} [fieldSelector] Field selector. e.g.: metadata.name&#x3D;&#x3D;halo
         * @param {Array<string>} [sort] Sorting criteria in the format: property,(asc|desc). Default sort order is ascending. Multiple sort criteria are supported.
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        queryPosts: async (page?: number, size?: number, labelSelector?: Array<string>, fieldSelector?: Array<string>, sort?: Array<string>, options: RawAxiosRequestConfig = {}): Promise<RequestArgs> => {
            const localVarPath = `/apis/api.content.halo.run/v1alpha1/posts`;
            // use dummy base URL string because the URL constructor only accepts absolute URLs.
            const localVarUrlObj = new URL(localVarPath, DUMMY_BASE_URL);
            let baseOptions;
            if (configuration) {
                baseOptions = configuration.baseOptions;
            }

            const localVarRequestOptions = { method: 'GET', ...baseOptions, ...options};
            const localVarHeaderParameter = {} as any;
            const localVarQueryParameter = {} as any;

            // authentication basicAuth required
            // http basic authentication required
            setBasicAuthToObject(localVarRequestOptions, configuration)

            // authentication bearerAuth required
            // http bearer authentication required
            await setBearerAuthToObject(localVarHeaderParameter, configuration)

            if (page !== undefined) {
                localVarQueryParameter['page'] = page;
            }

            if (size !== undefined) {
                localVarQueryParameter['size'] = size;
            }

            if (labelSelector) {
                localVarQueryParameter['labelSelector'] = labelSelector;
            }

            if (fieldSelector) {
                localVarQueryParameter['fieldSelector'] = fieldSelector;
            }

            if (sort) {
                localVarQueryParameter['sort'] = sort;
            }


    
            setSearchParams(localVarUrlObj, localVarQueryParameter);
            let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
            localVarRequestOptions.headers = {...localVarHeaderParameter, ...headersFromBaseOptions, ...options.headers};

            return {
                url: toPathString(localVarUrlObj),
                options: localVarRequestOptions,
            };
        },
    }
};

/**
 * PostV1alpha1PublicApi - functional programming interface
 * @export
 */
export const PostV1alpha1PublicApiFp = function(configuration?: Configuration) {
    const localVarAxiosParamCreator = PostV1alpha1PublicApiAxiosParamCreator(configuration)
    return {
        /**
         * Gets a post by name.
         * @param {string} name Post name
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        async queryPostByName(name: string, options?: RawAxiosRequestConfig): Promise<(axios?: AxiosInstance, basePath?: string) => AxiosPromise<PostVo>> {
            const localVarAxiosArgs = await localVarAxiosParamCreator.queryPostByName(name, options);
            const localVarOperationServerIndex = configuration?.serverIndex ?? 0;
            const localVarOperationServerBasePath = operationServerMap['PostV1alpha1PublicApi.queryPostByName']?.[localVarOperationServerIndex]?.url;
            return (axios, basePath) => createRequestFunction(localVarAxiosArgs, globalAxios, BASE_PATH, configuration)(axios, localVarOperationServerBasePath || basePath);
        },
        /**
         * Gets a post navigation by name.
         * @param {string} name Post name
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        async queryPostNavigationByName(name: string, options?: RawAxiosRequestConfig): Promise<(axios?: AxiosInstance, basePath?: string) => AxiosPromise<NavigationPostVo>> {
            const localVarAxiosArgs = await localVarAxiosParamCreator.queryPostNavigationByName(name, options);
            const localVarOperationServerIndex = configuration?.serverIndex ?? 0;
            const localVarOperationServerBasePath = operationServerMap['PostV1alpha1PublicApi.queryPostNavigationByName']?.[localVarOperationServerIndex]?.url;
            return (axios, basePath) => createRequestFunction(localVarAxiosArgs, globalAxios, BASE_PATH, configuration)(axios, localVarOperationServerBasePath || basePath);
        },
        /**
         * Lists posts.
         * @param {number} [page] Page number. Default is 0.
         * @param {number} [size] Size number. Default is 0.
         * @param {Array<string>} [labelSelector] Label selector. e.g.: hidden!&#x3D;true
         * @param {Array<string>} [fieldSelector] Field selector. e.g.: metadata.name&#x3D;&#x3D;halo
         * @param {Array<string>} [sort] Sorting criteria in the format: property,(asc|desc). Default sort order is ascending. Multiple sort criteria are supported.
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        async queryPosts(page?: number, size?: number, labelSelector?: Array<string>, fieldSelector?: Array<string>, sort?: Array<string>, options?: RawAxiosRequestConfig): Promise<(axios?: AxiosInstance, basePath?: string) => AxiosPromise<ListedPostVoList>> {
            const localVarAxiosArgs = await localVarAxiosParamCreator.queryPosts(page, size, labelSelector, fieldSelector, sort, options);
            const localVarOperationServerIndex = configuration?.serverIndex ?? 0;
            const localVarOperationServerBasePath = operationServerMap['PostV1alpha1PublicApi.queryPosts']?.[localVarOperationServerIndex]?.url;
            return (axios, basePath) => createRequestFunction(localVarAxiosArgs, globalAxios, BASE_PATH, configuration)(axios, localVarOperationServerBasePath || basePath);
        },
    }
};

/**
 * PostV1alpha1PublicApi - factory interface
 * @export
 */
export const PostV1alpha1PublicApiFactory = function (configuration?: Configuration, basePath?: string, axios?: AxiosInstance) {
    const localVarFp = PostV1alpha1PublicApiFp(configuration)
    return {
        /**
         * Gets a post by name.
         * @param {PostV1alpha1PublicApiQueryPostByNameRequest} requestParameters Request parameters.
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        queryPostByName(requestParameters: PostV1alpha1PublicApiQueryPostByNameRequest, options?: RawAxiosRequestConfig): AxiosPromise<PostVo> {
            return localVarFp.queryPostByName(requestParameters.name, options).then((request) => request(axios, basePath));
        },
        /**
         * Gets a post navigation by name.
         * @param {PostV1alpha1PublicApiQueryPostNavigationByNameRequest} requestParameters Request parameters.
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        queryPostNavigationByName(requestParameters: PostV1alpha1PublicApiQueryPostNavigationByNameRequest, options?: RawAxiosRequestConfig): AxiosPromise<NavigationPostVo> {
            return localVarFp.queryPostNavigationByName(requestParameters.name, options).then((request) => request(axios, basePath));
        },
        /**
         * Lists posts.
         * @param {PostV1alpha1PublicApiQueryPostsRequest} requestParameters Request parameters.
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        queryPosts(requestParameters: PostV1alpha1PublicApiQueryPostsRequest = {}, options?: RawAxiosRequestConfig): AxiosPromise<ListedPostVoList> {
            return localVarFp.queryPosts(requestParameters.page, requestParameters.size, requestParameters.labelSelector, requestParameters.fieldSelector, requestParameters.sort, options).then((request) => request(axios, basePath));
        },
    };
};

/**
 * Request parameters for queryPostByName operation in PostV1alpha1PublicApi.
 * @export
 * @interface PostV1alpha1PublicApiQueryPostByNameRequest
 */
export interface PostV1alpha1PublicApiQueryPostByNameRequest {
    /**
     * Post name
     * @type {string}
     * @memberof PostV1alpha1PublicApiQueryPostByName
     */
    readonly name: string
}

/**
 * Request parameters for queryPostNavigationByName operation in PostV1alpha1PublicApi.
 * @export
 * @interface PostV1alpha1PublicApiQueryPostNavigationByNameRequest
 */
export interface PostV1alpha1PublicApiQueryPostNavigationByNameRequest {
    /**
     * Post name
     * @type {string}
     * @memberof PostV1alpha1PublicApiQueryPostNavigationByName
     */
    readonly name: string
}

/**
 * Request parameters for queryPosts operation in PostV1alpha1PublicApi.
 * @export
 * @interface PostV1alpha1PublicApiQueryPostsRequest
 */
export interface PostV1alpha1PublicApiQueryPostsRequest {
    /**
     * Page number. Default is 0.
     * @type {number}
     * @memberof PostV1alpha1PublicApiQueryPosts
     */
    readonly page?: number

    /**
     * Size number. Default is 0.
     * @type {number}
     * @memberof PostV1alpha1PublicApiQueryPosts
     */
    readonly size?: number

    /**
     * Label selector. e.g.: hidden!&#x3D;true
     * @type {Array<string>}
     * @memberof PostV1alpha1PublicApiQueryPosts
     */
    readonly labelSelector?: Array<string>

    /**
     * Field selector. e.g.: metadata.name&#x3D;&#x3D;halo
     * @type {Array<string>}
     * @memberof PostV1alpha1PublicApiQueryPosts
     */
    readonly fieldSelector?: Array<string>

    /**
     * Sorting criteria in the format: property,(asc|desc). Default sort order is ascending. Multiple sort criteria are supported.
     * @type {Array<string>}
     * @memberof PostV1alpha1PublicApiQueryPosts
     */
    readonly sort?: Array<string>
}

/**
 * PostV1alpha1PublicApi - object-oriented interface
 * @export
 * @class PostV1alpha1PublicApi
 * @extends {BaseAPI}
 */
export class PostV1alpha1PublicApi extends BaseAPI {
    /**
     * Gets a post by name.
     * @param {PostV1alpha1PublicApiQueryPostByNameRequest} requestParameters Request parameters.
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof PostV1alpha1PublicApi
     */
    public queryPostByName(requestParameters: PostV1alpha1PublicApiQueryPostByNameRequest, options?: RawAxiosRequestConfig) {
        return PostV1alpha1PublicApiFp(this.configuration).queryPostByName(requestParameters.name, options).then((request) => request(this.axios, this.basePath));
    }

    /**
     * Gets a post navigation by name.
     * @param {PostV1alpha1PublicApiQueryPostNavigationByNameRequest} requestParameters Request parameters.
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof PostV1alpha1PublicApi
     */
    public queryPostNavigationByName(requestParameters: PostV1alpha1PublicApiQueryPostNavigationByNameRequest, options?: RawAxiosRequestConfig) {
        return PostV1alpha1PublicApiFp(this.configuration).queryPostNavigationByName(requestParameters.name, options).then((request) => request(this.axios, this.basePath));
    }

    /**
     * Lists posts.
     * @param {PostV1alpha1PublicApiQueryPostsRequest} requestParameters Request parameters.
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof PostV1alpha1PublicApi
     */
    public queryPosts(requestParameters: PostV1alpha1PublicApiQueryPostsRequest = {}, options?: RawAxiosRequestConfig) {
        return PostV1alpha1PublicApiFp(this.configuration).queryPosts(requestParameters.page, requestParameters.size, requestParameters.labelSelector, requestParameters.fieldSelector, requestParameters.sort, options).then((request) => request(this.axios, this.basePath));
    }
}

