/* tslint:disable */
/* eslint-disable */
/**
 * Halo
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: 2.20.10-SNAPSHOT
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


import type { Configuration } from '../configuration';
import type { AxiosPromise, AxiosInstance, RawAxiosRequestConfig } from 'axios';
import globalAxios from 'axios';
// Some imports not used depending on template conditions
// @ts-ignore
import { DUMMY_BASE_URL, assertParamExists, setApiKeyToObject, setBasicAuthToObject, setBearerAuthToObject, setOAuthToObject, setSearchParams, serializeDataIfNeeded, toPathString, createRequestFunction } from '../common';
// @ts-ignore
import { BASE_PATH, COLLECTION_FORMATS, RequestArgs, BaseAPI, RequiredError, operationServerMap } from '../base';
// @ts-ignore
import { ListedPostList } from '../models';
// @ts-ignore
import { Post } from '../models';
// @ts-ignore
import { Snapshot } from '../models';
/**
 * PostV1alpha1UcApi - axios parameter creator
 * @export
 */
export const PostV1alpha1UcApiAxiosParamCreator = function (configuration?: Configuration) {
    return {
        /**
         * Create my post. If you want to create a post with content, please set  annotation: \"content.halo.run/content-json\" into annotations and refer  to Content for corresponding data type. 
         * @param {Post} [post] 
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        createMyPost: async (post?: Post, options: RawAxiosRequestConfig = {}): Promise<RequestArgs> => {
            const localVarPath = `/apis/uc.api.content.halo.run/v1alpha1/posts`;
            // use dummy base URL string because the URL constructor only accepts absolute URLs.
            const localVarUrlObj = new URL(localVarPath, DUMMY_BASE_URL);
            let baseOptions;
            if (configuration) {
                baseOptions = configuration.baseOptions;
            }

            const localVarRequestOptions = { method: 'POST', ...baseOptions, ...options};
            const localVarHeaderParameter = {} as any;
            const localVarQueryParameter = {} as any;

            // authentication basicAuth required
            // http basic authentication required
            setBasicAuthToObject(localVarRequestOptions, configuration)

            // authentication bearerAuth required
            // http bearer authentication required
            await setBearerAuthToObject(localVarHeaderParameter, configuration)


    
            localVarHeaderParameter['Content-Type'] = 'application/json';

            setSearchParams(localVarUrlObj, localVarQueryParameter);
            let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
            localVarRequestOptions.headers = {...localVarHeaderParameter, ...headersFromBaseOptions, ...options.headers};
            localVarRequestOptions.data = serializeDataIfNeeded(post, localVarRequestOptions, configuration)

            return {
                url: toPathString(localVarUrlObj),
                options: localVarRequestOptions,
            };
        },
        /**
         * Get post that belongs to the current user.
         * @param {string} name Post name
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        getMyPost: async (name: string, options: RawAxiosRequestConfig = {}): Promise<RequestArgs> => {
            // verify required parameter 'name' is not null or undefined
            assertParamExists('getMyPost', 'name', name)
            const localVarPath = `/apis/uc.api.content.halo.run/v1alpha1/posts/{name}`
                .replace(`{${"name"}}`, encodeURIComponent(String(name)));
            // use dummy base URL string because the URL constructor only accepts absolute URLs.
            const localVarUrlObj = new URL(localVarPath, DUMMY_BASE_URL);
            let baseOptions;
            if (configuration) {
                baseOptions = configuration.baseOptions;
            }

            const localVarRequestOptions = { method: 'GET', ...baseOptions, ...options};
            const localVarHeaderParameter = {} as any;
            const localVarQueryParameter = {} as any;

            // authentication basicAuth required
            // http basic authentication required
            setBasicAuthToObject(localVarRequestOptions, configuration)

            // authentication bearerAuth required
            // http bearer authentication required
            await setBearerAuthToObject(localVarHeaderParameter, configuration)


    
            setSearchParams(localVarUrlObj, localVarQueryParameter);
            let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
            localVarRequestOptions.headers = {...localVarHeaderParameter, ...headersFromBaseOptions, ...options.headers};

            return {
                url: toPathString(localVarUrlObj),
                options: localVarRequestOptions,
            };
        },
        /**
         * Get my post draft.
         * @param {string} name Post name
         * @param {boolean} [patched] Should include patched content and raw or not.
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        getMyPostDraft: async (name: string, patched?: boolean, options: RawAxiosRequestConfig = {}): Promise<RequestArgs> => {
            // verify required parameter 'name' is not null or undefined
            assertParamExists('getMyPostDraft', 'name', name)
            const localVarPath = `/apis/uc.api.content.halo.run/v1alpha1/posts/{name}/draft`
                .replace(`{${"name"}}`, encodeURIComponent(String(name)));
            // use dummy base URL string because the URL constructor only accepts absolute URLs.
            const localVarUrlObj = new URL(localVarPath, DUMMY_BASE_URL);
            let baseOptions;
            if (configuration) {
                baseOptions = configuration.baseOptions;
            }

            const localVarRequestOptions = { method: 'GET', ...baseOptions, ...options};
            const localVarHeaderParameter = {} as any;
            const localVarQueryParameter = {} as any;

            // authentication basicAuth required
            // http basic authentication required
            setBasicAuthToObject(localVarRequestOptions, configuration)

            // authentication bearerAuth required
            // http bearer authentication required
            await setBearerAuthToObject(localVarHeaderParameter, configuration)

            if (patched !== undefined) {
                localVarQueryParameter['patched'] = patched;
            }


    
            setSearchParams(localVarUrlObj, localVarQueryParameter);
            let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
            localVarRequestOptions.headers = {...localVarHeaderParameter, ...headersFromBaseOptions, ...options.headers};

            return {
                url: toPathString(localVarUrlObj),
                options: localVarRequestOptions,
            };
        },
        /**
         * List posts owned by the current user.
         * @param {number} [page] Page number. Default is 0.
         * @param {number} [size] Size number. Default is 0.
         * @param {Array<string>} [labelSelector] Label selector. e.g.: hidden!&#x3D;true
         * @param {Array<string>} [fieldSelector] Field selector. e.g.: metadata.name&#x3D;&#x3D;halo
         * @param {Array<string>} [sort] Sorting criteria in the format: property,(asc|desc). Default sort order is ascending. Multiple sort criteria are supported.
         * @param {ListMyPostsPublishPhaseEnum} [publishPhase] Posts filtered by publish phase.
         * @param {string} [keyword] Posts filtered by keyword.
         * @param {string} [categoryWithChildren] Posts filtered by category including sub-categories.
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        listMyPosts: async (page?: number, size?: number, labelSelector?: Array<string>, fieldSelector?: Array<string>, sort?: Array<string>, publishPhase?: ListMyPostsPublishPhaseEnum, keyword?: string, categoryWithChildren?: string, options: RawAxiosRequestConfig = {}): Promise<RequestArgs> => {
            const localVarPath = `/apis/uc.api.content.halo.run/v1alpha1/posts`;
            // use dummy base URL string because the URL constructor only accepts absolute URLs.
            const localVarUrlObj = new URL(localVarPath, DUMMY_BASE_URL);
            let baseOptions;
            if (configuration) {
                baseOptions = configuration.baseOptions;
            }

            const localVarRequestOptions = { method: 'GET', ...baseOptions, ...options};
            const localVarHeaderParameter = {} as any;
            const localVarQueryParameter = {} as any;

            // authentication basicAuth required
            // http basic authentication required
            setBasicAuthToObject(localVarRequestOptions, configuration)

            // authentication bearerAuth required
            // http bearer authentication required
            await setBearerAuthToObject(localVarHeaderParameter, configuration)

            if (page !== undefined) {
                localVarQueryParameter['page'] = page;
            }

            if (size !== undefined) {
                localVarQueryParameter['size'] = size;
            }

            if (labelSelector) {
                localVarQueryParameter['labelSelector'] = labelSelector;
            }

            if (fieldSelector) {
                localVarQueryParameter['fieldSelector'] = fieldSelector;
            }

            if (sort) {
                localVarQueryParameter['sort'] = sort;
            }

            if (publishPhase !== undefined) {
                localVarQueryParameter['publishPhase'] = publishPhase;
            }

            if (keyword !== undefined) {
                localVarQueryParameter['keyword'] = keyword;
            }

            if (categoryWithChildren !== undefined) {
                localVarQueryParameter['categoryWithChildren'] = categoryWithChildren;
            }


    
            setSearchParams(localVarUrlObj, localVarQueryParameter);
            let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
            localVarRequestOptions.headers = {...localVarHeaderParameter, ...headersFromBaseOptions, ...options.headers};

            return {
                url: toPathString(localVarUrlObj),
                options: localVarRequestOptions,
            };
        },
        /**
         * Publish my post.
         * @param {string} name Post name
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        publishMyPost: async (name: string, options: RawAxiosRequestConfig = {}): Promise<RequestArgs> => {
            // verify required parameter 'name' is not null or undefined
            assertParamExists('publishMyPost', 'name', name)
            const localVarPath = `/apis/uc.api.content.halo.run/v1alpha1/posts/{name}/publish`
                .replace(`{${"name"}}`, encodeURIComponent(String(name)));
            // use dummy base URL string because the URL constructor only accepts absolute URLs.
            const localVarUrlObj = new URL(localVarPath, DUMMY_BASE_URL);
            let baseOptions;
            if (configuration) {
                baseOptions = configuration.baseOptions;
            }

            const localVarRequestOptions = { method: 'PUT', ...baseOptions, ...options};
            const localVarHeaderParameter = {} as any;
            const localVarQueryParameter = {} as any;

            // authentication basicAuth required
            // http basic authentication required
            setBasicAuthToObject(localVarRequestOptions, configuration)

            // authentication bearerAuth required
            // http bearer authentication required
            await setBearerAuthToObject(localVarHeaderParameter, configuration)


    
            setSearchParams(localVarUrlObj, localVarQueryParameter);
            let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
            localVarRequestOptions.headers = {...localVarHeaderParameter, ...headersFromBaseOptions, ...options.headers};

            return {
                url: toPathString(localVarUrlObj),
                options: localVarRequestOptions,
            };
        },
        /**
         * Move my post to recycle bin.
         * @param {string} name Post name
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        recycleMyPost: async (name: string, options: RawAxiosRequestConfig = {}): Promise<RequestArgs> => {
            // verify required parameter 'name' is not null or undefined
            assertParamExists('recycleMyPost', 'name', name)
            const localVarPath = `/apis/uc.api.content.halo.run/v1alpha1/posts/{name}/recycle`
                .replace(`{${"name"}}`, encodeURIComponent(String(name)));
            // use dummy base URL string because the URL constructor only accepts absolute URLs.
            const localVarUrlObj = new URL(localVarPath, DUMMY_BASE_URL);
            let baseOptions;
            if (configuration) {
                baseOptions = configuration.baseOptions;
            }

            const localVarRequestOptions = { method: 'DELETE', ...baseOptions, ...options};
            const localVarHeaderParameter = {} as any;
            const localVarQueryParameter = {} as any;

            // authentication basicAuth required
            // http basic authentication required
            setBasicAuthToObject(localVarRequestOptions, configuration)

            // authentication bearerAuth required
            // http bearer authentication required
            await setBearerAuthToObject(localVarHeaderParameter, configuration)


    
            setSearchParams(localVarUrlObj, localVarQueryParameter);
            let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
            localVarRequestOptions.headers = {...localVarHeaderParameter, ...headersFromBaseOptions, ...options.headers};

            return {
                url: toPathString(localVarUrlObj),
                options: localVarRequestOptions,
            };
        },
        /**
         * Unpublish my post.
         * @param {string} name Post name
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        unpublishMyPost: async (name: string, options: RawAxiosRequestConfig = {}): Promise<RequestArgs> => {
            // verify required parameter 'name' is not null or undefined
            assertParamExists('unpublishMyPost', 'name', name)
            const localVarPath = `/apis/uc.api.content.halo.run/v1alpha1/posts/{name}/unpublish`
                .replace(`{${"name"}}`, encodeURIComponent(String(name)));
            // use dummy base URL string because the URL constructor only accepts absolute URLs.
            const localVarUrlObj = new URL(localVarPath, DUMMY_BASE_URL);
            let baseOptions;
            if (configuration) {
                baseOptions = configuration.baseOptions;
            }

            const localVarRequestOptions = { method: 'PUT', ...baseOptions, ...options};
            const localVarHeaderParameter = {} as any;
            const localVarQueryParameter = {} as any;

            // authentication basicAuth required
            // http basic authentication required
            setBasicAuthToObject(localVarRequestOptions, configuration)

            // authentication bearerAuth required
            // http bearer authentication required
            await setBearerAuthToObject(localVarHeaderParameter, configuration)


    
            setSearchParams(localVarUrlObj, localVarQueryParameter);
            let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
            localVarRequestOptions.headers = {...localVarHeaderParameter, ...headersFromBaseOptions, ...options.headers};

            return {
                url: toPathString(localVarUrlObj),
                options: localVarRequestOptions,
            };
        },
        /**
         * Update my post.
         * @param {string} name Post name
         * @param {Post} [post] 
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        updateMyPost: async (name: string, post?: Post, options: RawAxiosRequestConfig = {}): Promise<RequestArgs> => {
            // verify required parameter 'name' is not null or undefined
            assertParamExists('updateMyPost', 'name', name)
            const localVarPath = `/apis/uc.api.content.halo.run/v1alpha1/posts/{name}`
                .replace(`{${"name"}}`, encodeURIComponent(String(name)));
            // use dummy base URL string because the URL constructor only accepts absolute URLs.
            const localVarUrlObj = new URL(localVarPath, DUMMY_BASE_URL);
            let baseOptions;
            if (configuration) {
                baseOptions = configuration.baseOptions;
            }

            const localVarRequestOptions = { method: 'PUT', ...baseOptions, ...options};
            const localVarHeaderParameter = {} as any;
            const localVarQueryParameter = {} as any;

            // authentication basicAuth required
            // http basic authentication required
            setBasicAuthToObject(localVarRequestOptions, configuration)

            // authentication bearerAuth required
            // http bearer authentication required
            await setBearerAuthToObject(localVarHeaderParameter, configuration)


    
            localVarHeaderParameter['Content-Type'] = 'application/json';

            setSearchParams(localVarUrlObj, localVarQueryParameter);
            let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
            localVarRequestOptions.headers = {...localVarHeaderParameter, ...headersFromBaseOptions, ...options.headers};
            localVarRequestOptions.data = serializeDataIfNeeded(post, localVarRequestOptions, configuration)

            return {
                url: toPathString(localVarUrlObj),
                options: localVarRequestOptions,
            };
        },
        /**
         * Update draft of my post. Please make sure set annotation: \"content.halo.run/content-json\" into annotations and refer to Content for corresponding data type. 
         * @param {string} name Post name
         * @param {Snapshot} [snapshot] 
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        updateMyPostDraft: async (name: string, snapshot?: Snapshot, options: RawAxiosRequestConfig = {}): Promise<RequestArgs> => {
            // verify required parameter 'name' is not null or undefined
            assertParamExists('updateMyPostDraft', 'name', name)
            const localVarPath = `/apis/uc.api.content.halo.run/v1alpha1/posts/{name}/draft`
                .replace(`{${"name"}}`, encodeURIComponent(String(name)));
            // use dummy base URL string because the URL constructor only accepts absolute URLs.
            const localVarUrlObj = new URL(localVarPath, DUMMY_BASE_URL);
            let baseOptions;
            if (configuration) {
                baseOptions = configuration.baseOptions;
            }

            const localVarRequestOptions = { method: 'PUT', ...baseOptions, ...options};
            const localVarHeaderParameter = {} as any;
            const localVarQueryParameter = {} as any;

            // authentication basicAuth required
            // http basic authentication required
            setBasicAuthToObject(localVarRequestOptions, configuration)

            // authentication bearerAuth required
            // http bearer authentication required
            await setBearerAuthToObject(localVarHeaderParameter, configuration)


    
            localVarHeaderParameter['Content-Type'] = 'application/json';

            setSearchParams(localVarUrlObj, localVarQueryParameter);
            let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
            localVarRequestOptions.headers = {...localVarHeaderParameter, ...headersFromBaseOptions, ...options.headers};
            localVarRequestOptions.data = serializeDataIfNeeded(snapshot, localVarRequestOptions, configuration)

            return {
                url: toPathString(localVarUrlObj),
                options: localVarRequestOptions,
            };
        },
    }
};

/**
 * PostV1alpha1UcApi - functional programming interface
 * @export
 */
export const PostV1alpha1UcApiFp = function(configuration?: Configuration) {
    const localVarAxiosParamCreator = PostV1alpha1UcApiAxiosParamCreator(configuration)
    return {
        /**
         * Create my post. If you want to create a post with content, please set  annotation: \"content.halo.run/content-json\" into annotations and refer  to Content for corresponding data type. 
         * @param {Post} [post] 
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        async createMyPost(post?: Post, options?: RawAxiosRequestConfig): Promise<(axios?: AxiosInstance, basePath?: string) => AxiosPromise<Post>> {
            const localVarAxiosArgs = await localVarAxiosParamCreator.createMyPost(post, options);
            const localVarOperationServerIndex = configuration?.serverIndex ?? 0;
            const localVarOperationServerBasePath = operationServerMap['PostV1alpha1UcApi.createMyPost']?.[localVarOperationServerIndex]?.url;
            return (axios, basePath) => createRequestFunction(localVarAxiosArgs, globalAxios, BASE_PATH, configuration)(axios, localVarOperationServerBasePath || basePath);
        },
        /**
         * Get post that belongs to the current user.
         * @param {string} name Post name
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        async getMyPost(name: string, options?: RawAxiosRequestConfig): Promise<(axios?: AxiosInstance, basePath?: string) => AxiosPromise<Post>> {
            const localVarAxiosArgs = await localVarAxiosParamCreator.getMyPost(name, options);
            const localVarOperationServerIndex = configuration?.serverIndex ?? 0;
            const localVarOperationServerBasePath = operationServerMap['PostV1alpha1UcApi.getMyPost']?.[localVarOperationServerIndex]?.url;
            return (axios, basePath) => createRequestFunction(localVarAxiosArgs, globalAxios, BASE_PATH, configuration)(axios, localVarOperationServerBasePath || basePath);
        },
        /**
         * Get my post draft.
         * @param {string} name Post name
         * @param {boolean} [patched] Should include patched content and raw or not.
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        async getMyPostDraft(name: string, patched?: boolean, options?: RawAxiosRequestConfig): Promise<(axios?: AxiosInstance, basePath?: string) => AxiosPromise<Snapshot>> {
            const localVarAxiosArgs = await localVarAxiosParamCreator.getMyPostDraft(name, patched, options);
            const localVarOperationServerIndex = configuration?.serverIndex ?? 0;
            const localVarOperationServerBasePath = operationServerMap['PostV1alpha1UcApi.getMyPostDraft']?.[localVarOperationServerIndex]?.url;
            return (axios, basePath) => createRequestFunction(localVarAxiosArgs, globalAxios, BASE_PATH, configuration)(axios, localVarOperationServerBasePath || basePath);
        },
        /**
         * List posts owned by the current user.
         * @param {number} [page] Page number. Default is 0.
         * @param {number} [size] Size number. Default is 0.
         * @param {Array<string>} [labelSelector] Label selector. e.g.: hidden!&#x3D;true
         * @param {Array<string>} [fieldSelector] Field selector. e.g.: metadata.name&#x3D;&#x3D;halo
         * @param {Array<string>} [sort] Sorting criteria in the format: property,(asc|desc). Default sort order is ascending. Multiple sort criteria are supported.
         * @param {ListMyPostsPublishPhaseEnum} [publishPhase] Posts filtered by publish phase.
         * @param {string} [keyword] Posts filtered by keyword.
         * @param {string} [categoryWithChildren] Posts filtered by category including sub-categories.
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        async listMyPosts(page?: number, size?: number, labelSelector?: Array<string>, fieldSelector?: Array<string>, sort?: Array<string>, publishPhase?: ListMyPostsPublishPhaseEnum, keyword?: string, categoryWithChildren?: string, options?: RawAxiosRequestConfig): Promise<(axios?: AxiosInstance, basePath?: string) => AxiosPromise<ListedPostList>> {
            const localVarAxiosArgs = await localVarAxiosParamCreator.listMyPosts(page, size, labelSelector, fieldSelector, sort, publishPhase, keyword, categoryWithChildren, options);
            const localVarOperationServerIndex = configuration?.serverIndex ?? 0;
            const localVarOperationServerBasePath = operationServerMap['PostV1alpha1UcApi.listMyPosts']?.[localVarOperationServerIndex]?.url;
            return (axios, basePath) => createRequestFunction(localVarAxiosArgs, globalAxios, BASE_PATH, configuration)(axios, localVarOperationServerBasePath || basePath);
        },
        /**
         * Publish my post.
         * @param {string} name Post name
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        async publishMyPost(name: string, options?: RawAxiosRequestConfig): Promise<(axios?: AxiosInstance, basePath?: string) => AxiosPromise<Post>> {
            const localVarAxiosArgs = await localVarAxiosParamCreator.publishMyPost(name, options);
            const localVarOperationServerIndex = configuration?.serverIndex ?? 0;
            const localVarOperationServerBasePath = operationServerMap['PostV1alpha1UcApi.publishMyPost']?.[localVarOperationServerIndex]?.url;
            return (axios, basePath) => createRequestFunction(localVarAxiosArgs, globalAxios, BASE_PATH, configuration)(axios, localVarOperationServerBasePath || basePath);
        },
        /**
         * Move my post to recycle bin.
         * @param {string} name Post name
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        async recycleMyPost(name: string, options?: RawAxiosRequestConfig): Promise<(axios?: AxiosInstance, basePath?: string) => AxiosPromise<Post>> {
            const localVarAxiosArgs = await localVarAxiosParamCreator.recycleMyPost(name, options);
            const localVarOperationServerIndex = configuration?.serverIndex ?? 0;
            const localVarOperationServerBasePath = operationServerMap['PostV1alpha1UcApi.recycleMyPost']?.[localVarOperationServerIndex]?.url;
            return (axios, basePath) => createRequestFunction(localVarAxiosArgs, globalAxios, BASE_PATH, configuration)(axios, localVarOperationServerBasePath || basePath);
        },
        /**
         * Unpublish my post.
         * @param {string} name Post name
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        async unpublishMyPost(name: string, options?: RawAxiosRequestConfig): Promise<(axios?: AxiosInstance, basePath?: string) => AxiosPromise<Post>> {
            const localVarAxiosArgs = await localVarAxiosParamCreator.unpublishMyPost(name, options);
            const localVarOperationServerIndex = configuration?.serverIndex ?? 0;
            const localVarOperationServerBasePath = operationServerMap['PostV1alpha1UcApi.unpublishMyPost']?.[localVarOperationServerIndex]?.url;
            return (axios, basePath) => createRequestFunction(localVarAxiosArgs, globalAxios, BASE_PATH, configuration)(axios, localVarOperationServerBasePath || basePath);
        },
        /**
         * Update my post.
         * @param {string} name Post name
         * @param {Post} [post] 
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        async updateMyPost(name: string, post?: Post, options?: RawAxiosRequestConfig): Promise<(axios?: AxiosInstance, basePath?: string) => AxiosPromise<Post>> {
            const localVarAxiosArgs = await localVarAxiosParamCreator.updateMyPost(name, post, options);
            const localVarOperationServerIndex = configuration?.serverIndex ?? 0;
            const localVarOperationServerBasePath = operationServerMap['PostV1alpha1UcApi.updateMyPost']?.[localVarOperationServerIndex]?.url;
            return (axios, basePath) => createRequestFunction(localVarAxiosArgs, globalAxios, BASE_PATH, configuration)(axios, localVarOperationServerBasePath || basePath);
        },
        /**
         * Update draft of my post. Please make sure set annotation: \"content.halo.run/content-json\" into annotations and refer to Content for corresponding data type. 
         * @param {string} name Post name
         * @param {Snapshot} [snapshot] 
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        async updateMyPostDraft(name: string, snapshot?: Snapshot, options?: RawAxiosRequestConfig): Promise<(axios?: AxiosInstance, basePath?: string) => AxiosPromise<Snapshot>> {
            const localVarAxiosArgs = await localVarAxiosParamCreator.updateMyPostDraft(name, snapshot, options);
            const localVarOperationServerIndex = configuration?.serverIndex ?? 0;
            const localVarOperationServerBasePath = operationServerMap['PostV1alpha1UcApi.updateMyPostDraft']?.[localVarOperationServerIndex]?.url;
            return (axios, basePath) => createRequestFunction(localVarAxiosArgs, globalAxios, BASE_PATH, configuration)(axios, localVarOperationServerBasePath || basePath);
        },
    }
};

/**
 * PostV1alpha1UcApi - factory interface
 * @export
 */
export const PostV1alpha1UcApiFactory = function (configuration?: Configuration, basePath?: string, axios?: AxiosInstance) {
    const localVarFp = PostV1alpha1UcApiFp(configuration)
    return {
        /**
         * Create my post. If you want to create a post with content, please set  annotation: \"content.halo.run/content-json\" into annotations and refer  to Content for corresponding data type. 
         * @param {PostV1alpha1UcApiCreateMyPostRequest} requestParameters Request parameters.
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        createMyPost(requestParameters: PostV1alpha1UcApiCreateMyPostRequest = {}, options?: RawAxiosRequestConfig): AxiosPromise<Post> {
            return localVarFp.createMyPost(requestParameters.post, options).then((request) => request(axios, basePath));
        },
        /**
         * Get post that belongs to the current user.
         * @param {PostV1alpha1UcApiGetMyPostRequest} requestParameters Request parameters.
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        getMyPost(requestParameters: PostV1alpha1UcApiGetMyPostRequest, options?: RawAxiosRequestConfig): AxiosPromise<Post> {
            return localVarFp.getMyPost(requestParameters.name, options).then((request) => request(axios, basePath));
        },
        /**
         * Get my post draft.
         * @param {PostV1alpha1UcApiGetMyPostDraftRequest} requestParameters Request parameters.
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        getMyPostDraft(requestParameters: PostV1alpha1UcApiGetMyPostDraftRequest, options?: RawAxiosRequestConfig): AxiosPromise<Snapshot> {
            return localVarFp.getMyPostDraft(requestParameters.name, requestParameters.patched, options).then((request) => request(axios, basePath));
        },
        /**
         * List posts owned by the current user.
         * @param {PostV1alpha1UcApiListMyPostsRequest} requestParameters Request parameters.
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        listMyPosts(requestParameters: PostV1alpha1UcApiListMyPostsRequest = {}, options?: RawAxiosRequestConfig): AxiosPromise<ListedPostList> {
            return localVarFp.listMyPosts(requestParameters.page, requestParameters.size, requestParameters.labelSelector, requestParameters.fieldSelector, requestParameters.sort, requestParameters.publishPhase, requestParameters.keyword, requestParameters.categoryWithChildren, options).then((request) => request(axios, basePath));
        },
        /**
         * Publish my post.
         * @param {PostV1alpha1UcApiPublishMyPostRequest} requestParameters Request parameters.
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        publishMyPost(requestParameters: PostV1alpha1UcApiPublishMyPostRequest, options?: RawAxiosRequestConfig): AxiosPromise<Post> {
            return localVarFp.publishMyPost(requestParameters.name, options).then((request) => request(axios, basePath));
        },
        /**
         * Move my post to recycle bin.
         * @param {PostV1alpha1UcApiRecycleMyPostRequest} requestParameters Request parameters.
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        recycleMyPost(requestParameters: PostV1alpha1UcApiRecycleMyPostRequest, options?: RawAxiosRequestConfig): AxiosPromise<Post> {
            return localVarFp.recycleMyPost(requestParameters.name, options).then((request) => request(axios, basePath));
        },
        /**
         * Unpublish my post.
         * @param {PostV1alpha1UcApiUnpublishMyPostRequest} requestParameters Request parameters.
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        unpublishMyPost(requestParameters: PostV1alpha1UcApiUnpublishMyPostRequest, options?: RawAxiosRequestConfig): AxiosPromise<Post> {
            return localVarFp.unpublishMyPost(requestParameters.name, options).then((request) => request(axios, basePath));
        },
        /**
         * Update my post.
         * @param {PostV1alpha1UcApiUpdateMyPostRequest} requestParameters Request parameters.
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        updateMyPost(requestParameters: PostV1alpha1UcApiUpdateMyPostRequest, options?: RawAxiosRequestConfig): AxiosPromise<Post> {
            return localVarFp.updateMyPost(requestParameters.name, requestParameters.post, options).then((request) => request(axios, basePath));
        },
        /**
         * Update draft of my post. Please make sure set annotation: \"content.halo.run/content-json\" into annotations and refer to Content for corresponding data type. 
         * @param {PostV1alpha1UcApiUpdateMyPostDraftRequest} requestParameters Request parameters.
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        updateMyPostDraft(requestParameters: PostV1alpha1UcApiUpdateMyPostDraftRequest, options?: RawAxiosRequestConfig): AxiosPromise<Snapshot> {
            return localVarFp.updateMyPostDraft(requestParameters.name, requestParameters.snapshot, options).then((request) => request(axios, basePath));
        },
    };
};

/**
 * Request parameters for createMyPost operation in PostV1alpha1UcApi.
 * @export
 * @interface PostV1alpha1UcApiCreateMyPostRequest
 */
export interface PostV1alpha1UcApiCreateMyPostRequest {
    /**
     * 
     * @type {Post}
     * @memberof PostV1alpha1UcApiCreateMyPost
     */
    readonly post?: Post
}

/**
 * Request parameters for getMyPost operation in PostV1alpha1UcApi.
 * @export
 * @interface PostV1alpha1UcApiGetMyPostRequest
 */
export interface PostV1alpha1UcApiGetMyPostRequest {
    /**
     * Post name
     * @type {string}
     * @memberof PostV1alpha1UcApiGetMyPost
     */
    readonly name: string
}

/**
 * Request parameters for getMyPostDraft operation in PostV1alpha1UcApi.
 * @export
 * @interface PostV1alpha1UcApiGetMyPostDraftRequest
 */
export interface PostV1alpha1UcApiGetMyPostDraftRequest {
    /**
     * Post name
     * @type {string}
     * @memberof PostV1alpha1UcApiGetMyPostDraft
     */
    readonly name: string

    /**
     * Should include patched content and raw or not.
     * @type {boolean}
     * @memberof PostV1alpha1UcApiGetMyPostDraft
     */
    readonly patched?: boolean
}

/**
 * Request parameters for listMyPosts operation in PostV1alpha1UcApi.
 * @export
 * @interface PostV1alpha1UcApiListMyPostsRequest
 */
export interface PostV1alpha1UcApiListMyPostsRequest {
    /**
     * Page number. Default is 0.
     * @type {number}
     * @memberof PostV1alpha1UcApiListMyPosts
     */
    readonly page?: number

    /**
     * Size number. Default is 0.
     * @type {number}
     * @memberof PostV1alpha1UcApiListMyPosts
     */
    readonly size?: number

    /**
     * Label selector. e.g.: hidden!&#x3D;true
     * @type {Array<string>}
     * @memberof PostV1alpha1UcApiListMyPosts
     */
    readonly labelSelector?: Array<string>

    /**
     * Field selector. e.g.: metadata.name&#x3D;&#x3D;halo
     * @type {Array<string>}
     * @memberof PostV1alpha1UcApiListMyPosts
     */
    readonly fieldSelector?: Array<string>

    /**
     * Sorting criteria in the format: property,(asc|desc). Default sort order is ascending. Multiple sort criteria are supported.
     * @type {Array<string>}
     * @memberof PostV1alpha1UcApiListMyPosts
     */
    readonly sort?: Array<string>

    /**
     * Posts filtered by publish phase.
     * @type {'DRAFT' | 'PENDING_APPROVAL' | 'PUBLISHED' | 'FAILED'}
     * @memberof PostV1alpha1UcApiListMyPosts
     */
    readonly publishPhase?: ListMyPostsPublishPhaseEnum

    /**
     * Posts filtered by keyword.
     * @type {string}
     * @memberof PostV1alpha1UcApiListMyPosts
     */
    readonly keyword?: string

    /**
     * Posts filtered by category including sub-categories.
     * @type {string}
     * @memberof PostV1alpha1UcApiListMyPosts
     */
    readonly categoryWithChildren?: string
}

/**
 * Request parameters for publishMyPost operation in PostV1alpha1UcApi.
 * @export
 * @interface PostV1alpha1UcApiPublishMyPostRequest
 */
export interface PostV1alpha1UcApiPublishMyPostRequest {
    /**
     * Post name
     * @type {string}
     * @memberof PostV1alpha1UcApiPublishMyPost
     */
    readonly name: string
}

/**
 * Request parameters for recycleMyPost operation in PostV1alpha1UcApi.
 * @export
 * @interface PostV1alpha1UcApiRecycleMyPostRequest
 */
export interface PostV1alpha1UcApiRecycleMyPostRequest {
    /**
     * Post name
     * @type {string}
     * @memberof PostV1alpha1UcApiRecycleMyPost
     */
    readonly name: string
}

/**
 * Request parameters for unpublishMyPost operation in PostV1alpha1UcApi.
 * @export
 * @interface PostV1alpha1UcApiUnpublishMyPostRequest
 */
export interface PostV1alpha1UcApiUnpublishMyPostRequest {
    /**
     * Post name
     * @type {string}
     * @memberof PostV1alpha1UcApiUnpublishMyPost
     */
    readonly name: string
}

/**
 * Request parameters for updateMyPost operation in PostV1alpha1UcApi.
 * @export
 * @interface PostV1alpha1UcApiUpdateMyPostRequest
 */
export interface PostV1alpha1UcApiUpdateMyPostRequest {
    /**
     * Post name
     * @type {string}
     * @memberof PostV1alpha1UcApiUpdateMyPost
     */
    readonly name: string

    /**
     * 
     * @type {Post}
     * @memberof PostV1alpha1UcApiUpdateMyPost
     */
    readonly post?: Post
}

/**
 * Request parameters for updateMyPostDraft operation in PostV1alpha1UcApi.
 * @export
 * @interface PostV1alpha1UcApiUpdateMyPostDraftRequest
 */
export interface PostV1alpha1UcApiUpdateMyPostDraftRequest {
    /**
     * Post name
     * @type {string}
     * @memberof PostV1alpha1UcApiUpdateMyPostDraft
     */
    readonly name: string

    /**
     * 
     * @type {Snapshot}
     * @memberof PostV1alpha1UcApiUpdateMyPostDraft
     */
    readonly snapshot?: Snapshot
}

/**
 * PostV1alpha1UcApi - object-oriented interface
 * @export
 * @class PostV1alpha1UcApi
 * @extends {BaseAPI}
 */
export class PostV1alpha1UcApi extends BaseAPI {
    /**
     * Create my post. If you want to create a post with content, please set  annotation: \"content.halo.run/content-json\" into annotations and refer  to Content for corresponding data type. 
     * @param {PostV1alpha1UcApiCreateMyPostRequest} requestParameters Request parameters.
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof PostV1alpha1UcApi
     */
    public createMyPost(requestParameters: PostV1alpha1UcApiCreateMyPostRequest = {}, options?: RawAxiosRequestConfig) {
        return PostV1alpha1UcApiFp(this.configuration).createMyPost(requestParameters.post, options).then((request) => request(this.axios, this.basePath));
    }

    /**
     * Get post that belongs to the current user.
     * @param {PostV1alpha1UcApiGetMyPostRequest} requestParameters Request parameters.
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof PostV1alpha1UcApi
     */
    public getMyPost(requestParameters: PostV1alpha1UcApiGetMyPostRequest, options?: RawAxiosRequestConfig) {
        return PostV1alpha1UcApiFp(this.configuration).getMyPost(requestParameters.name, options).then((request) => request(this.axios, this.basePath));
    }

    /**
     * Get my post draft.
     * @param {PostV1alpha1UcApiGetMyPostDraftRequest} requestParameters Request parameters.
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof PostV1alpha1UcApi
     */
    public getMyPostDraft(requestParameters: PostV1alpha1UcApiGetMyPostDraftRequest, options?: RawAxiosRequestConfig) {
        return PostV1alpha1UcApiFp(this.configuration).getMyPostDraft(requestParameters.name, requestParameters.patched, options).then((request) => request(this.axios, this.basePath));
    }

    /**
     * List posts owned by the current user.
     * @param {PostV1alpha1UcApiListMyPostsRequest} requestParameters Request parameters.
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof PostV1alpha1UcApi
     */
    public listMyPosts(requestParameters: PostV1alpha1UcApiListMyPostsRequest = {}, options?: RawAxiosRequestConfig) {
        return PostV1alpha1UcApiFp(this.configuration).listMyPosts(requestParameters.page, requestParameters.size, requestParameters.labelSelector, requestParameters.fieldSelector, requestParameters.sort, requestParameters.publishPhase, requestParameters.keyword, requestParameters.categoryWithChildren, options).then((request) => request(this.axios, this.basePath));
    }

    /**
     * Publish my post.
     * @param {PostV1alpha1UcApiPublishMyPostRequest} requestParameters Request parameters.
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof PostV1alpha1UcApi
     */
    public publishMyPost(requestParameters: PostV1alpha1UcApiPublishMyPostRequest, options?: RawAxiosRequestConfig) {
        return PostV1alpha1UcApiFp(this.configuration).publishMyPost(requestParameters.name, options).then((request) => request(this.axios, this.basePath));
    }

    /**
     * Move my post to recycle bin.
     * @param {PostV1alpha1UcApiRecycleMyPostRequest} requestParameters Request parameters.
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof PostV1alpha1UcApi
     */
    public recycleMyPost(requestParameters: PostV1alpha1UcApiRecycleMyPostRequest, options?: RawAxiosRequestConfig) {
        return PostV1alpha1UcApiFp(this.configuration).recycleMyPost(requestParameters.name, options).then((request) => request(this.axios, this.basePath));
    }

    /**
     * Unpublish my post.
     * @param {PostV1alpha1UcApiUnpublishMyPostRequest} requestParameters Request parameters.
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof PostV1alpha1UcApi
     */
    public unpublishMyPost(requestParameters: PostV1alpha1UcApiUnpublishMyPostRequest, options?: RawAxiosRequestConfig) {
        return PostV1alpha1UcApiFp(this.configuration).unpublishMyPost(requestParameters.name, options).then((request) => request(this.axios, this.basePath));
    }

    /**
     * Update my post.
     * @param {PostV1alpha1UcApiUpdateMyPostRequest} requestParameters Request parameters.
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof PostV1alpha1UcApi
     */
    public updateMyPost(requestParameters: PostV1alpha1UcApiUpdateMyPostRequest, options?: RawAxiosRequestConfig) {
        return PostV1alpha1UcApiFp(this.configuration).updateMyPost(requestParameters.name, requestParameters.post, options).then((request) => request(this.axios, this.basePath));
    }

    /**
     * Update draft of my post. Please make sure set annotation: \"content.halo.run/content-json\" into annotations and refer to Content for corresponding data type. 
     * @param {PostV1alpha1UcApiUpdateMyPostDraftRequest} requestParameters Request parameters.
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof PostV1alpha1UcApi
     */
    public updateMyPostDraft(requestParameters: PostV1alpha1UcApiUpdateMyPostDraftRequest, options?: RawAxiosRequestConfig) {
        return PostV1alpha1UcApiFp(this.configuration).updateMyPostDraft(requestParameters.name, requestParameters.snapshot, options).then((request) => request(this.axios, this.basePath));
    }
}

/**
 * @export
 */
export const ListMyPostsPublishPhaseEnum = {
    Draft: 'DRAFT',
    PendingApproval: 'PENDING_APPROVAL',
    Published: 'PUBLISHED',
    Failed: 'FAILED'
} as const;
export type ListMyPostsPublishPhaseEnum = typeof ListMyPostsPublishPhaseEnum[keyof typeof ListMyPostsPublishPhaseEnum];
