/* tslint:disable */
/* eslint-disable */
/**
 * Halo
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: 2.20.10-SNAPSHOT
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


import type { Configuration } from '../configuration';
import type { AxiosPromise, AxiosInstance, RawAxiosRequestConfig } from 'axios';
import globalAxios from 'axios';
// Some imports not used depending on template conditions
// @ts-ignore
import { DUMMY_BASE_URL, assertParamExists, setApiKeyToObject, setBasicAuthToObject, setBearerAuthToObject, setOAuthToObject, setSearchParams, serializeDataIfNeeded, toPathString, createRequestFunction } from '../common';
// @ts-ignore
import { BASE_PATH, COLLECTION_FORMATS, RequestArgs, BaseAPI, RequiredError, operationServerMap } from '../base';
// @ts-ignore
import { JsonPatchInner } from '../models';
// @ts-ignore
import { Reason } from '../models';
// @ts-ignore
import { ReasonList } from '../models';
/**
 * ReasonV1alpha1Api - axios parameter creator
 * @export
 */
export const ReasonV1alpha1ApiAxiosParamCreator = function (configuration?: Configuration) {
    return {
        /**
         * Create Reason
         * @param {Reason} [reason] Fresh reason
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        createReason: async (reason?: Reason, options: RawAxiosRequestConfig = {}): Promise<RequestArgs> => {
            const localVarPath = `/apis/notification.halo.run/v1alpha1/reasons`;
            // use dummy base URL string because the URL constructor only accepts absolute URLs.
            const localVarUrlObj = new URL(localVarPath, DUMMY_BASE_URL);
            let baseOptions;
            if (configuration) {
                baseOptions = configuration.baseOptions;
            }

            const localVarRequestOptions = { method: 'POST', ...baseOptions, ...options};
            const localVarHeaderParameter = {} as any;
            const localVarQueryParameter = {} as any;

            // authentication basicAuth required
            // http basic authentication required
            setBasicAuthToObject(localVarRequestOptions, configuration)

            // authentication bearerAuth required
            // http bearer authentication required
            await setBearerAuthToObject(localVarHeaderParameter, configuration)


    
            localVarHeaderParameter['Content-Type'] = 'application/json';

            setSearchParams(localVarUrlObj, localVarQueryParameter);
            let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
            localVarRequestOptions.headers = {...localVarHeaderParameter, ...headersFromBaseOptions, ...options.headers};
            localVarRequestOptions.data = serializeDataIfNeeded(reason, localVarRequestOptions, configuration)

            return {
                url: toPathString(localVarUrlObj),
                options: localVarRequestOptions,
            };
        },
        /**
         * Delete Reason
         * @param {string} name Name of reason
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        deleteReason: async (name: string, options: RawAxiosRequestConfig = {}): Promise<RequestArgs> => {
            // verify required parameter 'name' is not null or undefined
            assertParamExists('deleteReason', 'name', name)
            const localVarPath = `/apis/notification.halo.run/v1alpha1/reasons/{name}`
                .replace(`{${"name"}}`, encodeURIComponent(String(name)));
            // use dummy base URL string because the URL constructor only accepts absolute URLs.
            const localVarUrlObj = new URL(localVarPath, DUMMY_BASE_URL);
            let baseOptions;
            if (configuration) {
                baseOptions = configuration.baseOptions;
            }

            const localVarRequestOptions = { method: 'DELETE', ...baseOptions, ...options};
            const localVarHeaderParameter = {} as any;
            const localVarQueryParameter = {} as any;

            // authentication basicAuth required
            // http basic authentication required
            setBasicAuthToObject(localVarRequestOptions, configuration)

            // authentication bearerAuth required
            // http bearer authentication required
            await setBearerAuthToObject(localVarHeaderParameter, configuration)


    
            setSearchParams(localVarUrlObj, localVarQueryParameter);
            let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
            localVarRequestOptions.headers = {...localVarHeaderParameter, ...headersFromBaseOptions, ...options.headers};

            return {
                url: toPathString(localVarUrlObj),
                options: localVarRequestOptions,
            };
        },
        /**
         * Get Reason
         * @param {string} name Name of reason
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        getReason: async (name: string, options: RawAxiosRequestConfig = {}): Promise<RequestArgs> => {
            // verify required parameter 'name' is not null or undefined
            assertParamExists('getReason', 'name', name)
            const localVarPath = `/apis/notification.halo.run/v1alpha1/reasons/{name}`
                .replace(`{${"name"}}`, encodeURIComponent(String(name)));
            // use dummy base URL string because the URL constructor only accepts absolute URLs.
            const localVarUrlObj = new URL(localVarPath, DUMMY_BASE_URL);
            let baseOptions;
            if (configuration) {
                baseOptions = configuration.baseOptions;
            }

            const localVarRequestOptions = { method: 'GET', ...baseOptions, ...options};
            const localVarHeaderParameter = {} as any;
            const localVarQueryParameter = {} as any;

            // authentication basicAuth required
            // http basic authentication required
            setBasicAuthToObject(localVarRequestOptions, configuration)

            // authentication bearerAuth required
            // http bearer authentication required
            await setBearerAuthToObject(localVarHeaderParameter, configuration)


    
            setSearchParams(localVarUrlObj, localVarQueryParameter);
            let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
            localVarRequestOptions.headers = {...localVarHeaderParameter, ...headersFromBaseOptions, ...options.headers};

            return {
                url: toPathString(localVarUrlObj),
                options: localVarRequestOptions,
            };
        },
        /**
         * List Reason
         * @param {number} [page] Page number. Default is 0.
         * @param {number} [size] Size number. Default is 0.
         * @param {Array<string>} [labelSelector] Label selector. e.g.: hidden!&#x3D;true
         * @param {Array<string>} [fieldSelector] Field selector. e.g.: metadata.name&#x3D;&#x3D;halo
         * @param {Array<string>} [sort] Sorting criteria in the format: property,(asc|desc). Default sort order is ascending. Multiple sort criteria are supported.
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        listReason: async (page?: number, size?: number, labelSelector?: Array<string>, fieldSelector?: Array<string>, sort?: Array<string>, options: RawAxiosRequestConfig = {}): Promise<RequestArgs> => {
            const localVarPath = `/apis/notification.halo.run/v1alpha1/reasons`;
            // use dummy base URL string because the URL constructor only accepts absolute URLs.
            const localVarUrlObj = new URL(localVarPath, DUMMY_BASE_URL);
            let baseOptions;
            if (configuration) {
                baseOptions = configuration.baseOptions;
            }

            const localVarRequestOptions = { method: 'GET', ...baseOptions, ...options};
            const localVarHeaderParameter = {} as any;
            const localVarQueryParameter = {} as any;

            // authentication basicAuth required
            // http basic authentication required
            setBasicAuthToObject(localVarRequestOptions, configuration)

            // authentication bearerAuth required
            // http bearer authentication required
            await setBearerAuthToObject(localVarHeaderParameter, configuration)

            if (page !== undefined) {
                localVarQueryParameter['page'] = page;
            }

            if (size !== undefined) {
                localVarQueryParameter['size'] = size;
            }

            if (labelSelector) {
                localVarQueryParameter['labelSelector'] = labelSelector;
            }

            if (fieldSelector) {
                localVarQueryParameter['fieldSelector'] = fieldSelector;
            }

            if (sort) {
                localVarQueryParameter['sort'] = sort;
            }


    
            setSearchParams(localVarUrlObj, localVarQueryParameter);
            let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
            localVarRequestOptions.headers = {...localVarHeaderParameter, ...headersFromBaseOptions, ...options.headers};

            return {
                url: toPathString(localVarUrlObj),
                options: localVarRequestOptions,
            };
        },
        /**
         * Patch Reason
         * @param {string} name Name of reason
         * @param {Array<JsonPatchInner>} [jsonPatchInner] 
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        patchReason: async (name: string, jsonPatchInner?: Array<JsonPatchInner>, options: RawAxiosRequestConfig = {}): Promise<RequestArgs> => {
            // verify required parameter 'name' is not null or undefined
            assertParamExists('patchReason', 'name', name)
            const localVarPath = `/apis/notification.halo.run/v1alpha1/reasons/{name}`
                .replace(`{${"name"}}`, encodeURIComponent(String(name)));
            // use dummy base URL string because the URL constructor only accepts absolute URLs.
            const localVarUrlObj = new URL(localVarPath, DUMMY_BASE_URL);
            let baseOptions;
            if (configuration) {
                baseOptions = configuration.baseOptions;
            }

            const localVarRequestOptions = { method: 'PATCH', ...baseOptions, ...options};
            const localVarHeaderParameter = {} as any;
            const localVarQueryParameter = {} as any;

            // authentication basicAuth required
            // http basic authentication required
            setBasicAuthToObject(localVarRequestOptions, configuration)

            // authentication bearerAuth required
            // http bearer authentication required
            await setBearerAuthToObject(localVarHeaderParameter, configuration)


    
            localVarHeaderParameter['Content-Type'] = 'application/json-patch+json';

            setSearchParams(localVarUrlObj, localVarQueryParameter);
            let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
            localVarRequestOptions.headers = {...localVarHeaderParameter, ...headersFromBaseOptions, ...options.headers};
            localVarRequestOptions.data = serializeDataIfNeeded(jsonPatchInner, localVarRequestOptions, configuration)

            return {
                url: toPathString(localVarUrlObj),
                options: localVarRequestOptions,
            };
        },
        /**
         * Update Reason
         * @param {string} name Name of reason
         * @param {Reason} [reason] Updated reason
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        updateReason: async (name: string, reason?: Reason, options: RawAxiosRequestConfig = {}): Promise<RequestArgs> => {
            // verify required parameter 'name' is not null or undefined
            assertParamExists('updateReason', 'name', name)
            const localVarPath = `/apis/notification.halo.run/v1alpha1/reasons/{name}`
                .replace(`{${"name"}}`, encodeURIComponent(String(name)));
            // use dummy base URL string because the URL constructor only accepts absolute URLs.
            const localVarUrlObj = new URL(localVarPath, DUMMY_BASE_URL);
            let baseOptions;
            if (configuration) {
                baseOptions = configuration.baseOptions;
            }

            const localVarRequestOptions = { method: 'PUT', ...baseOptions, ...options};
            const localVarHeaderParameter = {} as any;
            const localVarQueryParameter = {} as any;

            // authentication basicAuth required
            // http basic authentication required
            setBasicAuthToObject(localVarRequestOptions, configuration)

            // authentication bearerAuth required
            // http bearer authentication required
            await setBearerAuthToObject(localVarHeaderParameter, configuration)


    
            localVarHeaderParameter['Content-Type'] = 'application/json';

            setSearchParams(localVarUrlObj, localVarQueryParameter);
            let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
            localVarRequestOptions.headers = {...localVarHeaderParameter, ...headersFromBaseOptions, ...options.headers};
            localVarRequestOptions.data = serializeDataIfNeeded(reason, localVarRequestOptions, configuration)

            return {
                url: toPathString(localVarUrlObj),
                options: localVarRequestOptions,
            };
        },
    }
};

/**
 * ReasonV1alpha1Api - functional programming interface
 * @export
 */
export const ReasonV1alpha1ApiFp = function(configuration?: Configuration) {
    const localVarAxiosParamCreator = ReasonV1alpha1ApiAxiosParamCreator(configuration)
    return {
        /**
         * Create Reason
         * @param {Reason} [reason] Fresh reason
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        async createReason(reason?: Reason, options?: RawAxiosRequestConfig): Promise<(axios?: AxiosInstance, basePath?: string) => AxiosPromise<Reason>> {
            const localVarAxiosArgs = await localVarAxiosParamCreator.createReason(reason, options);
            const localVarOperationServerIndex = configuration?.serverIndex ?? 0;
            const localVarOperationServerBasePath = operationServerMap['ReasonV1alpha1Api.createReason']?.[localVarOperationServerIndex]?.url;
            return (axios, basePath) => createRequestFunction(localVarAxiosArgs, globalAxios, BASE_PATH, configuration)(axios, localVarOperationServerBasePath || basePath);
        },
        /**
         * Delete Reason
         * @param {string} name Name of reason
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        async deleteReason(name: string, options?: RawAxiosRequestConfig): Promise<(axios?: AxiosInstance, basePath?: string) => AxiosPromise<void>> {
            const localVarAxiosArgs = await localVarAxiosParamCreator.deleteReason(name, options);
            const localVarOperationServerIndex = configuration?.serverIndex ?? 0;
            const localVarOperationServerBasePath = operationServerMap['ReasonV1alpha1Api.deleteReason']?.[localVarOperationServerIndex]?.url;
            return (axios, basePath) => createRequestFunction(localVarAxiosArgs, globalAxios, BASE_PATH, configuration)(axios, localVarOperationServerBasePath || basePath);
        },
        /**
         * Get Reason
         * @param {string} name Name of reason
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        async getReason(name: string, options?: RawAxiosRequestConfig): Promise<(axios?: AxiosInstance, basePath?: string) => AxiosPromise<Reason>> {
            const localVarAxiosArgs = await localVarAxiosParamCreator.getReason(name, options);
            const localVarOperationServerIndex = configuration?.serverIndex ?? 0;
            const localVarOperationServerBasePath = operationServerMap['ReasonV1alpha1Api.getReason']?.[localVarOperationServerIndex]?.url;
            return (axios, basePath) => createRequestFunction(localVarAxiosArgs, globalAxios, BASE_PATH, configuration)(axios, localVarOperationServerBasePath || basePath);
        },
        /**
         * List Reason
         * @param {number} [page] Page number. Default is 0.
         * @param {number} [size] Size number. Default is 0.
         * @param {Array<string>} [labelSelector] Label selector. e.g.: hidden!&#x3D;true
         * @param {Array<string>} [fieldSelector] Field selector. e.g.: metadata.name&#x3D;&#x3D;halo
         * @param {Array<string>} [sort] Sorting criteria in the format: property,(asc|desc). Default sort order is ascending. Multiple sort criteria are supported.
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        async listReason(page?: number, size?: number, labelSelector?: Array<string>, fieldSelector?: Array<string>, sort?: Array<string>, options?: RawAxiosRequestConfig): Promise<(axios?: AxiosInstance, basePath?: string) => AxiosPromise<ReasonList>> {
            const localVarAxiosArgs = await localVarAxiosParamCreator.listReason(page, size, labelSelector, fieldSelector, sort, options);
            const localVarOperationServerIndex = configuration?.serverIndex ?? 0;
            const localVarOperationServerBasePath = operationServerMap['ReasonV1alpha1Api.listReason']?.[localVarOperationServerIndex]?.url;
            return (axios, basePath) => createRequestFunction(localVarAxiosArgs, globalAxios, BASE_PATH, configuration)(axios, localVarOperationServerBasePath || basePath);
        },
        /**
         * Patch Reason
         * @param {string} name Name of reason
         * @param {Array<JsonPatchInner>} [jsonPatchInner] 
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        async patchReason(name: string, jsonPatchInner?: Array<JsonPatchInner>, options?: RawAxiosRequestConfig): Promise<(axios?: AxiosInstance, basePath?: string) => AxiosPromise<Reason>> {
            const localVarAxiosArgs = await localVarAxiosParamCreator.patchReason(name, jsonPatchInner, options);
            const localVarOperationServerIndex = configuration?.serverIndex ?? 0;
            const localVarOperationServerBasePath = operationServerMap['ReasonV1alpha1Api.patchReason']?.[localVarOperationServerIndex]?.url;
            return (axios, basePath) => createRequestFunction(localVarAxiosArgs, globalAxios, BASE_PATH, configuration)(axios, localVarOperationServerBasePath || basePath);
        },
        /**
         * Update Reason
         * @param {string} name Name of reason
         * @param {Reason} [reason] Updated reason
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        async updateReason(name: string, reason?: Reason, options?: RawAxiosRequestConfig): Promise<(axios?: AxiosInstance, basePath?: string) => AxiosPromise<Reason>> {
            const localVarAxiosArgs = await localVarAxiosParamCreator.updateReason(name, reason, options);
            const localVarOperationServerIndex = configuration?.serverIndex ?? 0;
            const localVarOperationServerBasePath = operationServerMap['ReasonV1alpha1Api.updateReason']?.[localVarOperationServerIndex]?.url;
            return (axios, basePath) => createRequestFunction(localVarAxiosArgs, globalAxios, BASE_PATH, configuration)(axios, localVarOperationServerBasePath || basePath);
        },
    }
};

/**
 * ReasonV1alpha1Api - factory interface
 * @export
 */
export const ReasonV1alpha1ApiFactory = function (configuration?: Configuration, basePath?: string, axios?: AxiosInstance) {
    const localVarFp = ReasonV1alpha1ApiFp(configuration)
    return {
        /**
         * Create Reason
         * @param {ReasonV1alpha1ApiCreateReasonRequest} requestParameters Request parameters.
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        createReason(requestParameters: ReasonV1alpha1ApiCreateReasonRequest = {}, options?: RawAxiosRequestConfig): AxiosPromise<Reason> {
            return localVarFp.createReason(requestParameters.reason, options).then((request) => request(axios, basePath));
        },
        /**
         * Delete Reason
         * @param {ReasonV1alpha1ApiDeleteReasonRequest} requestParameters Request parameters.
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        deleteReason(requestParameters: ReasonV1alpha1ApiDeleteReasonRequest, options?: RawAxiosRequestConfig): AxiosPromise<void> {
            return localVarFp.deleteReason(requestParameters.name, options).then((request) => request(axios, basePath));
        },
        /**
         * Get Reason
         * @param {ReasonV1alpha1ApiGetReasonRequest} requestParameters Request parameters.
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        getReason(requestParameters: ReasonV1alpha1ApiGetReasonRequest, options?: RawAxiosRequestConfig): AxiosPromise<Reason> {
            return localVarFp.getReason(requestParameters.name, options).then((request) => request(axios, basePath));
        },
        /**
         * List Reason
         * @param {ReasonV1alpha1ApiListReasonRequest} requestParameters Request parameters.
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        listReason(requestParameters: ReasonV1alpha1ApiListReasonRequest = {}, options?: RawAxiosRequestConfig): AxiosPromise<ReasonList> {
            return localVarFp.listReason(requestParameters.page, requestParameters.size, requestParameters.labelSelector, requestParameters.fieldSelector, requestParameters.sort, options).then((request) => request(axios, basePath));
        },
        /**
         * Patch Reason
         * @param {ReasonV1alpha1ApiPatchReasonRequest} requestParameters Request parameters.
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        patchReason(requestParameters: ReasonV1alpha1ApiPatchReasonRequest, options?: RawAxiosRequestConfig): AxiosPromise<Reason> {
            return localVarFp.patchReason(requestParameters.name, requestParameters.jsonPatchInner, options).then((request) => request(axios, basePath));
        },
        /**
         * Update Reason
         * @param {ReasonV1alpha1ApiUpdateReasonRequest} requestParameters Request parameters.
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        updateReason(requestParameters: ReasonV1alpha1ApiUpdateReasonRequest, options?: RawAxiosRequestConfig): AxiosPromise<Reason> {
            return localVarFp.updateReason(requestParameters.name, requestParameters.reason, options).then((request) => request(axios, basePath));
        },
    };
};

/**
 * Request parameters for createReason operation in ReasonV1alpha1Api.
 * @export
 * @interface ReasonV1alpha1ApiCreateReasonRequest
 */
export interface ReasonV1alpha1ApiCreateReasonRequest {
    /**
     * Fresh reason
     * @type {Reason}
     * @memberof ReasonV1alpha1ApiCreateReason
     */
    readonly reason?: Reason
}

/**
 * Request parameters for deleteReason operation in ReasonV1alpha1Api.
 * @export
 * @interface ReasonV1alpha1ApiDeleteReasonRequest
 */
export interface ReasonV1alpha1ApiDeleteReasonRequest {
    /**
     * Name of reason
     * @type {string}
     * @memberof ReasonV1alpha1ApiDeleteReason
     */
    readonly name: string
}

/**
 * Request parameters for getReason operation in ReasonV1alpha1Api.
 * @export
 * @interface ReasonV1alpha1ApiGetReasonRequest
 */
export interface ReasonV1alpha1ApiGetReasonRequest {
    /**
     * Name of reason
     * @type {string}
     * @memberof ReasonV1alpha1ApiGetReason
     */
    readonly name: string
}

/**
 * Request parameters for listReason operation in ReasonV1alpha1Api.
 * @export
 * @interface ReasonV1alpha1ApiListReasonRequest
 */
export interface ReasonV1alpha1ApiListReasonRequest {
    /**
     * Page number. Default is 0.
     * @type {number}
     * @memberof ReasonV1alpha1ApiListReason
     */
    readonly page?: number

    /**
     * Size number. Default is 0.
     * @type {number}
     * @memberof ReasonV1alpha1ApiListReason
     */
    readonly size?: number

    /**
     * Label selector. e.g.: hidden!&#x3D;true
     * @type {Array<string>}
     * @memberof ReasonV1alpha1ApiListReason
     */
    readonly labelSelector?: Array<string>

    /**
     * Field selector. e.g.: metadata.name&#x3D;&#x3D;halo
     * @type {Array<string>}
     * @memberof ReasonV1alpha1ApiListReason
     */
    readonly fieldSelector?: Array<string>

    /**
     * Sorting criteria in the format: property,(asc|desc). Default sort order is ascending. Multiple sort criteria are supported.
     * @type {Array<string>}
     * @memberof ReasonV1alpha1ApiListReason
     */
    readonly sort?: Array<string>
}

/**
 * Request parameters for patchReason operation in ReasonV1alpha1Api.
 * @export
 * @interface ReasonV1alpha1ApiPatchReasonRequest
 */
export interface ReasonV1alpha1ApiPatchReasonRequest {
    /**
     * Name of reason
     * @type {string}
     * @memberof ReasonV1alpha1ApiPatchReason
     */
    readonly name: string

    /**
     * 
     * @type {Array<JsonPatchInner>}
     * @memberof ReasonV1alpha1ApiPatchReason
     */
    readonly jsonPatchInner?: Array<JsonPatchInner>
}

/**
 * Request parameters for updateReason operation in ReasonV1alpha1Api.
 * @export
 * @interface ReasonV1alpha1ApiUpdateReasonRequest
 */
export interface ReasonV1alpha1ApiUpdateReasonRequest {
    /**
     * Name of reason
     * @type {string}
     * @memberof ReasonV1alpha1ApiUpdateReason
     */
    readonly name: string

    /**
     * Updated reason
     * @type {Reason}
     * @memberof ReasonV1alpha1ApiUpdateReason
     */
    readonly reason?: Reason
}

/**
 * ReasonV1alpha1Api - object-oriented interface
 * @export
 * @class ReasonV1alpha1Api
 * @extends {BaseAPI}
 */
export class ReasonV1alpha1Api extends BaseAPI {
    /**
     * Create Reason
     * @param {ReasonV1alpha1ApiCreateReasonRequest} requestParameters Request parameters.
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof ReasonV1alpha1Api
     */
    public createReason(requestParameters: ReasonV1alpha1ApiCreateReasonRequest = {}, options?: RawAxiosRequestConfig) {
        return ReasonV1alpha1ApiFp(this.configuration).createReason(requestParameters.reason, options).then((request) => request(this.axios, this.basePath));
    }

    /**
     * Delete Reason
     * @param {ReasonV1alpha1ApiDeleteReasonRequest} requestParameters Request parameters.
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof ReasonV1alpha1Api
     */
    public deleteReason(requestParameters: ReasonV1alpha1ApiDeleteReasonRequest, options?: RawAxiosRequestConfig) {
        return ReasonV1alpha1ApiFp(this.configuration).deleteReason(requestParameters.name, options).then((request) => request(this.axios, this.basePath));
    }

    /**
     * Get Reason
     * @param {ReasonV1alpha1ApiGetReasonRequest} requestParameters Request parameters.
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof ReasonV1alpha1Api
     */
    public getReason(requestParameters: ReasonV1alpha1ApiGetReasonRequest, options?: RawAxiosRequestConfig) {
        return ReasonV1alpha1ApiFp(this.configuration).getReason(requestParameters.name, options).then((request) => request(this.axios, this.basePath));
    }

    /**
     * List Reason
     * @param {ReasonV1alpha1ApiListReasonRequest} requestParameters Request parameters.
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof ReasonV1alpha1Api
     */
    public listReason(requestParameters: ReasonV1alpha1ApiListReasonRequest = {}, options?: RawAxiosRequestConfig) {
        return ReasonV1alpha1ApiFp(this.configuration).listReason(requestParameters.page, requestParameters.size, requestParameters.labelSelector, requestParameters.fieldSelector, requestParameters.sort, options).then((request) => request(this.axios, this.basePath));
    }

    /**
     * Patch Reason
     * @param {ReasonV1alpha1ApiPatchReasonRequest} requestParameters Request parameters.
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof ReasonV1alpha1Api
     */
    public patchReason(requestParameters: ReasonV1alpha1ApiPatchReasonRequest, options?: RawAxiosRequestConfig) {
        return ReasonV1alpha1ApiFp(this.configuration).patchReason(requestParameters.name, requestParameters.jsonPatchInner, options).then((request) => request(this.axios, this.basePath));
    }

    /**
     * Update Reason
     * @param {ReasonV1alpha1ApiUpdateReasonRequest} requestParameters Request parameters.
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof ReasonV1alpha1Api
     */
    public updateReason(requestParameters: ReasonV1alpha1ApiUpdateReasonRequest, options?: RawAxiosRequestConfig) {
        return ReasonV1alpha1ApiFp(this.configuration).updateReason(requestParameters.name, requestParameters.reason, options).then((request) => request(this.axios, this.basePath));
    }
}

