/* tslint:disable */
/* eslint-disable */
/**
 * Halo
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: 2.20.10-SNAPSHOT
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


import type { Configuration } from '../configuration';
import type { AxiosPromise, AxiosInstance, RawAxiosRequestConfig } from 'axios';
import globalAxios from 'axios';
// Some imports not used depending on template conditions
// @ts-ignore
import { DUMMY_BASE_URL, assertParamExists, setApiKeyToObject, setBasicAuthToObject, setBearerAuthToObject, setOAuthToObject, setSearchParams, serializeDataIfNeeded, toPathString, createRequestFunction } from '../common';
// @ts-ignore
import { BASE_PATH, COLLECTION_FORMATS, RequestArgs, BaseAPI, RequiredError, operationServerMap } from '../base';
// @ts-ignore
import { JsonPatchInner } from '../models';
// @ts-ignore
import { Role } from '../models';
// @ts-ignore
import { RoleList } from '../models';
/**
 * RoleV1alpha1Api - axios parameter creator
 * @export
 */
export const RoleV1alpha1ApiAxiosParamCreator = function (configuration?: Configuration) {
    return {
        /**
         * Create Role
         * @param {Role} [role] Fresh role
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        createRole: async (role?: Role, options: RawAxiosRequestConfig = {}): Promise<RequestArgs> => {
            const localVarPath = `/api/v1alpha1/roles`;
            // use dummy base URL string because the URL constructor only accepts absolute URLs.
            const localVarUrlObj = new URL(localVarPath, DUMMY_BASE_URL);
            let baseOptions;
            if (configuration) {
                baseOptions = configuration.baseOptions;
            }

            const localVarRequestOptions = { method: 'POST', ...baseOptions, ...options};
            const localVarHeaderParameter = {} as any;
            const localVarQueryParameter = {} as any;

            // authentication basicAuth required
            // http basic authentication required
            setBasicAuthToObject(localVarRequestOptions, configuration)

            // authentication bearerAuth required
            // http bearer authentication required
            await setBearerAuthToObject(localVarHeaderParameter, configuration)


    
            localVarHeaderParameter['Content-Type'] = 'application/json';

            setSearchParams(localVarUrlObj, localVarQueryParameter);
            let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
            localVarRequestOptions.headers = {...localVarHeaderParameter, ...headersFromBaseOptions, ...options.headers};
            localVarRequestOptions.data = serializeDataIfNeeded(role, localVarRequestOptions, configuration)

            return {
                url: toPathString(localVarUrlObj),
                options: localVarRequestOptions,
            };
        },
        /**
         * Delete Role
         * @param {string} name Name of role
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        deleteRole: async (name: string, options: RawAxiosRequestConfig = {}): Promise<RequestArgs> => {
            // verify required parameter 'name' is not null or undefined
            assertParamExists('deleteRole', 'name', name)
            const localVarPath = `/api/v1alpha1/roles/{name}`
                .replace(`{${"name"}}`, encodeURIComponent(String(name)));
            // use dummy base URL string because the URL constructor only accepts absolute URLs.
            const localVarUrlObj = new URL(localVarPath, DUMMY_BASE_URL);
            let baseOptions;
            if (configuration) {
                baseOptions = configuration.baseOptions;
            }

            const localVarRequestOptions = { method: 'DELETE', ...baseOptions, ...options};
            const localVarHeaderParameter = {} as any;
            const localVarQueryParameter = {} as any;

            // authentication basicAuth required
            // http basic authentication required
            setBasicAuthToObject(localVarRequestOptions, configuration)

            // authentication bearerAuth required
            // http bearer authentication required
            await setBearerAuthToObject(localVarHeaderParameter, configuration)


    
            setSearchParams(localVarUrlObj, localVarQueryParameter);
            let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
            localVarRequestOptions.headers = {...localVarHeaderParameter, ...headersFromBaseOptions, ...options.headers};

            return {
                url: toPathString(localVarUrlObj),
                options: localVarRequestOptions,
            };
        },
        /**
         * Get Role
         * @param {string} name Name of role
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        getRole: async (name: string, options: RawAxiosRequestConfig = {}): Promise<RequestArgs> => {
            // verify required parameter 'name' is not null or undefined
            assertParamExists('getRole', 'name', name)
            const localVarPath = `/api/v1alpha1/roles/{name}`
                .replace(`{${"name"}}`, encodeURIComponent(String(name)));
            // use dummy base URL string because the URL constructor only accepts absolute URLs.
            const localVarUrlObj = new URL(localVarPath, DUMMY_BASE_URL);
            let baseOptions;
            if (configuration) {
                baseOptions = configuration.baseOptions;
            }

            const localVarRequestOptions = { method: 'GET', ...baseOptions, ...options};
            const localVarHeaderParameter = {} as any;
            const localVarQueryParameter = {} as any;

            // authentication basicAuth required
            // http basic authentication required
            setBasicAuthToObject(localVarRequestOptions, configuration)

            // authentication bearerAuth required
            // http bearer authentication required
            await setBearerAuthToObject(localVarHeaderParameter, configuration)


    
            setSearchParams(localVarUrlObj, localVarQueryParameter);
            let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
            localVarRequestOptions.headers = {...localVarHeaderParameter, ...headersFromBaseOptions, ...options.headers};

            return {
                url: toPathString(localVarUrlObj),
                options: localVarRequestOptions,
            };
        },
        /**
         * List Role
         * @param {number} [page] Page number. Default is 0.
         * @param {number} [size] Size number. Default is 0.
         * @param {Array<string>} [labelSelector] Label selector. e.g.: hidden!&#x3D;true
         * @param {Array<string>} [fieldSelector] Field selector. e.g.: metadata.name&#x3D;&#x3D;halo
         * @param {Array<string>} [sort] Sorting criteria in the format: property,(asc|desc). Default sort order is ascending. Multiple sort criteria are supported.
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        listRole: async (page?: number, size?: number, labelSelector?: Array<string>, fieldSelector?: Array<string>, sort?: Array<string>, options: RawAxiosRequestConfig = {}): Promise<RequestArgs> => {
            const localVarPath = `/api/v1alpha1/roles`;
            // use dummy base URL string because the URL constructor only accepts absolute URLs.
            const localVarUrlObj = new URL(localVarPath, DUMMY_BASE_URL);
            let baseOptions;
            if (configuration) {
                baseOptions = configuration.baseOptions;
            }

            const localVarRequestOptions = { method: 'GET', ...baseOptions, ...options};
            const localVarHeaderParameter = {} as any;
            const localVarQueryParameter = {} as any;

            // authentication basicAuth required
            // http basic authentication required
            setBasicAuthToObject(localVarRequestOptions, configuration)

            // authentication bearerAuth required
            // http bearer authentication required
            await setBearerAuthToObject(localVarHeaderParameter, configuration)

            if (page !== undefined) {
                localVarQueryParameter['page'] = page;
            }

            if (size !== undefined) {
                localVarQueryParameter['size'] = size;
            }

            if (labelSelector) {
                localVarQueryParameter['labelSelector'] = labelSelector;
            }

            if (fieldSelector) {
                localVarQueryParameter['fieldSelector'] = fieldSelector;
            }

            if (sort) {
                localVarQueryParameter['sort'] = sort;
            }


    
            setSearchParams(localVarUrlObj, localVarQueryParameter);
            let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
            localVarRequestOptions.headers = {...localVarHeaderParameter, ...headersFromBaseOptions, ...options.headers};

            return {
                url: toPathString(localVarUrlObj),
                options: localVarRequestOptions,
            };
        },
        /**
         * Patch Role
         * @param {string} name Name of role
         * @param {Array<JsonPatchInner>} [jsonPatchInner] 
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        patchRole: async (name: string, jsonPatchInner?: Array<JsonPatchInner>, options: RawAxiosRequestConfig = {}): Promise<RequestArgs> => {
            // verify required parameter 'name' is not null or undefined
            assertParamExists('patchRole', 'name', name)
            const localVarPath = `/api/v1alpha1/roles/{name}`
                .replace(`{${"name"}}`, encodeURIComponent(String(name)));
            // use dummy base URL string because the URL constructor only accepts absolute URLs.
            const localVarUrlObj = new URL(localVarPath, DUMMY_BASE_URL);
            let baseOptions;
            if (configuration) {
                baseOptions = configuration.baseOptions;
            }

            const localVarRequestOptions = { method: 'PATCH', ...baseOptions, ...options};
            const localVarHeaderParameter = {} as any;
            const localVarQueryParameter = {} as any;

            // authentication basicAuth required
            // http basic authentication required
            setBasicAuthToObject(localVarRequestOptions, configuration)

            // authentication bearerAuth required
            // http bearer authentication required
            await setBearerAuthToObject(localVarHeaderParameter, configuration)


    
            localVarHeaderParameter['Content-Type'] = 'application/json-patch+json';

            setSearchParams(localVarUrlObj, localVarQueryParameter);
            let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
            localVarRequestOptions.headers = {...localVarHeaderParameter, ...headersFromBaseOptions, ...options.headers};
            localVarRequestOptions.data = serializeDataIfNeeded(jsonPatchInner, localVarRequestOptions, configuration)

            return {
                url: toPathString(localVarUrlObj),
                options: localVarRequestOptions,
            };
        },
        /**
         * Update Role
         * @param {string} name Name of role
         * @param {Role} [role] Updated role
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        updateRole: async (name: string, role?: Role, options: RawAxiosRequestConfig = {}): Promise<RequestArgs> => {
            // verify required parameter 'name' is not null or undefined
            assertParamExists('updateRole', 'name', name)
            const localVarPath = `/api/v1alpha1/roles/{name}`
                .replace(`{${"name"}}`, encodeURIComponent(String(name)));
            // use dummy base URL string because the URL constructor only accepts absolute URLs.
            const localVarUrlObj = new URL(localVarPath, DUMMY_BASE_URL);
            let baseOptions;
            if (configuration) {
                baseOptions = configuration.baseOptions;
            }

            const localVarRequestOptions = { method: 'PUT', ...baseOptions, ...options};
            const localVarHeaderParameter = {} as any;
            const localVarQueryParameter = {} as any;

            // authentication basicAuth required
            // http basic authentication required
            setBasicAuthToObject(localVarRequestOptions, configuration)

            // authentication bearerAuth required
            // http bearer authentication required
            await setBearerAuthToObject(localVarHeaderParameter, configuration)


    
            localVarHeaderParameter['Content-Type'] = 'application/json';

            setSearchParams(localVarUrlObj, localVarQueryParameter);
            let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
            localVarRequestOptions.headers = {...localVarHeaderParameter, ...headersFromBaseOptions, ...options.headers};
            localVarRequestOptions.data = serializeDataIfNeeded(role, localVarRequestOptions, configuration)

            return {
                url: toPathString(localVarUrlObj),
                options: localVarRequestOptions,
            };
        },
    }
};

/**
 * RoleV1alpha1Api - functional programming interface
 * @export
 */
export const RoleV1alpha1ApiFp = function(configuration?: Configuration) {
    const localVarAxiosParamCreator = RoleV1alpha1ApiAxiosParamCreator(configuration)
    return {
        /**
         * Create Role
         * @param {Role} [role] Fresh role
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        async createRole(role?: Role, options?: RawAxiosRequestConfig): Promise<(axios?: AxiosInstance, basePath?: string) => AxiosPromise<Role>> {
            const localVarAxiosArgs = await localVarAxiosParamCreator.createRole(role, options);
            const localVarOperationServerIndex = configuration?.serverIndex ?? 0;
            const localVarOperationServerBasePath = operationServerMap['RoleV1alpha1Api.createRole']?.[localVarOperationServerIndex]?.url;
            return (axios, basePath) => createRequestFunction(localVarAxiosArgs, globalAxios, BASE_PATH, configuration)(axios, localVarOperationServerBasePath || basePath);
        },
        /**
         * Delete Role
         * @param {string} name Name of role
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        async deleteRole(name: string, options?: RawAxiosRequestConfig): Promise<(axios?: AxiosInstance, basePath?: string) => AxiosPromise<void>> {
            const localVarAxiosArgs = await localVarAxiosParamCreator.deleteRole(name, options);
            const localVarOperationServerIndex = configuration?.serverIndex ?? 0;
            const localVarOperationServerBasePath = operationServerMap['RoleV1alpha1Api.deleteRole']?.[localVarOperationServerIndex]?.url;
            return (axios, basePath) => createRequestFunction(localVarAxiosArgs, globalAxios, BASE_PATH, configuration)(axios, localVarOperationServerBasePath || basePath);
        },
        /**
         * Get Role
         * @param {string} name Name of role
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        async getRole(name: string, options?: RawAxiosRequestConfig): Promise<(axios?: AxiosInstance, basePath?: string) => AxiosPromise<Role>> {
            const localVarAxiosArgs = await localVarAxiosParamCreator.getRole(name, options);
            const localVarOperationServerIndex = configuration?.serverIndex ?? 0;
            const localVarOperationServerBasePath = operationServerMap['RoleV1alpha1Api.getRole']?.[localVarOperationServerIndex]?.url;
            return (axios, basePath) => createRequestFunction(localVarAxiosArgs, globalAxios, BASE_PATH, configuration)(axios, localVarOperationServerBasePath || basePath);
        },
        /**
         * List Role
         * @param {number} [page] Page number. Default is 0.
         * @param {number} [size] Size number. Default is 0.
         * @param {Array<string>} [labelSelector] Label selector. e.g.: hidden!&#x3D;true
         * @param {Array<string>} [fieldSelector] Field selector. e.g.: metadata.name&#x3D;&#x3D;halo
         * @param {Array<string>} [sort] Sorting criteria in the format: property,(asc|desc). Default sort order is ascending. Multiple sort criteria are supported.
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        async listRole(page?: number, size?: number, labelSelector?: Array<string>, fieldSelector?: Array<string>, sort?: Array<string>, options?: RawAxiosRequestConfig): Promise<(axios?: AxiosInstance, basePath?: string) => AxiosPromise<RoleList>> {
            const localVarAxiosArgs = await localVarAxiosParamCreator.listRole(page, size, labelSelector, fieldSelector, sort, options);
            const localVarOperationServerIndex = configuration?.serverIndex ?? 0;
            const localVarOperationServerBasePath = operationServerMap['RoleV1alpha1Api.listRole']?.[localVarOperationServerIndex]?.url;
            return (axios, basePath) => createRequestFunction(localVarAxiosArgs, globalAxios, BASE_PATH, configuration)(axios, localVarOperationServerBasePath || basePath);
        },
        /**
         * Patch Role
         * @param {string} name Name of role
         * @param {Array<JsonPatchInner>} [jsonPatchInner] 
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        async patchRole(name: string, jsonPatchInner?: Array<JsonPatchInner>, options?: RawAxiosRequestConfig): Promise<(axios?: AxiosInstance, basePath?: string) => AxiosPromise<Role>> {
            const localVarAxiosArgs = await localVarAxiosParamCreator.patchRole(name, jsonPatchInner, options);
            const localVarOperationServerIndex = configuration?.serverIndex ?? 0;
            const localVarOperationServerBasePath = operationServerMap['RoleV1alpha1Api.patchRole']?.[localVarOperationServerIndex]?.url;
            return (axios, basePath) => createRequestFunction(localVarAxiosArgs, globalAxios, BASE_PATH, configuration)(axios, localVarOperationServerBasePath || basePath);
        },
        /**
         * Update Role
         * @param {string} name Name of role
         * @param {Role} [role] Updated role
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        async updateRole(name: string, role?: Role, options?: RawAxiosRequestConfig): Promise<(axios?: AxiosInstance, basePath?: string) => AxiosPromise<Role>> {
            const localVarAxiosArgs = await localVarAxiosParamCreator.updateRole(name, role, options);
            const localVarOperationServerIndex = configuration?.serverIndex ?? 0;
            const localVarOperationServerBasePath = operationServerMap['RoleV1alpha1Api.updateRole']?.[localVarOperationServerIndex]?.url;
            return (axios, basePath) => createRequestFunction(localVarAxiosArgs, globalAxios, BASE_PATH, configuration)(axios, localVarOperationServerBasePath || basePath);
        },
    }
};

/**
 * RoleV1alpha1Api - factory interface
 * @export
 */
export const RoleV1alpha1ApiFactory = function (configuration?: Configuration, basePath?: string, axios?: AxiosInstance) {
    const localVarFp = RoleV1alpha1ApiFp(configuration)
    return {
        /**
         * Create Role
         * @param {RoleV1alpha1ApiCreateRoleRequest} requestParameters Request parameters.
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        createRole(requestParameters: RoleV1alpha1ApiCreateRoleRequest = {}, options?: RawAxiosRequestConfig): AxiosPromise<Role> {
            return localVarFp.createRole(requestParameters.role, options).then((request) => request(axios, basePath));
        },
        /**
         * Delete Role
         * @param {RoleV1alpha1ApiDeleteRoleRequest} requestParameters Request parameters.
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        deleteRole(requestParameters: RoleV1alpha1ApiDeleteRoleRequest, options?: RawAxiosRequestConfig): AxiosPromise<void> {
            return localVarFp.deleteRole(requestParameters.name, options).then((request) => request(axios, basePath));
        },
        /**
         * Get Role
         * @param {RoleV1alpha1ApiGetRoleRequest} requestParameters Request parameters.
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        getRole(requestParameters: RoleV1alpha1ApiGetRoleRequest, options?: RawAxiosRequestConfig): AxiosPromise<Role> {
            return localVarFp.getRole(requestParameters.name, options).then((request) => request(axios, basePath));
        },
        /**
         * List Role
         * @param {RoleV1alpha1ApiListRoleRequest} requestParameters Request parameters.
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        listRole(requestParameters: RoleV1alpha1ApiListRoleRequest = {}, options?: RawAxiosRequestConfig): AxiosPromise<RoleList> {
            return localVarFp.listRole(requestParameters.page, requestParameters.size, requestParameters.labelSelector, requestParameters.fieldSelector, requestParameters.sort, options).then((request) => request(axios, basePath));
        },
        /**
         * Patch Role
         * @param {RoleV1alpha1ApiPatchRoleRequest} requestParameters Request parameters.
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        patchRole(requestParameters: RoleV1alpha1ApiPatchRoleRequest, options?: RawAxiosRequestConfig): AxiosPromise<Role> {
            return localVarFp.patchRole(requestParameters.name, requestParameters.jsonPatchInner, options).then((request) => request(axios, basePath));
        },
        /**
         * Update Role
         * @param {RoleV1alpha1ApiUpdateRoleRequest} requestParameters Request parameters.
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        updateRole(requestParameters: RoleV1alpha1ApiUpdateRoleRequest, options?: RawAxiosRequestConfig): AxiosPromise<Role> {
            return localVarFp.updateRole(requestParameters.name, requestParameters.role, options).then((request) => request(axios, basePath));
        },
    };
};

/**
 * Request parameters for createRole operation in RoleV1alpha1Api.
 * @export
 * @interface RoleV1alpha1ApiCreateRoleRequest
 */
export interface RoleV1alpha1ApiCreateRoleRequest {
    /**
     * Fresh role
     * @type {Role}
     * @memberof RoleV1alpha1ApiCreateRole
     */
    readonly role?: Role
}

/**
 * Request parameters for deleteRole operation in RoleV1alpha1Api.
 * @export
 * @interface RoleV1alpha1ApiDeleteRoleRequest
 */
export interface RoleV1alpha1ApiDeleteRoleRequest {
    /**
     * Name of role
     * @type {string}
     * @memberof RoleV1alpha1ApiDeleteRole
     */
    readonly name: string
}

/**
 * Request parameters for getRole operation in RoleV1alpha1Api.
 * @export
 * @interface RoleV1alpha1ApiGetRoleRequest
 */
export interface RoleV1alpha1ApiGetRoleRequest {
    /**
     * Name of role
     * @type {string}
     * @memberof RoleV1alpha1ApiGetRole
     */
    readonly name: string
}

/**
 * Request parameters for listRole operation in RoleV1alpha1Api.
 * @export
 * @interface RoleV1alpha1ApiListRoleRequest
 */
export interface RoleV1alpha1ApiListRoleRequest {
    /**
     * Page number. Default is 0.
     * @type {number}
     * @memberof RoleV1alpha1ApiListRole
     */
    readonly page?: number

    /**
     * Size number. Default is 0.
     * @type {number}
     * @memberof RoleV1alpha1ApiListRole
     */
    readonly size?: number

    /**
     * Label selector. e.g.: hidden!&#x3D;true
     * @type {Array<string>}
     * @memberof RoleV1alpha1ApiListRole
     */
    readonly labelSelector?: Array<string>

    /**
     * Field selector. e.g.: metadata.name&#x3D;&#x3D;halo
     * @type {Array<string>}
     * @memberof RoleV1alpha1ApiListRole
     */
    readonly fieldSelector?: Array<string>

    /**
     * Sorting criteria in the format: property,(asc|desc). Default sort order is ascending. Multiple sort criteria are supported.
     * @type {Array<string>}
     * @memberof RoleV1alpha1ApiListRole
     */
    readonly sort?: Array<string>
}

/**
 * Request parameters for patchRole operation in RoleV1alpha1Api.
 * @export
 * @interface RoleV1alpha1ApiPatchRoleRequest
 */
export interface RoleV1alpha1ApiPatchRoleRequest {
    /**
     * Name of role
     * @type {string}
     * @memberof RoleV1alpha1ApiPatchRole
     */
    readonly name: string

    /**
     * 
     * @type {Array<JsonPatchInner>}
     * @memberof RoleV1alpha1ApiPatchRole
     */
    readonly jsonPatchInner?: Array<JsonPatchInner>
}

/**
 * Request parameters for updateRole operation in RoleV1alpha1Api.
 * @export
 * @interface RoleV1alpha1ApiUpdateRoleRequest
 */
export interface RoleV1alpha1ApiUpdateRoleRequest {
    /**
     * Name of role
     * @type {string}
     * @memberof RoleV1alpha1ApiUpdateRole
     */
    readonly name: string

    /**
     * Updated role
     * @type {Role}
     * @memberof RoleV1alpha1ApiUpdateRole
     */
    readonly role?: Role
}

/**
 * RoleV1alpha1Api - object-oriented interface
 * @export
 * @class RoleV1alpha1Api
 * @extends {BaseAPI}
 */
export class RoleV1alpha1Api extends BaseAPI {
    /**
     * Create Role
     * @param {RoleV1alpha1ApiCreateRoleRequest} requestParameters Request parameters.
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof RoleV1alpha1Api
     */
    public createRole(requestParameters: RoleV1alpha1ApiCreateRoleRequest = {}, options?: RawAxiosRequestConfig) {
        return RoleV1alpha1ApiFp(this.configuration).createRole(requestParameters.role, options).then((request) => request(this.axios, this.basePath));
    }

    /**
     * Delete Role
     * @param {RoleV1alpha1ApiDeleteRoleRequest} requestParameters Request parameters.
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof RoleV1alpha1Api
     */
    public deleteRole(requestParameters: RoleV1alpha1ApiDeleteRoleRequest, options?: RawAxiosRequestConfig) {
        return RoleV1alpha1ApiFp(this.configuration).deleteRole(requestParameters.name, options).then((request) => request(this.axios, this.basePath));
    }

    /**
     * Get Role
     * @param {RoleV1alpha1ApiGetRoleRequest} requestParameters Request parameters.
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof RoleV1alpha1Api
     */
    public getRole(requestParameters: RoleV1alpha1ApiGetRoleRequest, options?: RawAxiosRequestConfig) {
        return RoleV1alpha1ApiFp(this.configuration).getRole(requestParameters.name, options).then((request) => request(this.axios, this.basePath));
    }

    /**
     * List Role
     * @param {RoleV1alpha1ApiListRoleRequest} requestParameters Request parameters.
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof RoleV1alpha1Api
     */
    public listRole(requestParameters: RoleV1alpha1ApiListRoleRequest = {}, options?: RawAxiosRequestConfig) {
        return RoleV1alpha1ApiFp(this.configuration).listRole(requestParameters.page, requestParameters.size, requestParameters.labelSelector, requestParameters.fieldSelector, requestParameters.sort, options).then((request) => request(this.axios, this.basePath));
    }

    /**
     * Patch Role
     * @param {RoleV1alpha1ApiPatchRoleRequest} requestParameters Request parameters.
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof RoleV1alpha1Api
     */
    public patchRole(requestParameters: RoleV1alpha1ApiPatchRoleRequest, options?: RawAxiosRequestConfig) {
        return RoleV1alpha1ApiFp(this.configuration).patchRole(requestParameters.name, requestParameters.jsonPatchInner, options).then((request) => request(this.axios, this.basePath));
    }

    /**
     * Update Role
     * @param {RoleV1alpha1ApiUpdateRoleRequest} requestParameters Request parameters.
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof RoleV1alpha1Api
     */
    public updateRole(requestParameters: RoleV1alpha1ApiUpdateRoleRequest, options?: RawAxiosRequestConfig) {
        return RoleV1alpha1ApiFp(this.configuration).updateRole(requestParameters.name, requestParameters.role, options).then((request) => request(this.axios, this.basePath));
    }
}

