/* tslint:disable */
/* eslint-disable */
/**
 * Halo
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: 2.20.10-SNAPSHOT
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


import type { Configuration } from '../configuration';
import type { AxiosPromise, AxiosInstance, RawAxiosRequestConfig } from 'axios';
import globalAxios from 'axios';
// Some imports not used depending on template conditions
// @ts-ignore
import { DUMMY_BASE_URL, assertParamExists, setApiKeyToObject, setBasicAuthToObject, setBearerAuthToObject, setOAuthToObject, setSearchParams, serializeDataIfNeeded, toPathString, createRequestFunction } from '../common';
// @ts-ignore
import { BASE_PATH, COLLECTION_FORMATS, RequestArgs, BaseAPI, RequiredError, operationServerMap } from '../base';
// @ts-ignore
import { JsonPatchInner } from '../models';
// @ts-ignore
import { Secret } from '../models';
// @ts-ignore
import { SecretList } from '../models';
/**
 * SecretV1alpha1Api - axios parameter creator
 * @export
 */
export const SecretV1alpha1ApiAxiosParamCreator = function (configuration?: Configuration) {
    return {
        /**
         * Create Secret
         * @param {Secret} [secret] Fresh secret
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        createSecret: async (secret?: Secret, options: RawAxiosRequestConfig = {}): Promise<RequestArgs> => {
            const localVarPath = `/api/v1alpha1/secrets`;
            // use dummy base URL string because the URL constructor only accepts absolute URLs.
            const localVarUrlObj = new URL(localVarPath, DUMMY_BASE_URL);
            let baseOptions;
            if (configuration) {
                baseOptions = configuration.baseOptions;
            }

            const localVarRequestOptions = { method: 'POST', ...baseOptions, ...options};
            const localVarHeaderParameter = {} as any;
            const localVarQueryParameter = {} as any;

            // authentication basicAuth required
            // http basic authentication required
            setBasicAuthToObject(localVarRequestOptions, configuration)

            // authentication bearerAuth required
            // http bearer authentication required
            await setBearerAuthToObject(localVarHeaderParameter, configuration)


    
            localVarHeaderParameter['Content-Type'] = 'application/json';

            setSearchParams(localVarUrlObj, localVarQueryParameter);
            let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
            localVarRequestOptions.headers = {...localVarHeaderParameter, ...headersFromBaseOptions, ...options.headers};
            localVarRequestOptions.data = serializeDataIfNeeded(secret, localVarRequestOptions, configuration)

            return {
                url: toPathString(localVarUrlObj),
                options: localVarRequestOptions,
            };
        },
        /**
         * Delete Secret
         * @param {string} name Name of secret
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        deleteSecret: async (name: string, options: RawAxiosRequestConfig = {}): Promise<RequestArgs> => {
            // verify required parameter 'name' is not null or undefined
            assertParamExists('deleteSecret', 'name', name)
            const localVarPath = `/api/v1alpha1/secrets/{name}`
                .replace(`{${"name"}}`, encodeURIComponent(String(name)));
            // use dummy base URL string because the URL constructor only accepts absolute URLs.
            const localVarUrlObj = new URL(localVarPath, DUMMY_BASE_URL);
            let baseOptions;
            if (configuration) {
                baseOptions = configuration.baseOptions;
            }

            const localVarRequestOptions = { method: 'DELETE', ...baseOptions, ...options};
            const localVarHeaderParameter = {} as any;
            const localVarQueryParameter = {} as any;

            // authentication basicAuth required
            // http basic authentication required
            setBasicAuthToObject(localVarRequestOptions, configuration)

            // authentication bearerAuth required
            // http bearer authentication required
            await setBearerAuthToObject(localVarHeaderParameter, configuration)


    
            setSearchParams(localVarUrlObj, localVarQueryParameter);
            let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
            localVarRequestOptions.headers = {...localVarHeaderParameter, ...headersFromBaseOptions, ...options.headers};

            return {
                url: toPathString(localVarUrlObj),
                options: localVarRequestOptions,
            };
        },
        /**
         * Get Secret
         * @param {string} name Name of secret
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        getSecret: async (name: string, options: RawAxiosRequestConfig = {}): Promise<RequestArgs> => {
            // verify required parameter 'name' is not null or undefined
            assertParamExists('getSecret', 'name', name)
            const localVarPath = `/api/v1alpha1/secrets/{name}`
                .replace(`{${"name"}}`, encodeURIComponent(String(name)));
            // use dummy base URL string because the URL constructor only accepts absolute URLs.
            const localVarUrlObj = new URL(localVarPath, DUMMY_BASE_URL);
            let baseOptions;
            if (configuration) {
                baseOptions = configuration.baseOptions;
            }

            const localVarRequestOptions = { method: 'GET', ...baseOptions, ...options};
            const localVarHeaderParameter = {} as any;
            const localVarQueryParameter = {} as any;

            // authentication basicAuth required
            // http basic authentication required
            setBasicAuthToObject(localVarRequestOptions, configuration)

            // authentication bearerAuth required
            // http bearer authentication required
            await setBearerAuthToObject(localVarHeaderParameter, configuration)


    
            setSearchParams(localVarUrlObj, localVarQueryParameter);
            let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
            localVarRequestOptions.headers = {...localVarHeaderParameter, ...headersFromBaseOptions, ...options.headers};

            return {
                url: toPathString(localVarUrlObj),
                options: localVarRequestOptions,
            };
        },
        /**
         * List Secret
         * @param {number} [page] Page number. Default is 0.
         * @param {number} [size] Size number. Default is 0.
         * @param {Array<string>} [labelSelector] Label selector. e.g.: hidden!&#x3D;true
         * @param {Array<string>} [fieldSelector] Field selector. e.g.: metadata.name&#x3D;&#x3D;halo
         * @param {Array<string>} [sort] Sorting criteria in the format: property,(asc|desc). Default sort order is ascending. Multiple sort criteria are supported.
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        listSecret: async (page?: number, size?: number, labelSelector?: Array<string>, fieldSelector?: Array<string>, sort?: Array<string>, options: RawAxiosRequestConfig = {}): Promise<RequestArgs> => {
            const localVarPath = `/api/v1alpha1/secrets`;
            // use dummy base URL string because the URL constructor only accepts absolute URLs.
            const localVarUrlObj = new URL(localVarPath, DUMMY_BASE_URL);
            let baseOptions;
            if (configuration) {
                baseOptions = configuration.baseOptions;
            }

            const localVarRequestOptions = { method: 'GET', ...baseOptions, ...options};
            const localVarHeaderParameter = {} as any;
            const localVarQueryParameter = {} as any;

            // authentication basicAuth required
            // http basic authentication required
            setBasicAuthToObject(localVarRequestOptions, configuration)

            // authentication bearerAuth required
            // http bearer authentication required
            await setBearerAuthToObject(localVarHeaderParameter, configuration)

            if (page !== undefined) {
                localVarQueryParameter['page'] = page;
            }

            if (size !== undefined) {
                localVarQueryParameter['size'] = size;
            }

            if (labelSelector) {
                localVarQueryParameter['labelSelector'] = labelSelector;
            }

            if (fieldSelector) {
                localVarQueryParameter['fieldSelector'] = fieldSelector;
            }

            if (sort) {
                localVarQueryParameter['sort'] = sort;
            }


    
            setSearchParams(localVarUrlObj, localVarQueryParameter);
            let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
            localVarRequestOptions.headers = {...localVarHeaderParameter, ...headersFromBaseOptions, ...options.headers};

            return {
                url: toPathString(localVarUrlObj),
                options: localVarRequestOptions,
            };
        },
        /**
         * Patch Secret
         * @param {string} name Name of secret
         * @param {Array<JsonPatchInner>} [jsonPatchInner] 
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        patchSecret: async (name: string, jsonPatchInner?: Array<JsonPatchInner>, options: RawAxiosRequestConfig = {}): Promise<RequestArgs> => {
            // verify required parameter 'name' is not null or undefined
            assertParamExists('patchSecret', 'name', name)
            const localVarPath = `/api/v1alpha1/secrets/{name}`
                .replace(`{${"name"}}`, encodeURIComponent(String(name)));
            // use dummy base URL string because the URL constructor only accepts absolute URLs.
            const localVarUrlObj = new URL(localVarPath, DUMMY_BASE_URL);
            let baseOptions;
            if (configuration) {
                baseOptions = configuration.baseOptions;
            }

            const localVarRequestOptions = { method: 'PATCH', ...baseOptions, ...options};
            const localVarHeaderParameter = {} as any;
            const localVarQueryParameter = {} as any;

            // authentication basicAuth required
            // http basic authentication required
            setBasicAuthToObject(localVarRequestOptions, configuration)

            // authentication bearerAuth required
            // http bearer authentication required
            await setBearerAuthToObject(localVarHeaderParameter, configuration)


    
            localVarHeaderParameter['Content-Type'] = 'application/json-patch+json';

            setSearchParams(localVarUrlObj, localVarQueryParameter);
            let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
            localVarRequestOptions.headers = {...localVarHeaderParameter, ...headersFromBaseOptions, ...options.headers};
            localVarRequestOptions.data = serializeDataIfNeeded(jsonPatchInner, localVarRequestOptions, configuration)

            return {
                url: toPathString(localVarUrlObj),
                options: localVarRequestOptions,
            };
        },
        /**
         * Update Secret
         * @param {string} name Name of secret
         * @param {Secret} [secret] Updated secret
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        updateSecret: async (name: string, secret?: Secret, options: RawAxiosRequestConfig = {}): Promise<RequestArgs> => {
            // verify required parameter 'name' is not null or undefined
            assertParamExists('updateSecret', 'name', name)
            const localVarPath = `/api/v1alpha1/secrets/{name}`
                .replace(`{${"name"}}`, encodeURIComponent(String(name)));
            // use dummy base URL string because the URL constructor only accepts absolute URLs.
            const localVarUrlObj = new URL(localVarPath, DUMMY_BASE_URL);
            let baseOptions;
            if (configuration) {
                baseOptions = configuration.baseOptions;
            }

            const localVarRequestOptions = { method: 'PUT', ...baseOptions, ...options};
            const localVarHeaderParameter = {} as any;
            const localVarQueryParameter = {} as any;

            // authentication basicAuth required
            // http basic authentication required
            setBasicAuthToObject(localVarRequestOptions, configuration)

            // authentication bearerAuth required
            // http bearer authentication required
            await setBearerAuthToObject(localVarHeaderParameter, configuration)


    
            localVarHeaderParameter['Content-Type'] = 'application/json';

            setSearchParams(localVarUrlObj, localVarQueryParameter);
            let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
            localVarRequestOptions.headers = {...localVarHeaderParameter, ...headersFromBaseOptions, ...options.headers};
            localVarRequestOptions.data = serializeDataIfNeeded(secret, localVarRequestOptions, configuration)

            return {
                url: toPathString(localVarUrlObj),
                options: localVarRequestOptions,
            };
        },
    }
};

/**
 * SecretV1alpha1Api - functional programming interface
 * @export
 */
export const SecretV1alpha1ApiFp = function(configuration?: Configuration) {
    const localVarAxiosParamCreator = SecretV1alpha1ApiAxiosParamCreator(configuration)
    return {
        /**
         * Create Secret
         * @param {Secret} [secret] Fresh secret
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        async createSecret(secret?: Secret, options?: RawAxiosRequestConfig): Promise<(axios?: AxiosInstance, basePath?: string) => AxiosPromise<Secret>> {
            const localVarAxiosArgs = await localVarAxiosParamCreator.createSecret(secret, options);
            const localVarOperationServerIndex = configuration?.serverIndex ?? 0;
            const localVarOperationServerBasePath = operationServerMap['SecretV1alpha1Api.createSecret']?.[localVarOperationServerIndex]?.url;
            return (axios, basePath) => createRequestFunction(localVarAxiosArgs, globalAxios, BASE_PATH, configuration)(axios, localVarOperationServerBasePath || basePath);
        },
        /**
         * Delete Secret
         * @param {string} name Name of secret
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        async deleteSecret(name: string, options?: RawAxiosRequestConfig): Promise<(axios?: AxiosInstance, basePath?: string) => AxiosPromise<void>> {
            const localVarAxiosArgs = await localVarAxiosParamCreator.deleteSecret(name, options);
            const localVarOperationServerIndex = configuration?.serverIndex ?? 0;
            const localVarOperationServerBasePath = operationServerMap['SecretV1alpha1Api.deleteSecret']?.[localVarOperationServerIndex]?.url;
            return (axios, basePath) => createRequestFunction(localVarAxiosArgs, globalAxios, BASE_PATH, configuration)(axios, localVarOperationServerBasePath || basePath);
        },
        /**
         * Get Secret
         * @param {string} name Name of secret
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        async getSecret(name: string, options?: RawAxiosRequestConfig): Promise<(axios?: AxiosInstance, basePath?: string) => AxiosPromise<Secret>> {
            const localVarAxiosArgs = await localVarAxiosParamCreator.getSecret(name, options);
            const localVarOperationServerIndex = configuration?.serverIndex ?? 0;
            const localVarOperationServerBasePath = operationServerMap['SecretV1alpha1Api.getSecret']?.[localVarOperationServerIndex]?.url;
            return (axios, basePath) => createRequestFunction(localVarAxiosArgs, globalAxios, BASE_PATH, configuration)(axios, localVarOperationServerBasePath || basePath);
        },
        /**
         * List Secret
         * @param {number} [page] Page number. Default is 0.
         * @param {number} [size] Size number. Default is 0.
         * @param {Array<string>} [labelSelector] Label selector. e.g.: hidden!&#x3D;true
         * @param {Array<string>} [fieldSelector] Field selector. e.g.: metadata.name&#x3D;&#x3D;halo
         * @param {Array<string>} [sort] Sorting criteria in the format: property,(asc|desc). Default sort order is ascending. Multiple sort criteria are supported.
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        async listSecret(page?: number, size?: number, labelSelector?: Array<string>, fieldSelector?: Array<string>, sort?: Array<string>, options?: RawAxiosRequestConfig): Promise<(axios?: AxiosInstance, basePath?: string) => AxiosPromise<SecretList>> {
            const localVarAxiosArgs = await localVarAxiosParamCreator.listSecret(page, size, labelSelector, fieldSelector, sort, options);
            const localVarOperationServerIndex = configuration?.serverIndex ?? 0;
            const localVarOperationServerBasePath = operationServerMap['SecretV1alpha1Api.listSecret']?.[localVarOperationServerIndex]?.url;
            return (axios, basePath) => createRequestFunction(localVarAxiosArgs, globalAxios, BASE_PATH, configuration)(axios, localVarOperationServerBasePath || basePath);
        },
        /**
         * Patch Secret
         * @param {string} name Name of secret
         * @param {Array<JsonPatchInner>} [jsonPatchInner] 
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        async patchSecret(name: string, jsonPatchInner?: Array<JsonPatchInner>, options?: RawAxiosRequestConfig): Promise<(axios?: AxiosInstance, basePath?: string) => AxiosPromise<Secret>> {
            const localVarAxiosArgs = await localVarAxiosParamCreator.patchSecret(name, jsonPatchInner, options);
            const localVarOperationServerIndex = configuration?.serverIndex ?? 0;
            const localVarOperationServerBasePath = operationServerMap['SecretV1alpha1Api.patchSecret']?.[localVarOperationServerIndex]?.url;
            return (axios, basePath) => createRequestFunction(localVarAxiosArgs, globalAxios, BASE_PATH, configuration)(axios, localVarOperationServerBasePath || basePath);
        },
        /**
         * Update Secret
         * @param {string} name Name of secret
         * @param {Secret} [secret] Updated secret
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        async updateSecret(name: string, secret?: Secret, options?: RawAxiosRequestConfig): Promise<(axios?: AxiosInstance, basePath?: string) => AxiosPromise<Secret>> {
            const localVarAxiosArgs = await localVarAxiosParamCreator.updateSecret(name, secret, options);
            const localVarOperationServerIndex = configuration?.serverIndex ?? 0;
            const localVarOperationServerBasePath = operationServerMap['SecretV1alpha1Api.updateSecret']?.[localVarOperationServerIndex]?.url;
            return (axios, basePath) => createRequestFunction(localVarAxiosArgs, globalAxios, BASE_PATH, configuration)(axios, localVarOperationServerBasePath || basePath);
        },
    }
};

/**
 * SecretV1alpha1Api - factory interface
 * @export
 */
export const SecretV1alpha1ApiFactory = function (configuration?: Configuration, basePath?: string, axios?: AxiosInstance) {
    const localVarFp = SecretV1alpha1ApiFp(configuration)
    return {
        /**
         * Create Secret
         * @param {SecretV1alpha1ApiCreateSecretRequest} requestParameters Request parameters.
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        createSecret(requestParameters: SecretV1alpha1ApiCreateSecretRequest = {}, options?: RawAxiosRequestConfig): AxiosPromise<Secret> {
            return localVarFp.createSecret(requestParameters.secret, options).then((request) => request(axios, basePath));
        },
        /**
         * Delete Secret
         * @param {SecretV1alpha1ApiDeleteSecretRequest} requestParameters Request parameters.
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        deleteSecret(requestParameters: SecretV1alpha1ApiDeleteSecretRequest, options?: RawAxiosRequestConfig): AxiosPromise<void> {
            return localVarFp.deleteSecret(requestParameters.name, options).then((request) => request(axios, basePath));
        },
        /**
         * Get Secret
         * @param {SecretV1alpha1ApiGetSecretRequest} requestParameters Request parameters.
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        getSecret(requestParameters: SecretV1alpha1ApiGetSecretRequest, options?: RawAxiosRequestConfig): AxiosPromise<Secret> {
            return localVarFp.getSecret(requestParameters.name, options).then((request) => request(axios, basePath));
        },
        /**
         * List Secret
         * @param {SecretV1alpha1ApiListSecretRequest} requestParameters Request parameters.
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        listSecret(requestParameters: SecretV1alpha1ApiListSecretRequest = {}, options?: RawAxiosRequestConfig): AxiosPromise<SecretList> {
            return localVarFp.listSecret(requestParameters.page, requestParameters.size, requestParameters.labelSelector, requestParameters.fieldSelector, requestParameters.sort, options).then((request) => request(axios, basePath));
        },
        /**
         * Patch Secret
         * @param {SecretV1alpha1ApiPatchSecretRequest} requestParameters Request parameters.
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        patchSecret(requestParameters: SecretV1alpha1ApiPatchSecretRequest, options?: RawAxiosRequestConfig): AxiosPromise<Secret> {
            return localVarFp.patchSecret(requestParameters.name, requestParameters.jsonPatchInner, options).then((request) => request(axios, basePath));
        },
        /**
         * Update Secret
         * @param {SecretV1alpha1ApiUpdateSecretRequest} requestParameters Request parameters.
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        updateSecret(requestParameters: SecretV1alpha1ApiUpdateSecretRequest, options?: RawAxiosRequestConfig): AxiosPromise<Secret> {
            return localVarFp.updateSecret(requestParameters.name, requestParameters.secret, options).then((request) => request(axios, basePath));
        },
    };
};

/**
 * Request parameters for createSecret operation in SecretV1alpha1Api.
 * @export
 * @interface SecretV1alpha1ApiCreateSecretRequest
 */
export interface SecretV1alpha1ApiCreateSecretRequest {
    /**
     * Fresh secret
     * @type {Secret}
     * @memberof SecretV1alpha1ApiCreateSecret
     */
    readonly secret?: Secret
}

/**
 * Request parameters for deleteSecret operation in SecretV1alpha1Api.
 * @export
 * @interface SecretV1alpha1ApiDeleteSecretRequest
 */
export interface SecretV1alpha1ApiDeleteSecretRequest {
    /**
     * Name of secret
     * @type {string}
     * @memberof SecretV1alpha1ApiDeleteSecret
     */
    readonly name: string
}

/**
 * Request parameters for getSecret operation in SecretV1alpha1Api.
 * @export
 * @interface SecretV1alpha1ApiGetSecretRequest
 */
export interface SecretV1alpha1ApiGetSecretRequest {
    /**
     * Name of secret
     * @type {string}
     * @memberof SecretV1alpha1ApiGetSecret
     */
    readonly name: string
}

/**
 * Request parameters for listSecret operation in SecretV1alpha1Api.
 * @export
 * @interface SecretV1alpha1ApiListSecretRequest
 */
export interface SecretV1alpha1ApiListSecretRequest {
    /**
     * Page number. Default is 0.
     * @type {number}
     * @memberof SecretV1alpha1ApiListSecret
     */
    readonly page?: number

    /**
     * Size number. Default is 0.
     * @type {number}
     * @memberof SecretV1alpha1ApiListSecret
     */
    readonly size?: number

    /**
     * Label selector. e.g.: hidden!&#x3D;true
     * @type {Array<string>}
     * @memberof SecretV1alpha1ApiListSecret
     */
    readonly labelSelector?: Array<string>

    /**
     * Field selector. e.g.: metadata.name&#x3D;&#x3D;halo
     * @type {Array<string>}
     * @memberof SecretV1alpha1ApiListSecret
     */
    readonly fieldSelector?: Array<string>

    /**
     * Sorting criteria in the format: property,(asc|desc). Default sort order is ascending. Multiple sort criteria are supported.
     * @type {Array<string>}
     * @memberof SecretV1alpha1ApiListSecret
     */
    readonly sort?: Array<string>
}

/**
 * Request parameters for patchSecret operation in SecretV1alpha1Api.
 * @export
 * @interface SecretV1alpha1ApiPatchSecretRequest
 */
export interface SecretV1alpha1ApiPatchSecretRequest {
    /**
     * Name of secret
     * @type {string}
     * @memberof SecretV1alpha1ApiPatchSecret
     */
    readonly name: string

    /**
     * 
     * @type {Array<JsonPatchInner>}
     * @memberof SecretV1alpha1ApiPatchSecret
     */
    readonly jsonPatchInner?: Array<JsonPatchInner>
}

/**
 * Request parameters for updateSecret operation in SecretV1alpha1Api.
 * @export
 * @interface SecretV1alpha1ApiUpdateSecretRequest
 */
export interface SecretV1alpha1ApiUpdateSecretRequest {
    /**
     * Name of secret
     * @type {string}
     * @memberof SecretV1alpha1ApiUpdateSecret
     */
    readonly name: string

    /**
     * Updated secret
     * @type {Secret}
     * @memberof SecretV1alpha1ApiUpdateSecret
     */
    readonly secret?: Secret
}

/**
 * SecretV1alpha1Api - object-oriented interface
 * @export
 * @class SecretV1alpha1Api
 * @extends {BaseAPI}
 */
export class SecretV1alpha1Api extends BaseAPI {
    /**
     * Create Secret
     * @param {SecretV1alpha1ApiCreateSecretRequest} requestParameters Request parameters.
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof SecretV1alpha1Api
     */
    public createSecret(requestParameters: SecretV1alpha1ApiCreateSecretRequest = {}, options?: RawAxiosRequestConfig) {
        return SecretV1alpha1ApiFp(this.configuration).createSecret(requestParameters.secret, options).then((request) => request(this.axios, this.basePath));
    }

    /**
     * Delete Secret
     * @param {SecretV1alpha1ApiDeleteSecretRequest} requestParameters Request parameters.
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof SecretV1alpha1Api
     */
    public deleteSecret(requestParameters: SecretV1alpha1ApiDeleteSecretRequest, options?: RawAxiosRequestConfig) {
        return SecretV1alpha1ApiFp(this.configuration).deleteSecret(requestParameters.name, options).then((request) => request(this.axios, this.basePath));
    }

    /**
     * Get Secret
     * @param {SecretV1alpha1ApiGetSecretRequest} requestParameters Request parameters.
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof SecretV1alpha1Api
     */
    public getSecret(requestParameters: SecretV1alpha1ApiGetSecretRequest, options?: RawAxiosRequestConfig) {
        return SecretV1alpha1ApiFp(this.configuration).getSecret(requestParameters.name, options).then((request) => request(this.axios, this.basePath));
    }

    /**
     * List Secret
     * @param {SecretV1alpha1ApiListSecretRequest} requestParameters Request parameters.
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof SecretV1alpha1Api
     */
    public listSecret(requestParameters: SecretV1alpha1ApiListSecretRequest = {}, options?: RawAxiosRequestConfig) {
        return SecretV1alpha1ApiFp(this.configuration).listSecret(requestParameters.page, requestParameters.size, requestParameters.labelSelector, requestParameters.fieldSelector, requestParameters.sort, options).then((request) => request(this.axios, this.basePath));
    }

    /**
     * Patch Secret
     * @param {SecretV1alpha1ApiPatchSecretRequest} requestParameters Request parameters.
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof SecretV1alpha1Api
     */
    public patchSecret(requestParameters: SecretV1alpha1ApiPatchSecretRequest, options?: RawAxiosRequestConfig) {
        return SecretV1alpha1ApiFp(this.configuration).patchSecret(requestParameters.name, requestParameters.jsonPatchInner, options).then((request) => request(this.axios, this.basePath));
    }

    /**
     * Update Secret
     * @param {SecretV1alpha1ApiUpdateSecretRequest} requestParameters Request parameters.
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof SecretV1alpha1Api
     */
    public updateSecret(requestParameters: SecretV1alpha1ApiUpdateSecretRequest, options?: RawAxiosRequestConfig) {
        return SecretV1alpha1ApiFp(this.configuration).updateSecret(requestParameters.name, requestParameters.secret, options).then((request) => request(this.axios, this.basePath));
    }
}

