/* tslint:disable */
/* eslint-disable */
/**
 * Halo
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: 2.20.10-SNAPSHOT
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


import type { Configuration } from '../configuration';
import type { AxiosPromise, AxiosInstance, RawAxiosRequestConfig } from 'axios';
import globalAxios from 'axios';
// Some imports not used depending on template conditions
// @ts-ignore
import { DUMMY_BASE_URL, assertParamExists, setApiKeyToObject, setBasicAuthToObject, setBearerAuthToObject, setOAuthToObject, setSearchParams, serializeDataIfNeeded, toPathString, createRequestFunction } from '../common';
// @ts-ignore
import { BASE_PATH, COLLECTION_FORMATS, RequestArgs, BaseAPI, RequiredError, operationServerMap } from '../base';
// @ts-ignore
import { Content } from '../models';
// @ts-ignore
import { ContentWrapper } from '../models';
// @ts-ignore
import { ListedSinglePageList } from '../models';
// @ts-ignore
import { ListedSnapshotDto } from '../models';
// @ts-ignore
import { Post } from '../models';
// @ts-ignore
import { RevertSnapshotForSingleParam } from '../models';
// @ts-ignore
import { SinglePage } from '../models';
// @ts-ignore
import { SinglePageRequest } from '../models';
/**
 * SinglePageV1alpha1ConsoleApi - axios parameter creator
 * @export
 */
export const SinglePageV1alpha1ConsoleApiAxiosParamCreator = function (configuration?: Configuration) {
    return {
        /**
         * Delete a content for post.
         * @param {string} name 
         * @param {string} snapshotName 
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        deleteSinglePageContent: async (name: string, snapshotName: string, options: RawAxiosRequestConfig = {}): Promise<RequestArgs> => {
            // verify required parameter 'name' is not null or undefined
            assertParamExists('deleteSinglePageContent', 'name', name)
            // verify required parameter 'snapshotName' is not null or undefined
            assertParamExists('deleteSinglePageContent', 'snapshotName', snapshotName)
            const localVarPath = `/apis/api.console.halo.run/v1alpha1/singlepages/{name}/content`
                .replace(`{${"name"}}`, encodeURIComponent(String(name)));
            // use dummy base URL string because the URL constructor only accepts absolute URLs.
            const localVarUrlObj = new URL(localVarPath, DUMMY_BASE_URL);
            let baseOptions;
            if (configuration) {
                baseOptions = configuration.baseOptions;
            }

            const localVarRequestOptions = { method: 'DELETE', ...baseOptions, ...options};
            const localVarHeaderParameter = {} as any;
            const localVarQueryParameter = {} as any;

            // authentication basicAuth required
            // http basic authentication required
            setBasicAuthToObject(localVarRequestOptions, configuration)

            // authentication bearerAuth required
            // http bearer authentication required
            await setBearerAuthToObject(localVarHeaderParameter, configuration)

            if (snapshotName !== undefined) {
                localVarQueryParameter['snapshotName'] = snapshotName;
            }


    
            setSearchParams(localVarUrlObj, localVarQueryParameter);
            let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
            localVarRequestOptions.headers = {...localVarHeaderParameter, ...headersFromBaseOptions, ...options.headers};

            return {
                url: toPathString(localVarUrlObj),
                options: localVarRequestOptions,
            };
        },
        /**
         * Draft a single page.
         * @param {SinglePageRequest} singlePageRequest 
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        draftSinglePage: async (singlePageRequest: SinglePageRequest, options: RawAxiosRequestConfig = {}): Promise<RequestArgs> => {
            // verify required parameter 'singlePageRequest' is not null or undefined
            assertParamExists('draftSinglePage', 'singlePageRequest', singlePageRequest)
            const localVarPath = `/apis/api.console.halo.run/v1alpha1/singlepages`;
            // use dummy base URL string because the URL constructor only accepts absolute URLs.
            const localVarUrlObj = new URL(localVarPath, DUMMY_BASE_URL);
            let baseOptions;
            if (configuration) {
                baseOptions = configuration.baseOptions;
            }

            const localVarRequestOptions = { method: 'POST', ...baseOptions, ...options};
            const localVarHeaderParameter = {} as any;
            const localVarQueryParameter = {} as any;

            // authentication basicAuth required
            // http basic authentication required
            setBasicAuthToObject(localVarRequestOptions, configuration)

            // authentication bearerAuth required
            // http bearer authentication required
            await setBearerAuthToObject(localVarHeaderParameter, configuration)


    
            localVarHeaderParameter['Content-Type'] = 'application/json';

            setSearchParams(localVarUrlObj, localVarQueryParameter);
            let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
            localVarRequestOptions.headers = {...localVarHeaderParameter, ...headersFromBaseOptions, ...options.headers};
            localVarRequestOptions.data = serializeDataIfNeeded(singlePageRequest, localVarRequestOptions, configuration)

            return {
                url: toPathString(localVarUrlObj),
                options: localVarRequestOptions,
            };
        },
        /**
         * Fetch content of single page.
         * @param {string} name 
         * @param {string} snapshotName 
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        fetchSinglePageContent: async (name: string, snapshotName: string, options: RawAxiosRequestConfig = {}): Promise<RequestArgs> => {
            // verify required parameter 'name' is not null or undefined
            assertParamExists('fetchSinglePageContent', 'name', name)
            // verify required parameter 'snapshotName' is not null or undefined
            assertParamExists('fetchSinglePageContent', 'snapshotName', snapshotName)
            const localVarPath = `/apis/api.console.halo.run/v1alpha1/singlepages/{name}/content`
                .replace(`{${"name"}}`, encodeURIComponent(String(name)));
            // use dummy base URL string because the URL constructor only accepts absolute URLs.
            const localVarUrlObj = new URL(localVarPath, DUMMY_BASE_URL);
            let baseOptions;
            if (configuration) {
                baseOptions = configuration.baseOptions;
            }

            const localVarRequestOptions = { method: 'GET', ...baseOptions, ...options};
            const localVarHeaderParameter = {} as any;
            const localVarQueryParameter = {} as any;

            // authentication basicAuth required
            // http basic authentication required
            setBasicAuthToObject(localVarRequestOptions, configuration)

            // authentication bearerAuth required
            // http bearer authentication required
            await setBearerAuthToObject(localVarHeaderParameter, configuration)

            if (snapshotName !== undefined) {
                localVarQueryParameter['snapshotName'] = snapshotName;
            }


    
            setSearchParams(localVarUrlObj, localVarQueryParameter);
            let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
            localVarRequestOptions.headers = {...localVarHeaderParameter, ...headersFromBaseOptions, ...options.headers};

            return {
                url: toPathString(localVarUrlObj),
                options: localVarRequestOptions,
            };
        },
        /**
         * Fetch head content of single page.
         * @param {string} name 
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        fetchSinglePageHeadContent: async (name: string, options: RawAxiosRequestConfig = {}): Promise<RequestArgs> => {
            // verify required parameter 'name' is not null or undefined
            assertParamExists('fetchSinglePageHeadContent', 'name', name)
            const localVarPath = `/apis/api.console.halo.run/v1alpha1/singlepages/{name}/head-content`
                .replace(`{${"name"}}`, encodeURIComponent(String(name)));
            // use dummy base URL string because the URL constructor only accepts absolute URLs.
            const localVarUrlObj = new URL(localVarPath, DUMMY_BASE_URL);
            let baseOptions;
            if (configuration) {
                baseOptions = configuration.baseOptions;
            }

            const localVarRequestOptions = { method: 'GET', ...baseOptions, ...options};
            const localVarHeaderParameter = {} as any;
            const localVarQueryParameter = {} as any;

            // authentication basicAuth required
            // http basic authentication required
            setBasicAuthToObject(localVarRequestOptions, configuration)

            // authentication bearerAuth required
            // http bearer authentication required
            await setBearerAuthToObject(localVarHeaderParameter, configuration)


    
            setSearchParams(localVarUrlObj, localVarQueryParameter);
            let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
            localVarRequestOptions.headers = {...localVarHeaderParameter, ...headersFromBaseOptions, ...options.headers};

            return {
                url: toPathString(localVarUrlObj),
                options: localVarRequestOptions,
            };
        },
        /**
         * Fetch release content of single page.
         * @param {string} name 
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        fetchSinglePageReleaseContent: async (name: string, options: RawAxiosRequestConfig = {}): Promise<RequestArgs> => {
            // verify required parameter 'name' is not null or undefined
            assertParamExists('fetchSinglePageReleaseContent', 'name', name)
            const localVarPath = `/apis/api.console.halo.run/v1alpha1/singlepages/{name}/release-content`
                .replace(`{${"name"}}`, encodeURIComponent(String(name)));
            // use dummy base URL string because the URL constructor only accepts absolute URLs.
            const localVarUrlObj = new URL(localVarPath, DUMMY_BASE_URL);
            let baseOptions;
            if (configuration) {
                baseOptions = configuration.baseOptions;
            }

            const localVarRequestOptions = { method: 'GET', ...baseOptions, ...options};
            const localVarHeaderParameter = {} as any;
            const localVarQueryParameter = {} as any;

            // authentication basicAuth required
            // http basic authentication required
            setBasicAuthToObject(localVarRequestOptions, configuration)

            // authentication bearerAuth required
            // http bearer authentication required
            await setBearerAuthToObject(localVarHeaderParameter, configuration)


    
            setSearchParams(localVarUrlObj, localVarQueryParameter);
            let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
            localVarRequestOptions.headers = {...localVarHeaderParameter, ...headersFromBaseOptions, ...options.headers};

            return {
                url: toPathString(localVarUrlObj),
                options: localVarRequestOptions,
            };
        },
        /**
         * List all snapshots for single page content.
         * @param {string} name 
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        listSinglePageSnapshots: async (name: string, options: RawAxiosRequestConfig = {}): Promise<RequestArgs> => {
            // verify required parameter 'name' is not null or undefined
            assertParamExists('listSinglePageSnapshots', 'name', name)
            const localVarPath = `/apis/api.console.halo.run/v1alpha1/singlepages/{name}/snapshot`
                .replace(`{${"name"}}`, encodeURIComponent(String(name)));
            // use dummy base URL string because the URL constructor only accepts absolute URLs.
            const localVarUrlObj = new URL(localVarPath, DUMMY_BASE_URL);
            let baseOptions;
            if (configuration) {
                baseOptions = configuration.baseOptions;
            }

            const localVarRequestOptions = { method: 'GET', ...baseOptions, ...options};
            const localVarHeaderParameter = {} as any;
            const localVarQueryParameter = {} as any;

            // authentication basicAuth required
            // http basic authentication required
            setBasicAuthToObject(localVarRequestOptions, configuration)

            // authentication bearerAuth required
            // http bearer authentication required
            await setBearerAuthToObject(localVarHeaderParameter, configuration)


    
            setSearchParams(localVarUrlObj, localVarQueryParameter);
            let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
            localVarRequestOptions.headers = {...localVarHeaderParameter, ...headersFromBaseOptions, ...options.headers};

            return {
                url: toPathString(localVarUrlObj),
                options: localVarRequestOptions,
            };
        },
        /**
         * List single pages.
         * @param {number} [page] Page number. Default is 0.
         * @param {number} [size] Size number. Default is 0.
         * @param {Array<string>} [labelSelector] Label selector. e.g.: hidden!&#x3D;true
         * @param {Array<string>} [fieldSelector] Field selector. e.g.: metadata.name&#x3D;&#x3D;halo
         * @param {Array<string>} [sort] Sorting criteria in the format: property,(asc|desc). Default sort order is ascending. Multiple sort criteria are supported.
         * @param {Array<string>} [contributor] SinglePages filtered by contributor.
         * @param {ListSinglePagesPublishPhaseEnum} [publishPhase] SinglePages filtered by publish phase.
         * @param {ListSinglePagesVisibleEnum} [visible] SinglePages filtered by visibility.
         * @param {string} [keyword] SinglePages filtered by keyword.
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        listSinglePages: async (page?: number, size?: number, labelSelector?: Array<string>, fieldSelector?: Array<string>, sort?: Array<string>, contributor?: Array<string>, publishPhase?: ListSinglePagesPublishPhaseEnum, visible?: ListSinglePagesVisibleEnum, keyword?: string, options: RawAxiosRequestConfig = {}): Promise<RequestArgs> => {
            const localVarPath = `/apis/api.console.halo.run/v1alpha1/singlepages`;
            // use dummy base URL string because the URL constructor only accepts absolute URLs.
            const localVarUrlObj = new URL(localVarPath, DUMMY_BASE_URL);
            let baseOptions;
            if (configuration) {
                baseOptions = configuration.baseOptions;
            }

            const localVarRequestOptions = { method: 'GET', ...baseOptions, ...options};
            const localVarHeaderParameter = {} as any;
            const localVarQueryParameter = {} as any;

            // authentication basicAuth required
            // http basic authentication required
            setBasicAuthToObject(localVarRequestOptions, configuration)

            // authentication bearerAuth required
            // http bearer authentication required
            await setBearerAuthToObject(localVarHeaderParameter, configuration)

            if (page !== undefined) {
                localVarQueryParameter['page'] = page;
            }

            if (size !== undefined) {
                localVarQueryParameter['size'] = size;
            }

            if (labelSelector) {
                localVarQueryParameter['labelSelector'] = labelSelector;
            }

            if (fieldSelector) {
                localVarQueryParameter['fieldSelector'] = fieldSelector;
            }

            if (sort) {
                localVarQueryParameter['sort'] = sort;
            }

            if (contributor) {
                localVarQueryParameter['contributor'] = contributor;
            }

            if (publishPhase !== undefined) {
                localVarQueryParameter['publishPhase'] = publishPhase;
            }

            if (visible !== undefined) {
                localVarQueryParameter['visible'] = visible;
            }

            if (keyword !== undefined) {
                localVarQueryParameter['keyword'] = keyword;
            }


    
            setSearchParams(localVarUrlObj, localVarQueryParameter);
            let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
            localVarRequestOptions.headers = {...localVarHeaderParameter, ...headersFromBaseOptions, ...options.headers};

            return {
                url: toPathString(localVarUrlObj),
                options: localVarRequestOptions,
            };
        },
        /**
         * Publish a single page.
         * @param {string} name 
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        publishSinglePage: async (name: string, options: RawAxiosRequestConfig = {}): Promise<RequestArgs> => {
            // verify required parameter 'name' is not null or undefined
            assertParamExists('publishSinglePage', 'name', name)
            const localVarPath = `/apis/api.console.halo.run/v1alpha1/singlepages/{name}/publish`
                .replace(`{${"name"}}`, encodeURIComponent(String(name)));
            // use dummy base URL string because the URL constructor only accepts absolute URLs.
            const localVarUrlObj = new URL(localVarPath, DUMMY_BASE_URL);
            let baseOptions;
            if (configuration) {
                baseOptions = configuration.baseOptions;
            }

            const localVarRequestOptions = { method: 'PUT', ...baseOptions, ...options};
            const localVarHeaderParameter = {} as any;
            const localVarQueryParameter = {} as any;

            // authentication basicAuth required
            // http basic authentication required
            setBasicAuthToObject(localVarRequestOptions, configuration)

            // authentication bearerAuth required
            // http bearer authentication required
            await setBearerAuthToObject(localVarHeaderParameter, configuration)


    
            setSearchParams(localVarUrlObj, localVarQueryParameter);
            let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
            localVarRequestOptions.headers = {...localVarHeaderParameter, ...headersFromBaseOptions, ...options.headers};

            return {
                url: toPathString(localVarUrlObj),
                options: localVarRequestOptions,
            };
        },
        /**
         * Revert to specified snapshot for single page content.
         * @param {string} name 
         * @param {RevertSnapshotForSingleParam} revertSnapshotForSingleParam 
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        revertToSpecifiedSnapshotForSinglePage: async (name: string, revertSnapshotForSingleParam: RevertSnapshotForSingleParam, options: RawAxiosRequestConfig = {}): Promise<RequestArgs> => {
            // verify required parameter 'name' is not null or undefined
            assertParamExists('revertToSpecifiedSnapshotForSinglePage', 'name', name)
            // verify required parameter 'revertSnapshotForSingleParam' is not null or undefined
            assertParamExists('revertToSpecifiedSnapshotForSinglePage', 'revertSnapshotForSingleParam', revertSnapshotForSingleParam)
            const localVarPath = `/apis/api.console.halo.run/v1alpha1/singlepages/{name}/revert-content`
                .replace(`{${"name"}}`, encodeURIComponent(String(name)));
            // use dummy base URL string because the URL constructor only accepts absolute URLs.
            const localVarUrlObj = new URL(localVarPath, DUMMY_BASE_URL);
            let baseOptions;
            if (configuration) {
                baseOptions = configuration.baseOptions;
            }

            const localVarRequestOptions = { method: 'PUT', ...baseOptions, ...options};
            const localVarHeaderParameter = {} as any;
            const localVarQueryParameter = {} as any;

            // authentication basicAuth required
            // http basic authentication required
            setBasicAuthToObject(localVarRequestOptions, configuration)

            // authentication bearerAuth required
            // http bearer authentication required
            await setBearerAuthToObject(localVarHeaderParameter, configuration)


    
            localVarHeaderParameter['Content-Type'] = 'application/json';

            setSearchParams(localVarUrlObj, localVarQueryParameter);
            let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
            localVarRequestOptions.headers = {...localVarHeaderParameter, ...headersFromBaseOptions, ...options.headers};
            localVarRequestOptions.data = serializeDataIfNeeded(revertSnapshotForSingleParam, localVarRequestOptions, configuration)

            return {
                url: toPathString(localVarUrlObj),
                options: localVarRequestOptions,
            };
        },
        /**
         * Update a single page.
         * @param {string} name 
         * @param {SinglePageRequest} singlePageRequest 
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        updateDraftSinglePage: async (name: string, singlePageRequest: SinglePageRequest, options: RawAxiosRequestConfig = {}): Promise<RequestArgs> => {
            // verify required parameter 'name' is not null or undefined
            assertParamExists('updateDraftSinglePage', 'name', name)
            // verify required parameter 'singlePageRequest' is not null or undefined
            assertParamExists('updateDraftSinglePage', 'singlePageRequest', singlePageRequest)
            const localVarPath = `/apis/api.console.halo.run/v1alpha1/singlepages/{name}`
                .replace(`{${"name"}}`, encodeURIComponent(String(name)));
            // use dummy base URL string because the URL constructor only accepts absolute URLs.
            const localVarUrlObj = new URL(localVarPath, DUMMY_BASE_URL);
            let baseOptions;
            if (configuration) {
                baseOptions = configuration.baseOptions;
            }

            const localVarRequestOptions = { method: 'PUT', ...baseOptions, ...options};
            const localVarHeaderParameter = {} as any;
            const localVarQueryParameter = {} as any;

            // authentication basicAuth required
            // http basic authentication required
            setBasicAuthToObject(localVarRequestOptions, configuration)

            // authentication bearerAuth required
            // http bearer authentication required
            await setBearerAuthToObject(localVarHeaderParameter, configuration)


    
            localVarHeaderParameter['Content-Type'] = 'application/json';

            setSearchParams(localVarUrlObj, localVarQueryParameter);
            let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
            localVarRequestOptions.headers = {...localVarHeaderParameter, ...headersFromBaseOptions, ...options.headers};
            localVarRequestOptions.data = serializeDataIfNeeded(singlePageRequest, localVarRequestOptions, configuration)

            return {
                url: toPathString(localVarUrlObj),
                options: localVarRequestOptions,
            };
        },
        /**
         * Update a single page\'s content.
         * @param {string} name 
         * @param {Content} content 
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        updateSinglePageContent: async (name: string, content: Content, options: RawAxiosRequestConfig = {}): Promise<RequestArgs> => {
            // verify required parameter 'name' is not null or undefined
            assertParamExists('updateSinglePageContent', 'name', name)
            // verify required parameter 'content' is not null or undefined
            assertParamExists('updateSinglePageContent', 'content', content)
            const localVarPath = `/apis/api.console.halo.run/v1alpha1/singlepages/{name}/content`
                .replace(`{${"name"}}`, encodeURIComponent(String(name)));
            // use dummy base URL string because the URL constructor only accepts absolute URLs.
            const localVarUrlObj = new URL(localVarPath, DUMMY_BASE_URL);
            let baseOptions;
            if (configuration) {
                baseOptions = configuration.baseOptions;
            }

            const localVarRequestOptions = { method: 'PUT', ...baseOptions, ...options};
            const localVarHeaderParameter = {} as any;
            const localVarQueryParameter = {} as any;

            // authentication basicAuth required
            // http basic authentication required
            setBasicAuthToObject(localVarRequestOptions, configuration)

            // authentication bearerAuth required
            // http bearer authentication required
            await setBearerAuthToObject(localVarHeaderParameter, configuration)


    
            localVarHeaderParameter['Content-Type'] = 'application/json';

            setSearchParams(localVarUrlObj, localVarQueryParameter);
            let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
            localVarRequestOptions.headers = {...localVarHeaderParameter, ...headersFromBaseOptions, ...options.headers};
            localVarRequestOptions.data = serializeDataIfNeeded(content, localVarRequestOptions, configuration)

            return {
                url: toPathString(localVarUrlObj),
                options: localVarRequestOptions,
            };
        },
    }
};

/**
 * SinglePageV1alpha1ConsoleApi - functional programming interface
 * @export
 */
export const SinglePageV1alpha1ConsoleApiFp = function(configuration?: Configuration) {
    const localVarAxiosParamCreator = SinglePageV1alpha1ConsoleApiAxiosParamCreator(configuration)
    return {
        /**
         * Delete a content for post.
         * @param {string} name 
         * @param {string} snapshotName 
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        async deleteSinglePageContent(name: string, snapshotName: string, options?: RawAxiosRequestConfig): Promise<(axios?: AxiosInstance, basePath?: string) => AxiosPromise<ContentWrapper>> {
            const localVarAxiosArgs = await localVarAxiosParamCreator.deleteSinglePageContent(name, snapshotName, options);
            const localVarOperationServerIndex = configuration?.serverIndex ?? 0;
            const localVarOperationServerBasePath = operationServerMap['SinglePageV1alpha1ConsoleApi.deleteSinglePageContent']?.[localVarOperationServerIndex]?.url;
            return (axios, basePath) => createRequestFunction(localVarAxiosArgs, globalAxios, BASE_PATH, configuration)(axios, localVarOperationServerBasePath || basePath);
        },
        /**
         * Draft a single page.
         * @param {SinglePageRequest} singlePageRequest 
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        async draftSinglePage(singlePageRequest: SinglePageRequest, options?: RawAxiosRequestConfig): Promise<(axios?: AxiosInstance, basePath?: string) => AxiosPromise<SinglePage>> {
            const localVarAxiosArgs = await localVarAxiosParamCreator.draftSinglePage(singlePageRequest, options);
            const localVarOperationServerIndex = configuration?.serverIndex ?? 0;
            const localVarOperationServerBasePath = operationServerMap['SinglePageV1alpha1ConsoleApi.draftSinglePage']?.[localVarOperationServerIndex]?.url;
            return (axios, basePath) => createRequestFunction(localVarAxiosArgs, globalAxios, BASE_PATH, configuration)(axios, localVarOperationServerBasePath || basePath);
        },
        /**
         * Fetch content of single page.
         * @param {string} name 
         * @param {string} snapshotName 
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        async fetchSinglePageContent(name: string, snapshotName: string, options?: RawAxiosRequestConfig): Promise<(axios?: AxiosInstance, basePath?: string) => AxiosPromise<ContentWrapper>> {
            const localVarAxiosArgs = await localVarAxiosParamCreator.fetchSinglePageContent(name, snapshotName, options);
            const localVarOperationServerIndex = configuration?.serverIndex ?? 0;
            const localVarOperationServerBasePath = operationServerMap['SinglePageV1alpha1ConsoleApi.fetchSinglePageContent']?.[localVarOperationServerIndex]?.url;
            return (axios, basePath) => createRequestFunction(localVarAxiosArgs, globalAxios, BASE_PATH, configuration)(axios, localVarOperationServerBasePath || basePath);
        },
        /**
         * Fetch head content of single page.
         * @param {string} name 
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        async fetchSinglePageHeadContent(name: string, options?: RawAxiosRequestConfig): Promise<(axios?: AxiosInstance, basePath?: string) => AxiosPromise<ContentWrapper>> {
            const localVarAxiosArgs = await localVarAxiosParamCreator.fetchSinglePageHeadContent(name, options);
            const localVarOperationServerIndex = configuration?.serverIndex ?? 0;
            const localVarOperationServerBasePath = operationServerMap['SinglePageV1alpha1ConsoleApi.fetchSinglePageHeadContent']?.[localVarOperationServerIndex]?.url;
            return (axios, basePath) => createRequestFunction(localVarAxiosArgs, globalAxios, BASE_PATH, configuration)(axios, localVarOperationServerBasePath || basePath);
        },
        /**
         * Fetch release content of single page.
         * @param {string} name 
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        async fetchSinglePageReleaseContent(name: string, options?: RawAxiosRequestConfig): Promise<(axios?: AxiosInstance, basePath?: string) => AxiosPromise<ContentWrapper>> {
            const localVarAxiosArgs = await localVarAxiosParamCreator.fetchSinglePageReleaseContent(name, options);
            const localVarOperationServerIndex = configuration?.serverIndex ?? 0;
            const localVarOperationServerBasePath = operationServerMap['SinglePageV1alpha1ConsoleApi.fetchSinglePageReleaseContent']?.[localVarOperationServerIndex]?.url;
            return (axios, basePath) => createRequestFunction(localVarAxiosArgs, globalAxios, BASE_PATH, configuration)(axios, localVarOperationServerBasePath || basePath);
        },
        /**
         * List all snapshots for single page content.
         * @param {string} name 
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        async listSinglePageSnapshots(name: string, options?: RawAxiosRequestConfig): Promise<(axios?: AxiosInstance, basePath?: string) => AxiosPromise<Array<ListedSnapshotDto>>> {
            const localVarAxiosArgs = await localVarAxiosParamCreator.listSinglePageSnapshots(name, options);
            const localVarOperationServerIndex = configuration?.serverIndex ?? 0;
            const localVarOperationServerBasePath = operationServerMap['SinglePageV1alpha1ConsoleApi.listSinglePageSnapshots']?.[localVarOperationServerIndex]?.url;
            return (axios, basePath) => createRequestFunction(localVarAxiosArgs, globalAxios, BASE_PATH, configuration)(axios, localVarOperationServerBasePath || basePath);
        },
        /**
         * List single pages.
         * @param {number} [page] Page number. Default is 0.
         * @param {number} [size] Size number. Default is 0.
         * @param {Array<string>} [labelSelector] Label selector. e.g.: hidden!&#x3D;true
         * @param {Array<string>} [fieldSelector] Field selector. e.g.: metadata.name&#x3D;&#x3D;halo
         * @param {Array<string>} [sort] Sorting criteria in the format: property,(asc|desc). Default sort order is ascending. Multiple sort criteria are supported.
         * @param {Array<string>} [contributor] SinglePages filtered by contributor.
         * @param {ListSinglePagesPublishPhaseEnum} [publishPhase] SinglePages filtered by publish phase.
         * @param {ListSinglePagesVisibleEnum} [visible] SinglePages filtered by visibility.
         * @param {string} [keyword] SinglePages filtered by keyword.
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        async listSinglePages(page?: number, size?: number, labelSelector?: Array<string>, fieldSelector?: Array<string>, sort?: Array<string>, contributor?: Array<string>, publishPhase?: ListSinglePagesPublishPhaseEnum, visible?: ListSinglePagesVisibleEnum, keyword?: string, options?: RawAxiosRequestConfig): Promise<(axios?: AxiosInstance, basePath?: string) => AxiosPromise<ListedSinglePageList>> {
            const localVarAxiosArgs = await localVarAxiosParamCreator.listSinglePages(page, size, labelSelector, fieldSelector, sort, contributor, publishPhase, visible, keyword, options);
            const localVarOperationServerIndex = configuration?.serverIndex ?? 0;
            const localVarOperationServerBasePath = operationServerMap['SinglePageV1alpha1ConsoleApi.listSinglePages']?.[localVarOperationServerIndex]?.url;
            return (axios, basePath) => createRequestFunction(localVarAxiosArgs, globalAxios, BASE_PATH, configuration)(axios, localVarOperationServerBasePath || basePath);
        },
        /**
         * Publish a single page.
         * @param {string} name 
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        async publishSinglePage(name: string, options?: RawAxiosRequestConfig): Promise<(axios?: AxiosInstance, basePath?: string) => AxiosPromise<SinglePage>> {
            const localVarAxiosArgs = await localVarAxiosParamCreator.publishSinglePage(name, options);
            const localVarOperationServerIndex = configuration?.serverIndex ?? 0;
            const localVarOperationServerBasePath = operationServerMap['SinglePageV1alpha1ConsoleApi.publishSinglePage']?.[localVarOperationServerIndex]?.url;
            return (axios, basePath) => createRequestFunction(localVarAxiosArgs, globalAxios, BASE_PATH, configuration)(axios, localVarOperationServerBasePath || basePath);
        },
        /**
         * Revert to specified snapshot for single page content.
         * @param {string} name 
         * @param {RevertSnapshotForSingleParam} revertSnapshotForSingleParam 
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        async revertToSpecifiedSnapshotForSinglePage(name: string, revertSnapshotForSingleParam: RevertSnapshotForSingleParam, options?: RawAxiosRequestConfig): Promise<(axios?: AxiosInstance, basePath?: string) => AxiosPromise<Post>> {
            const localVarAxiosArgs = await localVarAxiosParamCreator.revertToSpecifiedSnapshotForSinglePage(name, revertSnapshotForSingleParam, options);
            const localVarOperationServerIndex = configuration?.serverIndex ?? 0;
            const localVarOperationServerBasePath = operationServerMap['SinglePageV1alpha1ConsoleApi.revertToSpecifiedSnapshotForSinglePage']?.[localVarOperationServerIndex]?.url;
            return (axios, basePath) => createRequestFunction(localVarAxiosArgs, globalAxios, BASE_PATH, configuration)(axios, localVarOperationServerBasePath || basePath);
        },
        /**
         * Update a single page.
         * @param {string} name 
         * @param {SinglePageRequest} singlePageRequest 
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        async updateDraftSinglePage(name: string, singlePageRequest: SinglePageRequest, options?: RawAxiosRequestConfig): Promise<(axios?: AxiosInstance, basePath?: string) => AxiosPromise<SinglePage>> {
            const localVarAxiosArgs = await localVarAxiosParamCreator.updateDraftSinglePage(name, singlePageRequest, options);
            const localVarOperationServerIndex = configuration?.serverIndex ?? 0;
            const localVarOperationServerBasePath = operationServerMap['SinglePageV1alpha1ConsoleApi.updateDraftSinglePage']?.[localVarOperationServerIndex]?.url;
            return (axios, basePath) => createRequestFunction(localVarAxiosArgs, globalAxios, BASE_PATH, configuration)(axios, localVarOperationServerBasePath || basePath);
        },
        /**
         * Update a single page\'s content.
         * @param {string} name 
         * @param {Content} content 
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        async updateSinglePageContent(name: string, content: Content, options?: RawAxiosRequestConfig): Promise<(axios?: AxiosInstance, basePath?: string) => AxiosPromise<Post>> {
            const localVarAxiosArgs = await localVarAxiosParamCreator.updateSinglePageContent(name, content, options);
            const localVarOperationServerIndex = configuration?.serverIndex ?? 0;
            const localVarOperationServerBasePath = operationServerMap['SinglePageV1alpha1ConsoleApi.updateSinglePageContent']?.[localVarOperationServerIndex]?.url;
            return (axios, basePath) => createRequestFunction(localVarAxiosArgs, globalAxios, BASE_PATH, configuration)(axios, localVarOperationServerBasePath || basePath);
        },
    }
};

/**
 * SinglePageV1alpha1ConsoleApi - factory interface
 * @export
 */
export const SinglePageV1alpha1ConsoleApiFactory = function (configuration?: Configuration, basePath?: string, axios?: AxiosInstance) {
    const localVarFp = SinglePageV1alpha1ConsoleApiFp(configuration)
    return {
        /**
         * Delete a content for post.
         * @param {SinglePageV1alpha1ConsoleApiDeleteSinglePageContentRequest} requestParameters Request parameters.
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        deleteSinglePageContent(requestParameters: SinglePageV1alpha1ConsoleApiDeleteSinglePageContentRequest, options?: RawAxiosRequestConfig): AxiosPromise<ContentWrapper> {
            return localVarFp.deleteSinglePageContent(requestParameters.name, requestParameters.snapshotName, options).then((request) => request(axios, basePath));
        },
        /**
         * Draft a single page.
         * @param {SinglePageV1alpha1ConsoleApiDraftSinglePageRequest} requestParameters Request parameters.
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        draftSinglePage(requestParameters: SinglePageV1alpha1ConsoleApiDraftSinglePageRequest, options?: RawAxiosRequestConfig): AxiosPromise<SinglePage> {
            return localVarFp.draftSinglePage(requestParameters.singlePageRequest, options).then((request) => request(axios, basePath));
        },
        /**
         * Fetch content of single page.
         * @param {SinglePageV1alpha1ConsoleApiFetchSinglePageContentRequest} requestParameters Request parameters.
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        fetchSinglePageContent(requestParameters: SinglePageV1alpha1ConsoleApiFetchSinglePageContentRequest, options?: RawAxiosRequestConfig): AxiosPromise<ContentWrapper> {
            return localVarFp.fetchSinglePageContent(requestParameters.name, requestParameters.snapshotName, options).then((request) => request(axios, basePath));
        },
        /**
         * Fetch head content of single page.
         * @param {SinglePageV1alpha1ConsoleApiFetchSinglePageHeadContentRequest} requestParameters Request parameters.
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        fetchSinglePageHeadContent(requestParameters: SinglePageV1alpha1ConsoleApiFetchSinglePageHeadContentRequest, options?: RawAxiosRequestConfig): AxiosPromise<ContentWrapper> {
            return localVarFp.fetchSinglePageHeadContent(requestParameters.name, options).then((request) => request(axios, basePath));
        },
        /**
         * Fetch release content of single page.
         * @param {SinglePageV1alpha1ConsoleApiFetchSinglePageReleaseContentRequest} requestParameters Request parameters.
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        fetchSinglePageReleaseContent(requestParameters: SinglePageV1alpha1ConsoleApiFetchSinglePageReleaseContentRequest, options?: RawAxiosRequestConfig): AxiosPromise<ContentWrapper> {
            return localVarFp.fetchSinglePageReleaseContent(requestParameters.name, options).then((request) => request(axios, basePath));
        },
        /**
         * List all snapshots for single page content.
         * @param {SinglePageV1alpha1ConsoleApiListSinglePageSnapshotsRequest} requestParameters Request parameters.
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        listSinglePageSnapshots(requestParameters: SinglePageV1alpha1ConsoleApiListSinglePageSnapshotsRequest, options?: RawAxiosRequestConfig): AxiosPromise<Array<ListedSnapshotDto>> {
            return localVarFp.listSinglePageSnapshots(requestParameters.name, options).then((request) => request(axios, basePath));
        },
        /**
         * List single pages.
         * @param {SinglePageV1alpha1ConsoleApiListSinglePagesRequest} requestParameters Request parameters.
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        listSinglePages(requestParameters: SinglePageV1alpha1ConsoleApiListSinglePagesRequest = {}, options?: RawAxiosRequestConfig): AxiosPromise<ListedSinglePageList> {
            return localVarFp.listSinglePages(requestParameters.page, requestParameters.size, requestParameters.labelSelector, requestParameters.fieldSelector, requestParameters.sort, requestParameters.contributor, requestParameters.publishPhase, requestParameters.visible, requestParameters.keyword, options).then((request) => request(axios, basePath));
        },
        /**
         * Publish a single page.
         * @param {SinglePageV1alpha1ConsoleApiPublishSinglePageRequest} requestParameters Request parameters.
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        publishSinglePage(requestParameters: SinglePageV1alpha1ConsoleApiPublishSinglePageRequest, options?: RawAxiosRequestConfig): AxiosPromise<SinglePage> {
            return localVarFp.publishSinglePage(requestParameters.name, options).then((request) => request(axios, basePath));
        },
        /**
         * Revert to specified snapshot for single page content.
         * @param {SinglePageV1alpha1ConsoleApiRevertToSpecifiedSnapshotForSinglePageRequest} requestParameters Request parameters.
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        revertToSpecifiedSnapshotForSinglePage(requestParameters: SinglePageV1alpha1ConsoleApiRevertToSpecifiedSnapshotForSinglePageRequest, options?: RawAxiosRequestConfig): AxiosPromise<Post> {
            return localVarFp.revertToSpecifiedSnapshotForSinglePage(requestParameters.name, requestParameters.revertSnapshotForSingleParam, options).then((request) => request(axios, basePath));
        },
        /**
         * Update a single page.
         * @param {SinglePageV1alpha1ConsoleApiUpdateDraftSinglePageRequest} requestParameters Request parameters.
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        updateDraftSinglePage(requestParameters: SinglePageV1alpha1ConsoleApiUpdateDraftSinglePageRequest, options?: RawAxiosRequestConfig): AxiosPromise<SinglePage> {
            return localVarFp.updateDraftSinglePage(requestParameters.name, requestParameters.singlePageRequest, options).then((request) => request(axios, basePath));
        },
        /**
         * Update a single page\'s content.
         * @param {SinglePageV1alpha1ConsoleApiUpdateSinglePageContentRequest} requestParameters Request parameters.
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        updateSinglePageContent(requestParameters: SinglePageV1alpha1ConsoleApiUpdateSinglePageContentRequest, options?: RawAxiosRequestConfig): AxiosPromise<Post> {
            return localVarFp.updateSinglePageContent(requestParameters.name, requestParameters.content, options).then((request) => request(axios, basePath));
        },
    };
};

/**
 * Request parameters for deleteSinglePageContent operation in SinglePageV1alpha1ConsoleApi.
 * @export
 * @interface SinglePageV1alpha1ConsoleApiDeleteSinglePageContentRequest
 */
export interface SinglePageV1alpha1ConsoleApiDeleteSinglePageContentRequest {
    /**
     * 
     * @type {string}
     * @memberof SinglePageV1alpha1ConsoleApiDeleteSinglePageContent
     */
    readonly name: string

    /**
     * 
     * @type {string}
     * @memberof SinglePageV1alpha1ConsoleApiDeleteSinglePageContent
     */
    readonly snapshotName: string
}

/**
 * Request parameters for draftSinglePage operation in SinglePageV1alpha1ConsoleApi.
 * @export
 * @interface SinglePageV1alpha1ConsoleApiDraftSinglePageRequest
 */
export interface SinglePageV1alpha1ConsoleApiDraftSinglePageRequest {
    /**
     * 
     * @type {SinglePageRequest}
     * @memberof SinglePageV1alpha1ConsoleApiDraftSinglePage
     */
    readonly singlePageRequest: SinglePageRequest
}

/**
 * Request parameters for fetchSinglePageContent operation in SinglePageV1alpha1ConsoleApi.
 * @export
 * @interface SinglePageV1alpha1ConsoleApiFetchSinglePageContentRequest
 */
export interface SinglePageV1alpha1ConsoleApiFetchSinglePageContentRequest {
    /**
     * 
     * @type {string}
     * @memberof SinglePageV1alpha1ConsoleApiFetchSinglePageContent
     */
    readonly name: string

    /**
     * 
     * @type {string}
     * @memberof SinglePageV1alpha1ConsoleApiFetchSinglePageContent
     */
    readonly snapshotName: string
}

/**
 * Request parameters for fetchSinglePageHeadContent operation in SinglePageV1alpha1ConsoleApi.
 * @export
 * @interface SinglePageV1alpha1ConsoleApiFetchSinglePageHeadContentRequest
 */
export interface SinglePageV1alpha1ConsoleApiFetchSinglePageHeadContentRequest {
    /**
     * 
     * @type {string}
     * @memberof SinglePageV1alpha1ConsoleApiFetchSinglePageHeadContent
     */
    readonly name: string
}

/**
 * Request parameters for fetchSinglePageReleaseContent operation in SinglePageV1alpha1ConsoleApi.
 * @export
 * @interface SinglePageV1alpha1ConsoleApiFetchSinglePageReleaseContentRequest
 */
export interface SinglePageV1alpha1ConsoleApiFetchSinglePageReleaseContentRequest {
    /**
     * 
     * @type {string}
     * @memberof SinglePageV1alpha1ConsoleApiFetchSinglePageReleaseContent
     */
    readonly name: string
}

/**
 * Request parameters for listSinglePageSnapshots operation in SinglePageV1alpha1ConsoleApi.
 * @export
 * @interface SinglePageV1alpha1ConsoleApiListSinglePageSnapshotsRequest
 */
export interface SinglePageV1alpha1ConsoleApiListSinglePageSnapshotsRequest {
    /**
     * 
     * @type {string}
     * @memberof SinglePageV1alpha1ConsoleApiListSinglePageSnapshots
     */
    readonly name: string
}

/**
 * Request parameters for listSinglePages operation in SinglePageV1alpha1ConsoleApi.
 * @export
 * @interface SinglePageV1alpha1ConsoleApiListSinglePagesRequest
 */
export interface SinglePageV1alpha1ConsoleApiListSinglePagesRequest {
    /**
     * Page number. Default is 0.
     * @type {number}
     * @memberof SinglePageV1alpha1ConsoleApiListSinglePages
     */
    readonly page?: number

    /**
     * Size number. Default is 0.
     * @type {number}
     * @memberof SinglePageV1alpha1ConsoleApiListSinglePages
     */
    readonly size?: number

    /**
     * Label selector. e.g.: hidden!&#x3D;true
     * @type {Array<string>}
     * @memberof SinglePageV1alpha1ConsoleApiListSinglePages
     */
    readonly labelSelector?: Array<string>

    /**
     * Field selector. e.g.: metadata.name&#x3D;&#x3D;halo
     * @type {Array<string>}
     * @memberof SinglePageV1alpha1ConsoleApiListSinglePages
     */
    readonly fieldSelector?: Array<string>

    /**
     * Sorting criteria in the format: property,(asc|desc). Default sort order is ascending. Multiple sort criteria are supported.
     * @type {Array<string>}
     * @memberof SinglePageV1alpha1ConsoleApiListSinglePages
     */
    readonly sort?: Array<string>

    /**
     * SinglePages filtered by contributor.
     * @type {Array<string>}
     * @memberof SinglePageV1alpha1ConsoleApiListSinglePages
     */
    readonly contributor?: Array<string>

    /**
     * SinglePages filtered by publish phase.
     * @type {'DRAFT' | 'PENDING_APPROVAL' | 'PUBLISHED' | 'FAILED'}
     * @memberof SinglePageV1alpha1ConsoleApiListSinglePages
     */
    readonly publishPhase?: ListSinglePagesPublishPhaseEnum

    /**
     * SinglePages filtered by visibility.
     * @type {'PUBLIC' | 'INTERNAL' | 'PRIVATE'}
     * @memberof SinglePageV1alpha1ConsoleApiListSinglePages
     */
    readonly visible?: ListSinglePagesVisibleEnum

    /**
     * SinglePages filtered by keyword.
     * @type {string}
     * @memberof SinglePageV1alpha1ConsoleApiListSinglePages
     */
    readonly keyword?: string
}

/**
 * Request parameters for publishSinglePage operation in SinglePageV1alpha1ConsoleApi.
 * @export
 * @interface SinglePageV1alpha1ConsoleApiPublishSinglePageRequest
 */
export interface SinglePageV1alpha1ConsoleApiPublishSinglePageRequest {
    /**
     * 
     * @type {string}
     * @memberof SinglePageV1alpha1ConsoleApiPublishSinglePage
     */
    readonly name: string
}

/**
 * Request parameters for revertToSpecifiedSnapshotForSinglePage operation in SinglePageV1alpha1ConsoleApi.
 * @export
 * @interface SinglePageV1alpha1ConsoleApiRevertToSpecifiedSnapshotForSinglePageRequest
 */
export interface SinglePageV1alpha1ConsoleApiRevertToSpecifiedSnapshotForSinglePageRequest {
    /**
     * 
     * @type {string}
     * @memberof SinglePageV1alpha1ConsoleApiRevertToSpecifiedSnapshotForSinglePage
     */
    readonly name: string

    /**
     * 
     * @type {RevertSnapshotForSingleParam}
     * @memberof SinglePageV1alpha1ConsoleApiRevertToSpecifiedSnapshotForSinglePage
     */
    readonly revertSnapshotForSingleParam: RevertSnapshotForSingleParam
}

/**
 * Request parameters for updateDraftSinglePage operation in SinglePageV1alpha1ConsoleApi.
 * @export
 * @interface SinglePageV1alpha1ConsoleApiUpdateDraftSinglePageRequest
 */
export interface SinglePageV1alpha1ConsoleApiUpdateDraftSinglePageRequest {
    /**
     * 
     * @type {string}
     * @memberof SinglePageV1alpha1ConsoleApiUpdateDraftSinglePage
     */
    readonly name: string

    /**
     * 
     * @type {SinglePageRequest}
     * @memberof SinglePageV1alpha1ConsoleApiUpdateDraftSinglePage
     */
    readonly singlePageRequest: SinglePageRequest
}

/**
 * Request parameters for updateSinglePageContent operation in SinglePageV1alpha1ConsoleApi.
 * @export
 * @interface SinglePageV1alpha1ConsoleApiUpdateSinglePageContentRequest
 */
export interface SinglePageV1alpha1ConsoleApiUpdateSinglePageContentRequest {
    /**
     * 
     * @type {string}
     * @memberof SinglePageV1alpha1ConsoleApiUpdateSinglePageContent
     */
    readonly name: string

    /**
     * 
     * @type {Content}
     * @memberof SinglePageV1alpha1ConsoleApiUpdateSinglePageContent
     */
    readonly content: Content
}

/**
 * SinglePageV1alpha1ConsoleApi - object-oriented interface
 * @export
 * @class SinglePageV1alpha1ConsoleApi
 * @extends {BaseAPI}
 */
export class SinglePageV1alpha1ConsoleApi extends BaseAPI {
    /**
     * Delete a content for post.
     * @param {SinglePageV1alpha1ConsoleApiDeleteSinglePageContentRequest} requestParameters Request parameters.
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof SinglePageV1alpha1ConsoleApi
     */
    public deleteSinglePageContent(requestParameters: SinglePageV1alpha1ConsoleApiDeleteSinglePageContentRequest, options?: RawAxiosRequestConfig) {
        return SinglePageV1alpha1ConsoleApiFp(this.configuration).deleteSinglePageContent(requestParameters.name, requestParameters.snapshotName, options).then((request) => request(this.axios, this.basePath));
    }

    /**
     * Draft a single page.
     * @param {SinglePageV1alpha1ConsoleApiDraftSinglePageRequest} requestParameters Request parameters.
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof SinglePageV1alpha1ConsoleApi
     */
    public draftSinglePage(requestParameters: SinglePageV1alpha1ConsoleApiDraftSinglePageRequest, options?: RawAxiosRequestConfig) {
        return SinglePageV1alpha1ConsoleApiFp(this.configuration).draftSinglePage(requestParameters.singlePageRequest, options).then((request) => request(this.axios, this.basePath));
    }

    /**
     * Fetch content of single page.
     * @param {SinglePageV1alpha1ConsoleApiFetchSinglePageContentRequest} requestParameters Request parameters.
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof SinglePageV1alpha1ConsoleApi
     */
    public fetchSinglePageContent(requestParameters: SinglePageV1alpha1ConsoleApiFetchSinglePageContentRequest, options?: RawAxiosRequestConfig) {
        return SinglePageV1alpha1ConsoleApiFp(this.configuration).fetchSinglePageContent(requestParameters.name, requestParameters.snapshotName, options).then((request) => request(this.axios, this.basePath));
    }

    /**
     * Fetch head content of single page.
     * @param {SinglePageV1alpha1ConsoleApiFetchSinglePageHeadContentRequest} requestParameters Request parameters.
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof SinglePageV1alpha1ConsoleApi
     */
    public fetchSinglePageHeadContent(requestParameters: SinglePageV1alpha1ConsoleApiFetchSinglePageHeadContentRequest, options?: RawAxiosRequestConfig) {
        return SinglePageV1alpha1ConsoleApiFp(this.configuration).fetchSinglePageHeadContent(requestParameters.name, options).then((request) => request(this.axios, this.basePath));
    }

    /**
     * Fetch release content of single page.
     * @param {SinglePageV1alpha1ConsoleApiFetchSinglePageReleaseContentRequest} requestParameters Request parameters.
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof SinglePageV1alpha1ConsoleApi
     */
    public fetchSinglePageReleaseContent(requestParameters: SinglePageV1alpha1ConsoleApiFetchSinglePageReleaseContentRequest, options?: RawAxiosRequestConfig) {
        return SinglePageV1alpha1ConsoleApiFp(this.configuration).fetchSinglePageReleaseContent(requestParameters.name, options).then((request) => request(this.axios, this.basePath));
    }

    /**
     * List all snapshots for single page content.
     * @param {SinglePageV1alpha1ConsoleApiListSinglePageSnapshotsRequest} requestParameters Request parameters.
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof SinglePageV1alpha1ConsoleApi
     */
    public listSinglePageSnapshots(requestParameters: SinglePageV1alpha1ConsoleApiListSinglePageSnapshotsRequest, options?: RawAxiosRequestConfig) {
        return SinglePageV1alpha1ConsoleApiFp(this.configuration).listSinglePageSnapshots(requestParameters.name, options).then((request) => request(this.axios, this.basePath));
    }

    /**
     * List single pages.
     * @param {SinglePageV1alpha1ConsoleApiListSinglePagesRequest} requestParameters Request parameters.
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof SinglePageV1alpha1ConsoleApi
     */
    public listSinglePages(requestParameters: SinglePageV1alpha1ConsoleApiListSinglePagesRequest = {}, options?: RawAxiosRequestConfig) {
        return SinglePageV1alpha1ConsoleApiFp(this.configuration).listSinglePages(requestParameters.page, requestParameters.size, requestParameters.labelSelector, requestParameters.fieldSelector, requestParameters.sort, requestParameters.contributor, requestParameters.publishPhase, requestParameters.visible, requestParameters.keyword, options).then((request) => request(this.axios, this.basePath));
    }

    /**
     * Publish a single page.
     * @param {SinglePageV1alpha1ConsoleApiPublishSinglePageRequest} requestParameters Request parameters.
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof SinglePageV1alpha1ConsoleApi
     */
    public publishSinglePage(requestParameters: SinglePageV1alpha1ConsoleApiPublishSinglePageRequest, options?: RawAxiosRequestConfig) {
        return SinglePageV1alpha1ConsoleApiFp(this.configuration).publishSinglePage(requestParameters.name, options).then((request) => request(this.axios, this.basePath));
    }

    /**
     * Revert to specified snapshot for single page content.
     * @param {SinglePageV1alpha1ConsoleApiRevertToSpecifiedSnapshotForSinglePageRequest} requestParameters Request parameters.
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof SinglePageV1alpha1ConsoleApi
     */
    public revertToSpecifiedSnapshotForSinglePage(requestParameters: SinglePageV1alpha1ConsoleApiRevertToSpecifiedSnapshotForSinglePageRequest, options?: RawAxiosRequestConfig) {
        return SinglePageV1alpha1ConsoleApiFp(this.configuration).revertToSpecifiedSnapshotForSinglePage(requestParameters.name, requestParameters.revertSnapshotForSingleParam, options).then((request) => request(this.axios, this.basePath));
    }

    /**
     * Update a single page.
     * @param {SinglePageV1alpha1ConsoleApiUpdateDraftSinglePageRequest} requestParameters Request parameters.
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof SinglePageV1alpha1ConsoleApi
     */
    public updateDraftSinglePage(requestParameters: SinglePageV1alpha1ConsoleApiUpdateDraftSinglePageRequest, options?: RawAxiosRequestConfig) {
        return SinglePageV1alpha1ConsoleApiFp(this.configuration).updateDraftSinglePage(requestParameters.name, requestParameters.singlePageRequest, options).then((request) => request(this.axios, this.basePath));
    }

    /**
     * Update a single page\'s content.
     * @param {SinglePageV1alpha1ConsoleApiUpdateSinglePageContentRequest} requestParameters Request parameters.
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof SinglePageV1alpha1ConsoleApi
     */
    public updateSinglePageContent(requestParameters: SinglePageV1alpha1ConsoleApiUpdateSinglePageContentRequest, options?: RawAxiosRequestConfig) {
        return SinglePageV1alpha1ConsoleApiFp(this.configuration).updateSinglePageContent(requestParameters.name, requestParameters.content, options).then((request) => request(this.axios, this.basePath));
    }
}

/**
 * @export
 */
export const ListSinglePagesPublishPhaseEnum = {
    Draft: 'DRAFT',
    PendingApproval: 'PENDING_APPROVAL',
    Published: 'PUBLISHED',
    Failed: 'FAILED'
} as const;
export type ListSinglePagesPublishPhaseEnum = typeof ListSinglePagesPublishPhaseEnum[keyof typeof ListSinglePagesPublishPhaseEnum];
/**
 * @export
 */
export const ListSinglePagesVisibleEnum = {
    Public: 'PUBLIC',
    Internal: 'INTERNAL',
    Private: 'PRIVATE'
} as const;
export type ListSinglePagesVisibleEnum = typeof ListSinglePagesVisibleEnum[keyof typeof ListSinglePagesVisibleEnum];
