/* tslint:disable */
/* eslint-disable */
/**
 * Halo
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: 2.20.10-SNAPSHOT
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


import type { Configuration } from '../configuration';
import type { AxiosPromise, AxiosInstance, RawAxiosRequestConfig } from 'axios';
import globalAxios from 'axios';
// Some imports not used depending on template conditions
// @ts-ignore
import { DUMMY_BASE_URL, assertParamExists, setApiKeyToObject, setBasicAuthToObject, setBearerAuthToObject, setOAuthToObject, setSearchParams, serializeDataIfNeeded, toPathString, createRequestFunction } from '../common';
// @ts-ignore
import { BASE_PATH, COLLECTION_FORMATS, RequestArgs, BaseAPI, RequiredError, operationServerMap } from '../base';
// @ts-ignore
import { JsonPatchInner } from '../models';
// @ts-ignore
import { Subscription } from '../models';
// @ts-ignore
import { SubscriptionList } from '../models';
/**
 * SubscriptionV1alpha1Api - axios parameter creator
 * @export
 */
export const SubscriptionV1alpha1ApiAxiosParamCreator = function (configuration?: Configuration) {
    return {
        /**
         * Create Subscription
         * @param {Subscription} [subscription] Fresh subscription
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        createSubscription: async (subscription?: Subscription, options: RawAxiosRequestConfig = {}): Promise<RequestArgs> => {
            const localVarPath = `/apis/notification.halo.run/v1alpha1/subscriptions`;
            // use dummy base URL string because the URL constructor only accepts absolute URLs.
            const localVarUrlObj = new URL(localVarPath, DUMMY_BASE_URL);
            let baseOptions;
            if (configuration) {
                baseOptions = configuration.baseOptions;
            }

            const localVarRequestOptions = { method: 'POST', ...baseOptions, ...options};
            const localVarHeaderParameter = {} as any;
            const localVarQueryParameter = {} as any;

            // authentication basicAuth required
            // http basic authentication required
            setBasicAuthToObject(localVarRequestOptions, configuration)

            // authentication bearerAuth required
            // http bearer authentication required
            await setBearerAuthToObject(localVarHeaderParameter, configuration)


    
            localVarHeaderParameter['Content-Type'] = 'application/json';

            setSearchParams(localVarUrlObj, localVarQueryParameter);
            let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
            localVarRequestOptions.headers = {...localVarHeaderParameter, ...headersFromBaseOptions, ...options.headers};
            localVarRequestOptions.data = serializeDataIfNeeded(subscription, localVarRequestOptions, configuration)

            return {
                url: toPathString(localVarUrlObj),
                options: localVarRequestOptions,
            };
        },
        /**
         * Delete Subscription
         * @param {string} name Name of subscription
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        deleteSubscription: async (name: string, options: RawAxiosRequestConfig = {}): Promise<RequestArgs> => {
            // verify required parameter 'name' is not null or undefined
            assertParamExists('deleteSubscription', 'name', name)
            const localVarPath = `/apis/notification.halo.run/v1alpha1/subscriptions/{name}`
                .replace(`{${"name"}}`, encodeURIComponent(String(name)));
            // use dummy base URL string because the URL constructor only accepts absolute URLs.
            const localVarUrlObj = new URL(localVarPath, DUMMY_BASE_URL);
            let baseOptions;
            if (configuration) {
                baseOptions = configuration.baseOptions;
            }

            const localVarRequestOptions = { method: 'DELETE', ...baseOptions, ...options};
            const localVarHeaderParameter = {} as any;
            const localVarQueryParameter = {} as any;

            // authentication basicAuth required
            // http basic authentication required
            setBasicAuthToObject(localVarRequestOptions, configuration)

            // authentication bearerAuth required
            // http bearer authentication required
            await setBearerAuthToObject(localVarHeaderParameter, configuration)


    
            setSearchParams(localVarUrlObj, localVarQueryParameter);
            let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
            localVarRequestOptions.headers = {...localVarHeaderParameter, ...headersFromBaseOptions, ...options.headers};

            return {
                url: toPathString(localVarUrlObj),
                options: localVarRequestOptions,
            };
        },
        /**
         * Get Subscription
         * @param {string} name Name of subscription
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        getSubscription: async (name: string, options: RawAxiosRequestConfig = {}): Promise<RequestArgs> => {
            // verify required parameter 'name' is not null or undefined
            assertParamExists('getSubscription', 'name', name)
            const localVarPath = `/apis/notification.halo.run/v1alpha1/subscriptions/{name}`
                .replace(`{${"name"}}`, encodeURIComponent(String(name)));
            // use dummy base URL string because the URL constructor only accepts absolute URLs.
            const localVarUrlObj = new URL(localVarPath, DUMMY_BASE_URL);
            let baseOptions;
            if (configuration) {
                baseOptions = configuration.baseOptions;
            }

            const localVarRequestOptions = { method: 'GET', ...baseOptions, ...options};
            const localVarHeaderParameter = {} as any;
            const localVarQueryParameter = {} as any;

            // authentication basicAuth required
            // http basic authentication required
            setBasicAuthToObject(localVarRequestOptions, configuration)

            // authentication bearerAuth required
            // http bearer authentication required
            await setBearerAuthToObject(localVarHeaderParameter, configuration)


    
            setSearchParams(localVarUrlObj, localVarQueryParameter);
            let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
            localVarRequestOptions.headers = {...localVarHeaderParameter, ...headersFromBaseOptions, ...options.headers};

            return {
                url: toPathString(localVarUrlObj),
                options: localVarRequestOptions,
            };
        },
        /**
         * List Subscription
         * @param {number} [page] Page number. Default is 0.
         * @param {number} [size] Size number. Default is 0.
         * @param {Array<string>} [labelSelector] Label selector. e.g.: hidden!&#x3D;true
         * @param {Array<string>} [fieldSelector] Field selector. e.g.: metadata.name&#x3D;&#x3D;halo
         * @param {Array<string>} [sort] Sorting criteria in the format: property,(asc|desc). Default sort order is ascending. Multiple sort criteria are supported.
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        listSubscription: async (page?: number, size?: number, labelSelector?: Array<string>, fieldSelector?: Array<string>, sort?: Array<string>, options: RawAxiosRequestConfig = {}): Promise<RequestArgs> => {
            const localVarPath = `/apis/notification.halo.run/v1alpha1/subscriptions`;
            // use dummy base URL string because the URL constructor only accepts absolute URLs.
            const localVarUrlObj = new URL(localVarPath, DUMMY_BASE_URL);
            let baseOptions;
            if (configuration) {
                baseOptions = configuration.baseOptions;
            }

            const localVarRequestOptions = { method: 'GET', ...baseOptions, ...options};
            const localVarHeaderParameter = {} as any;
            const localVarQueryParameter = {} as any;

            // authentication basicAuth required
            // http basic authentication required
            setBasicAuthToObject(localVarRequestOptions, configuration)

            // authentication bearerAuth required
            // http bearer authentication required
            await setBearerAuthToObject(localVarHeaderParameter, configuration)

            if (page !== undefined) {
                localVarQueryParameter['page'] = page;
            }

            if (size !== undefined) {
                localVarQueryParameter['size'] = size;
            }

            if (labelSelector) {
                localVarQueryParameter['labelSelector'] = labelSelector;
            }

            if (fieldSelector) {
                localVarQueryParameter['fieldSelector'] = fieldSelector;
            }

            if (sort) {
                localVarQueryParameter['sort'] = sort;
            }


    
            setSearchParams(localVarUrlObj, localVarQueryParameter);
            let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
            localVarRequestOptions.headers = {...localVarHeaderParameter, ...headersFromBaseOptions, ...options.headers};

            return {
                url: toPathString(localVarUrlObj),
                options: localVarRequestOptions,
            };
        },
        /**
         * Patch Subscription
         * @param {string} name Name of subscription
         * @param {Array<JsonPatchInner>} [jsonPatchInner] 
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        patchSubscription: async (name: string, jsonPatchInner?: Array<JsonPatchInner>, options: RawAxiosRequestConfig = {}): Promise<RequestArgs> => {
            // verify required parameter 'name' is not null or undefined
            assertParamExists('patchSubscription', 'name', name)
            const localVarPath = `/apis/notification.halo.run/v1alpha1/subscriptions/{name}`
                .replace(`{${"name"}}`, encodeURIComponent(String(name)));
            // use dummy base URL string because the URL constructor only accepts absolute URLs.
            const localVarUrlObj = new URL(localVarPath, DUMMY_BASE_URL);
            let baseOptions;
            if (configuration) {
                baseOptions = configuration.baseOptions;
            }

            const localVarRequestOptions = { method: 'PATCH', ...baseOptions, ...options};
            const localVarHeaderParameter = {} as any;
            const localVarQueryParameter = {} as any;

            // authentication basicAuth required
            // http basic authentication required
            setBasicAuthToObject(localVarRequestOptions, configuration)

            // authentication bearerAuth required
            // http bearer authentication required
            await setBearerAuthToObject(localVarHeaderParameter, configuration)


    
            localVarHeaderParameter['Content-Type'] = 'application/json-patch+json';

            setSearchParams(localVarUrlObj, localVarQueryParameter);
            let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
            localVarRequestOptions.headers = {...localVarHeaderParameter, ...headersFromBaseOptions, ...options.headers};
            localVarRequestOptions.data = serializeDataIfNeeded(jsonPatchInner, localVarRequestOptions, configuration)

            return {
                url: toPathString(localVarUrlObj),
                options: localVarRequestOptions,
            };
        },
        /**
         * Update Subscription
         * @param {string} name Name of subscription
         * @param {Subscription} [subscription] Updated subscription
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        updateSubscription: async (name: string, subscription?: Subscription, options: RawAxiosRequestConfig = {}): Promise<RequestArgs> => {
            // verify required parameter 'name' is not null or undefined
            assertParamExists('updateSubscription', 'name', name)
            const localVarPath = `/apis/notification.halo.run/v1alpha1/subscriptions/{name}`
                .replace(`{${"name"}}`, encodeURIComponent(String(name)));
            // use dummy base URL string because the URL constructor only accepts absolute URLs.
            const localVarUrlObj = new URL(localVarPath, DUMMY_BASE_URL);
            let baseOptions;
            if (configuration) {
                baseOptions = configuration.baseOptions;
            }

            const localVarRequestOptions = { method: 'PUT', ...baseOptions, ...options};
            const localVarHeaderParameter = {} as any;
            const localVarQueryParameter = {} as any;

            // authentication basicAuth required
            // http basic authentication required
            setBasicAuthToObject(localVarRequestOptions, configuration)

            // authentication bearerAuth required
            // http bearer authentication required
            await setBearerAuthToObject(localVarHeaderParameter, configuration)


    
            localVarHeaderParameter['Content-Type'] = 'application/json';

            setSearchParams(localVarUrlObj, localVarQueryParameter);
            let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
            localVarRequestOptions.headers = {...localVarHeaderParameter, ...headersFromBaseOptions, ...options.headers};
            localVarRequestOptions.data = serializeDataIfNeeded(subscription, localVarRequestOptions, configuration)

            return {
                url: toPathString(localVarUrlObj),
                options: localVarRequestOptions,
            };
        },
    }
};

/**
 * SubscriptionV1alpha1Api - functional programming interface
 * @export
 */
export const SubscriptionV1alpha1ApiFp = function(configuration?: Configuration) {
    const localVarAxiosParamCreator = SubscriptionV1alpha1ApiAxiosParamCreator(configuration)
    return {
        /**
         * Create Subscription
         * @param {Subscription} [subscription] Fresh subscription
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        async createSubscription(subscription?: Subscription, options?: RawAxiosRequestConfig): Promise<(axios?: AxiosInstance, basePath?: string) => AxiosPromise<Subscription>> {
            const localVarAxiosArgs = await localVarAxiosParamCreator.createSubscription(subscription, options);
            const localVarOperationServerIndex = configuration?.serverIndex ?? 0;
            const localVarOperationServerBasePath = operationServerMap['SubscriptionV1alpha1Api.createSubscription']?.[localVarOperationServerIndex]?.url;
            return (axios, basePath) => createRequestFunction(localVarAxiosArgs, globalAxios, BASE_PATH, configuration)(axios, localVarOperationServerBasePath || basePath);
        },
        /**
         * Delete Subscription
         * @param {string} name Name of subscription
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        async deleteSubscription(name: string, options?: RawAxiosRequestConfig): Promise<(axios?: AxiosInstance, basePath?: string) => AxiosPromise<void>> {
            const localVarAxiosArgs = await localVarAxiosParamCreator.deleteSubscription(name, options);
            const localVarOperationServerIndex = configuration?.serverIndex ?? 0;
            const localVarOperationServerBasePath = operationServerMap['SubscriptionV1alpha1Api.deleteSubscription']?.[localVarOperationServerIndex]?.url;
            return (axios, basePath) => createRequestFunction(localVarAxiosArgs, globalAxios, BASE_PATH, configuration)(axios, localVarOperationServerBasePath || basePath);
        },
        /**
         * Get Subscription
         * @param {string} name Name of subscription
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        async getSubscription(name: string, options?: RawAxiosRequestConfig): Promise<(axios?: AxiosInstance, basePath?: string) => AxiosPromise<Subscription>> {
            const localVarAxiosArgs = await localVarAxiosParamCreator.getSubscription(name, options);
            const localVarOperationServerIndex = configuration?.serverIndex ?? 0;
            const localVarOperationServerBasePath = operationServerMap['SubscriptionV1alpha1Api.getSubscription']?.[localVarOperationServerIndex]?.url;
            return (axios, basePath) => createRequestFunction(localVarAxiosArgs, globalAxios, BASE_PATH, configuration)(axios, localVarOperationServerBasePath || basePath);
        },
        /**
         * List Subscription
         * @param {number} [page] Page number. Default is 0.
         * @param {number} [size] Size number. Default is 0.
         * @param {Array<string>} [labelSelector] Label selector. e.g.: hidden!&#x3D;true
         * @param {Array<string>} [fieldSelector] Field selector. e.g.: metadata.name&#x3D;&#x3D;halo
         * @param {Array<string>} [sort] Sorting criteria in the format: property,(asc|desc). Default sort order is ascending. Multiple sort criteria are supported.
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        async listSubscription(page?: number, size?: number, labelSelector?: Array<string>, fieldSelector?: Array<string>, sort?: Array<string>, options?: RawAxiosRequestConfig): Promise<(axios?: AxiosInstance, basePath?: string) => AxiosPromise<SubscriptionList>> {
            const localVarAxiosArgs = await localVarAxiosParamCreator.listSubscription(page, size, labelSelector, fieldSelector, sort, options);
            const localVarOperationServerIndex = configuration?.serverIndex ?? 0;
            const localVarOperationServerBasePath = operationServerMap['SubscriptionV1alpha1Api.listSubscription']?.[localVarOperationServerIndex]?.url;
            return (axios, basePath) => createRequestFunction(localVarAxiosArgs, globalAxios, BASE_PATH, configuration)(axios, localVarOperationServerBasePath || basePath);
        },
        /**
         * Patch Subscription
         * @param {string} name Name of subscription
         * @param {Array<JsonPatchInner>} [jsonPatchInner] 
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        async patchSubscription(name: string, jsonPatchInner?: Array<JsonPatchInner>, options?: RawAxiosRequestConfig): Promise<(axios?: AxiosInstance, basePath?: string) => AxiosPromise<Subscription>> {
            const localVarAxiosArgs = await localVarAxiosParamCreator.patchSubscription(name, jsonPatchInner, options);
            const localVarOperationServerIndex = configuration?.serverIndex ?? 0;
            const localVarOperationServerBasePath = operationServerMap['SubscriptionV1alpha1Api.patchSubscription']?.[localVarOperationServerIndex]?.url;
            return (axios, basePath) => createRequestFunction(localVarAxiosArgs, globalAxios, BASE_PATH, configuration)(axios, localVarOperationServerBasePath || basePath);
        },
        /**
         * Update Subscription
         * @param {string} name Name of subscription
         * @param {Subscription} [subscription] Updated subscription
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        async updateSubscription(name: string, subscription?: Subscription, options?: RawAxiosRequestConfig): Promise<(axios?: AxiosInstance, basePath?: string) => AxiosPromise<Subscription>> {
            const localVarAxiosArgs = await localVarAxiosParamCreator.updateSubscription(name, subscription, options);
            const localVarOperationServerIndex = configuration?.serverIndex ?? 0;
            const localVarOperationServerBasePath = operationServerMap['SubscriptionV1alpha1Api.updateSubscription']?.[localVarOperationServerIndex]?.url;
            return (axios, basePath) => createRequestFunction(localVarAxiosArgs, globalAxios, BASE_PATH, configuration)(axios, localVarOperationServerBasePath || basePath);
        },
    }
};

/**
 * SubscriptionV1alpha1Api - factory interface
 * @export
 */
export const SubscriptionV1alpha1ApiFactory = function (configuration?: Configuration, basePath?: string, axios?: AxiosInstance) {
    const localVarFp = SubscriptionV1alpha1ApiFp(configuration)
    return {
        /**
         * Create Subscription
         * @param {SubscriptionV1alpha1ApiCreateSubscriptionRequest} requestParameters Request parameters.
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        createSubscription(requestParameters: SubscriptionV1alpha1ApiCreateSubscriptionRequest = {}, options?: RawAxiosRequestConfig): AxiosPromise<Subscription> {
            return localVarFp.createSubscription(requestParameters.subscription, options).then((request) => request(axios, basePath));
        },
        /**
         * Delete Subscription
         * @param {SubscriptionV1alpha1ApiDeleteSubscriptionRequest} requestParameters Request parameters.
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        deleteSubscription(requestParameters: SubscriptionV1alpha1ApiDeleteSubscriptionRequest, options?: RawAxiosRequestConfig): AxiosPromise<void> {
            return localVarFp.deleteSubscription(requestParameters.name, options).then((request) => request(axios, basePath));
        },
        /**
         * Get Subscription
         * @param {SubscriptionV1alpha1ApiGetSubscriptionRequest} requestParameters Request parameters.
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        getSubscription(requestParameters: SubscriptionV1alpha1ApiGetSubscriptionRequest, options?: RawAxiosRequestConfig): AxiosPromise<Subscription> {
            return localVarFp.getSubscription(requestParameters.name, options).then((request) => request(axios, basePath));
        },
        /**
         * List Subscription
         * @param {SubscriptionV1alpha1ApiListSubscriptionRequest} requestParameters Request parameters.
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        listSubscription(requestParameters: SubscriptionV1alpha1ApiListSubscriptionRequest = {}, options?: RawAxiosRequestConfig): AxiosPromise<SubscriptionList> {
            return localVarFp.listSubscription(requestParameters.page, requestParameters.size, requestParameters.labelSelector, requestParameters.fieldSelector, requestParameters.sort, options).then((request) => request(axios, basePath));
        },
        /**
         * Patch Subscription
         * @param {SubscriptionV1alpha1ApiPatchSubscriptionRequest} requestParameters Request parameters.
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        patchSubscription(requestParameters: SubscriptionV1alpha1ApiPatchSubscriptionRequest, options?: RawAxiosRequestConfig): AxiosPromise<Subscription> {
            return localVarFp.patchSubscription(requestParameters.name, requestParameters.jsonPatchInner, options).then((request) => request(axios, basePath));
        },
        /**
         * Update Subscription
         * @param {SubscriptionV1alpha1ApiUpdateSubscriptionRequest} requestParameters Request parameters.
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        updateSubscription(requestParameters: SubscriptionV1alpha1ApiUpdateSubscriptionRequest, options?: RawAxiosRequestConfig): AxiosPromise<Subscription> {
            return localVarFp.updateSubscription(requestParameters.name, requestParameters.subscription, options).then((request) => request(axios, basePath));
        },
    };
};

/**
 * Request parameters for createSubscription operation in SubscriptionV1alpha1Api.
 * @export
 * @interface SubscriptionV1alpha1ApiCreateSubscriptionRequest
 */
export interface SubscriptionV1alpha1ApiCreateSubscriptionRequest {
    /**
     * Fresh subscription
     * @type {Subscription}
     * @memberof SubscriptionV1alpha1ApiCreateSubscription
     */
    readonly subscription?: Subscription
}

/**
 * Request parameters for deleteSubscription operation in SubscriptionV1alpha1Api.
 * @export
 * @interface SubscriptionV1alpha1ApiDeleteSubscriptionRequest
 */
export interface SubscriptionV1alpha1ApiDeleteSubscriptionRequest {
    /**
     * Name of subscription
     * @type {string}
     * @memberof SubscriptionV1alpha1ApiDeleteSubscription
     */
    readonly name: string
}

/**
 * Request parameters for getSubscription operation in SubscriptionV1alpha1Api.
 * @export
 * @interface SubscriptionV1alpha1ApiGetSubscriptionRequest
 */
export interface SubscriptionV1alpha1ApiGetSubscriptionRequest {
    /**
     * Name of subscription
     * @type {string}
     * @memberof SubscriptionV1alpha1ApiGetSubscription
     */
    readonly name: string
}

/**
 * Request parameters for listSubscription operation in SubscriptionV1alpha1Api.
 * @export
 * @interface SubscriptionV1alpha1ApiListSubscriptionRequest
 */
export interface SubscriptionV1alpha1ApiListSubscriptionRequest {
    /**
     * Page number. Default is 0.
     * @type {number}
     * @memberof SubscriptionV1alpha1ApiListSubscription
     */
    readonly page?: number

    /**
     * Size number. Default is 0.
     * @type {number}
     * @memberof SubscriptionV1alpha1ApiListSubscription
     */
    readonly size?: number

    /**
     * Label selector. e.g.: hidden!&#x3D;true
     * @type {Array<string>}
     * @memberof SubscriptionV1alpha1ApiListSubscription
     */
    readonly labelSelector?: Array<string>

    /**
     * Field selector. e.g.: metadata.name&#x3D;&#x3D;halo
     * @type {Array<string>}
     * @memberof SubscriptionV1alpha1ApiListSubscription
     */
    readonly fieldSelector?: Array<string>

    /**
     * Sorting criteria in the format: property,(asc|desc). Default sort order is ascending. Multiple sort criteria are supported.
     * @type {Array<string>}
     * @memberof SubscriptionV1alpha1ApiListSubscription
     */
    readonly sort?: Array<string>
}

/**
 * Request parameters for patchSubscription operation in SubscriptionV1alpha1Api.
 * @export
 * @interface SubscriptionV1alpha1ApiPatchSubscriptionRequest
 */
export interface SubscriptionV1alpha1ApiPatchSubscriptionRequest {
    /**
     * Name of subscription
     * @type {string}
     * @memberof SubscriptionV1alpha1ApiPatchSubscription
     */
    readonly name: string

    /**
     * 
     * @type {Array<JsonPatchInner>}
     * @memberof SubscriptionV1alpha1ApiPatchSubscription
     */
    readonly jsonPatchInner?: Array<JsonPatchInner>
}

/**
 * Request parameters for updateSubscription operation in SubscriptionV1alpha1Api.
 * @export
 * @interface SubscriptionV1alpha1ApiUpdateSubscriptionRequest
 */
export interface SubscriptionV1alpha1ApiUpdateSubscriptionRequest {
    /**
     * Name of subscription
     * @type {string}
     * @memberof SubscriptionV1alpha1ApiUpdateSubscription
     */
    readonly name: string

    /**
     * Updated subscription
     * @type {Subscription}
     * @memberof SubscriptionV1alpha1ApiUpdateSubscription
     */
    readonly subscription?: Subscription
}

/**
 * SubscriptionV1alpha1Api - object-oriented interface
 * @export
 * @class SubscriptionV1alpha1Api
 * @extends {BaseAPI}
 */
export class SubscriptionV1alpha1Api extends BaseAPI {
    /**
     * Create Subscription
     * @param {SubscriptionV1alpha1ApiCreateSubscriptionRequest} requestParameters Request parameters.
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof SubscriptionV1alpha1Api
     */
    public createSubscription(requestParameters: SubscriptionV1alpha1ApiCreateSubscriptionRequest = {}, options?: RawAxiosRequestConfig) {
        return SubscriptionV1alpha1ApiFp(this.configuration).createSubscription(requestParameters.subscription, options).then((request) => request(this.axios, this.basePath));
    }

    /**
     * Delete Subscription
     * @param {SubscriptionV1alpha1ApiDeleteSubscriptionRequest} requestParameters Request parameters.
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof SubscriptionV1alpha1Api
     */
    public deleteSubscription(requestParameters: SubscriptionV1alpha1ApiDeleteSubscriptionRequest, options?: RawAxiosRequestConfig) {
        return SubscriptionV1alpha1ApiFp(this.configuration).deleteSubscription(requestParameters.name, options).then((request) => request(this.axios, this.basePath));
    }

    /**
     * Get Subscription
     * @param {SubscriptionV1alpha1ApiGetSubscriptionRequest} requestParameters Request parameters.
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof SubscriptionV1alpha1Api
     */
    public getSubscription(requestParameters: SubscriptionV1alpha1ApiGetSubscriptionRequest, options?: RawAxiosRequestConfig) {
        return SubscriptionV1alpha1ApiFp(this.configuration).getSubscription(requestParameters.name, options).then((request) => request(this.axios, this.basePath));
    }

    /**
     * List Subscription
     * @param {SubscriptionV1alpha1ApiListSubscriptionRequest} requestParameters Request parameters.
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof SubscriptionV1alpha1Api
     */
    public listSubscription(requestParameters: SubscriptionV1alpha1ApiListSubscriptionRequest = {}, options?: RawAxiosRequestConfig) {
        return SubscriptionV1alpha1ApiFp(this.configuration).listSubscription(requestParameters.page, requestParameters.size, requestParameters.labelSelector, requestParameters.fieldSelector, requestParameters.sort, options).then((request) => request(this.axios, this.basePath));
    }

    /**
     * Patch Subscription
     * @param {SubscriptionV1alpha1ApiPatchSubscriptionRequest} requestParameters Request parameters.
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof SubscriptionV1alpha1Api
     */
    public patchSubscription(requestParameters: SubscriptionV1alpha1ApiPatchSubscriptionRequest, options?: RawAxiosRequestConfig) {
        return SubscriptionV1alpha1ApiFp(this.configuration).patchSubscription(requestParameters.name, requestParameters.jsonPatchInner, options).then((request) => request(this.axios, this.basePath));
    }

    /**
     * Update Subscription
     * @param {SubscriptionV1alpha1ApiUpdateSubscriptionRequest} requestParameters Request parameters.
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof SubscriptionV1alpha1Api
     */
    public updateSubscription(requestParameters: SubscriptionV1alpha1ApiUpdateSubscriptionRequest, options?: RawAxiosRequestConfig) {
        return SubscriptionV1alpha1ApiFp(this.configuration).updateSubscription(requestParameters.name, requestParameters.subscription, options).then((request) => request(this.axios, this.basePath));
    }
}

